/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.CoordPair;
import com.elluminate.groupware.calculator.CoordSpace;
import com.elluminate.groupware.calculator.LocalCalculatorContext;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.ParseException;

public class SharedCalculatorContext
extends LocalCalculatorContext
implements PropertyChangeListener,
ChannelDataListener {
    private static final int FUNC_0_MASK = 1;
    private static final int FUNC_1_MASK = 2;
    private static final int SPACE_MASK = 4;
    private static final int MARK_MASK = 8;
    private static final int GRID_MASK = 16;
    private Channel channel = null;
    protected ClientList clients = null;
    private int pendingMask = 0;
    private Object pendingLock = new Object();

    public void connect(Channel chnl, ClientList clnts) {
        this.channel = chnl;
        this.clients = clnts;
    }

    public void disconnect() {
        this.channel = null;
        this.clients = null;
    }

    public boolean isConnected() {
        return this.channel != null;
    }

    @Override
    public boolean isWritable() {
        ClientInfo me = this.clients.getMyClient();
        if (me == null) {
            return false;
        }
        return me.getProperty("calculatorAccess", false);
    }

    @Override
    public void setCoordSpace(CoordSpace spc) {
        super.setCoordSpace(spc);
        if (this.isDragging()) {
            this.setPending(4);
        } else {
            this.sendSetSpace(this.clients.getMyAddress(), (short)0);
        }
    }

    @Override
    public void setGridSpacing(double spacing) {
        super.setGridSpacing(spacing);
        if (this.isDragging()) {
            this.setPending(16);
        } else {
            this.sendSetGrid(this.clients.getMyAddress(), (short)0);
        }
    }

    @Override
    public void setMark(CoordPair mark) {
        super.setMark(mark);
        if (this.isDragging()) {
            this.setPending(8);
        } else {
            this.sendSetMark(this.clients.getMyAddress(), (short)0);
        }
    }

    @Override
    public void setFunctionName(int index, String name) throws ParseException {
        super.setFunctionName(index, name);
        if (this.isDragging()) {
            this.setPending(1 << index);
        } else {
            this.sendSetFunction(index, this.clients.getMyAddress(), (short)0);
        }
    }

    @Override
    public void setFunctionColor(int index, Color color) {
        super.setFunctionColor(index, color);
        if (this.isDragging()) {
            this.setPending(1 << index);
        } else {
            this.sendSetFunction(index, this.clients.getMyAddress(), (short)0);
        }
    }

    @Override
    public void setFunctionVisible(int index, boolean visible) {
        super.setFunctionVisible(index, visible);
        if (this.isDragging()) {
            this.setPending(1 << index);
        } else {
            this.sendSetFunction(index, this.clients.getMyAddress(), (short)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDragging(boolean state) {
        Debug.lockEnter((Object)this, (String)"setDragging", (String)"pendingLock", (Object)this.pendingLock);
        Object object = this.pendingLock;
        synchronized (object) {
            if (this.isDragging() && !state) {
                if ((this.pendingMask & 1) != 0) {
                    this.sendSetFunction(0, this.clients.getMyAddress(), (short)0);
                }
                if ((this.pendingMask & 2) != 0) {
                    this.sendSetFunction(1, this.clients.getMyAddress(), (short)0);
                }
                if ((this.pendingMask & 4) != 0) {
                    this.sendSetSpace(this.clients.getMyAddress(), (short)0);
                }
                if ((this.pendingMask & 0x10) != 0) {
                    this.sendSetGrid(this.clients.getMyAddress(), (short)0);
                }
                if ((this.pendingMask & 8) != 0) {
                    this.sendSetMark(this.clients.getMyAddress(), (short)0);
                }
                this.pendingMask = 0;
            }
        }
        Debug.lockLeave((Object)this, (String)"setDragging", (String)"pendingLock", (Object)this.pendingLock);
        super.setDragging(state);
    }

    public void onChannelData(ChannelDataEvent e) {
        if (e.getSourceAddress() != 0) {
            return;
        }
        this.dispatch(e, (short)-32767);
    }

    protected void dispatch(ChannelDataEvent e, short relay) {
        switch (e.getCommand()) {
            case 1: {
                this.parseSetFunction(e, relay);
                break;
            }
            case 2: {
                this.parseSetSpace(e, relay);
                break;
            }
            case 3: {
                this.parseSetGrid(e, relay);
                break;
            }
            case 4: {
                this.parseSetMark(e, relay);
                break;
            }
            case 5: {
                this.parseClearMark(e, relay);
                break;
            }
            default: {
                LogSupport.error((Object)this, (String)"onChannelData", (String)("Unexpected/unknown calculator command - " + e.getCommand()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPending(int mask) {
        Debug.lockEnter((Object)this, (String)"setPending", (String)"pendingLock", (Object)this.pendingLock);
        Object object = this.pendingLock;
        synchronized (object) {
            this.pendingMask |= mask;
        }
        Debug.lockLeave((Object)this, (String)"setPending", (String)"pendingLock", (Object)this.pendingLock);
    }

    protected ChannelDataEvent getEvent(short to, byte cmd) {
        return ChannelDataEvent.getInstance((Object)this, (short)to, (byte)cmd);
    }

    protected void parseSetFunction(ChannelDataEvent e, short relay) {
        DataInputStream str = e.read();
        try {
            short from = this.readFrom(e, str);
            byte index = str.readByte();
            String name = str.readUTF();
            boolean visible = str.readBoolean();
            short r = str.readShort();
            short g = str.readShort();
            short b = str.readShort();
            Color c = new Color(r, g, b);
            super.setFunctionName(index, name);
            super.setFunctionColor(index, c);
            super.setFunctionVisible(index, visible);
            if (relay != -32767) {
                this.sendSetFunction(index, from, relay);
            }
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"parseSetFunction", (Throwable)ex, (boolean)true);
        }
    }

    protected void sendSetFunction(int index, short from, short to) {
        String name = this.getFunctionName(index);
        Color c = this.getFunctionColor(index);
        if (!this.channel.isUp()) {
            return;
        }
        ChannelDataEvent e = this.getEvent(to, (byte)1);
        DataOutputStream str = e.write();
        try {
            str.writeShort(from);
            str.writeByte(index);
            str.writeUTF(name == null ? "" : name);
            str.writeBoolean(this.isFunctionVisible(index));
            str.writeShort(c.getRed());
            str.writeShort(c.getGreen());
            str.writeShort(c.getBlue());
            str.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendSetFunction", (Throwable)ex, (boolean)true);
            return;
        }
        this.channel.onChannelData(e);
    }

    protected void parseSetSpace(ChannelDataEvent e, short relay) {
        DataInputStream str = e.read();
        try {
            short from = this.readFrom(e, str);
            double minX = str.readDouble();
            double maxX = str.readDouble();
            double minY = str.readDouble();
            double maxY = str.readDouble();
            CoordSpace space = new CoordSpace(minX, maxX, minY, maxY);
            super.setCoordSpace(space);
            if (relay != -32767) {
                this.sendSetSpace(from, relay);
            }
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"parseSetSpace", (Throwable)ex, (boolean)true);
        }
    }

    protected void sendSetSpace(short from, short to) {
        CoordSpace space = this.getCoordSpace();
        if (!this.channel.isUp()) {
            return;
        }
        ChannelDataEvent e = this.getEvent(to, (byte)2);
        DataOutputStream str = e.write();
        try {
            str.writeShort(from);
            str.writeDouble(space.getMinX());
            str.writeDouble(space.getMaxX());
            str.writeDouble(space.getMinY());
            str.writeDouble(space.getMaxY());
            str.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendSetSpace", (Throwable)ex, (boolean)true);
        }
    }

    protected void parseSetMark(ChannelDataEvent e, short relay) {
        DataInputStream str = e.read();
        try {
            short from = this.readFrom(e, str);
            double x = str.readDouble();
            double y = str.readDouble();
            CoordPair mark = new CoordPair(x, y);
            super.setMark(mark);
            if (relay != -32767) {
                this.sendSetMark(from, relay);
            }
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"parseSetMark", (Throwable)ex, (boolean)true);
        }
    }

    protected void parseClearMark(ChannelDataEvent e, short relay) {
        DataInputStream str = e.read();
        try {
            short from = this.readFrom(e, str);
            super.setMark(null);
            if (relay != -32767) {
                this.sendSetMark(from, relay);
            }
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"parseClearMark", (Throwable)ex, (boolean)true);
        }
    }

    protected void sendSetMark(short from, short to) {
        CoordPair mark = this.getMark();
        if (!this.channel.isUp()) {
            return;
        }
        if (mark != null) {
            ChannelDataEvent e = this.getEvent(to, (byte)4);
            DataOutputStream str = e.write();
            try {
                str.writeShort(from);
                str.writeDouble(mark.x);
                str.writeDouble(mark.y);
                str.close();
                this.channel.onChannelData(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"setSendMark", (Throwable)ex, (boolean)true);
            }
        } else {
            ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)to, (byte)5);
            DataOutputStream str = e.write();
            try {
                str.writeShort(from);
                str.close();
                this.channel.onChannelData(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"setSendMark", (Throwable)ex, (boolean)true);
            }
        }
    }

    protected void parseSetGrid(ChannelDataEvent e, short relay) {
        DataInputStream str = e.read();
        try {
            short from = this.readFrom(e, str);
            double grid = str.readDouble();
            super.setGridSpacing(grid);
            if (relay != -32767) {
                this.sendSetGrid(from, relay);
            }
            str.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"parseSetGrid", (Throwable)ex, (boolean)true);
        }
    }

    protected void sendSetGrid(short from, short to) {
        double grid = this.getGridSpacing();
        if (!this.channel.isUp()) {
            return;
        }
        ChannelDataEvent e = this.getEvent(to, (byte)3);
        DataOutputStream str = e.write();
        try {
            str.writeShort(from);
            str.writeDouble(grid);
            str.close();
            this.channel.onChannelData(e);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"setSendMark", (Throwable)ex, (boolean)true);
        }
    }

    private short readFrom(ChannelDataEvent e, DataInputStream str) {
        short from = -32767;
        try {
            from = str.readShort();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"readFrom", (Throwable)ex, (boolean)true);
        }
        if (e.getSourceAddress() != 0) {
            from = e.getSourceAddress();
        }
        return from;
    }
}

