/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;

public class FunctionTokenizer {
    static final String Delimiters = "+-*/^()";
    I18n i18n = I18n.create((Object)this);
    String str = null;
    int last = -1;
    int cursor = 0;
    DecimalFormatSymbols symbols = new DecimalFormatSymbols();
    char decimal = this.symbols.getDecimalSeparator();

    public FunctionTokenizer(String s) {
        this.str = s;
    }

    public boolean hasMoreTokens() {
        while (this.cursor < this.str.length() && Character.isSpaceChar(this.str.charAt(this.cursor))) {
            ++this.cursor;
        }
        return this.cursor < this.str.length();
    }

    public String nextToken() throws ParseException {
        while (this.cursor < this.str.length() && Character.isSpaceChar(this.str.charAt(this.cursor))) {
            ++this.cursor;
        }
        this.last = this.cursor++;
        if (this.last >= this.str.length()) {
            return null;
        }
        char c = this.str.charAt(this.last);
        if (Delimiters.indexOf(c) < 0) {
            if (Character.isLetter(c)) {
                while (this.cursor < this.str.length() && Character.isLetter(this.str.charAt(this.cursor))) {
                    ++this.cursor;
                }
            } else if (c == this.decimal || Character.isDigit(c)) {
                while (this.cursor < this.str.length() && (Character.isDigit(this.str.charAt(this.cursor)) || this.str.charAt(this.cursor) == this.decimal)) {
                    ++this.cursor;
                }
            } else {
                throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTIONTOKENIZER_BADCHAR, new Object[]{new Character(c)}), this.cursor);
            }
        }
        String token = this.str.substring(this.last, this.cursor);
        return token;
    }

    public int lastTokenOffset() {
        return this.last;
    }
}

