/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.CoordPair;
import com.elluminate.util.CPropertyChangeSupport;
import java.beans.PropertyChangeListener;

public class CoordSpace {
    public static final byte UPPER_RIGHT = 0;
    public static final byte LOWER_RIGHT = 1;
    public static final byte UPPER_LEFT = 2;
    public static final byte LOWER_LEFT = 3;
    private static final double MIN = -2.147483648E9;
    private static final double MAX = 2.147483647E9;
    private double minX = 0.0;
    private double maxX = 0.0;
    private double minY = 0.0;
    private double maxY = 0.0;
    private CPropertyChangeSupport changeSupport = new CPropertyChangeSupport((Object)this);

    public CoordSpace() {
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(lst);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(prop, lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(prop, lst);
    }

    public CoordSpace(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.normalize();
    }

    public CoordSpace(CoordPair min, CoordPair max) {
        this.minX = min.x;
        this.minY = min.y;
        this.maxX = max.x;
        this.maxY = max.y;
        this.normalize();
    }

    public void move(double deltaX, double deltaY) {
        this.minX += deltaX;
        this.maxX += deltaX;
        this.minY += deltaY;
        this.maxY += deltaY;
        this.normalize();
        this.changeSupport.firePropertyChange("all", null, null);
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double x) {
        double oldX = this.minX;
        this.minX = x;
        this.normalize();
        this.change("minX", oldX, this.minX);
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double x) {
        double oldX = this.maxX;
        this.maxX = x;
        this.normalize();
        this.change("maxX", oldX, this.maxX);
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double y) {
        double oldY = this.minY;
        this.minY = y;
        this.normalize();
        this.change("minY", oldY, this.minY);
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double y) {
        double oldY = this.maxY;
        this.maxY = y;
        this.normalize();
        this.change("maxY", oldY, this.maxY);
    }

    public double getXRange() {
        return this.maxX - this.minX;
    }

    public double getYRange() {
        return this.maxY - this.minY;
    }

    public CoordPair getCenter() {
        return new CoordPair((this.minX + this.maxX) / 2.0, (this.minY + this.maxY) / 2.0);
    }

    public boolean contains(CoordPair point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double x, double y) {
        if (x < this.minX || x > this.maxX) {
            return false;
        }
        return !(y < this.minY) && !(y > this.maxY);
    }

    public byte getQuadrant(CoordPair point) {
        return this.getQuadrant(point.x, point.y);
    }

    public byte getQuadrant(double x, double y) {
        byte quadrant = 0;
        if (x < (this.minX + this.maxX) / 2.0) {
            quadrant = (byte)(quadrant + 2);
        }
        if (y < (this.minY + this.maxY) / 2.0) {
            quadrant = (byte)(quadrant + 1);
        }
        return quadrant;
    }

    private void change(String name, double from, double to) {
        this.changeSupport.firePropertyChange(name, (Object)new Double(from), (Object)new Double(to));
    }

    private void normalize() {
        double tmp;
        if (this.minX > this.maxX) {
            tmp = this.minX;
            this.minX = this.maxX;
            this.maxX = tmp;
        }
        if (this.minY > this.maxY) {
            tmp = this.minY;
            this.minY = this.maxY;
            this.maxY = tmp;
        }
        this.minX = Math.max(this.minX, -2.147483648E9);
        this.maxX = Math.min(this.maxX, 2.147483647E9);
        this.minY = Math.max(this.minY, -2.147483648E9);
        this.maxY = Math.min(this.maxY, 2.147483647E9);
    }
}

