/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.StringsProperties;
import com.elluminate.groupware.calculator.Term;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;

public class BuiltinFactory {
    private I18n i18n = I18n.create((Object)this);
    private ArrayList packages = new ArrayList();

    public BuiltinFactory() {
        this.packages.add("com.elluminate.groupware.calculator.builtin");
    }

    public void addBuiltinPrefix(String prefix) {
        if (this.packages.contains(prefix)) {
            return;
        }
        this.packages.add(prefix);
    }

    public void removeBuiltinPrefix(String prefix) {
        this.packages.remove(prefix);
    }

    public ArrayList getPrefixList() {
        return (ArrayList)this.packages.clone();
    }

    public Term createInstance(String name) throws ParseException {
        String first = name.substring(0, 1).toUpperCase(Locale.ENGLISH);
        String remainder = name.substring(1).toLowerCase(Locale.ENGLISH);
        String builtin = first + remainder;
        for (String prefix : this.packages) {
            try {
                Class<?> cls = Class.forName(prefix + "." + builtin + "Builtin");
                return (Term)cls.newInstance();
            }
            catch (Exception ex) {
            }
        }
        throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.BUILTINFACTORY_UNKNOWNBUILTIN, new Object[]{name}), 0);
    }
}

