/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.dataModel.ACLChangeListener;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanel;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanelListener;
import com.elluminate.groupware.whiteboard.module.ui.menu.ScreenPropertiesPanelListener;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class ScreenPropertiesPanel
extends JPanel
implements ACLChangeListener,
ScreenSizePanelListener {
    static final int NUMBER_COLUMN = 0;
    static final int NUMBER_COLUMN_WIDTH = 50;
    static final int NAME_COLUMN = 1;
    static final int TOTAL_COLUMNS = 2;
    I18n i18n = I18n.create((Object)this);
    ScreenSizePanel screenSizePanel;
    JPanel centerPanel = new JPanel(new BorderLayout());
    TitledBorder centerBorder;
    String[] screenNames = new String[0];
    ScreenModel[] screens = null;
    Dimension[] screenSizes;
    String numberColumnHeaderText;
    String nameColumnHeaderText;
    int screenWidth;
    int screenHeight;
    boolean sizeAcquired = false;
    boolean commonWidth = true;
    boolean commonHeight = true;
    JTable screenNameTable = new CTable();
    ScreenNameTableModel tableModel = new ScreenNameTableModel();
    JScrollPane scrollPane;
    ScreenPropertiesPanelListener listener;
    WhiteboardContext context;

    public ScreenPropertiesPanel(WhiteboardContext context, ScreenPropertiesPanelListener listener) {
        this.context = context;
        this.listener = listener;
        this.setLayout(new BorderLayout(0, 6));
        this.screenSizePanel = new ScreenSizePanel(context, this, 4200, 4200);
        this.centerBorder = new TitledBorder(this.i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESPANEL_NAMEPANELTITLE));
        this.centerPanel.setBorder(BorderFactory.createCompoundBorder(this.centerBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.numberColumnHeaderText = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESPANEL_NUMBERCOLUMHEADERTEXT);
        this.nameColumnHeaderText = this.i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESPANEL_NAMECOLUMNHEADERTEXT);
        this.scrollPane = new JScrollPane(this.screenNameTable, 22, 31);
        this.scrollPane.getViewport().setBackground(this.screenNameTable.getBackground());
        this.scrollPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ScreenPropertiesPanel.this.screenNameTable.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScreenPropertiesPanel.this.screenNameTable.clearSelection();
            }
        });
        this.centerPanel.add((Component)this.scrollPane, "Center");
        this.add((Component)this.screenSizePanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.screenNameTable.setSelectionMode(0);
        this.screenNameTable.setModel(this.tableModel);
        this.screenNameTable.createDefaultColumnsFromModel();
        this.screenNameTable.setAutoResizeMode(3);
        this.screenNameTable.setIntercellSpacing(new Dimension(0, 1));
        this.screenNameTable.setShowHorizontalLines(false);
        this.screenNameTable.setShowVerticalLines(false);
        TableColumn col = this.screenNameTable.getColumnModel().getColumn(0);
        col.setMinWidth(50);
        col.setPreferredWidth(50);
        col.setMaxWidth(50);
        this.screenNameTable.getTableHeader().setReorderingAllowed(false);
        this.screenNameTable.getTableHeader().setResizingAllowed(false);
        this.screenNameTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ScreenPropertiesPanel.this.screenNameTable.columnAtPoint(e.getPoint()) == 1) {
                    ScreenPropertiesPanel.this.onScreenSizePanelChange();
                }
            }
        });
    }

    public void populateScreens(TreePath[] paths) {
        int i;
        if (this.screens != null) {
            for (i = 0; i < this.screens.length; ++i) {
                this.screens[i].removeACLChangeListener((ACLChangeListener)this);
            }
        }
        this.screens = new ScreenModel[paths.length];
        for (i = 0; i < this.screens.length; ++i) {
            this.screens[i] = (ScreenModel)((DisplayNode)paths[i].getLastPathComponent()).whiteboardPeer();
            this.screens[i].addACLChangeListener((ACLChangeListener)this);
        }
        this.screenNames = new String[this.screens.length];
        this.screenSizes = new Dimension[this.screens.length];
        for (i = 0; i < this.screens.length; ++i) {
            this.screenNames[i] = this.screens[i].getScreenName();
            this.screenSizes[i] = this.screens[i].getScreenSize();
        }
        this.screenSizePanel.populateScreenSize(this.screenSizes);
        int desiredWidth = 250;
        int desiredHeight = this.screenNameTable.getTableHeader().getHeight() + 4 * this.screenNameTable.getRowHeight();
        Dimension tableSize = new Dimension(desiredWidth, desiredHeight);
        this.screenNameTable.setPreferredScrollableViewportSize(tableSize);
        IconRenderer renderer = new IconRenderer();
        TableColumn nameColumn = this.screenNameTable.getColumn(this.nameColumnHeaderText);
        nameColumn.setCellRenderer(renderer);
        TableColumn numberColumn = this.screenNameTable.getColumn(this.numberColumnHeaderText);
        numberColumn.setCellRenderer(renderer);
        this.evaluateScreensAccess();
    }

    public boolean isSizeValid() {
        return this.screenSizePanel.isSizeValid();
    }

    private void evaluateScreensAccess() {
        boolean canModify = false;
        for (int i = 0; i < this.screens.length; ++i) {
            canModify |= this.screens[i].canCreate();
        }
        this.screenSizePanel.setEnabled(canModify);
        this.screenNameTable.setEnabled(canModify);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.screens != null) {
            for (int i = 0; i < this.screens.length; ++i) {
                if (visible) {
                    this.screens[i].addACLChangeListener((ACLChangeListener)this);
                    continue;
                }
                this.screens[i].removeACLChangeListener((ACLChangeListener)this);
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void onScreenSizePanelChange() {
        this.listener.onScreenPropertiesPanel();
    }

    public void onACLChange(ACLTerm aclTerm) {
        if (aclTerm.getName().equals("accessible")) {
            this.screenNameTable.repaint();
        }
        this.evaluateScreensAccess();
    }

    private int widestCellInColumn(JTable table, TableColumn column) {
        int columnIndex = column.getModelIndex();
        int width = 0;
        int maxWidth = 0;
        for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, columnIndex);
            if (renderer != null) {
                Component comp = renderer.getTableCellRendererComponent(table, table.getValueAt(rowIndex, columnIndex), false, false, rowIndex, columnIndex);
                width = comp.getPreferredSize().width;
            } else {
                width = 0;
            }
            maxWidth = Math.max(maxWidth, width);
        }
        return maxWidth;
    }

    public boolean updateScreens() {
        Dimension size = null;
        if (this.screenNameTable.isEditing()) {
            TableCellEditor cellEditor = this.screenNameTable.getCellEditor();
            cellEditor.stopCellEditing();
        }
        for (int i = 0; i < this.screens.length; ++i) {
            if (this.screens[i].getObjectID() == null || !this.screens[i].isEditable() || !this.screens[i].canCreate()) continue;
            if (!this.screenNames[i].equals(this.screens[i].getScreenName())) {
                this.screens[i].setScreenNameFromUi(this.screenNames[i]);
            }
            if ((size = this.screenSizePanel.getSize(this.screens[i].getScreenSize())) == null) continue;
            this.screens[i].setScreenSize(size);
        }
        return true;
    }

    class IconRenderer
    extends DefaultTableCellRenderer {
        IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            if (table.isCellEditable(row, column)) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.blue);
            }
            this.setText(value != null ? value.toString() : "");
            return this;
        }
    }

    class ScreenNameTableModel
    extends AbstractTableModel {
        ScreenNameTableModel() {
        }

        @Override
        public int getRowCount() {
            return ScreenPropertiesPanel.this.screenNames.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                switch (column) {
                    case 0: {
                        return new Integer(row + 1);
                    }
                    case 1: {
                        return ScreenPropertiesPanel.this.screenNames[row];
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 1 && value instanceof String) {
                if (((String)value).length() <= 0) {
                    ModalDialog.showMessageDialog((Component)ScreenPropertiesPanel.this.scrollPane, (Object)ScreenPropertiesPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESPANEL_EMPTYNAME), (String)ScreenPropertiesPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESPANEL_EMPTYNAMETITLE), (int)0);
                    return;
                }
                ScreenPropertiesPanel.this.screenNames[row] = (String)value;
                ScreenPropertiesPanel.this.listener.onScreenPropertiesPanel();
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ScreenPropertiesPanel.this.numberColumnHeaderText;
                }
                case 1: {
                    return ScreenPropertiesPanel.this.nameColumnHeaderText;
                }
            }
            return "unknown";
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 1 && ScreenPropertiesPanel.this.screens[row].getObjectID() != null) {
                return ScreenPropertiesPanel.this.screens[row].isEditable() && ScreenPropertiesPanel.this.screens[row].isAccessible() && ScreenPropertiesPanel.this.screens[row].canCreate();
            }
            return false;
        }
    }
}

