/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.listeners.SelectionListener;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.ScreenGotoListener;
import com.elluminate.groupware.whiteboard.module.ui.menu.AlignBottomAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.AlignCenterAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.AlignLeftAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.AlignMiddleAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.AlignRightAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.AlignTopAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.DistributeHCenterAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.DistributeHSpaceAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.DistributeVCenterAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.DistributeVSpaceAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractJMenu;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ObjectAlignMenu
extends WBAbstractJMenu
implements PopupMenuListener,
ScreenGotoListener,
SelectionListener {
    private AlignTopAction ata;
    private AlignCenterAction aca;
    private AlignBottomAction aba;
    private AlignLeftAction ala;
    private AlignMiddleAction ama;
    private AlignRightAction ara;
    private DistributeHCenterAction dhca;
    private DistributeVCenterAction dvca;
    private DistributeHSpaceAction dhsa;
    private DistributeVSpaceAction dvsa;
    private ScreenModel screen;

    public ObjectAlignMenu(WhiteboardContext context, Object housing, ScreenModel screen) {
        super(context, housing, "ObjectAlignMenu");
        this.screen = screen;
        this.ata = new AlignTopAction(context, (Object)this, this.screen);
        this.aca = new AlignCenterAction(context, (Object)this, this.screen);
        this.aba = new AlignBottomAction(context, (Object)this, this.screen);
        this.addSeparator();
        this.ala = new AlignLeftAction(context, (Object)this, this.screen);
        this.ama = new AlignMiddleAction(context, (Object)this, this.screen);
        this.ara = new AlignRightAction(context, (Object)this, this.screen);
        this.addSeparator();
        this.dvca = new DistributeVCenterAction(context, (Object)this, this.screen);
        this.dvsa = new DistributeVSpaceAction(context, (Object)this, this.screen);
        this.addSeparator();
        this.dhca = new DistributeHCenterAction(context, (Object)this, this.screen);
        this.dhsa = new DistributeHSpaceAction(context, (Object)this, this.screen);
        this.addSeparator();
        ControllerPane controller = (ControllerPane)context.getController();
        this.add(controller.getAlignAction().menuItemFactory());
    }

    @Override
    public void onScreenGoto(ScreenModel oldScreen, ScreenModel newScreen) {
        this.screen = newScreen;
        this.enableItems();
    }

    public void onSelect(AbstractToolModel tool, boolean selected) {
        this.enableItems();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.setupListeners(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.setupListeners(false);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.setupListeners(false);
    }

    private void setupListeners(boolean install) {
        ControllerPane controller = (ControllerPane)this.context.getController();
        if (install) {
            controller.getCanvas().addScreenGotoListener(this);
            this.context.addSelectionListener((SelectionListener)this);
            this.enableItems();
        } else {
            controller.getCanvas().removeScreenGotoListener(this);
            this.context.removeSelectionListener((SelectionListener)this);
        }
    }

    private void enableItems() {
        boolean enable = this.screen.getSelectedToolCount() > 0;
        this.ata.setEnabled(enable);
        this.aca.setEnabled(enable);
        this.aba.setEnabled(enable);
        this.ala.setEnabled(enable);
        this.ama.setEnabled(enable);
        this.ara.setEnabled(enable);
        enable = this.screen.getSelectedToolCount() > 2;
        this.dhca.setEnabled(enable);
        this.dvca.setEnabled(enable);
        this.dhsa.setEnabled(enable);
        this.dvsa.setEnabled(enable);
    }
}

