/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.ui.menu.ImportSelectionDialog;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class ImportWBDAction
extends WBAbstractAction {
    TreePath[] paths;
    TreePath[] pathsToProcess;
    ImportSelectionDialog selectionDialog = null;
    String actionName;

    public ImportWBDAction(WhiteboardContext context, Object housing, TreePath[] paths, String actionName) {
        super(context, housing, actionName);
        this.actionName = actionName;
        this.setPaths(paths);
    }

    public void setPaths(TreePath[] paths) {
        this.paths = paths;
        this.setEnabled(ActionUtilities.canCreateTree((WhiteboardContext)this.context, (TreePath[])paths) || paths == null && this.context.isChair());
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAction();
    }

    @Override
    public void actionPerformed(ActionFeatureEvent e) {
        this.performAction();
    }

    private void performAction() {
        String ownerPrefix = this.context.getBean().getOwnerPrefix();
        Preferences preferences = this.context.getBean().getPreferences();
        ScreenModel watchingScreen = this.context.getController().getScreen();
        try {
            int insertRelationship = preferences.getIntegerSetting(ownerPrefix + ".importCreationLocation", 1);
            this.pathsToProcess = this.paths;
            if (this.pathsToProcess == null) {
                this.pathsToProcess = new TreePath[1];
                DisplayNode pathPeer = new DisplayNode();
                pathPeer.setUserObject((Object)this.context.getController().getScreen());
                this.pathsToProcess[0] = new TreePath(pathPeer);
            }
            if (this.pathsToProcess == null || this.pathsToProcess.length == 0 || !ActionUtilities.canCreateTree((WhiteboardContext)this.context, (TreePath[])this.pathsToProcess)) {
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.IMPORTACTIONS_NOPATHS), (String)i18n.getString((PropertiesEnum)StringsProperties.IMPORTACTIONS_NOPATHSTITLE), (int)0);
                return;
            }
            FileUtils.loadWBD(this.context, this.context.fileToLoad, true, insertRelationship, watchingScreen, this.pathsToProcess);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)ex, (boolean)true);
        }
    }
}

