/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.GoToScreen;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.groupware.whiteboard.module.ui.GroupSelectionDialog;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

class CopyScreensToGroupsAction
extends WBAbstractAction {
    private I18n i18n = I18n.create(CopyScreensToGroupsAction.class);
    private ScreenModel[] selectedScreens;

    public CopyScreensToGroupsAction(WhiteboardContext context, Object menu, TreePath[] selectedScreens) {
        super(context, menu, "CopyScreensToGroupsAction");
        boolean onlyMainRoomSelected = true;
        ArrayList<WBNode> scrs = new ArrayList<WBNode>();
        WBNode[] nodes = ActionUtilities.pathsToNodes((TreePath[])selectedScreens);
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof ScreenModel)) continue;
                scrs.add(nodes[i]);
                ScreenRoot root = (ScreenRoot)((ScreenModel)nodes[i]).getRoot();
                if (root == null || root.getGroupID() == 0) continue;
                onlyMainRoomSelected = false;
            }
        }
        this.selectedScreens = scrs.toArray(new ScreenModel[0]);
        this.setEnabled(context.isChair() && onlyMainRoomSelected && selectedScreens != null && selectedScreens.length > 0 && this.getCurrentGroups().length != 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GroupSelectionDialog d = new GroupSelectionDialog(this.context.getDialogParentFrame(), this.i18n.getString((PropertiesEnum)StringsProperties.COPYSCREENSTOGROUPS_DIALOGTITLE), this.getCurrentGroups());
        d.setPrompt(this.i18n.getString((PropertiesEnum)StringsProperties.COPYSCREENSTOGROUPS_DIALOGPROMPT));
        d.setButtonText(this.i18n.getString((PropertiesEnum)StringsProperties.COPYSCREENSTOGROUPS_DIALOGCOPYBUTTON));
        d.setVisible(true);
        if (!d.wasCanceled()) {
            ScreenRoot[] grps = d.getSelectedGroups();
            ActionUtilities.duplicateScreensToGroups((WhiteboardContext)this.context, (ScreenModel[])this.selectedScreens, (ScreenRoot[])grps);
            for (int i = 0; i < grps.length; ++i) {
                ScreenRoot grp = grps[i];
                ScreenModel scr = (ScreenModel)grp.getScreenAt(0);
                GoToScreen gotoScreen = new GoToScreen(this.context, scr.getObjectID(), Short.valueOf(grp.getGroupID()));
                this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)gotoScreen);
            }
        }
    }

    private ScreenRoot[] getCurrentGroups() {
        ArrayList<ScreenRoot> groups = new ArrayList<ScreenRoot>();
        ScreenGroups roots = (ScreenGroups)this.context.getDataModel().getRoot();
        for (int i = 0; i < roots.getChildCount(); ++i) {
            ScreenRoot root = (ScreenRoot)roots.getChildAt(i);
            if (root.getGroupID() == 0) continue;
            groups.add(root);
        }
        return groups.toArray(new ScreenRoot[0]);
    }
}

