/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.keyboard;

import com.elluminate.groupware.whiteboard.module.ui.keyboard.AlphaSource;
import com.elluminate.groupware.whiteboard.module.ui.keyboard.GhostButton;
import com.elluminate.groupware.whiteboard.module.ui.keyboard.GhostToggleButton;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KeyBoard
extends JPanel
implements ActionListener,
AlphaSource,
KeyListener,
MouseListener,
MouseMotionListener {
    static Insets keyInsets = new Insets(0, 0, 0, 0);
    I18n i18n = I18n.create((Object)this);
    String keyboardName;
    LinkedList rows = new LinkedList();
    HashMap buttons = new HashMap();
    final ActionListener actionListener = this;
    boolean shiftDown = false;
    boolean capsLockDown = false;
    boolean escDown = false;
    boolean ctrlDown = false;
    boolean altDown = false;
    boolean metaDown = false;
    boolean insertDown = false;
    int modifiers = 0;
    LinkedList keyListeners = new LinkedList();
    boolean mouseInPanel = false;
    float alphaLevel = 0.1f;
    KeyBoard keyBoardThis = this;
    JPanel keyPanel;
    LinkedList shiftKeys = new LinkedList();
    LinkedList ctrlKeys = new LinkedList();
    LinkedList metaKeys = new LinkedList();
    LinkedList altKeys = new LinkedList();
    LinkedList otherToggleKeys = new LinkedList();
    int cellWidth = 16;
    int cellHeight = 16;
    int suppressKeyLock = 0;
    boolean visible = true;

    public KeyBoard(String keyboardName) {
        try {
            this.keyboardName = keyboardName;
            this.keyPanel = new JPanel(new GridBagLayout());
            this.setLayout(new BorderLayout());
            this.add((Component)this.keyPanel, "Center");
            this.setOpaque(false);
            this.setDoubleBuffered(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
            this.buildKeyboard(keyboardName);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    void buildKeyboard(String keyboardName) {
        int rowLengthMax = 0;
        int rowLength = 0;
        try {
            String cellSize = this.i18n.getStringLegacy(keyboardName + ".width");
            this.cellWidth = Integer.parseInt(cellSize);
            cellSize = this.i18n.getStringLegacy(keyboardName + ".height");
            this.cellHeight = Integer.parseInt(cellSize);
            String rowNames = this.i18n.getStringLegacy(keyboardName + ".rows");
            StringTokenizer tokenizeRows = new StringTokenizer(rowNames, ",");
            int rowIndex = 0;
            while (tokenizeRows.hasMoreTokens()) {
                String rowName = tokenizeRows.nextToken().trim();
                JPanel row = new JPanel(new GridBagLayout());
                int[] pad = this.makePad(keyboardName, rowName);
                this.keyPanel.add((Component)row, new GridBagConstraints(0, rowIndex, 1, 1, 1.0, 1.0, 17, 1, keyInsets, pad[0], pad[1]));
                this.rows.add(new Row(keyboardName, rowName, rowIndex, row));
                GridBagLayout layout = (GridBagLayout)row.getLayout();
                rowLength = 0;
                for (int i = 0; i < row.getComponentCount(); ++i) {
                    GridBagConstraints constraint = layout.getConstraints(row.getComponent(i));
                    rowLength += constraint.gridwidth;
                }
                rowLengthMax = Math.max(rowLengthMax, rowLength);
                ++rowIndex;
            }
            this.setPreferredSize(this.getPreferredSize());
            this.setSize(this.getPreferredSize());
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"buildKeyboard", (Throwable)ex, (boolean)true, (String)("Cannot parse row information for: " + keyboardName));
        }
    }

    int[] makePad(String keyboardName, String rowName) {
        int[] pad = new int[2];
        try {
            String padString = this.i18n.getStringLegacy(keyboardName + ".pad." + rowName);
            StringTokenizer tokenizer = new StringTokenizer(padString, ",");
            for (int i = 0; i < 2 && tokenizer.hasMoreTokens(); ++i) {
                String padding = tokenizer.nextToken().trim();
                pad[i] = Integer.parseInt(padding);
            }
        }
        catch (NumberFormatException ex) {
            LogSupport.exception((Object)this, (String)"makePad", (Throwable)ex, (boolean)true, (String)("Cannot parse pad information for: " + keyboardName + ".pad." + rowName));
        }
        return pad;
    }

    public void addPseudoKeyListener(KeyListener l) {
        if (!this.keyListeners.contains(l)) {
            this.keyListeners.add(l);
        }
    }

    public void removePseudoKeyListener(KeyListener l) {
        this.keyListeners.remove(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KeyEvent event;
        char output;
        AbstractButton button = (AbstractButton)e.getSource();
        Key key = (Key)this.buttons.get(button);
        switch (key.keyStroke.getKeyCode()) {
            case 16: {
                if (button.isSelected() == this.shiftDown) break;
                this.shiftDown = button.isSelected();
                this.capsLockDown = false;
                this.reflectShiftValue();
                break;
            }
            case 18: {
                this.altDown = button.isSelected();
                break;
            }
            case 17: {
                this.ctrlDown = button.isSelected();
                break;
            }
            case 155: {
                this.insertDown = button.isSelected();
                break;
            }
            case 157: {
                this.metaDown = button.isSelected();
                break;
            }
        }
        this.modifiers = 0;
        if (this.shiftDown) {
            this.modifiers |= 1;
        }
        if (this.altDown) {
            this.modifiers |= 8;
        }
        if (this.ctrlDown) {
            this.modifiers |= 2;
        }
        if (this.metaDown) {
            this.modifiers |= 4;
        }
        char c = output = this.shiftDown ? key.upperChar : key.lowerChar;
        if (!(button instanceof JToggleButton && !button.isSelected() || this.keyListeners.isEmpty())) {
            try {
                event = new KeyEvent(this, 401, System.currentTimeMillis(), this.modifiers, key.keyStroke.getKeyCode(), output);
                this.fireKeyListeners(event);
            }
            catch (Exception e1) {
                LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)e1, (boolean)true);
            }
        }
        if ((!(button instanceof JToggleButton) || button instanceof JToggleButton && !button.isSelected()) && !this.keyListeners.isEmpty()) {
            try {
                if (output != '\uffff') {
                    event = new KeyEvent(this, 400, System.currentTimeMillis(), this.modifiers, 0, output);
                    this.fireKeyListeners(event);
                }
                event = new KeyEvent(this, 402, System.currentTimeMillis(), this.modifiers, key.keyStroke.getKeyCode(), output);
                this.fireKeyListeners(event);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)ex, (boolean)true);
            }
        }
    }

    void fireKeyListeners(KeyEvent event) {
        if (this.suppressKeyLock == 0) {
            for (KeyListener l : this.keyListeners) {
                switch (event.getID()) {
                    case 401: {
                        l.keyPressed(event);
                        break;
                    }
                    case 400: {
                        l.keyTyped(event);
                        break;
                    }
                    case 402: {
                        l.keyReleased(event);
                        break;
                    }
                }
            }
        }
    }

    void reflectShiftValue() {
        for (Map.Entry entry : this.buttons.entrySet()) {
            AbstractButton testButton = (AbstractButton)entry.getKey();
            Key testKey = (Key)entry.getValue();
            if (this.shiftDown || this.capsLockDown) {
                if (testKey.lowerIcon == null && testKey.upperIcon == null) {
                    testButton.setText(testKey.shiftedFace);
                    testButton.setIcon(null);
                    continue;
                }
                testButton.setText("");
                if (testKey.upperIcon != null) {
                    testButton.setIcon(testKey.upperIcon);
                    continue;
                }
                testButton.setIcon(testKey.lowerIcon);
                continue;
            }
            if (testKey.lowerIcon == null) {
                testButton.setText(testKey.unshiftedFace);
                testButton.setIcon(null);
                continue;
            }
            testButton.setText("");
            testButton.setIcon(testKey.lowerIcon);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mouseInPanel) {
            this.processAlpha(e);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        super.setVisible(visible);
    }

    void processAlpha(MouseEvent e) {
        if (this.visible && this.alphaLevel < 1.0f) {
            if (!this.isVisible()) {
                super.setVisible(true);
            }
            Point point = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), this);
            boolean newMouse = this.keyPanel.getBounds().contains(point);
            if (newMouse != this.mouseInPanel) {
                if (this.alphaLevel < 1.0f) {
                    this.repaint();
                }
                this.mouseInPanel = newMouse;
            }
            if (this.alphaLevel < 1.0f) {
                ((Component)e.getSource()).repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processAlpha(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.processAlpha(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.alphaLevel < 1.0f) {
            super.setVisible(false);
        }
    }

    @Override
    public float getAlpha() {
        return this.mouseInPanel ? 1.0f : this.alphaLevel;
    }

    @Override
    public void paint(Graphics g) {
        if (this.alphaLevel < 1.0f && !this.mouseInPanel) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, this.alphaLevel));
            super.paint(g2);
        } else {
            super.paint(g);
        }
    }

    public void setUnfocusedAlpha(int percentage) {
        this.alphaLevel = Math.min(1.0f, Math.max(0.0f, (float)(255 * percentage) / 100.0f));
        this.setOpaque(percentage == 100);
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.mergeModifiers(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.mergeModifiers(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.mergeModifiers(e);
    }

    void mergeModifiers(KeyEvent e) {
        ++this.suppressKeyLock;
        if (e.getKeyCode() == 20) {
            switch (e.getID()) {
                case 401: {
                    this.capsLockDown = !this.capsLockDown;
                    break;
                }
                case 402: {
                    break;
                }
            }
        }
        this.altDown = e.isAltDown();
        this.shiftDown = e.isShiftDown();
        this.metaDown = e.isMetaDown();
        this.ctrlDown = (e.getModifiers() & 2) != 0;
        this.waldoKey(this.ctrlDown, this.ctrlKeys);
        this.waldoKey(this.altDown, this.altKeys);
        this.waldoKey(this.metaDown, this.metaKeys);
        this.waldoKey(this.shiftDown || this.capsLockDown, this.shiftKeys);
        this.waldoKey(false, this.otherToggleKeys);
        this.reflectShiftValue();
        --this.suppressKeyLock;
    }

    void waldoKey(boolean state, LinkedList keys) {
        for (AbstractButton button : keys) {
            if (button.isSelected() == state) continue;
            button.setSelected(state);
        }
    }

    class Key {
        int column;
        int width = 1;
        String unshiftedFace = "***";
        String shiftedFace = "***";
        KeyStroke keyStroke = null;
        char lowerChar = '\u0000';
        char upperChar = '\u0000';
        Icon lowerIcon = null;
        Icon upperIcon = null;

        public Key(String name, int column, JPanel row) {
            String token = null;
            boolean toggle = false;
            this.column = column;
            try {
                String keyInformation = KeyBoard.this.i18n.getStringLegacy(name);
                StringTokenizer tokenizer = new StringTokenizer(keyInformation, ",");
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    try {
                        token = tokenizer.nextToken().trim();
                        switch (i) {
                            case 0: {
                                toggle = token.equalsIgnoreCase("t");
                                break;
                            }
                            case 1: {
                                this.width = Integer.parseInt(token);
                                break;
                            }
                            case 2: {
                                this.unshiftedFace = this.decodeString(token);
                                break;
                            }
                            case 3: {
                                this.shiftedFace = this.decodeString(token);
                                break;
                            }
                            case 4: {
                                this.lowerChar = this.decodeChar(token);
                                break;
                            }
                            case 5: {
                                this.upperChar = this.decodeChar(token);
                                break;
                            }
                            case 6: {
                                this.keyStroke = KeyStroke.getKeyStroke(token);
                                break;
                            }
                            case 7: {
                                this.lowerIcon = KeyBoard.this.i18n.getIcon(token);
                                break;
                            }
                            case 8: {
                                this.upperIcon = KeyBoard.this.i18n.getIcon(token);
                                break;
                            }
                        }
                    }
                    catch (Exception ex1) {
                        LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex1, (boolean)true, (String)("Cannot parse keys information for: " + name + " at token " + (i + 1) + " of '" + keyInformation + "'\n token seen as: '" + token));
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true, (String)("Cannot find key information for: " + name));
            }
            this.makeKey(this, row, toggle);
        }

        void makeKey(Key key, JPanel row, boolean toggle) {
            AbstractButton button = toggle ? new GhostToggleButton(KeyBoard.this.keyBoardThis) : new GhostButton(KeyBoard.this.keyBoardThis);
            button.setMargin(keyInsets);
            button.setPreferredSize(new Dimension(this.width * KeyBoard.this.cellWidth, KeyBoard.this.cellHeight));
            if (this.lowerIcon == null) {
                button.setIcon(null);
                button.setText(this.unshiftedFace);
            } else {
                button.setText("");
                button.setIcon(this.lowerIcon);
            }
            row.add((Component)button, new GridBagConstraints(this.column, 0, this.width, 1, 1.0, 1.0, 10, 1, keyInsets, 0, 0));
            button.addActionListener(KeyBoard.this.actionListener);
            button.setOpaque(false);
            button.setFocusPainted(false);
            button.addMouseListener(KeyBoard.this.keyBoardThis);
            button.addMouseMotionListener(KeyBoard.this.keyBoardThis);
            button.addKeyListener(KeyBoard.this.keyBoardThis);
            KeyBoard.this.buttons.put(button, key);
            switch (key.keyStroke.getKeyCode()) {
                case 18: {
                    KeyBoard.this.altKeys.add(button);
                    break;
                }
                case 17: {
                    KeyBoard.this.ctrlKeys.add(button);
                    break;
                }
                case 157: {
                    KeyBoard.this.metaKeys.add(button);
                    break;
                }
                case 16: {
                    KeyBoard.this.shiftKeys.add(button);
                    break;
                }
                default: {
                    if (!(button instanceof JToggleButton)) break;
                    KeyBoard.this.otherToggleKeys.add(button);
                }
            }
        }

        String decodeString(String token) {
            if (token == null || token.equals("")) {
                return token;
            }
            StringBuffer output = new StringBuffer(token.length());
            String newToken = token;
            int index = newToken.indexOf("@");
            while (index >= 0) {
                if (index > 0) {
                    output.append(newToken.substring(0, index - 1));
                }
                if (newToken.length() > index + 1) {
                    if (newToken.charAt(index + 1) == '1') {
                        output.append("@");
                        index += 2;
                    } else if (newToken.charAt(index + 1) == '2') {
                        output.append(",");
                        index += 2;
                    } else if (newToken.charAt(index + 1) == '3') {
                        output.append("\\");
                        index += 2;
                    } else {
                        output.append("@");
                        ++index;
                    }
                } else {
                    output.append("@");
                }
                newToken = newToken.length() > index + 2 ? newToken.substring(index + 2) : "";
                index = newToken.indexOf("@");
            }
            output.append(newToken);
            return output.toString();
        }

        char decodeChar(String token) {
            if (token == null || token.length() == 0) {
                return '\uffff';
            }
            if (token.length() == 1) {
                return token.charAt(0);
            }
            try {
                char value = (char)Integer.parseInt(token, 16);
                if (value == '\u0000') {
                    value = '\uffff';
                }
                return (char)value;
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"decodeChar", (Throwable)ex, (boolean)true, (String)("Cannot decode character code: " + token));
                return '\uffff';
            }
        }
    }

    class Row {
        LinkedList keys = new LinkedList();

        public Row(String keyboardName, String rowName, int rowIndex, JPanel row) {
            this.makeKeys(keyboardName, rowName, row);
        }

        public int getKeyCount() {
            return this.keys.size();
        }

        void makeKeys(String keyboardName, String rowName, JPanel row) {
            try {
                String keysString = KeyBoard.this.i18n.getStringLegacy(keyboardName + ".keys." + rowName);
                StringTokenizer tokenizer = new StringTokenizer(keysString, ",");
                String rowKey = keyboardName + ".key.";
                int column = 0;
                int keyIndex = 0;
                while (tokenizer.hasMoreTokens()) {
                    Key key = new Key(rowKey + tokenizer.nextToken().trim(), column, row);
                    this.keys.add(key);
                    column += key.width;
                    ++keyIndex;
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"makeKeys", (Throwable)ex, (boolean)true, (String)("Cannot parse keys information for: " + keyboardName + ".keys." + rowName));
            }
        }
    }
}

