/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.CompatibleFont;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.attributes.AttributeSetEvent;
import com.elluminate.groupware.whiteboard.attributes.ToolFontInterface;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickEditorPanel;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickMenuPicker;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.QuickEditorInterface;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesPanel;
import com.elluminate.gui.FontUtils;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class ToolFontEditorUI
extends QuickEditorPanel
implements QuickEditorInterface {
    private static final Icon NO_ICON = null;
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static final String[] fontFamilyNames = FontUtils.getFontNames();
    private static final int[] textSizes = new int[]{8, 9, 10, 11, 12, 14, 18, 24, 36, 48, 72};
    private static final String MULTI_FONT = "";
    private static final int MULTI_SIZE = -1;
    private FontPicker fontPicker;
    private SizePicker sizePicker;
    private JToggleButton boldButton = new JToggleButton();
    private JToggleButton italicButton = new JToggleButton();
    private JToggleButton underlineButton = new JToggleButton();
    private String commonFontName = "";
    private int commonFontSize = -1;
    private int boldCount = 0;
    private int italicCount = 0;
    private int underlineCount = 0;
    private int plainCount = 0;
    private boolean setBold = false;
    private boolean setItalic = false;
    private boolean setUnderline = false;
    private boolean sizeIsValid = true;
    private int commonStyle = 1;
    private boolean evaluating = false;
    private WhiteboardContext context;
    private HashSet<Object> sourceNodes = new HashSet();
    private AbstractAttribute attribute = null;
    private HashSet attributes = new HashSet();
    private HashMap fontSources = new HashMap();
    private boolean haveChanges = false;

    public void setContext(WhiteboardContext context) {
        this.context = context;
        try {
            this.initialize();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"setContext", (Throwable)ex, (boolean)true);
        }
    }

    private void initialize() {
        ImageIcon boldIcon = null;
        ImageIcon boldRolloverIcon = null;
        ImageIcon boldSelectedIcon = null;
        ImageIcon italicIcon = null;
        ImageIcon italicRolloverIcon = null;
        ImageIcon italicSelectedIcon = null;
        ImageIcon underlineIcon = null;
        ImageIcon underlineRolloverIcon = null;
        ImageIcon underlineSelectedIcon = null;
        this.fontPicker = new FontPicker(this.context);
        this.fontPicker.setFocusable(false);
        this.fontPicker.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_FONTTIP));
        this.fontPicker.setMinimumSize(new Dimension(100, 15));
        this.sizePicker = new SizePicker(this.context);
        this.sizePicker.setFocusable(false);
        this.sizePicker.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_SIZETIP));
        this.sizePicker.setMinimumSize(new Dimension(60, 15));
        try {
            boldIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_BOLDICON);
            boldRolloverIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_BOLDICONROLLOVER);
            boldSelectedIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_BOLDICONSELECTED);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"initialize", (Throwable)ex, (boolean)true);
        }
        try {
            italicIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_ITALICICON);
            italicRolloverIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_ITALICICONROLLOVER);
            italicSelectedIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_ITALICICONSELECTED);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"initialize", (Throwable)ex, (boolean)true);
        }
        try {
            underlineIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_UNDERLINEICON);
            underlineRolloverIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_UNDERLINEICONROLLOVER);
            underlineSelectedIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_UNDERLINEICONSELECTED);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"initialize", (Throwable)ex, (boolean)true);
        }
        this.italicButton.setIcon(italicIcon);
        this.italicButton.setRolloverIcon(italicRolloverIcon);
        this.italicButton.setRolloverSelectedIcon(italicRolloverIcon);
        this.italicButton.setSelectedIcon(italicSelectedIcon);
        this.italicButton.setFocusable(false);
        this.italicButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_ITALICTIP));
        this.italicButton.setBorder(null);
        this.setButtonState(this.italicButton, ButtonState.OFF);
        this.boldButton.setIcon(boldIcon);
        this.boldButton.setRolloverIcon(boldRolloverIcon);
        this.boldButton.setRolloverSelectedIcon(boldRolloverIcon);
        this.boldButton.setSelectedIcon(boldSelectedIcon);
        this.boldButton.setFocusable(false);
        this.boldButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_BOLDTIP));
        this.boldButton.setBorder(null);
        this.setButtonState(this.boldButton, ButtonState.OFF);
        this.underlineButton.setIcon(underlineIcon);
        this.underlineButton.setRolloverIcon(underlineRolloverIcon);
        this.underlineButton.setRolloverSelectedIcon(underlineRolloverIcon);
        this.underlineButton.setSelectedIcon(underlineSelectedIcon);
        this.underlineButton.setFocusable(false);
        this.underlineButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_UNDERLINETIP));
        this.underlineButton.setBorder(null);
        this.setButtonState(this.underlineButton, ButtonState.OFF);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.fontPicker);
        this.add(Box.createHorizontalStrut(6));
        this.add(this.sizePicker);
        this.add(new JSeparator(1));
        this.add(this.boldButton);
        this.add(this.italicButton);
        this.add(this.underlineButton);
        this.fontPicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolFontEditorUI.this.fontPickerChanged();
            }
        });
        this.sizePicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ToolFontEditorUI.this.sizePickerChanged();
            }
        });
        this.italicButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ToolFontEditorUI.this.italicButton_itemStateChanged(e);
            }
        });
        this.boldButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ToolFontEditorUI.this.boldButton_itemStateChanged(e);
            }
        });
        this.underlineButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ToolFontEditorUI.this.underlineButton_itemStateChanged(e);
            }
        });
    }

    public AttributeEditorInterface newInstance() {
        ToolFontEditorUI ui = new ToolFontEditorUI();
        ui.setContext(this.context);
        return ui;
    }

    public void addAttribute(AbstractAttribute attribute) {
        if (this.attribute == null) {
            this.attribute = attribute;
        }
        this.attributes.add(attribute);
        this.evaluateAttributes();
    }

    public boolean removeAttribute(AbstractAttribute attribute) {
        this.attributes.remove(attribute);
        this.evaluateAttributes();
        return this.attributes.isEmpty();
    }

    @Override
    public void addQuickAttribute(AbstractAttribute attribute, ToolPropertiesPanel panel) {
        if (attribute.getParent() != null) {
            this.sourceNodes.add(attribute.getParent());
        }
        if (attribute.isQuickAttribute() && attribute instanceof ToolFontInterface) {
            String attributeGroup = attribute.getTabName();
            QuickEditorInterface.RefCount refCount = (QuickEditorInterface.RefCount)this.fontSources.get(attributeGroup);
            if (refCount == null) {
                refCount = new QuickEditorInterface.RefCount();
                this.fontSources.put(attributeGroup, refCount);
            }
            refCount.addRef();
            this.addAttribute(attribute);
        }
        this.validateQuickVisibility();
    }

    @Override
    public void removeQuickAttribute(AbstractAttribute attribute) {
        this.sourceNodes.remove(attribute.getParent());
        if (attribute.isQuickAttribute() && attribute instanceof ToolFontInterface) {
            String attributeGroup = attribute.getTabName();
            QuickEditorInterface.RefCount refCount = (QuickEditorInterface.RefCount)this.fontSources.get(attributeGroup);
            if (refCount == null) {
                return;
            }
            refCount.removeRef();
            if (refCount.isEmpty()) {
                this.fontSources.remove(attributeGroup);
            }
            this.removeAttribute(attribute);
        }
        this.validateQuickVisibility();
    }

    @Override
    public void validateQuickVisibility() {
        boolean visible = this.attributes.size() > 0 && this.attributes.size() == this.sourceNodes.size();
        boolean enable = this.fontSources.size() == 1;
        this.setEnabled(enable);
        this.setVisible(visible && enable);
    }

    public void evaluateAttributes() {
        boolean initialize = true;
        this.evaluating = true;
        this.commonFontSize = -1;
        this.commonFontName = MULTI_FONT;
        for (ToolFontInterface toolFont : this.attributes) {
            if (initialize) {
                this.commonFontName = toolFont.getFontName();
                this.commonFontSize = toolFont.getFontSize();
                this.boldCount = 0;
                this.plainCount = 0;
                this.italicCount = 0;
                this.underlineCount = 0;
                initialize = false;
            } else {
                if (!toolFont.getFontName().equals(this.commonFontName)) {
                    this.commonFontName = MULTI_FONT;
                }
                if (toolFont.getFontSize() != this.commonFontSize) {
                    this.commonFontSize = -1;
                }
            }
            if ((toolFont.getFontStyle() & 1) != 0) {
                ++this.boldCount;
            }
            if (toolFont.getFontStyle() == 0) {
                ++this.plainCount;
            }
            if ((toolFont.getFontStyle() & 2) != 0) {
                ++this.italicCount;
            }
            if (!toolFont.isUnderline()) continue;
            ++this.underlineCount;
        }
        ButtonState boldBtnState = ButtonState.OFF;
        ButtonState italicBtnState = ButtonState.OFF;
        ButtonState underlineBtnState = ButtonState.OFF;
        if (this.boldCount != this.attributes.size() && this.boldCount > 0) {
            boldBtnState = ButtonState.MIXED;
        } else if (this.boldCount == this.attributes.size()) {
            boldBtnState = ButtonState.ON;
        }
        if (this.italicCount != this.attributes.size() && this.italicCount > 0) {
            italicBtnState = ButtonState.MIXED;
        } else if (this.italicCount == this.attributes.size()) {
            italicBtnState = ButtonState.ON;
        }
        if (this.underlineCount != this.attributes.size() && this.underlineCount > 0) {
            underlineBtnState = ButtonState.MIXED;
        } else if (this.underlineCount == this.attributes.size()) {
            underlineBtnState = ButtonState.ON;
        }
        this.fontPicker.setSelectedFontName(this.commonFontName);
        this.sizePicker.setSelectedTextSize(this.commonFontSize);
        this.setButtonState(this.boldButton, boldBtnState);
        this.setButtonState(this.italicButton, italicBtnState);
        this.setButtonState(this.underlineButton, underlineBtnState);
        boolean enable = !this.attributes.isEmpty();
        this.fontPicker.setEnabled(enable);
        this.sizePicker.setEnabled(enable);
        this.boldButton.setEnabled(enable);
        this.italicButton.setEnabled(enable);
        this.underlineButton.setEnabled(enable);
        this.evaluating = false;
    }

    private void fontPickerChanged() {
        if (!this.evaluating) {
            this.haveChanges = true;
            this.fireTabPropertiesChange(this);
        }
    }

    private void sizePickerChanged() {
        if (!this.evaluating) {
            this.haveChanges = true;
            this.fireTabPropertiesChange(this);
        }
    }

    private void boldButton_itemStateChanged(ItemEvent e) {
        if (!this.evaluating) {
            this.haveChanges = true;
            this.setBold = true;
            this.boldCount = 0;
            ButtonState btnState = this.boldButton.isSelected() ? ButtonState.ON : ButtonState.OFF;
            this.setButtonState(this.boldButton, btnState);
            this.fireTabPropertiesChange(this);
        }
    }

    private void italicButton_itemStateChanged(ItemEvent e) {
        if (!this.evaluating) {
            this.haveChanges = true;
            this.setItalic = true;
            this.italicCount = 0;
            ButtonState btnState = this.italicButton.isSelected() ? ButtonState.ON : ButtonState.OFF;
            this.setButtonState(this.italicButton, btnState);
            this.fireTabPropertiesChange(this);
        }
    }

    private void underlineButton_itemStateChanged(ItemEvent e) {
        if (!this.evaluating) {
            this.haveChanges = true;
            this.setUnderline = true;
            this.underlineCount = 0;
            ButtonState btnState = this.underlineButton.isSelected() ? ButtonState.ON : ButtonState.OFF;
            this.setButtonState(this.underlineButton, btnState);
            this.fireTabPropertiesChange(this);
        }
    }

    private void setButtonState(AbstractButton button, ButtonState state) {
        switch (state) {
            case ON: {
                button.setSelected(true);
                break;
            }
            case OFF: {
                button.setSelected(false);
                break;
            }
            case MIXED: {
                button.setSelected(false);
            }
        }
    }

    public void applyChanges() {
        if (this.haveChanges && !this.evaluating) {
            this.haveChanges = false;
            this.updateFont();
        }
    }

    public boolean isApplyValid() {
        return this.sizeIsValid;
    }

    private void updateFont() {
        boolean style = false;
        boolean changed = false;
        boolean underline = false;
        if (this.evaluating) {
            return;
        }
        String fontName = this.fontPicker.getSelectedFontName();
        int pointSize = this.sizePicker.getSelectedTextSize();
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            int newFontSize;
            String newFontName;
            changed = false;
            ToolFontInterface toolFont = (ToolFontInterface)iter.next();
            if (fontName.equals(MULTI_FONT)) {
                newFontName = toolFont.getFontName();
            } else {
                newFontName = fontName;
                if (!newFontName.equals(toolFont.getFontName())) {
                    changed = true;
                }
            }
            if (pointSize < 1) {
                newFontSize = toolFont.getFontSize();
            } else {
                newFontSize = pointSize;
                if (newFontSize != toolFont.getFontSize()) {
                    changed = true;
                }
            }
            int newFontStyle = toolFont.getFontStyle();
            if (this.setBold && this.boldCount == 0 || this.boldCount == this.attributes.size()) {
                newFontStyle = this.boldButton.isSelected() ? (newFontStyle |= 1) : (newFontStyle &= 0xFFFFFFFE);
            }
            if (this.setItalic && this.italicCount == 0 || this.italicCount == this.attributes.size()) {
                newFontStyle = this.italicButton.isSelected() ? (newFontStyle |= 2) : (newFontStyle &= 0xFFFFFFFD);
            }
            if (this.setUnderline && this.underlineCount == 0 || this.underlineCount == this.attributes.size()) {
                underline = this.underlineButton.isSelected();
            }
            if (newFontStyle != toolFont.getFontStyle()) {
                changed = true;
            }
            if (underline != toolFont.getFont().isUnderline()) {
                changed = true;
            }
            CompatibleFont cFont = new CompatibleFont(newFontName, newFontStyle, newFontSize, underline);
            if (!changed) continue;
            toolFont.setFont(cFont);
        }
    }

    public String getTabName() {
        return this.attribute.getTabName();
    }

    public String getDisplayName() {
        return this.attribute.getDisplayName();
    }

    @Override
    public void onAttributeSetChange(AttributeSetEvent e) {
        AttributeSet attributeSet = e.getData();
        String fontName = StyleConstants.getFontFamily(attributeSet);
        int fontSize = StyleConstants.getFontSize(attributeSet);
        boolean bold = StyleConstants.isBold(attributeSet);
        boolean italic = StyleConstants.isItalic(attributeSet);
        boolean underLine = StyleConstants.isUnderline(attributeSet);
        if (!this.fontPicker.getSelectedFontName().equals(fontName)) {
            this.fontPicker.setSelectedFontName(fontName);
        }
        if (this.sizePicker.getSelectedTextSize() != fontSize) {
            this.sizePicker.setSelectedTextSize(fontSize);
        }
        if (this.boldButton.isSelected() != bold) {
            this.boldButton.setSelected(bold);
        }
        if (this.italicButton.isSelected() != italic) {
            this.italicButton.setSelected(italic);
        }
        if (this.underlineButton.isSelected() != underLine) {
            this.underlineButton.setSelected(underLine);
        }
        this.evaluateAttributes();
    }

    private static enum ButtonState {
        OFF,
        ON,
        MIXED;

    }

    private class FontPicker
    extends QuickMenuPicker {
        private Map<String, JMenuItem> itemMap;

        FontPicker(WhiteboardContext context) {
            super(context.getThrowableListener());
            this.itemMap = new TreeMap<String, JMenuItem>();
            for (String fn : fontFamilyNames) {
                JMenuItem item = this.add(fn, NO_ICON);
                this.itemMap.put(fn, item);
            }
        }

        public String getSelectedFontName() {
            JMenuItem item = super.getSelectedItem();
            if (item == null) {
                return ToolFontEditorUI.MULTI_FONT;
            }
            String fn = item.getText();
            if (fn == null) {
                return ToolFontEditorUI.MULTI_FONT;
            }
            return fn;
        }

        public void setSelectedFontName(String fn) {
            super.setSelectedItem(this.itemMap.get(fn));
        }
    }

    private class SizePicker
    extends QuickMenuPicker {
        private Map<Integer, JMenuItem> itemMap;
        private Map<JMenuItem, Integer> reverseMap;

        SizePicker(WhiteboardContext context) {
            super(context.getThrowableListener());
            this.itemMap = new TreeMap<Integer, JMenuItem>();
            this.reverseMap = new HashMap<JMenuItem, Integer>();
            for (int sz : textSizes) {
                String text = i18n.getString((PropertiesEnum)StringsProperties.TOOLFONTEDITORUI_SIZEMENUTEXT, new Object[]{sz});
                JMenuItem item = this.add(text, NO_ICON);
                this.itemMap.put(sz, item);
                this.reverseMap.put(item, sz);
            }
        }

        public int getSelectedTextSize() {
            Integer sz = this.reverseMap.get(super.getSelectedItem());
            if (sz == null) {
                return -1;
            }
            return sz;
        }

        public void setSelectedTextSize(int sz) {
            super.setSelectedItem(this.itemMap.get(sz));
        }
    }
}

