/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AbstractToolEditorUI;
import com.elluminate.util.LightweightTimer;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

public abstract class QuickEditorPanel
extends AbstractToolEditorUI
implements Runnable {
    private static final int FADE_MILLIS = 150;
    private static final int SCALE_MILLIS = 150;
    private boolean inTransition = false;
    private boolean targetVisibility = false;
    private long transitionStartTime = 0L;
    private LightweightTimer animationTimer = new LightweightTimer(2, (Runnable)this);

    public QuickEditorPanel() {
        super.setVisible(false);
    }

    @Override
    public void setVisible(boolean b) {
        if (this.inTransition && b == this.targetVisibility) {
            return;
        }
        if (!this.inTransition && b == this.isVisible()) {
            return;
        }
        if (this.inTransition) {
            long dt = System.currentTimeMillis() - this.transitionStartTime;
            this.transitionStartTime = System.currentTimeMillis() + dt - 150L - 150L;
        } else {
            this.inTransition = true;
            this.transitionStartTime = System.currentTimeMillis();
        }
        this.targetVisibility = b;
        this.animationTimer.scheduleEvery(40L);
        if (!this.isVisible()) {
            super.setVisible(true);
        }
    }

    @Override
    public void run() {
        this.repaint();
        this.revalidate();
        if (!this.inTransition) {
            this.animationTimer.cancel();
            this.transitionStartTime = 0L;
            return;
        }
        long dt = System.currentTimeMillis() - this.transitionStartTime;
        if (dt > 300L) {
            this.inTransition = false;
            super.setVisible(this.targetVisibility);
        }
    }

    private double computeEasing(double doneness) {
        return Math.max(0.0, Math.min(1.0, doneness));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.getTargetSize();
        if (!this.inTransition) {
            return dim;
        }
        long dt = System.currentTimeMillis() - this.transitionStartTime;
        double scale = this.targetVisibility ? this.computeEasing((double)dt / 150.0) : 1.0 - this.computeEasing((double)(dt - 150L) / 150.0);
        return new Dimension((int)Math.round((double)dim.width * scale), dim.height);
    }

    public Dimension getTargetSize() {
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintChildren(Graphics g) {
        if (!this.inTransition) {
            super.paintChildren(g);
        } else {
            long dt = System.currentTimeMillis() - this.transitionStartTime;
            double alpha = this.targetVisibility ? this.computeEasing((double)(dt - 150L) / 150.0) : 1.0 - this.computeEasing((double)dt / 150.0);
            AlphaComposite composite = AlphaComposite.getInstance(3, (float)alpha);
            Graphics2D g2 = null;
            try {
                g2 = (Graphics2D)g.create();
                g2.setComposite(composite);
                super.paintChildren(g2);
            }
            finally {
                if (g2 != null) {
                    g2.dispose();
                }
            }
        }
    }
}

