/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class WBScroller
extends JScrollPane {
    private List dressings = new Vector();
    private boolean mouseEnabled = false;
    private MouseAdapter mouseAdapter = null;
    private MouseMotionAdapter mouseMotionAdapter = null;
    private ContainerAdapter containerAdapter = null;
    private boolean setViewport = true;
    private int maxDressingWidth = 0;
    private int maxDressingHeight = 0;

    public WBScroller() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                WBScroller.this.processMouseReleased(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                WBScroller.this.processMouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WBScroller.this.processMouseExited(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                WBScroller.this.processMousePressed(e);
            }
        };
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                WBScroller.this.processMouseMotionEvent(e);
            }
        };
        this.containerAdapter = new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                WBScroller.this.this_componentRemoved(e);
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                WBScroller.this.this_componentAdded(e);
            }
        };
        this.addComponentListener(this.getViewport());
        this.addListeners(this.getViewport());
        this.enableMouse(true);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.mouseEnabled) {
            return;
        }
        for (JComponent component : this.dressings) {
            component.paint(g);
        }
    }

    private void viewport_Changed(ChangeEvent e) {
        if (this.mouseEnabled) {
            this.repaintAll();
        }
    }

    public void addComponent(JComponent component) {
        if (this.setViewport) {
            this.setDoubleBuffered(true);
            this.getViewport().setScrollMode(2);
            this.setViewport = false;
        }
        this.dressings.add(component);
        this.getComponentSize();
        this.repaintComponent(component);
    }

    public void processMouseReleased(MouseEvent e) {
        Point contPoint = new Point(SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.getViewport()));
        for (JComponent component : this.dressings) {
            if (!component.isVisible()) continue;
        }
    }

    public void processMousePressed(MouseEvent e) {
        this.processMouseMotionEvent(e);
    }

    public void processMouseEntered(MouseEvent e) {
        this.processMouseMotionEvent(e);
    }

    public void processMouseExited(MouseEvent e) {
        this.processMouseMotionEvent(e);
    }

    @Override
    public void processMouseMotionEvent(MouseEvent e) {
        Component comp = (Component)e.getSource();
        Point contPoint = new Point(SwingUtilities.convertPoint(comp, e.getPoint(), this.getViewport()));
        for (JComponent component : this.dressings) {
            this.repaintComponent(component);
        }
        super.processMouseEvent(e);
    }

    public void enableMouse(boolean enable) {
        if (enable) {
            // empty if block
        }
        this.disableEvents(16L);
        this.disableEvents(32L);
        if (this.mouseEnabled != enable) {
            this.repaintAll();
        }
        this.mouseEnabled = enable;
    }

    void this_componentRemoved(ContainerEvent e) {
        Component comp = e.getChild();
        comp.removeMouseListener(this.mouseAdapter);
        comp.removeMouseMotionListener(this.mouseMotionAdapter);
        if (comp instanceof JComponent) {
            ((JComponent)comp).removeContainerListener(this.containerAdapter);
        }
    }

    void this_componentAdded(ContainerEvent e) {
        Component comp = e.getChild();
        if (comp instanceof JComponent) {
            JComponent jComp = (JComponent)comp;
            this.addComponentListener(jComp);
            this.addListeners(jComp);
        } else {
            this.addListeners(comp);
        }
    }

    private void addListeners(Component comp) {
        comp.addMouseListener(this.mouseAdapter);
        comp.addMouseMotionListener(this.mouseMotionAdapter);
    }

    private void addComponentListener(JComponent comp) {
        comp.addContainerListener(this.containerAdapter);
    }

    public void repaintComponent(JComponent component) {
        this.repaint(component.getBounds(this.getViewBounds()));
    }

    private void repaintAll() {
        this.getComponentSize();
        for (JComponent component : this.dressings) {
            this.repaintComponent(component);
        }
    }

    private Rectangle getViewBounds() {
        Rectangle viewBounds = new Rectangle(this.getViewport().getBounds());
        Dimension viewSize = new Dimension(this.getViewport().getSize());
        if (this.getViewport().getComponentCount() > 0) {
            viewBounds.setSize(Math.min(Math.min(viewBounds.width, viewSize.width), this.getMaximumSize().width + this.maxDressingWidth), Math.min(Math.min(viewBounds.height, viewSize.height), this.getMaximumSize().height + this.maxDressingHeight));
        }
        return viewBounds;
    }

    private void getComponentSize() {
        this.maxDressingWidth = 0;
        this.maxDressingHeight = 0;
        for (JComponent component : this.dressings) {
            if (!component.isVisible()) continue;
            this.maxDressingWidth = Math.max(component.getWidth(), this.maxDressingWidth);
            this.maxDressingHeight = Math.max(component.getHeight(), this.maxDressingHeight);
        }
    }
}

