/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolStack
extends JPanel {
    public static final String SELECTION_CHANGED_CMD = "selectionChanged";
    private static final int BADGE_OFFSET = -2;
    private static final int DEFAULT_HORIZONTAL_GAP = 2;
    private static final int DEFAULT_VERTICAL_GAP = 2;
    private static final int SELECTOR_MASK = 7104;
    private static final int HOLD_TO_POPUP_TIME = 100;
    private I18n i18n = I18n.create((Object)this);
    private DisplayPane displayPane;
    private Icon badgeIcon;
    private StackIcon mainIcon;
    private StackIcon mainDisabledIcon;
    private StackIcon mainPressedIcon;
    private StackIcon mainSelectedIcon;
    private StackIcon mainRolloverIcon;
    private StackIcon mainRolloverSelectedIcon;
    private JToggleButton mainButton = new JToggleButton();
    private List<AbstractButton> buttons = new ArrayList<AbstractButton>();
    private AbstractButton lastSelectedBtn = null;
    private AbstractButton hoverBtn = null;
    private Dimension maxDims = new Dimension(1, 1);
    private ActionListener btnActionListener;
    private ChangeListener btnStateListener;
    private AWTEventListener awtMotionListener;
    private AWTEventListener popupCancelListener;
    private Popup popup = null;
    private ListenerRegistry<ActionListener> actionListeners;
    private final LightweightTimer selectorTimer;

    public ToolStack(ThrowableListener tl) {
        this(tl, 2, 2, Integer.MAX_VALUE);
    }

    public ToolStack(ThrowableListener tl, int hGap, int vGap) {
        this(tl, hGap, vGap, Integer.MAX_VALUE);
    }

    public ToolStack(ThrowableListener tl, int hGap, int vGap, int nPerRow) {
        super(null);
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.actionListeners = new ListenerRegistry(tl);
        this.displayPane = new DisplayPane(hGap, vGap, nPerRow);
        this.displayPane.setBorder(BorderFactory.createEmptyBorder(vGap, hGap, vGap, hGap));
        this.displayPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                ToolStack.this.hideSelector();
            }
        });
        this.badgeIcon = this.i18n.getIcon((PropertiesEnum)StringsProperties.TOOLSTACK_STACKBADGEICON);
        this.mainIcon = new StackIcon(null, this.badgeIcon);
        this.mainDisabledIcon = new StackIcon(null, this.badgeIcon);
        this.mainPressedIcon = new StackIcon(null, this.badgeIcon);
        this.mainSelectedIcon = new StackIcon(null, this.badgeIcon);
        this.mainRolloverIcon = new StackIcon(null, this.badgeIcon);
        this.mainRolloverSelectedIcon = new StackIcon(null, this.badgeIcon);
        this.mainButton.setIcon(this.mainIcon);
        this.add(this.mainButton);
        final Runnable doHideSelector = new Runnable(){

            @Override
            public void run() {
                ToolStack.this.hideSelector();
            }
        };
        Runnable doShowSelector = new Runnable(){

            @Override
            public void run() {
                ToolStack.this.showSelector();
            }
        };
        this.selectorTimer = new LightweightTimer(2, doShowSelector);
        this.awtMotionListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent ev) {
                if (!ToolStack.this.isShowingSelector()) {
                    return;
                }
                if (ev.getID() != 506) {
                    return;
                }
                if (!(ev instanceof MouseEvent)) {
                    return;
                }
                MouseEvent me = (MouseEvent)ev;
                Point pt = SwingUtilities.convertPoint(me.getComponent(), me.getX(), me.getY(), ToolStack.this.displayPane);
                AbstractButton btn = ToolStack.this.findButton(pt);
                if (btn == ToolStack.this.hoverBtn) {
                    return;
                }
                if (ToolStack.this.hoverBtn != null) {
                    ToolStack.this.dragOverButton(ToolStack.this.hoverBtn, false);
                }
                if (btn != null) {
                    ToolStack.this.dragOverButton(btn, true);
                }
                ToolStack.this.hoverBtn = btn;
            }
        };
        this.popupCancelListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent ev) {
                if (ev.getID() == 501) {
                    if (!(ev instanceof MouseEvent)) {
                        return;
                    }
                    MouseEvent me = (MouseEvent)ev;
                    Component cmp = me.getComponent();
                    if (ToolStack.this.displayPane.isAncestorOf(cmp)) {
                        return;
                    }
                    SwingRunnerSupport.invokeLater((Runnable)doHideSelector);
                    if (!ToolStack.this.displayPane.isAncestorOf(cmp) && UIManager.getBoolean("PopupMenu.consumeEventOnClose")) {
                        me.consume();
                    }
                }
            }
        };
        this.mainButton.addMouseListener(new MouseAdapter(){
            private boolean mouseIsDown = false;

            @Override
            public void mousePressed(MouseEvent ev) {
                if (ev.isConsumed()) {
                    return;
                }
                this.mouseIsDown = true;
                ToolStack.this.hoverBtn = null;
                Toolkit tKit = Toolkit.getDefaultToolkit();
                tKit.addAWTEventListener(ToolStack.this.awtMotionListener, 506L);
                if (ev.isPopupTrigger()) {
                    ToolStack.this.showSelector();
                    return;
                }
                ToolStack.this.selectorTimer.scheduleIn(100L);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (!this.mouseIsDown) {
                    return;
                }
                this.mouseIsDown = false;
                Toolkit tKit = Toolkit.getDefaultToolkit();
                tKit.removeAWTEventListener(ToolStack.this.awtMotionListener);
                ToolStack.this.selectorTimer.cancel();
                for (AbstractButton btn : ToolStack.this.buttons) {
                    ToolStack.this.dragOverButton(btn, false);
                }
                if (ToolStack.this.isShowingSelector()) {
                    if (ToolStack.this.hoverBtn != null) {
                        ToolStack.this.hoverBtn.doClick();
                    }
                } else if (ev.isPopupTrigger()) {
                    ToolStack.this.showSelector();
                } else if (ToolStack.this.lastSelectedBtn != null) {
                    Point pt = ev.getPoint();
                    if (ToolStack.this.mainButton.contains(pt)) {
                        ToolStack.this.lastSelectedBtn.doClick();
                    } else {
                        ToolStack.this.mirrorButtonState();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent ev) {
                if (this.mouseIsDown) {
                    ToolStack.this.selectorTimer.scheduleIn(100L);
                }
            }

            @Override
            public void mouseExited(MouseEvent ev) {
                ToolStack.this.selectorTimer.cancel();
            }
        });
        this.btnActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AbstractButton btn = (AbstractButton)ev.getSource();
                if (!ToolStack.this.buttons.contains(btn)) {
                    return;
                }
                ToolStack.this.selectButton(btn);
            }
        };
        this.btnStateListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                AbstractButton btn = (AbstractButton)ev.getSource();
                if (!ToolStack.this.buttons.contains(btn)) {
                    return;
                }
                if (btn.isSelected()) {
                    ToolStack.this.updateSelected(btn);
                }
                ToolStack.this.mirrorButtonState();
            }
        };
    }

    private AbstractButton findButton(Point pt) {
        for (AbstractButton btn : this.buttons) {
            if (pt.x < btn.getX() || pt.x > btn.getX() + btn.getWidth() || pt.y < btn.getY() || pt.y > btn.getY() + btn.getHeight()) continue;
            return btn;
        }
        return null;
    }

    private void dragOverButton(AbstractButton btn, boolean over) {
        btn.setBorderPainted(over && btn.isEnabled());
        btn.setContentAreaFilled(over && btn.isEnabled());
        ButtonModel bm = btn.getModel();
        bm.setArmed(over);
        bm.setPressed(over);
    }

    private void updateSelected(AbstractButton btn) {
        boolean changed = this.lastSelectedBtn != btn;
        this.lastSelectedBtn = btn;
        this.mainIcon.setIcon(btn == null ? null : btn.getIcon());
        Icon icon = btn == null ? null : btn.getDisabledIcon();
        this.mainDisabledIcon.setIcon(icon);
        this.mainButton.setDisabledIcon(icon == null ? null : this.mainDisabledIcon);
        icon = btn == null ? null : btn.getPressedIcon();
        this.mainPressedIcon.setIcon(icon);
        this.mainButton.setPressedIcon(icon == null ? null : this.mainPressedIcon);
        icon = btn == null ? null : btn.getSelectedIcon();
        this.mainSelectedIcon.setIcon(icon);
        this.mainButton.setSelectedIcon(icon == null ? null : this.mainSelectedIcon);
        icon = btn == null ? null : btn.getRolloverIcon();
        this.mainRolloverIcon.setIcon(icon);
        this.mainButton.setRolloverIcon(icon == null ? null : this.mainRolloverIcon);
        icon = btn == null ? null : btn.getRolloverSelectedIcon();
        this.mainRolloverSelectedIcon.setIcon(icon);
        this.mainButton.setRolloverSelectedIcon(icon == null ? null : this.mainRolloverSelectedIcon);
        this.mainButton.setText(btn == null ? null : btn.getText());
        this.mainButton.setToolTipText(btn == null ? null : btn.getToolTipText());
        this.mainButton.setMargin(btn == null ? new Insets(0, 0, 0, 0) : btn.getMargin());
        this.mainButton.setFocusable(btn == null ? false : btn.isFocusable());
        this.mainButton.setBorderPainted(btn == null ? false : btn.isBorderPainted());
        this.mainButton.setContentAreaFilled(btn == null ? false : btn.isContentAreaFilled());
        this.mainButton.setBorder(btn == null ? null : btn.getBorder());
        if (changed) {
            this.fireActionListener();
        }
        this.displayPane.invalidate();
        this.mainButton.invalidate();
    }

    private void mirrorButtonState() {
        boolean isSelected = false;
        for (AbstractButton btn : this.buttons) {
            if (!btn.isSelected()) continue;
            isSelected = true;
            break;
        }
        if (this.mainButton.isSelected() != isSelected) {
            this.mainButton.setSelected(isSelected);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add((Object)l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove((Object)l);
    }

    protected void fireActionListener() {
        FiringFunctor<ActionListener> ff = new FiringFunctor<ActionListener>(){
            ActionEvent ev = null;

            public void fire(ActionListener l) {
                if (this.ev == null) {
                    this.ev = new ActionEvent(ToolStack.this, 1001, ToolStack.SELECTION_CHANGED_CMD);
                }
                l.actionPerformed(this.ev);
            }
        };
        this.actionListeners.fire((FiringFunctor)ff);
    }

    public AbstractButton getMainButton() {
        return this.mainButton;
    }

    @Override
    public String getToolTipText() {
        return this.mainButton.getToolTipText();
    }

    @Override
    public void setToolTipText(String text) {
        this.mainButton.setToolTipText(text);
    }

    @Override
    public boolean isFocusable() {
        return this.mainButton.isFocusable();
    }

    @Override
    public void setFocusable(boolean b) {
        this.mainButton.setFocusable(b);
    }

    public void addButton(AbstractButton btn) {
        Dimension pref = btn.getPreferredSize();
        int prevWidth = this.maxDims.width;
        int prevHeight = this.maxDims.height;
        this.buttons.add(btn);
        this.displayPane.add(btn);
        btn.addActionListener(this.btnActionListener);
        btn.addChangeListener(this.btnStateListener);
        this.maxDims.width = Math.max(pref.width + Math.max(0, -2), this.maxDims.width);
        this.maxDims.height = Math.max(pref.height + Math.max(0, -2), this.maxDims.height);
        if (this.maxDims.width != prevWidth || this.maxDims.height != prevHeight) {
            this.mainButton.setPreferredSize(this.maxDims);
        }
        if (this.buttons.size() == 1) {
            this.selectButton(btn);
        }
    }

    public void selectButton(AbstractButton btn) {
        this.hideSelector();
        this.updateSelected(btn);
        this.mirrorButtonState();
        this.repaint();
    }

    public AbstractButton getSelectedButton() {
        return this.lastSelectedBtn;
    }

    public boolean isShowingSelector() {
        return this.popup != null;
    }

    public void showSelector() {
        if (this.isShowingSelector()) {
            return;
        }
        this.selectorTimer.cancel();
        Toolkit tKit = Toolkit.getDefaultToolkit();
        tKit.addAWTEventListener(this.popupCancelListener, 501L);
        PopupFactory f = PopupFactory.getSharedInstance();
        Point loc = this.mainButton.getLocationOnScreen();
        Insets marge = this.mainButton.getMargin();
        Insets ins = this.displayPane.getInsets();
        this.popup = f.getPopup(this, this.displayPane, loc.x + marge.left - ins.left, loc.y + marge.top - ins.top);
        this.popup.show();
    }

    public void hideSelector() {
        this.selectorTimer.cancel();
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.removeAWTEventListener(this.popupCancelListener);
        if (!this.isShowingSelector()) {
            return;
        }
        this.mirrorButtonState();
        Popup p = this.popup;
        this.popup = null;
        if (p != null) {
            p.hide();
        }
    }

    private class DisplayPane
    extends JPanel {
        int hGap;
        int vGap;
        int nPerRow;

        public DisplayPane(int hGap, int vGap, int nPerRow) {
            super(null);
            this.hGap = hGap;
            this.vGap = vGap;
            this.nPerRow = nPerRow;
        }

        @Override
        public Dimension getPreferredSize() {
            Component[] components = this.getComponents();
            Dimension result = new Dimension();
            Insets ins = this.getInsets();
            int rowWidth = ins.left + ins.right;
            int rowHeight = 0;
            result.width = ins.left + ins.right;
            result.height = ins.top + ins.bottom;
            int nOnRow = 0;
            int nRows = 0;
            for (Component c : components) {
                if (nOnRow >= this.nPerRow) {
                    if (nRows > 0) {
                        rowHeight += this.vGap;
                    }
                    result.height += rowHeight;
                    result.width = Math.max(result.width, rowWidth);
                    rowHeight = 0;
                    rowWidth = ins.left + ins.right;
                    nOnRow = 0;
                    ++nRows;
                }
                Dimension dim = c.getPreferredSize();
                if (nOnRow > 0) {
                    rowWidth += this.hGap;
                }
                rowWidth += dim.width;
                rowHeight = Math.max(rowHeight, dim.height);
                ++nOnRow;
            }
            if (nOnRow > 0) {
                if (nRows > 0) {
                    rowHeight += this.vGap;
                }
                result.height += rowHeight;
                result.width = Math.max(result.width, rowWidth);
                rowHeight = 0;
                rowWidth = ins.left + ins.right;
                ++nRows;
            }
            return result;
        }

        @Override
        public void doLayout() {
            Insets ins = this.getInsets();
            AbstractButton cur = ToolStack.this.getSelectedButton();
            Point pos = new Point(ins.left, ins.top);
            this.place(cur, pos);
            int nOnRow = 1;
            int rowHeight = cur.getHeight();
            for (Component c : this.getComponents()) {
                if (c == cur) continue;
                if (nOnRow >= this.nPerRow) {
                    pos.x = ins.left;
                    pos.y += rowHeight + this.vGap;
                    rowHeight = 0;
                    nOnRow = 0;
                }
                this.place(c, pos);
                rowHeight = Math.max(rowHeight, c.getHeight());
                ++nOnRow;
            }
        }

        private void place(Component c, Point pos) {
            Dimension dim = c.getPreferredSize();
            c.setSize(dim.width, dim.height);
            c.setLocation(pos.x, pos.y);
            pos.x += dim.width + this.hGap;
        }
    }

    private static class StackIcon
    implements Icon {
        private Icon base = null;
        private Icon badge = null;

        public StackIcon(Icon base, Icon badge) {
            this.base = base;
            this.badge = badge;
        }

        public void setIcon(Icon icon) {
            this.base = icon;
        }

        public void setBadge(Icon icon) {
            this.badge = icon;
        }

        @Override
        public int getIconHeight() {
            int h = 0;
            if (this.base != null) {
                h = Math.max(h, this.base.getIconHeight() + Math.max(0, -2));
            }
            if (this.badge != null) {
                h = Math.max(h, this.badge.getIconHeight());
            }
            return h;
        }

        @Override
        public int getIconWidth() {
            int w = 0;
            if (this.base != null) {
                w = Math.max(w, this.base.getIconWidth() + Math.max(0, -2));
            }
            if (this.badge != null) {
                w = Math.max(w, this.badge.getIconWidth());
            }
            return w;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.base != null) {
                this.base.paintIcon(c, g, x, y);
            }
            if (this.badge != null) {
                int dx = this.getIconWidth() - this.badge.getIconWidth() + -2;
                int dy = this.getIconHeight() - this.badge.getIconHeight() + -2;
                this.badge.paintIcon(c, g, x + dx, y + dy);
            }
        }
    }
}

