/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ToolSelectionListener;
import com.elluminate.groupware.whiteboard.listeners.ClientIDListener;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavigator;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPaneMouseAdapter;
import com.elluminate.groupware.whiteboard.module.ui.DisplayUtilities;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.ToolCellEditor;
import com.elluminate.groupware.whiteboard.module.ui.ToolCellRenderer;
import com.elluminate.groupware.whiteboard.module.ui.ToolEditMouseAdapter;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ToolNavigator
extends AbstractNavigator
implements ClientIDListener,
TreeModelListener,
ToolSelectionListener {
    public static final String SLIDE_TITLE_PROP = "slideTitle";
    private ScreenModel screen;
    private boolean displayUpdating = false;
    ControllerPaneMouseAdapter keyProcessor;
    private String screenName = "";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    Runnable displayUpdateRunnable = new DisplayUpdateRunnable();

    public ToolNavigator(WhiteboardContext context, ScreenModel screen, ControllerPaneMouseAdapter keyProcessor) {
        super(context);
        this.keyProcessor = keyProcessor;
        this.setScreen(screen);
    }

    public void addTitleChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(SLIDE_TITLE_PROP, l);
    }

    public void removeTitleChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(SLIDE_TITLE_PROP, l);
    }

    @Override
    public void setModel(DisplayModel model) {
        if (super.getModel() != null) {
            super.getModel().removeTreeModelListener(this);
        }
        super.setModel(model);
        model.addTreeModelListener((TreeModelListener)this);
    }

    @Override
    void frameClosing(WindowEvent e) {
        this.canClose();
    }

    boolean canClose() {
        if (this.context != null && this.context.getController() != null && ((ControllerPane)this.context.getController()).getPostToolNavigator()) {
            this.context.getController().postNavigator(false);
        }
        return false;
    }

    public void setScreen(ScreenModel screen) {
        if (this.screen == screen) {
            return;
        }
        this.screen = screen;
        if (screen.getToolTreeModel() == null) {
            DisplayUtilities.createToolTreeModel(screen, this.context);
        }
        ToolEditMouseAdapter mouseAdapter = new ToolEditMouseAdapter(this.context, this);
        this.setModel(screen.getToolTreeModel());
        this.navigatorTree.addKeyListener(this);
        this.setMotionAdapter(mouseAdapter);
        this.navigatorTree.setShowsRootHandles(true);
        ToolCellRenderer toolRenderer = new ToolCellRenderer(this.context);
        this.navigatorTree.setCellRenderer(toolRenderer);
        ToolCellEditor editor = new ToolCellEditor((JTree)((Object)this.navigatorTree), (DefaultTreeCellRenderer)toolRenderer, this.context);
        this.navigatorTree.setCellEditor(editor);
        this.navigatorTree.setShowThumbnails(this.context.getBean().areThumbnailsShowing());
        mouseAdapter.setScreen(screen, this.navigatorTree);
        this.setScreenName(i18n.getString((PropertiesEnum)StringsProperties.TOOLNAVIGATOR_ITEM, new Object[]{screen.getScreenName()}));
        this.setSelections(true);
        this.processNodeChange();
        this.navigatorTree.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelections(boolean visible) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Iterator iter = this.screen.getSelectedToolListIterator();
            while (iter.hasNext()) {
                DisplayNode peer = ((WBNode)iter.next()).getDisplayPeer();
                if (peer == null) continue;
                TreePath path = new TreePath(peer.getDisplayModel().getPathToRoot((TreeNode)peer));
                this.addSelectionPath(path);
            }
        }
        this.navigatorTree.expandRow(0);
    }

    public void onSelectTool(AbstractToolModel tool) {
        TreePath path;
        if (tool.getDisplayPeer() != null && (path = new TreePath(tool.getDisplayPeer().getPath())) != null && !this.navigatorTree.isPathSelected(path)) {
            this.addSelectionPath(path);
        }
    }

    public void onDeSelectTool(AbstractToolModel tool) {
        TreePath path;
        if (tool.getDisplayPeer() != null && (path = new TreePath(tool.getDisplayPeer().getPath())) != null && this.navigatorTree.isPathSelected(path)) {
            this.navigatorTree.removeSelectionPath(path);
        }
    }

    private void addSelectionPath(TreePath path) {
        this.navigatorTree.addSelectionPath(path);
        this.navigatorTree.expandPath(path);
    }

    public void setPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        DisplayNode node;
        if (e.getTreePath().getLastPathComponent() instanceof DisplayNode && (node = (DisplayNode)e.getTreePath().getLastPathComponent()).getUserObject() instanceof String) {
            this.setScreenName((String)node.getUserObject());
        }
        try {
            this.navigatorTree.expandRow(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setScreenName(String screenName) {
        String oldName = this.screenName;
        this.screenName = screenName;
        this.pcs.firePropertyChange(SLIDE_TITLE_PROP, oldName, screenName);
    }

    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.processNodeChange();
    }

    private String pathToString(TreePath path) {
        StringBuffer buf = new StringBuffer();
        Object[] components = path.getPath();
        for (int i = 0; i < components.length; ++i) {
            buf.append(components[i].toString());
            if (i >= components.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public void onClientID(int type, Short clientId, Short clientAddress) {
        this.updateDisplay();
    }

    private void updateDisplay() {
        SwingRunnerSupport.invokeLater((Runnable)this.displayUpdateRunnable);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.processNodeChange();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        boolean controlDown = (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() & e.getModifiers()) != 0;
        this.keyProcessor.processAcceleratorKey(e, controlDown);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyTyped(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyTyped(e);
    }

    private class DisplayUpdateRunnable
    implements Runnable {
        private DisplayUpdateRunnable() {
        }

        @Override
        public void run() {
            DisplayModel model = (DisplayModel)ToolNavigator.this.navigatorTree.getModel();
            model.nodeStructureChanged((TreeNode)model.getRoot());
            ToolNavigator.this.processNodeChange();
        }
    }
}

