/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavMouseAdapter;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavigator;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.groupware.whiteboard.module.ui.ToolEditPopup;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.TextToolModel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ToolEditMouseAdapter
extends AbstractNavMouseAdapter
implements TreeSelectionListener {
    ScreenModel screen;
    WhiteboardContext context;
    boolean enabled = true;

    public ToolEditMouseAdapter(WhiteboardContext context, AbstractNavigator navigator) {
        super(context, navigator);
        this.context = context;
        this.screen = null;
    }

    public void setScreen(ScreenModel screen, DndTree navTree) {
        this.screen = screen;
        navTree.addTreeSelectionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handlePopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        DndTree navTree = (DndTree)((Object)e.getSource());
        int selRow = navTree.getRowForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            TextToolModel tool;
            DisplayNode displayNode;
            Object obj;
            if (e.getClickCount() != 1 && e.getClickCount() == 2 && navTree.getSelectionCount() == 1 && (obj = navTree.getSelectionPath().getLastPathComponent()) instanceof DisplayNode && (displayNode = (DisplayNode)obj).whiteboardPeer() != null && displayNode.whiteboardPeer() instanceof TextToolModel && (tool = (TextToolModel)displayNode.whiteboardPeer()).isEditable()) {
                tool.startEditing();
                this.context.getController().requestFocus();
            }
        } else {
            navTree.clearSelection();
        }
        if (navTree.getSelectionCount() > 0) {
            navTree.requestFocus();
        }
        this.handlePopup(e);
    }

    private void handlePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.context.getController().isRightButton(false, e)) {
                this.context.getController().consumeRightButton();
            }
            this.managePopup(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void managePopup(MouseEvent e) {
        if (this.screen == null || !this.enabled) {
            return;
        }
        DndTree navTree = (DndTree)((Object)e.getSource());
        ToolEditPopup popup = new ToolEditPopup((JComponent)((Object)navTree), this.context, "ToolEdit", this.screen);
        popup.show((Component)((Object)navTree), e.getX(), e.getY());
        this.navigator.registerPopup((JPopupMenu)((Object)popup));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.screen == null) {
            return;
        }
        TreePath[] paths = e.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            DisplayNode node = (DisplayNode)paths[i].getLastPathComponent();
            if (!(node.getUserObject() instanceof AbstractToolModel)) continue;
            AbstractToolModel tool = (AbstractToolModel)node.getUserObject();
            if (tool != null && (!tool.isInBackground() || tool.findScreenParent() != null && tool.findScreenParent().canEditBackground())) {
                if (e.isAddedPath(paths[i]) && tool.isObjectExplorerSelectable()) {
                    this.screen.selectTool(tool);
                    continue;
                }
                this.screen.deSelectTool(tool);
                continue;
            }
            if (!(e.getSource() instanceof JTree)) continue;
            ((JTree)e.getSource()).removeSelectionPath(paths[i]);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

