/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class SizedNumericFilter
extends DocumentFilter {
    private int maxSize;

    public SizedNumericFilter() {
        this(Integer.MAX_VALUE);
    }

    public SizedNumericFilter(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
        this.replace(fb, offset, 0, text, attrs);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int delLength, String text, AttributeSet attrs) throws BadLocationException {
        if (fb.getDocument().getLength() - delLength + text.length() > this.maxSize) {
            return;
        }
        try {
            Integer.parseInt(text);
            super.replace(fb, offset, delLength, text, attrs);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }
}

