/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanelListener;
import com.elluminate.groupware.whiteboard.module.ui.SizedNumericFilter;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class ScreenSizePanel
extends JPanel {
    private static I18n i18n = I18n.create((Object)new Object(){});
    public static final String[] displayComboStrings = new String[]{"ScreenSizePanel.1024X768", "ScreenSizePanel.1280X720", "ScreenSizePanel.1280X1024", "ScreenSizePanel.1440X900", "ScreenSizePanel.1600X1200", "ScreenSizePanel.1680X1050", "ScreenSizePanel.1920X1080", "ScreenSizePanel.CurrentCanvas"};
    public static final int SIZE_FROM_CANVAS = -1;
    public static final int[] displayWidths = new int[]{758, 1014, 1014, 1174, 1334, 1414, 1654, -1};
    public static final int[] displayHeights = new int[]{579, 531, 835, 711, 1011, 861, 891, -1};
    private static int comboSelection = 1;
    private JRadioButton canvasRadioButton = new JRadioButton();
    private JRadioButton displayRadioButton = new JRadioButton();
    private JComboBox displaySizeCombo = new JComboBox();
    private ButtonGroup radioGroup = new ButtonGroup();
    private JLabel widthLabel = new JLabel();
    private JTextField screenWidthText = new JTextField(5);
    private JLabel heightLabel = new JLabel();
    private JTextField screenHeightText = new JTextField(5);
    private boolean enabled = true;
    boolean maskChangeNotify = true;
    ScreenSizePanelListener listener;
    private ButtonModel lastSizeSource;
    private String lastScreenWidth;
    private String lastScreenHeight;
    private int maxWidth;
    private int maxHeight;
    private Color disabledColor = Color.lightGray;
    WhiteboardContext context;

    public ScreenSizePanel(WhiteboardContext context, ScreenSizePanelListener listener, int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.context = context;
        this.listener = listener;
        this.setLayout(new GridLayout(0, 1, 0, 4));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(i18n.getString((PropertiesEnum)StringsProperties.SCREENSIZEPANEL_SIZEPANELTITLE)), BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.displayRadioButton.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENSIZEPANEL_COMBORADIOTEXT));
        this.canvasRadioButton.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENSIZEPANEL_CANVASRADIOTEXT));
        this.widthLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENSIZEPANEL_WIDTHTEXT));
        this.heightLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENSIZEPANEL_HEIGHTTEXT));
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this.displayRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.displaySizeCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        p.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(p);
        p = new JPanel(new GridBagLayout());
        p.add((Component)this.canvasRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.widthLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        p.add((Component)this.screenWidthText, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        p.add((Component)this.heightLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        p.add((Component)this.screenHeightText, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        p.add(Box.createHorizontalGlue(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(p);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleEvent(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleEvent(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleEvent(e);
            }

            private void handleEvent(DocumentEvent e) {
                if (!ScreenSizePanel.this.maskChangeNotify) {
                    ScreenSizePanel.this.listener.onScreenSizePanelChange();
                }
            }
        };
        this.screenWidthText.setHorizontalAlignment(4);
        this.screenWidthText.setText("0");
        AbstractDocument doc = (AbstractDocument)this.screenWidthText.getDocument();
        doc.addDocumentListener(dl);
        doc.setDocumentFilter(new SizedNumericFilter(4));
        this.setToolTipText(this.screenWidthText, "ScreenSizePanel.widthRangeTip", 50, maxWidth);
        this.screenHeightText.setHorizontalAlignment(4);
        this.screenHeightText.setText("0");
        doc = (AbstractDocument)this.screenHeightText.getDocument();
        doc.addDocumentListener(dl);
        doc.setDocumentFilter(new SizedNumericFilter(4));
        this.setToolTipText(this.screenHeightText, "ScreenSizePanel.heightRangeTip", 50, maxHeight);
        this.radioGroup.add(this.displayRadioButton);
        this.radioGroup.add(this.canvasRadioButton);
        for (int i = 0; i < displayComboStrings.length; ++i) {
            this.displaySizeCombo.addItem(i18n.getStringLegacy(displayComboStrings[i]));
        }
        this.displaySizeCombo.setSelectedIndex(comboSelection);
        this.displaySizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ScreenSizePanel.this.maskChangeNotify) {
                    ScreenSizePanel.this.listener.onScreenSizePanelChange();
                }
            }
        });
        this.disabledColor = this.screenWidthText.getBackground();
        this.canvasRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenSizePanel.this.selectRadioButton(ScreenSizePanel.this.canvasRadioButton);
                ScreenSizePanel.this.setSizeTipText();
                if (!ScreenSizePanel.this.maskChangeNotify) {
                    ScreenSizePanel.this.listener.onScreenSizePanelChange();
                }
            }
        });
        this.displayRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenSizePanel.this.selectRadioButton(ScreenSizePanel.this.displayRadioButton);
                ScreenSizePanel.this.setSizeTipText();
                if (!ScreenSizePanel.this.maskChangeNotify) {
                    ScreenSizePanel.this.listener.onScreenSizePanelChange();
                }
            }
        });
        this.lastSizeSource = this.radioGroup.getSelection();
        this.setSizeTipText();
    }

    private void setToolTipText(JTextField textField, String tipKey, int min, int max) {
        textField.setToolTipText(i18n.getStringLegacy(tipKey, new Object[]{new Integer(min), new Integer(max)}));
    }

    private void setSizeTipText() {
        int index = this.displaySizeCombo.getSelectedIndex();
        Integer width = new Integer(displayWidths[index]);
        Integer height = new Integer(displayHeights[index]);
        if (width < 0 || height < 0) {
            Dimension size = ((ControllerPane)this.context.getController()).getViewExtentSize().getSize();
            width = new Integer(size.width);
            height = new Integer(size.height);
        }
        this.displaySizeCombo.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SCREENSIZEPANEL_SIZETIP, new Object[]{width, height}));
    }

    public void setDefaultSize(Dimension size) {
        this.setSelections(size);
    }

    public void populateScreenSize(Dimension[] sizes) {
        this.setSelections(sizes[0]);
        this.maskChangeNotify = true;
        for (int i = 1; i < sizes.length; ++i) {
            if (sizes[0].width != sizes[i].width) {
                this.screenWidthText.setText("");
            }
            if (sizes[0].height == sizes[i].width) continue;
            this.screenHeightText.setText("");
        }
        this.maskChangeNotify = false;
    }

    private void setSelections(Dimension size) {
        this.maskChangeNotify = true;
        this.screenWidthText.setText(Integer.toString(size.width));
        this.screenHeightText.setText(Integer.toString(size.height));
        this.screenWidthText.setMinimumSize(this.screenWidthText.getPreferredSize());
        this.screenHeightText.setMinimumSize(this.screenHeightText.getPreferredSize());
        boolean canvasSelected = false;
        if (size.height > 50 && size.width > 50) {
            canvasSelected = true;
        }
        for (int i = 0; i < displayHeights.length; ++i) {
            if (size.width != displayWidths[i] || size.height != displayHeights[i]) continue;
            canvasSelected = false;
            this.displaySizeCombo.setSelectedIndex(i);
            comboSelection = i;
        }
        if (canvasSelected) {
            this.selectRadioButton(this.canvasRadioButton);
        } else {
            this.selectRadioButton(this.displayRadioButton);
        }
        this.maskChangeNotify = false;
    }

    private void selectRadioButton(JRadioButton button) {
        if (button == this.displayRadioButton) {
            this.displayRadioButton.setSelected(true);
        } else if (button == this.canvasRadioButton) {
            this.canvasRadioButton.setSelected(true);
        }
        boolean en = this.displayRadioButton.isSelected();
        this.displaySizeCombo.setEnabled(en);
        en = this.canvasRadioButton.isSelected();
        this.heightLabel.setEnabled(en);
        this.screenHeightText.setEnabled(en);
        this.widthLabel.setEnabled(en);
        this.screenWidthText.setEnabled(en);
        this.isHeightValid();
        this.isWidthValid();
        this.repaint();
        if (!this.maskChangeNotify) {
            this.listener.onScreenSizePanelChange();
        }
    }

    private Dimension getComboSize() {
        comboSelection = this.displaySizeCombo.getSelectedIndex();
        Dimension d = new Dimension(displayWidths[comboSelection], displayHeights[comboSelection]);
        Dimension size = ((ControllerPane)this.context.getController()).getViewExtentSize().getSize();
        d.width = this.checkFromCanvas(d.width, size.width);
        d.height = this.checkFromCanvas(d.height, size.height);
        return d;
    }

    private int checkFromCanvas(int value, int override) {
        return value != -1 ? value : override;
    }

    public boolean isSizeValid() {
        if (this.displayRadioButton.isSelected()) {
            return true;
        }
        return this.isWidthValid() && this.isHeightValid();
    }

    private boolean isWidthValid() {
        return this.validateInput(this.screenWidthText, 50, this.maxWidth);
    }

    private boolean isHeightValid() {
        return this.validateInput(this.screenHeightText, 50, this.maxHeight);
    }

    private int getIntValue(JTextField textField) {
        return this.getIntValue(textField, -1);
    }

    private int getIntValue(JTextField textField, int defaultValue) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private boolean validateInput(JTextField textField, int min, int max) {
        String input = textField.getText().trim();
        if (input.length() == 0) {
            return false;
        }
        try {
            int raw = Integer.parseInt(input);
            if (raw < min || raw > max) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private int limitValue(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    private void setColor(JTextField field, boolean bad) {
        if (bad) {
            field.setBackground(Color.pink);
        } else if (field.isEditable()) {
            field.setBackground(Color.white);
        } else {
            field.setBackground(this.disabledColor);
        }
    }

    @Override
    public Dimension getSize(Dimension oldSize) {
        Dimension returnSize = null;
        returnSize = this.displayRadioButton.isSelected() ? this.getComboSize() : this.getCustomSize();
        if (returnSize.equals(oldSize)) {
            return null;
        }
        return returnSize;
    }

    private Dimension getCustomSize() {
        return new Dimension(this.getIntValue(this.screenWidthText), this.getIntValue(this.screenHeightText));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.canvasRadioButton.setEnabled(enabled);
        this.displayRadioButton.setEnabled(enabled);
        if (enabled) {
            boolean en = this.displayRadioButton.isSelected();
            this.displaySizeCombo.setEnabled(en);
            en = this.canvasRadioButton.isSelected();
            this.heightLabel.setEnabled(en);
            this.screenHeightText.setEnabled(en);
            this.widthLabel.setEnabled(en);
            this.screenWidthText.setEnabled(en);
        } else {
            this.displaySizeCombo.setEnabled(false);
            this.heightLabel.setEnabled(false);
            this.screenHeightText.setEnabled(false);
            this.widthLabel.setEnabled(false);
            this.screenWidthText.setEnabled(false);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void saveSettings() {
        this.lastSizeSource = this.radioGroup.getSelection();
        this.lastScreenWidth = this.screenWidthText.getText();
        this.lastScreenHeight = this.screenHeightText.getText();
    }

    public void restoreSettings() {
        this.lastSizeSource.setSelected(true);
        this.screenWidthText.setText(this.lastScreenWidth);
        this.screenHeightText.setText(this.lastScreenHeight);
        this.isWidthValid();
        this.isHeightValid();
    }
}

