/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.util.SwingRunnerSupport;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JProgressBar;

public class ProgressInputStream
extends FilterInputStream {
    private JProgressBar progressBar = null;
    private int size = 0;
    private int nread = 0;
    private int mr = 0;
    private int delta = 0;

    public ProgressInputStream(JProgressBar progressBar, InputStream in) {
        super(in);
        this.progressBar = progressBar;
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0;
        }
        progressBar.setMaximum(this.size);
        progressBar.setMinimum(0);
        progressBar.setStringPainted(true);
        this.delta = this.size / 100;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.setValue(++this.nread);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.setValue(this.nread += nr);
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.setValue(this.nread += nr);
        }
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread = (int)((long)this.nread + nr);
            this.setValue(this.nread);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.setValue(this.nread);
    }

    private void setValue(final int value) {
        if (value - this.delta >= this.progressBar.getValue() || value >= this.progressBar.getMaximum()) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressInputStream.this.progressBar.setValue(value);
                }
            });
        }
    }
}

