/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.PointerToolModel;
import com.elluminate.groupware.whiteboard.tools.PointerUIInterface;
import com.elluminate.util.log.LogSupport;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class PointerUI
extends AbstractUI
implements PointerUIInterface {
    public void draw(Graphics g, AbstractToolModel tool) {
        if (!(tool instanceof PointerToolModel) || tool.isDeleted()) {
            return;
        }
        PointerToolModel pointerTool = (PointerToolModel)tool;
        Rectangle2D rectangle = (Rectangle2D)tool.getUIData();
        if (rectangle == null) {
            rectangle = new Rectangle2D.Double();
            tool.setUIData((Object)rectangle);
        }
        if (tool.isUIInvalid()) {
            Rectangle rect = tool.getBounds();
            int x = rect.width < 0 ? rect.x + rect.width : rect.x;
            int y = rect.height < 0 ? rect.y + rect.height : rect.y;
            int w = rect.width < 0 ? -rect.width : rect.width;
            int h = rect.height < 0 ? -rect.height : rect.height;
            rectangle.setFrame(x, y, w, h);
            tool.setUIInvalid(false);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (pointerTool.getPointerImageData() != null && pointerTool.isVisible() && pointerTool.getPointerImageData() != null) {
            try {
                Image image = pointerTool.getPointerImageAttribute().getImage();
                if (image != null) {
                    try {
                        boolean done = g2.drawImage(image, pointerTool.getBounds().x, pointerTool.getBounds().y, pointerTool.getBounds().width, pointerTool.getBounds().height, null);
                        pointerTool.getPointerImageAttribute().imageRendered();
                    }
                    catch (Throwable ex) {
                        LogSupport.exception((Object)((Object)this), (String)"draw", (Throwable)ex, (boolean)true);
                    }
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }
}

