/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.gui.component.ComboBoxCellRenderer;
import com.elluminate.gui.swing.CTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

class NavEntryRenderer
extends ComboBoxCellRenderer {
    static final String prefix = "                                                                                                                                ";
    Font titleFont;
    Font clientRootFont;
    Font serverRootFont;
    Font privateRootFont;
    WhiteboardContext context;

    public NavEntryRenderer(WhiteboardContext context, ListCellRenderer defaultRenderer) {
        super(defaultRenderer);
        this.context = context;
        Font f = UIManager.getFont("ComboBox.font");
        this.titleFont = f.deriveFont(1, f.getSize() + 2);
        this.clientRootFont = f.deriveFont(1);
        this.serverRootFont = f.deriveFont(1, f.getSize() + 2);
        this.privateRootFont = f.deriveFont(3);
    }

    protected void prepareComponent(Component cmp, JList list, Object value, int index, boolean selected, boolean focused) {
        if (!(cmp instanceof JLabel) || value == null) {
            return;
        }
        int depth = 0;
        if (index < 0) {
            cmp.setFont(this.titleFont);
        } else if (value instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)value;
            if (screen.isDeleted()) {
                ((JLabel)cmp).setText("*** Node has been deleted ***");
            }
            for (ScreenModel p = screen; p != null && !(p instanceof ScreenRoot) && depth < prefix.length(); depth += 6, p = p.getParent()) {
            }
            if (screen instanceof ScreenRoot) {
                if (((ScreenRoot)screen).isPrivate()) {
                    cmp.setFont(this.privateRootFont);
                } else if (ObjectUID.decodeClientId((Long)screen.getObjectID()) == 1) {
                    cmp.setFont(this.serverRootFont);
                } else {
                    cmp.setFont(this.clientRootFont);
                }
            }
            if (!screen.isVisible()) {
                cmp.setForeground(Color.red);
            }
        }
        if (value instanceof ScreenModel) {
            if (depth > 0) {
                ((JLabel)cmp).setText(prefix.substring(0, Math.min(prefix.length(), depth)) + ((ScreenModel)value).getScreenName());
            } else {
                ((JLabel)cmp).setText(((ScreenModel)value).getScreenName());
            }
        } else if (value instanceof String) {
            ((JLabel)cmp).setText((String)value);
        }
    }

    class TreeComboCellRenderer
    extends CTree
    implements ListCellRenderer {
        int visibleRow;
        JList list;

        TreeComboCellRenderer() {
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, this.list.getHeight());
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
            this.visibleRow = index;
            this.list = list;
            return this;
        }
    }
}

