/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavigator;
import com.elluminate.groupware.whiteboard.module.ui.JDOMNavMouseAdapter;
import com.elluminate.groupware.whiteboard.module.ui.MainTreeNavigator;
import com.elluminate.groupware.whiteboard.module.ui.ScreenCellRenderer;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;

public class JDOMNavigator
extends AbstractNavigator {
    JDOMNavMouseAdapter mouseAdapter = null;

    private JDOMNavigator() {
        this(null, null);
    }

    public JDOMNavigator(WhiteboardContext context, DisplayModel model) {
        super(context);
        super.setModel(model);
        this.navigatorTree.setEditable(true);
        this.navigatorTree.setRootVisible(false);
        this.navigatorTree.setShowsRootHandles(true);
        this.navigatorTree.setCellRenderer(new ScreenCellRenderer(context));
        this.mouseAdapter = new JDOMNavMouseAdapter(context, this);
        this.setMotionAdapter(this.mouseAdapter);
        this.navigatorTree.addKeyListener(this);
        ((WhiteboardBean)context.getBean()).addShowThumbnailsListener(new WhiteboardBean.ShowThumbnailsListener(){

            @Override
            public void showThumbnailsChanged(WhiteboardBean.ShowThumbnailsEvent e) {
                JDOMNavigator.this.navigatorTree.setRowHeight(16);
                JDOMNavigator.this.navigatorTree.setShowThumbnails(e.isShowingThumbnails());
            }
        });
    }

    @Override
    void frameClosing(WindowEvent e) {
        this.navigatorTree = null;
    }

    boolean canClose() {
        return true;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        MainTreeNavigator.processAcceleratorKey(e, this.navigatorTree, this.context);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        MainTreeNavigator.processAcceleratorKey(e, this.navigatorTree, this.context);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        MainTreeNavigator.processAcceleratorKey(e, this.navigatorTree, this.context);
    }
}

