/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageFileFilter;
import com.elluminate.groupware.whiteboard.module.imageloading.ImagePreview;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageSelectionButton;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageTable;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.SelectFrame;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.AppSnapListener;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.groupware.whiteboard.tools.ImageUIInterface;
import com.elluminate.groupware.whiteboard.tools.PaletteListener;
import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.ProgressSteps;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CTabbedPane;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.image.PICTImporter;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileFilter;

public class ImageUI
extends AbstractUI
implements ImageUIInterface {
    static I18n i18n = I18n.create((Object)new Object(){});
    private static File lastDirectory = Platform.getDefaultDir();
    private static String lastClipArtTab = "";
    private static int captureCounter = 0;
    private AppSnap appSnap = null;
    private EasyDialog paletteDialog = null;
    private static final boolean HAS_ZORDER_BUG = Platform.checkOSVersion((int)202, (String)"10.5*") && Platform.checkJavaVersion((String)"1.5*");

    public void draw(Graphics g, AbstractToolModel tool) {
        Image image;
        Rectangle2D rectangle = (Rectangle2D)tool.getUIData();
        ImageToolModel imageTool = (ImageToolModel)tool;
        WBImage wbImage = imageTool.getImage();
        if (rectangle == null && imageTool.visibleBorder()) {
            rectangle = new Rectangle2D.Double();
            tool.setUIData((Object)rectangle);
        }
        if (!imageTool.hasImage()) {
            return;
        }
        if (tool.isUIInvalid()) {
            if (rectangle == null) {
                rectangle = new Rectangle();
            }
            Rectangle rect = tool.getBounds();
            int x = rect.width < 0 ? rect.x + rect.width : rect.x;
            int y = rect.height < 0 ? rect.y + rect.height : rect.y;
            int w = rect.width < 0 ? -rect.width : rect.width;
            int h = rect.height < 0 ? -rect.height : rect.height;
            rectangle.setFrame(x, y, w, h);
            tool.setUIInvalid(false);
        }
        Graphics2D g2 = (Graphics2D)g;
        Composite oldComposite = null;
        if (tool.getColor().getAlpha() < 255 && tool.getColor().getAlpha() > 0) {
            oldComposite = g2.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, (float)tool.getColor().getAlpha() / 255.0f);
            g2.setComposite(alphaComposite);
        }
        if (wbImage != null && wbImage.getImageObject() != null && (image = wbImage.getImage()) != null) {
            try {
                if (tool.getColor().getAlpha() == 0) {
                    Color transColor = (Color)tool.getColor().getColor();
                    image = this.makeColorTransparent(image, transColor);
                }
                g2.drawImage(image, tool.getBounds().x, tool.getBounds().y, tool.getBounds().width, tool.getBounds().height, null);
            }
            catch (Throwable ex) {
                LogSupport.exception((Object)((Object)this), (String)"draw", (Throwable)ex, (boolean)true);
            }
        }
        if (oldComposite != null) {
            g2.setComposite(oldComposite);
        }
        if (imageTool.visibleBorder()) {
            try {
                g2.setStroke((BasicStroke)tool.getStroke().getStroke());
                g2.setColor((Color)tool.getColor().getColor());
                g2.draw(rectangle);
            }
            catch (Throwable ex1) {
                // empty catch block
            }
        }
    }

    public WBImage postFileDialog(String title, String buttonName, ScreenModel screen) {
        CFileChooser ch = new CFileChooser();
        if (lastDirectory != null) {
            ch.setCurrentDirectory(lastDirectory);
        }
        ch.setDialogTitle(title);
        ch.setApproveButtonText(buttonName);
        ch.removeChoosableFileFilter(ch.getAcceptAllFileFilter());
        ch.setFileFilter((FileFilter)new ImageFileFilter());
        ImagePreview access = new ImagePreview((JFileChooser)ch, screen.getScreenSize().width / 3, screen.getScreenSize().height / 3);
        ch.setAccessory((JComponent)access);
        WBImage im = null;
        WhiteboardContext context = screen.getContext();
        Frame f = context.getDialogParentFrame();
        if (ch.showOpenDialog((Component)f) == 0) {
            File file = ch.getSelectedFile();
            im = this.loadImage(context, file);
            lastDirectory = file.getParentFile();
        }
        access.dispose();
        return im;
    }

    public WBImage postClipArtPalette(PaletteListener _pl, String title, ScreenModel screen) {
        final PaletteListener pl = _pl;
        final WhiteboardContext context = screen.getContext();
        final ButtonGroup grp = new ButtonGroup();
        Frame f = context.getDialogParentFrame();
        this.paletteDialog = new EasyDialog((Component)f, title, false);
        int prefWidth = 800;
        this.paletteDialog.setResizable(true);
        this.paletteDialog.getRootPane().putClientProperty("Window.style", "small");
        MouseInputAdapter mouseListener = new MouseInputAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getSource() instanceof ImageSelectionButton) {
                    ImageUI.this.handleClipArtSelection(pl, context, grp, e.getClickCount() > 1);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getSource() instanceof ImageSelectionButton) {
                    ImageSelectionButton b = (ImageSelectionButton)e.getSource();
                    b.doClick();
                    pl.paletteItemDragged();
                    TransferHandler handler = b.getTransferHandler();
                    handler.exportAsDrag(b, e, 1);
                }
            }
        };
        boolean usingButtonAquaTabs = Platform.getLAF() == 502 && Platform.checkOSVersion((int)202, (String)"10.3+") && Platform.checkJavaVersion((String)"1.4+");
        CTabbedPane tp = new CTabbedPane(1, 1){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.getTabCount() == 0) {
                    String txt = i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_NOACTIVECLIPARTPALETTE);
                    FontMetrics fm = g.getFontMetrics();
                    g.drawString(txt, (this.getWidth() - fm.stringWidth(txt)) / 2, (this.getHeight() - fm.getAscent() - fm.getDescent()) / 2 + fm.getAscent());
                }
            }
        };
        Font font = tp.getFont();
        tp.setFont(font.deriveFont((float)(font.getSize() * 11 / 12)));
        this.paletteDialog.setContent((Component)tp);
        JScrollPane bogusTab = new JScrollPane();
        tp.addTab(null, (Component)bogusTab);
        this.paletteDialog.setInsets(null);
        this.paletteDialog.pack();
        Rectangle b1 = bogusTab.getBounds();
        Container parent = tp.getParent();
        b1 = SwingUtilities.convertRectangle((Component)tp, b1, parent);
        Rectangle b2 = parent.getBounds();
        Insets ins = new Insets(6, -(b1.x - b2.x), -(b2.y + b2.height - b1.y - b1.height), -(b2.x + b2.width - b1.x - b1.width));
        this.paletteDialog.setInsets(ins);
        tp.remove((Component)bogusTab);
        this.paletteDialog.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Dimension ps = ImageUI.this.paletteDialog.getPreferredSize();
                Dimension s = ImageUI.this.paletteDialog.getSize();
                if (s.height != ps.height) {
                    ImageUI.this.paletteDialog.setSize(s.width, ps.height);
                }
            }
        });
        this.paletteDialog.addWindowListener((WindowListener)new ClipArtWindowListener(pl, tp, grp, (Window)this.paletteDialog));
        if (WhiteboardModule.palettes == null) {
            LogSupport.message((Object)((Object)this), (String)"postClipArtPalette", (String)"Null whiteboard palettes. Aborting");
            return null;
        }
        Iterator itr = WhiteboardModule.palettes.paletteEntryIterator();
        while (itr.hasNext()) {
            ImageTable imageTable;
            PaletteEntry entry = (PaletteEntry)itr.next();
            if (!WhiteboardModule.palettes.canShow(entry, context.isChair()) || (imageTable = ImageTable.draggableTableFromResource(entry, mouseListener, grp)) == null) continue;
            imageTable.setBorder(BorderFactory.createEmptyBorder(2, 4, 6, 4));
            String resourceTitle = entry.getLocalizedPaletteTitle();
            JScrollPane sp = new JScrollPane(imageTable);
            sp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            sp.setHorizontalScrollBarPolicy(32);
            sp.setVerticalScrollBarPolicy(21);
            JScrollBar sb = sp.getHorizontalScrollBar();
            sb.setUnitIncrement(imageTable.getButtonWidth());
            int block = sb.getBlockIncrement();
            if ((block /= imageTable.getButtonWidth()) > 0) {
                sb.setBlockIncrement(block * imageTable.getButtonWidth());
            }
            if (usingButtonAquaTabs) {
                sp.setOpaque(false);
                sp.getViewport().setOpaque(false);
                imageTable.setOpaque(false);
            }
            tp.addTab(resourceTitle, (Component)sp);
        }
        if (tp.getTabCount() > 0) {
            int index = tp.indexOfTab(lastClipArtTab);
            if (index < 0 || index >= tp.getTabCount()) {
                index = 0;
            }
            tp.setSelectedIndex(index);
        }
        this.paletteDialog.pack();
        Dimension s = this.paletteDialog.getSize();
        if (s.width != prefWidth) {
            this.paletteDialog.setSize(prefWidth, s.height);
        }
        this.paletteDialog.setFocusable(false);
        this.paletteDialog.setFocusableWindowState(false);
        if (HAS_ZORDER_BUG) {
            this.paletteDialog.setAlwaysOnTop(true);
        } else {
            this.paletteDialog.toFront();
        }
        context.getController().addToolComponentToQuiesce((Window)this.paletteDialog);
        this.paletteDialog.show();
        return null;
    }

    private void handleClipArtPaletteClosed(CTabbedPane tp, ButtonGroup grp) {
        if (tp.getTabCount() > 0) {
            lastClipArtTab = tp.getTitleAt(tp.getSelectedIndex());
        }
        Enumeration<AbstractButton> enm = grp.getElements();
        while (enm.hasMoreElements()) {
            AbstractButton obj = enm.nextElement();
            if (!(obj instanceof ImageSelectionButton)) continue;
            ((ImageSelectionButton)obj).flush();
        }
    }

    private void handleClipArtSelection(PaletteListener pl, WhiteboardContext context, ButtonGroup grp, boolean doubleClick) {
        WBImage paletteImage = null;
        ImageData selectedPaletteItem = null;
        Enumeration<AbstractButton> enm = grp.getElements();
        while (enm.hasMoreElements()) {
            ImageSelectionButton b;
            AbstractButton obj = enm.nextElement();
            if (!(obj instanceof ImageSelectionButton) || !(b = (ImageSelectionButton)obj).isSelected()) continue;
            selectedPaletteItem = b.getData();
            if (selectedPaletteItem == null) break;
            paletteImage = ImageUI.loadImage(null, context, selectedPaletteItem.getImageBytes(), selectedPaletteItem.getPathname(), selectedPaletteItem.getToolTipString(), null);
            paletteImage.setPaletteType(selectedPaletteItem.getPaletteType());
            pl.paletteItemSelected(paletteImage, doubleClick, (Object)b);
            break;
        }
    }

    public WBImage postScreenCaptureDialog(AppSnapListener callback, ScreenModel screen) {
        if (SelectFrame.isAvailable()) {
            if (this.appSnap == null) {
                this.appSnap = new AppSnap(screen);
            }
            this.appSnap.reset(screen);
            this.appSnap.snapImage(callback, screen);
        }
        return null;
    }

    public static WBImage loadImage(File selectedFile, WhiteboardContext context, byte[] imageBytes, String imageName, String displayName, Component hostComponent) {
        WBImage image = null;
        if (selectedFile != null) {
            if (!ImageMimeUtilities.isCommonImageFile((File)selectedFile)) {
                try {
                    Image orig = ImageSupport.loadImage((File)selectedFile, (boolean)true);
                    String pngName = FileSysUtils.replaceExtension((String)selectedFile.getName(), (String)"png");
                    byte[] pngBytes = null;
                    pngBytes = ImageSupport.encodeAsPNG((Image)orig, (int)9);
                    image = new WBImage(context, pngBytes, pngName, pngName);
                }
                catch (Throwable t) {
                    Component component = hostComponent;
                    if (component == null) {
                        component = context.getDialogParentFrame();
                    }
                    ModalDialog.showMessageDialog((Component)component, (Object)i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_CANNOTLOAD, new Object[]{selectedFile.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_CANNOTLOADTITLE), (int)0);
                }
            } else {
                image = new WBImage(context, selectedFile);
            }
        } else if (imageBytes != null && imageName != null && (image = new WBImage(context, imageBytes, imageName, displayName)) != null) {
            image.getSize();
        }
        return ImageUI.validateImage(image, context, hostComponent);
    }

    public static void showLoadImageErrorDialog(Component dialogParent, String fileName, String msg) {
        ModalDialog.showMessageDialog((Component)dialogParent, (Object)i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_CANNOTLOAD, new Object[]{fileName, msg}), (String)i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_CANNOTLOADTITLE), (int)0);
    }

    public WBImage loadImage(WhiteboardContext context, File selectedFile) {
        return ImageUI.loadImage(selectedFile, context, null, selectedFile.getName(), selectedFile.getName(), null);
    }

    public WBImage loadImage(WhiteboardContext context, Image image) {
        byte[] imageBytes = ImageSupport.encodeAsPNG((Image)image, (int)9);
        WBImage wbImage = new WBImage(context, imageBytes, "unknown.png", "Dropped Image.png");
        return ImageUI.validateImage(wbImage, context, null);
    }

    public WBImage loadImage(WhiteboardContext context, InputStream is) {
        try {
            return this.loadImage(context, PICTImporter.convertPICT((InputStream)is, (boolean)true));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"loadImage", (Throwable)ex, (boolean)true);
            return null;
        }
    }

    private static WBImage validateImage(WBImage wbImage, WhiteboardContext context, Component hostComponent) {
        if (wbImage != null) {
            String imageFileName = wbImage.getImageFilename();
            if (!wbImage.imageExists()) {
                String reason = wbImage.getErrorMessage();
                if (reason == null) {
                    reason = "";
                }
                ModalDialog.showMessageDialog((Component)ImageUI.getComponent(context, hostComponent), (Object)i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_CANNOTLOAD, new Object[]{imageFileName, reason}), (String)i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_CANNOTLOADTITLE), (int)0);
                wbImage = null;
                return null;
            }
            if (context.getMediaCache().isCacheFull()) {
                long overSize = context.getMediaCache().getCacheSize() - context.getMediaCache().getMaxImageCache();
                wbImage.delete();
                wbImage = null;
                ModalDialog.showMessageDialog((Component)ImageUI.getComponent(context, hostComponent), (Object)i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_TOOBIG, new Object[]{new Long(overSize)}), (String)i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_TOOBIGTITLE), (int)0);
            }
        }
        return wbImage;
    }

    private static Component getComponent(WhiteboardContext context, Component host) {
        if (host == null) {
            return context.getDialogParentFrame();
        }
        return host;
    }

    private Image makeColorTransparent(Image im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    private class AppSnap {
        private final WhiteboardContext context;
        private Frame appFrame = null;
        private final ArrayList<Runnable> origWinState = new ArrayList();
        private int canvasWidth = 1014;
        private int canvasHeight = 835;
        private boolean cancelled = false;
        private SelectFrame selectFrame = null;
        private Rectangle selectRectangle = null;
        private byte[] imageBytes = null;
        private Dimension lastSelectSize = null;
        private Point lastSelectLocation = null;

        AppSnap(ScreenModel screen) {
            this.context = screen.getContext();
        }

        public synchronized void reset(ScreenModel screen) {
            this.appFrame = this.context.getDialogParentFrame();
            this.origWinState.clear();
            Dimension dim = screen == null ? null : screen.getScreenSize();
            this.canvasWidth = dim == null ? 1014 : dim.width;
            this.canvasHeight = dim == null ? 835 : dim.height;
            this.cancelled = false;
            this.selectRectangle = null;
            this.imageBytes = null;
            if (this.selectFrame != null) {
                this.selectFrame.disposeImage();
                this.selectFrame.dispose();
                this.selectFrame = null;
            }
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public byte[] getImageBytes() {
            return this.imageBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void snapImage(final AppSnapListener callback, final ScreenModel screen) {
            Runnable mainAction = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.notifyAll();
                    }
                    AppSnap.this.performSnap(callback, screen);
                }
            };
            WorkerThread doIt = new WorkerThread(mainAction, "AppSnap Image Capture");
            doIt.setDaemon(true);
            try {
                Runnable runnable = mainAction;
                synchronized (runnable) {
                    doIt.start();
                    mainAction.wait();
                }
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"snapImage", (Throwable)t, (boolean)true);
                callback.terminateCapture();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void performSnap(AppSnapListener callback, ScreenModel screen) {
            Runnable startAction = new Runnable(){

                @Override
                public void run() {
                    AppSnap.this.startSnap();
                }
            };
            Runnable cleanupAction = new Runnable(){

                @Override
                public void run() {
                    AppSnap.this.unhideApplicationWindows(AppSnap.this.origWinState);
                    AppSnap.this.reset(null);
                }
            };
            try {
                try {
                    SwingRunnerSupport.invokeAndWait((Runnable)startAction);
                }
                catch (InterruptedException intx) {
                    this.cancelled = true;
                }
                if (!this.cancelled) {
                    try {
                        this.imageBytes = this.encodeImage(this.selectFrame.getSelectedImage(), this.selectRectangle.width, this.selectRectangle.height, this.canvasWidth, this.canvasHeight);
                    }
                    catch (OutOfMemoryError oom) {
                        this.cancelled = true;
                        this.imageBytes = null;
                        String msg = i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_MEMORYERRORMSG);
                        String title = i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_ERRORTITLE);
                        ModalDialog.showMessageDialog(null, (Object)msg, (String)title, (int)0);
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"performSnap", (Throwable)t, (boolean)true);
                    }
                }
                if (!this.cancelled) {
                    String name = i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_CAPTUREIMAGENAME, new Object[]{++captureCounter, "jpg"});
                    WBImage wim = ImageUI.loadImage(null, this.context, this.imageBytes, name, name, null);
                    callback.captureImageProvided(wim, screen);
                }
            }
            finally {
                SwingRunnerSupport.invokeLater((Runnable)cleanupAction);
                callback.terminateCapture();
            }
        }

        private void checkPrevBounds(Rectangle screenBounds, Rectangle[] screens) {
            if (this.lastSelectSize == null || this.lastSelectLocation == null) {
                return;
            }
            if (this.lastSelectSize.width > screenBounds.width) {
                this.lastSelectSize.width = screenBounds.width;
            }
            if (this.lastSelectSize.height > screenBounds.height) {
                this.lastSelectSize.height = screenBounds.height;
            }
            if (this.lastSelectLocation.x < screenBounds.x) {
                this.lastSelectLocation.x = screenBounds.x;
            }
            if (this.lastSelectLocation.y < screenBounds.y) {
                this.lastSelectLocation.y = screenBounds.y;
            }
            int screenEndX = screenBounds.x + screenBounds.width;
            int screenEndY = screenBounds.y + screenBounds.height;
            if (this.lastSelectLocation.x + this.lastSelectSize.width > screenEndX) {
                this.lastSelectLocation.x = screenEndX - this.lastSelectSize.width;
            }
            if (this.lastSelectLocation.y + this.lastSelectSize.height > screenEndY) {
                this.lastSelectLocation.y = screenEndY - this.lastSelectSize.height;
            }
            if (GUIDebug.APP_SNAP.show()) {
                LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("Vetting window location vs. screens: loc=" + this.lastSelectLocation + " dim= " + this.lastSelectSize));
            }
            Point topLeft = new Point(this.lastSelectLocation);
            Point topRight = new Point(this.lastSelectLocation.x + this.lastSelectSize.width - 1, this.lastSelectLocation.y);
            boolean hasTopLeft = false;
            boolean hasTopRight = false;
            for (int sno = 0; sno < screens.length; ++sno) {
                int ix;
                boolean extendY;
                boolean extendX;
                int dEdgeY;
                int dEdgeX;
                if (screens[sno].contains(topLeft)) {
                    dEdgeX = screens[sno].x + screens[sno].width - 1 - topLeft.x;
                    dEdgeY = screens[sno].y + screens[sno].height - topLeft.y;
                    if (GUIDebug.APP_SNAP.show()) {
                        LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopLeft found in " + screens[sno] + " dEdgeX=" + dEdgeX + " dEdgeY=" + dEdgeY));
                    }
                    extendX = false;
                    extendY = false;
                    for (ix = 0; ix < screens.length; ++ix) {
                        if (ix == sno) continue;
                        if (screens[ix].contains(screens[sno].x + screens[sno].width + 1, topLeft.y)) {
                            extendX = true;
                            if (GUIDebug.APP_SNAP.show()) {
                                LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopLeft X extension by " + screens[ix]));
                            }
                        }
                        if (!screens[ix].contains(topLeft.x, screens[sno].y + screens[sno].height + 1)) continue;
                        extendY = true;
                        if (!GUIDebug.APP_SNAP.show()) continue;
                        LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopLeft Y extension by " + screens[ix]));
                    }
                    boolean bl = hasTopLeft = !(dEdgeX <= 8 && !extendX || dEdgeY <= 3 && !extendY);
                }
                if (!screens[sno].contains(topRight)) continue;
                dEdgeX = screens[sno].x - topRight.x;
                dEdgeY = screens[sno].y + screens[sno].height - topRight.y;
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopLeft found in " + screens[sno] + " dEdgeX=" + dEdgeX + " dEdgeY=" + dEdgeY));
                }
                extendX = false;
                extendY = false;
                for (ix = 0; ix < screens.length; ++ix) {
                    if (ix == sno) continue;
                    if (screens[ix].contains(screens[sno].x - 2, topLeft.y)) {
                        extendX = true;
                        if (GUIDebug.APP_SNAP.show()) {
                            LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopRight X extension by " + screens[ix]));
                        }
                    }
                    if (!screens[ix].contains(topLeft.x, screens[sno].y + screens[sno].height + 1)) continue;
                    extendY = true;
                    if (!GUIDebug.APP_SNAP.show()) continue;
                    LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopRight Y extension by " + screens[ix]));
                }
                hasTopRight = !(dEdgeX <= 8 && !extendX || dEdgeY <= 3 && !extendY);
            }
            if (GUIDebug.APP_SNAP.show()) {
                LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("Top left: " + topLeft + " " + hasTopLeft));
                LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("Top right: " + topRight + " " + hasTopRight));
            }
            if (!hasTopLeft && !hasTopRight) {
                this.lastSelectLocation = null;
                this.lastSelectSize = null;
            }
        }

        private void hideApplicationWindows(ArrayList<Runnable> origWinState) {
            Frame[] list;
            for (Frame f : list = Frame.getFrames()) {
                final Frame frm = f;
                final int origState = frm.getExtendedState();
                if ((origState & 1) != 0) continue;
                Runnable undo = new Runnable(){

                    @Override
                    public void run() {
                        frm.setExtendedState(origState);
                    }
                };
                frm.setExtendedState(origState | 1);
                origWinState.add(undo);
            }
        }

        private void unhideApplicationWindows(ArrayList<Runnable> origWinState) {
            if (origWinState.isEmpty()) {
                return;
            }
            for (int ix = origWinState.size() - 1; ix >= 0; --ix) {
                try {
                    Runnable undo = origWinState.get(ix);
                    if (undo == null) continue;
                    if (GUIDebug.APP_SNAP.show()) {
                        LogSupport.message((Object)this, (String)"unhideApplicationWindows", (String)("Restoring " + undo));
                    }
                    undo.run();
                    continue;
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"unhideApplicationWindows", (Throwable)t, (boolean)true);
                }
            }
            origWinState.clear();
        }

        private void startSnap() {
            Object action = null;
            Rectangle screenBounds = new Rectangle();
            Rectangle[] screens = GuiUtils.getScreenBounds((Rectangle)screenBounds);
            if (screens == null || screens.length < 1) {
                this.lastSelectLocation = null;
                this.lastSelectSize = null;
            }
            this.selectFrame = new SelectFrame(this.appFrame);
            this.hideApplicationWindows(this.origWinState);
            try {
                int h;
                int w;
                int y;
                int x;
                block11: {
                    block10: {
                        if (this.lastSelectSize != null && this.lastSelectLocation != null) {
                            if (GUIDebug.APP_SNAP.show()) {
                                LogSupport.message((Object)this, (String)"startSnap", (String)("Desktop bounds: " + screenBounds));
                                LogSupport.message((Object)this, (String)"startSnap", (String)("Vetting window location vs. bounds: loc=" + this.lastSelectLocation + " dim=" + this.lastSelectSize));
                            }
                            this.checkPrevBounds(screenBounds, screens);
                        }
                        x = 0;
                        y = 0;
                        w = this.canvasWidth;
                        h = this.canvasHeight;
                        if (this.lastSelectSize != null && this.lastSelectLocation != null) break block10;
                        if (screens == null || screens.length <= 0) break block11;
                        x = screens[0].x;
                        y = screens[0].y;
                        break block11;
                    }
                    if (this.lastSelectSize.width > 0 && this.lastSelectSize.height > 0 && screens != null) {
                        Rectangle r = new Rectangle(this.lastSelectLocation, this.lastSelectSize);
                        for (int ix = 0; ix < screens.length; ++ix) {
                            int area = -1;
                            Rectangle isect = screens[ix].intersection(r);
                            if (!isect.isEmpty()) {
                                area = isect.width * isect.height;
                            }
                            if (isect.width <= 4 || isect.height <= 4 || area <= 256) continue;
                            x = this.lastSelectLocation.x;
                            y = this.lastSelectLocation.y;
                            w = this.lastSelectSize.width;
                            h = this.lastSelectSize.height;
                            break;
                        }
                    }
                }
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message((Object)this, (String)"startSnap", (String)("Placing select frame: " + x + "," + y + " " + w + "x" + h));
                }
                this.selectFrame.setFrameLocation(x, y);
                this.selectFrame.setFrameSize(w, h);
                this.selectFrame.setWbBounds(this.canvasWidth, this.canvasHeight);
                this.selectRectangle = this.selectFrame.showModal();
                this.lastSelectSize = this.selectRectangle.getSize();
                this.lastSelectLocation = this.selectRectangle.getLocation();
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message((Object)this, (String)"startSnap", (String)("Saved position: " + this.lastSelectLocation + " " + this.lastSelectSize));
                }
                this.cancelled = this.selectFrame.isCancelled();
            }
            catch (Throwable t1) {
                LogSupport.exception((Object)this, (String)"startSnap", (Throwable)t1, (boolean)true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] encodeImage(Image img, int encodeWidth, int encodeHeight, int maxWidth, int maxHeight) {
            double widthScale = 1.0;
            double heightScale = 1.0;
            double scale = 1.0;
            if (encodeWidth > maxWidth || encodeHeight > maxHeight) {
                widthScale = (double)maxWidth / (double)encodeWidth;
                heightScale = (double)maxHeight / (double)encodeHeight;
                scale = Math.min(widthScale, heightScale);
            }
            byte[] imageBytes = null;
            ProgressSteps prg = null;
            try {
                byte[] byArray;
                try {
                    String title = i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_ENCODEPROGRESS_TITLE);
                    String[] steps = new String[]{i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_ENCODEPROGRESS_IMAGING), i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_ENCODEPROGRESS_SCALING), i18n.getString((PropertiesEnum)StringsProperties.IMAGEUI_ENCODEPROGRESS_ENCODING)};
                    prg = new ProgressSteps(null, (Object)title, null, steps);
                }
                catch (Throwable ex) {
                    LogSupport.exception((Object)this, (String)"encodeImage", (Throwable)ex, (boolean)true);
                }
                if (img == null) {
                    byArray = null;
                    return byArray;
                }
                if (prg != null) {
                    if (prg.isCanceled()) {
                        byArray = null;
                        return byArray;
                    }
                    prg.nextStep();
                }
                if (scale != 1.0) {
                    img = img.getScaledInstance((int)((double)encodeWidth * scale), (int)((double)encodeHeight * scale), 4);
                }
                if (prg != null) {
                    if (prg.isCanceled()) {
                        byArray = null;
                        return byArray;
                    }
                    prg.nextStep();
                }
                imageBytes = this.encodeJPEG(img);
                if (prg != null) {
                    if (prg.isCanceled()) {
                        byArray = null;
                        return byArray;
                    }
                    prg.nextStep();
                }
            }
            finally {
                if (prg != null) {
                    prg.close();
                }
            }
            return imageBytes;
        }

        private byte[] encodeJPEG(Image img) {
            if (img == null) {
                return null;
            }
            int quality = 85;
            byte[] bytes = null;
            try {
                bytes = ImageSupport.encodeAsJPEG((Image)img, (int)quality);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"encodeJPEG", (Throwable)ex, (boolean)true);
            }
            return bytes;
        }

        private byte[] encodePNG(Image img) {
            int compressionLevel = 9;
            byte[] bytes = null;
            try {
                bytes = ImageSupport.encodeAsPNG((Image)img, (int)compressionLevel);
            }
            catch (Exception e) {
                LogSupport.exception((Object)this, (String)"encodePNG", (Throwable)e, (boolean)true);
            }
            return bytes;
        }
    }

    private class ClipArtWindowListener
    implements WindowListener {
        PaletteListener pl;
        CTabbedPane ctp;
        ButtonGroup bg;
        Window d;
        KeyboardFocusManager focusManager;
        PaletteFocuser focuser;

        ClipArtWindowListener(PaletteListener pl, CTabbedPane ctp, ButtonGroup bg, Window d) {
            this.pl = pl;
            this.ctp = ctp;
            this.bg = bg;
            this.d = d;
            this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focuser = new PaletteFocuser(d);
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
            if (HAS_ZORDER_BUG) {
                this.focusManager.addPropertyChangeListener(this.focuser);
            }
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
            this.d.hide();
            if (HAS_ZORDER_BUG) {
                this.focusManager.removePropertyChangeListener(this.focuser);
            }
            ImageUI.this.handleClipArtPaletteClosed(this.ctp, this.bg);
            this.pl.paletteClosed();
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }
    }

    private class PaletteFocuser
    implements PropertyChangeListener {
        Window d;

        PaletteFocuser(Window d) {
            this.d = d;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean toUs = false;
            boolean fromUs = false;
            if ("focusOwner".equals(e.getPropertyName())) {
                Component comp = (Component)e.getNewValue();
                toUs = comp != null;
                Component comp0 = (Component)e.getOldValue();
                fromUs = comp0 != null;
                if (toUs && !fromUs) {
                    this.d.setAlwaysOnTop(true);
                } else if (!toUs && fromUs) {
                    this.d.setAlwaysOnTop(false);
                    this.d.toFront();
                }
            }
        }
    }
}

