/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.module.ui.DnDragGestureListener;
import com.elluminate.groupware.whiteboard.module.ui.DnDropTargetListener;
import com.elluminate.gui.swing.CTree;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import javax.swing.tree.TreeModel;

public class DndTree
extends CTree {
    protected static final long SCROLL_DELAY = 100L;
    protected static final int AUTOSCROLL_MARGIN = 12;
    private DnDragGestureListener dragGestureListener;
    private DnDropTargetListener dropTargetListener;
    private WhiteboardContext whiteboardContext;
    private boolean showThumbnails;
    private boolean paintsOwnDnd = true;

    public DndTree(WhiteboardContext context) {
        this.init(context);
    }

    public DndTree(TreeModel model, WhiteboardContext context) {
        super(model);
        this.init(context);
    }

    private void init(WhiteboardContext context) {
        this.whiteboardContext = context;
        this.showThumbnails = context.isShowThumbnails();
        this.setLargeModel(false);
        this.setRowHeight(0);
        DragSource dragSource = DragSource.getDefaultDragSource();
        this.dragGestureListener = new DnDragGestureListener(context, this);
        this.dropTargetListener = new DnDropTargetListener(context, this, this.dragGestureListener);
        this.dragGestureListener.setDropTargetListener(this.dropTargetListener);
        dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 3, this.dragGestureListener);
        DropTarget dropTarget = new DropTarget((Component)((Object)this), this.dropTargetListener);
        dropTarget.setDefaultActions(3);
    }

    protected void setPaintsOwnDnd(boolean paintsOwnDnd) {
        this.paintsOwnDnd = paintsOwnDnd;
    }

    protected DnDragGestureListener getDragListener() {
        return this.dragGestureListener;
    }

    protected DnDropTargetListener getDropListener() {
        return this.dropTargetListener;
    }

    protected boolean isShowThumbnails() {
        return this.showThumbnails;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.paintsOwnDnd) {
            this.paintDndTargets(g);
        }
    }

    protected void paintDndTargets(Graphics g) {
        if (this.dragGestureListener != null && this.dropTargetListener != null) {
            this.dragGestureListener.paintDraggedImages(g, this.dropTargetListener.getLocation());
            this.dropTargetListener.paintDropZone(g, this.dragGestureListener.getLocation());
        }
    }

    public void setShowThumbnails(boolean showThumbnails) {
        this.showThumbnails = showThumbnails;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DndTree.this.setRowHeight(0);
                DndTree.this.repaint();
                if (DndTree.this.getSelectionCount() == 1) {
                    DndTree.this.scrollPathToVisible(DndTree.this.getSelectionPath());
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        this.setShowThumbnails(this.whiteboardContext.isShowThumbnails());
        super.setVisible(visible);
    }
}

