/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.groupware.imps.EditMenuInterface;
import com.elluminate.groupware.imps.EditMenuSelectionListener;
import com.elluminate.groupware.whiteboard.ButtonBehaviour;
import com.elluminate.groupware.whiteboard.CanvasChangeListener;
import com.elluminate.groupware.whiteboard.OnlineListener;
import com.elluminate.groupware.whiteboard.ScreenClipboardListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.comm.GoToScreen;
import com.elluminate.groupware.whiteboard.conference.GroupManager;
import com.elluminate.groupware.whiteboard.conference.SendFollowInstructor;
import com.elluminate.groupware.whiteboard.dataModel.ACLChangeListener;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DataModelListener;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenResolver;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ACLList;
import com.elluminate.groupware.whiteboard.interfaces.ControllerPaneInterface;
import com.elluminate.groupware.whiteboard.interfaces.ControllerPaneUIInterface;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.groupware.whiteboard.interfaces.ToolSelectionListener;
import com.elluminate.groupware.whiteboard.listeners.ClientIDListener;
import com.elluminate.groupware.whiteboard.listeners.SelectionListener;
import com.elluminate.groupware.whiteboard.module.ProtectedPolicyAPI;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.groupware.whiteboard.module.WhiteboardPublisher;
import com.elluminate.groupware.whiteboard.module.navigation.ExplorerEnabledClerk;
import com.elluminate.groupware.whiteboard.module.navigation.ScreenNavigator;
import com.elluminate.groupware.whiteboard.module.ui.AbstractNavigator;
import com.elluminate.groupware.whiteboard.module.ui.AccessibleListener;
import com.elluminate.groupware.whiteboard.module.ui.ActionUtilities2;
import com.elluminate.groupware.whiteboard.module.ui.Canvas;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPaneMouseAdapter;
import com.elluminate.groupware.whiteboard.module.ui.MainTreeNavigator;
import com.elluminate.groupware.whiteboard.module.ui.NavigationListener;
import com.elluminate.groupware.whiteboard.module.ui.NewScreenDialog;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.ToolNavigator;
import com.elluminate.groupware.whiteboard.module.ui.ToolSlip;
import com.elluminate.groupware.whiteboard.module.ui.WBInputMethodRequests;
import com.elluminate.groupware.whiteboard.module.ui.dnd.WBNodeSelection;
import com.elluminate.groupware.whiteboard.module.ui.dnd.WBToolPasteHelper;
import com.elluminate.groupware.whiteboard.module.ui.keyboard.KeyBoard;
import com.elluminate.groupware.whiteboard.module.ui.menu.AlignDistributeAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.ExploreToolsAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.ImportWBDAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.NavExportAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.NavPrintAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.NewScreenAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.NewScreenGroupAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.ScreenPropertiesAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesDialog;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesPanel;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesPanelInterface;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.BackgroundTool;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.dnd.DTListener;
import com.elluminate.gui.dnd.DataFlavorManager;
import com.elluminate.gui.dnd.DropHelperInterface;
import com.elluminate.gui.dnd.UriListDataFlavor;
import com.elluminate.gui.dnd.XJavaSerializedObjectDataFlavor;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.util.ExternalDataBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodRequests;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class ControllerPane
extends JPanel
implements ACLChangeListener,
ACLList,
ControllerPaneInterface,
ControllerPaneUIInterface,
NavigationListener,
OnlineListener,
PropertyChangeListener,
ScreenClipboardListener,
ScreenResolver,
ToolSelectionListener,
ClipboardOwner,
EditMenuInterface,
SelectionListener {
    static final boolean DEBUG = false;
    private static I18n i18n = I18n.create((Object)new Object(){});
    public static final int FILL_PAGE = 0;
    public static final int FILL_WIDTH = 1;
    public static final int FILL_HEIGHT = 2;
    public static final int FILL_SCREEN = 3;
    private Canvas canvas;
    private JScrollPane canvasScroller = new JScrollPane();
    private JViewport canvasViewport;
    private ToolSlip toolSlip = null;
    private JPanel scrollContainer = new JPanel();
    private FlowLayout scrollContainerLayout = new FlowLayout();
    private JPanel westPanel = new JPanel(new BorderLayout());
    private JPanel keyboardPanel = new JPanel(new BorderLayout());
    private JComponent quickEditorsPanel = null;
    private JLabel protectedLabel = new JLabel();
    private JToggleButton keyboardButton = new JToggleButton();
    private JToggleButton rightButton = new JToggleButton();
    private NewScreenAction newScreenAction = null;
    private NewScreenGroupAction newScreenGroupAction = null;
    private NavExportAction navExportAction = null;
    private ScreenPropertiesAction screenPropertiesAction = null;
    private ToolPropertiesAction toolPropertiesAction = null;
    private ExploreToolsAction exploreToolsAction = null;
    private NavPrintAction printAction = null;
    private AlignDistributeAction alignToolsAction = null;
    private ToolPropertiesPanel toolPropertiesPanel = null;
    private ToolPropertiesPanelInterface toolPropertiesInterface = null;
    private ControllerPaneMouseAdapter mouseAdapter = null;
    private boolean whiteboardAccessible = false;
    private Cursor defaultCanvasCursor = Cursor.getDefaultCursor();
    private ActionMap actionMap = new ActionMap();
    private boolean autoScale = false;
    private AbstractToolModel toolCreche = null;
    private Object stamp = null;
    private Long pendingScreenUID = null;
    private HashMap aclMap = new HashMap();
    private ACLList aclParent = null;
    private WhiteboardContext context = null;
    private KeyBoard keyBoard = null;
    private boolean annunciateState = true;
    private NewScreenDialog newScreenDialog = null;
    private LinkedList accessibleListeners = new LinkedList();
    private AbstractToolModel selectedTool = null;
    private boolean proprietaryWhiteboards = false;
    private int viewWidth = 100;
    private int viewHeight = 100;
    private ImportWBDAction importWBDAction;
    private boolean processingNavKey = false;
    private ExplorerEnabledClerk explorerClerk;
    public MouseAdapter focusMouseAdapter = new FocusMouseAdapter();
    private ScreenNavigator screenNavigator;
    private int dropActions = 1;
    private DataFlavorManager dfManager;
    private WBInputMethodRequests inputMethodRequests;
    private ProtectedPolicyAPI protectedPolicy = null;
    private WhiteboardPublisher msgPublisher;
    private FeatureBroker broker;
    private ActionFeature newScreenFeature;
    private ActionFeature newScreenGroupFeature;
    private ActionFeature navImportFeature;
    private ActionFeature navExportFeature;
    private ActionFeature printFeature;
    private ActionFeature alignToolsFeature;
    private ActionFeature moveOnscreenFeature;
    private ActionFeature toolPropertiesFeature;
    private ActionFeature screenPropertiesFeature;
    private ActionFeature exploreToolsFeature;
    private ComponentFeature toolsPaletteFeature;
    private ComponentFeature screenExplorerFeature;
    private ActionFeature newPageFeature;
    private ActionFeature clearPageFeature;
    private ActionFeature removePageFeature;
    private ActionFeature newPageMenuFeature;
    private ActionFeature clearPageMenuFeature;
    private ActionFeature removePageMenuFeature;
    private boolean postToolNavigator = false;
    private ToolNavigator toolNavigator = null;
    private JDialog toolNavigatorDialog = null;
    private MainTreeNavigator treeNav = null;
    private boolean treeNavPosted = false;
    private ArrayList editMenuSelectionListeners = new ArrayList();

    public void setStamp(Object stamp) {
        this.stamp = stamp;
    }

    public Object getStamp() {
        return this.stamp;
    }

    public ControllerPane(WhiteboardContext context) {
        this.context = context;
        context.setController((ControllerPaneInterface)this);
        this.protectedPolicy = (ProtectedPolicyAPI)context.getImps().findBest(ProtectedPolicyAPI.class);
        this.explorerClerk = new ExplorerEnabledClerk(context);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
        context.getDataModel().addDataModelListener(new DataModelListener(){

            public void nodeAdded(WBNode addedNode, WBNode parentNode) {
                int nTools;
                ScreenModel currentScreen = ControllerPane.this.getScreen();
                int n = nTools = currentScreen == null ? 0 : currentScreen.getForegroundToolCount();
                if (parentNode == currentScreen && addedNode instanceof AbstractToolModel && !(addedNode instanceof BackgroundTool)) {
                    ++nTools;
                }
                ControllerPane.this.enableOffscreenMove();
                ControllerPane.this.enableClearPageFeature(nTools);
            }

            public void nodeRemoved(WBNode removedNode, int removedIndex, WBNode parentNode) {
                ScreenModel currentScreen = ControllerPane.this.getScreen();
                int nTools = currentScreen == null ? 0 : currentScreen.getForegroundToolCount();
                ControllerPane.this.enableOffscreenMove();
                ControllerPane.this.enableClearPageFeature(nTools);
            }
        });
        context.addSelectionListener((SelectionListener)this);
    }

    public void initWhiteboardPublisher(WhiteboardPublisher pub) {
        this.msgPublisher = pub;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.canvas = new Canvas(this.context);
        this.toolSlip = new ToolSlip(this.context, this);
        this.toolSlip.setOpaque(false);
        this.canvasViewport = this.canvasScroller.getViewport();
        this.canvasViewport.setOpaque(false);
        this.canvasScroller.setOpaque(false);
        this.canvasScroller.setAlignmentX(0.0f);
        this.canvasScroller.setAlignmentY(0.0f);
        this.canvasScroller.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.canvasScroller.setDoubleBuffered(true);
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.scrollContainer.setOpaque(false);
        this.scrollContainer.setLayout(this.scrollContainerLayout);
        this.scrollContainerLayout.setAlignment(1);
        this.scrollContainerLayout.setHgap(0);
        this.scrollContainerLayout.setVgap(0);
        this.scrollContainer.setAlignmentX(0.0f);
        this.scrollContainer.setAlignmentY(0.0f);
        this.protectedLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_PROTECTEDLABEL));
        this.canvas.setAlignmentX(0.0f);
        this.canvas.setAlignmentY(0.0f);
        this.westPanel.setAlignmentX(0.0f);
        this.westPanel.setAlignmentY(0.0f);
        this.toolSlip.setAlignmentX(0.0f);
        this.toolSlip.setAlignmentY(0.0f);
        this.keyboardPanel.setAlignmentX(0.0f);
        this.keyboardPanel.setAlignmentY(0.0f);
        this.keyboardButton.setAlignmentY(0.0f);
        this.keyboardButton.setMargin(new Insets(0, 0, 0, 0));
        this.scrollContainer.add((Component)this.canvas, null);
        this.canvas.setPreferredSize(WhiteboardContext.DEFAULT_SIZE);
        this.canvasScroller.getViewport().setView(this.scrollContainer);
        this.add((Component)this.canvasScroller, "Center");
        this.westPanel.setOpaque(false);
        JPanel westSouthPanel = new JPanel();
        westSouthPanel.setLayout(new BorderLayout());
        westSouthPanel.add(Box.createVerticalGlue(), "Center");
        westSouthPanel.add((Component)this.keyboardPanel, "South");
        this.westPanel.add((Component)westSouthPanel, "South");
        this.keyboardPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.keyboardPanel.add((Component)this.rightButton, "North");
        this.context.getButtonBehaviour().setButtonBehaviour((AbstractButton)this.rightButton, ButtonBehaviour.normalBorder, false);
        this.rightButton.setIcon(i18n.getIcon("ControllerPane.rightButtonIcon"));
        this.keyboardPanel.add((Component)this.keyboardButton, "Center");
        this.keyboardButton.setIcon(i18n.getIcon("ControllerPane.keyboardIcon"));
        this.context.getButtonBehaviour().setButtonBehaviour((AbstractButton)this.keyboardButton, ButtonBehaviour.normalBorder, false);
        this.keyboardButton.addActionListener(new KeyboardAction());
        this.add((Component)this.westPanel, "West");
        this.protectedLabel.setVisible(false);
        this.mouseAdapter = new ControllerPaneMouseAdapter(this.context, this);
        this.scrollContainer.addMouseListener(this.mouseAdapter);
        this.scrollContainer.addMouseMotionListener(this.mouseAdapter);
        this.canvasViewport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ControllerPane.this.processScaleChange();
            }
        });
        this.addMouseListener(this.focusMouseAdapter);
        this.westPanel.addMouseListener(this.focusMouseAdapter);
        this.addKeyListener(this.mouseAdapter);
        this.addFocusListener(this.mouseAdapter);
        this.addInputMethodListener(this.mouseAdapter);
        this.toolSlip.addToolSlipListener(this.mouseAdapter);
        this.keyboardPanel.setVisible(false);
        this.context.addOnlineListener((OnlineListener)this);
        this.canvasScroller.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ControllerPane.this.canvasSizeChanged();
            }
        });
        this.context.addScreenClipboardListener((ScreenClipboardListener)this);
        this.context.addCanvasChangeListener(new CanvasChangeListener(){

            public void onCanvasChange() {
                ControllerPane.this.enableCanvasAccess(ControllerPane.this.canvas.getScreen());
            }
        });
        this.getDataFlavorManager().addDataFlavor(WBNodeSelection.wbXMLFlavor, (DropHelperInterface)new WBToolPasteHelper(this.context), 1);
        this.getDataFlavorManager().addDataFlavor((DataFlavor)new UriListDataFlavor(), (DropHelperInterface)this.toolSlip, 3);
        this.getDataFlavorManager().addDataFlavor((DataFlavor)new XJavaSerializedObjectDataFlavor(), (DropHelperInterface)this.toolSlip, 3);
        this.getDataFlavorManager().addDataFlavor(DataFlavor.javaFileListFlavor, (DropHelperInterface)this.toolSlip, 2);
        this.getDataFlavorManager().addDataFlavor(new DataFlavor("image/x-pict; class=java.io.InputStream", "Mac PICT image"), (DropHelperInterface)this.toolSlip, 2);
        this.getDataFlavorManager().addDataFlavor(new DataFlavor("text/rtf; class=java.io.InputStream", "rtftext inputstream"), (DropHelperInterface)this.toolSlip, 2);
        this.getDataFlavorManager().addDataFlavor(DataFlavor.imageFlavor, (DropHelperInterface)this.toolSlip, 2);
        this.getDataFlavorManager().addDataFlavor(DataFlavor.stringFlavor, (DropHelperInterface)this.toolSlip, 5);
        this.getDataFlavorManager().addDataFlavor(new DataFlavor("text/plain; class=java.io.Reader; charset=Unicode", "plain text reader"), (DropHelperInterface)this.toolSlip, 5);
        this.getDataFlavorManager().addDataFlavor(new DataFlavor("text/plain; class=java.io.InputStream; charset=UTF-16", "plain text inputstream"), (DropHelperInterface)this.toolSlip, 5);
        DTListener dtListener = new DTListener(this.dfManager);
        DropTarget wbDropTarget = new DropTarget(this.canvas, this.dropActions, (DropTargetListener)dtListener, true);
        this.enableEvents(2056L);
        this.inputMethodRequests = new WBInputMethodRequests(this);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.inputMethodRequests;
    }

    private void setupButton(AbstractButton button, Icon normalIcon, Icon selectedIcon, String toolTip) {
        button.setIcon(normalIcon);
        if (selectedIcon != null) {
            button.setSelectedIcon(selectedIcon);
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setToolTipText(toolTip);
        this.context.getButtonBehaviour().setButtonBehaviour(button, ButtonBehaviour.normalBorder, false);
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
        int aspectMode = this.context.getScalerAspect();
        if (autoScale && (aspectMode == 3 || aspectMode == 0)) {
            this.canvasScroller.setHorizontalScrollBarPolicy(31);
            this.canvasScroller.setVerticalScrollBarPolicy(21);
        } else {
            this.canvasScroller.setHorizontalScrollBarPolicy(30);
            this.canvasScroller.setVerticalScrollBarPolicy(20);
        }
        this.mouseAdapter.setAutoScaleMode(autoScale);
        if (this.canvas.isVisible() && this.canvas.getScreen() != null) {
            this.processScaleChange();
        }
    }

    public void processScaleChange() {
        if (this.canvas == null || this.canvas.getScreen() == null) {
            return;
        }
        if (this.autoScale != this.context.isScaled()) {
            this.setAutoScale(this.context.isScaled());
            return;
        }
        int horizontalPolicy = 30;
        int verticalPolicy = 20;
        if (this.context.isAutoScaler()) {
            if (this.canvas.getScreen() != null) {
                double scaleY;
                double scaleX;
                Rectangle rect = this.canvasScroller.getViewportBorderBounds();
                this.viewWidth = Math.max(20, rect.width);
                this.viewHeight = Math.max(20, rect.height);
                double screenWidth = this.canvas.getScreen().getScreenSize().width;
                double screenHeight = this.canvas.getScreen().getScreenSize().height;
                if (screenWidth > 0.0 && screenHeight > 0.0) {
                    scaleX = (double)this.viewWidth / screenWidth;
                    scaleY = (double)this.viewHeight / screenHeight;
                } else {
                    scaleX = 1.0;
                    scaleY = 1.0;
                }
                int aspectMode = this.context.getScalerAspect();
                switch (aspectMode) {
                    case 1: {
                        scaleY = scaleX;
                        this.viewHeight = (int)Math.ceil(scaleX * screenHeight);
                        horizontalPolicy = 31;
                        verticalPolicy = 22;
                        break;
                    }
                    case 2: {
                        scaleX = scaleY;
                        this.viewWidth = (int)Math.ceil(scaleY * screenWidth);
                        horizontalPolicy = 32;
                        verticalPolicy = 21;
                        break;
                    }
                    case 0: {
                        if (scaleX > scaleY) {
                            scaleX = scaleY;
                            this.viewWidth = (int)Math.ceil(scaleX * screenWidth);
                        } else {
                            scaleY = scaleX;
                            this.viewHeight = (int)Math.ceil(scaleY * screenHeight);
                        }
                        horizontalPolicy = 31;
                        verticalPolicy = 21;
                        break;
                    }
                    case 3: {
                        horizontalPolicy = 31;
                        verticalPolicy = 21;
                        break;
                    }
                    default: {
                        scaleX = this.context.getScaleX();
                        scaleY = this.context.getScaleY();
                    }
                }
                this.context.setScaleX(scaleX);
                this.context.setScaleY(scaleY);
                this.setSize();
            }
        } else {
            if (this.canvas != null && this.canvas.getScreen() != null) {
                this.viewWidth = (int)((double)this.canvas.getScreen().getScreenSize().width * this.context.getScaleX());
                this.viewHeight = (int)((double)this.canvas.getScreen().getScreenSize().height * this.context.getScaleY());
            }
            this.setSize();
        }
        this.canvasScroller.setHorizontalScrollBarPolicy(horizontalPolicy);
        this.canvasScroller.setVerticalScrollBarPolicy(verticalPolicy);
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ControllerPane.this.scrollContainer.setPreferredSize(ControllerPane.this.getViewSize());
                ControllerPane.this.scrollContainer.revalidate();
                ((WhiteboardBean)ControllerPane.this.context.getBean()).displayTitleText();
            }
        });
    }

    public Dimension getViewSize() {
        return new Dimension(this.viewWidth, this.viewHeight);
    }

    public Dimension getViewExtentSize() {
        return this.canvasViewport.getExtentSize();
    }

    public boolean isExplorerSelected() {
        return this.explorerClerk.isExplorerSelected();
    }

    public void setExplorer(boolean selected) {
        this.explorerClerk.setExplorerSelected(selected);
        this.setAnnunciateState();
    }

    public void saveDocument() {
        this.navExportAction.actionPerformed((ActionEvent)null);
    }

    public boolean isProprietary() {
        return this.proprietaryWhiteboards && this.protectedPolicy.isActive();
    }

    public void changeGroup(Short clientId, Short newGroupId, Short oldGroupId) {
        boolean setting = false;
        if (this.context.getIDProcessor().isLocalClient(clientId)) {
            Short groupId = newGroupId == null ? ACLEntry.NULL_GROUP : newGroupId;
            GroupManager.GroupInfo info = this.context.getGroupManager().getGroupInfo(groupId);
            if (info != null) {
                setting = info.isFollowInstructor();
            }
            this.setFollowInstructor(setting);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        ClientInfo ci = this.context.getClientList().getMyClient();
        if (property.equals("whiteboardFloor") || property.equals("chair")) {
            boolean accessible = true;
            if (ci != null) {
                accessible = ci.getProperty("whiteboardFloor", false);
            }
            this.context.setAccessible(accessible);
            this.context.fireCanvasChangeListeners();
            if (this.broker != null && this.toolsPaletteFeature != null) {
                this.broker.setFeaturePublished((Feature)this.toolsPaletteFeature, accessible);
            }
        }
        if (this.navImportFeature != null) {
            this.navImportFeature.setEnabled(this.context.isChair());
        }
    }

    public Cursor getCanvasCursor() {
        return this.canvas.getCursor();
    }

    public void setCanvasCursor(Cursor cursor) {
        if (this.canvas.getCursor() != cursor) {
            this.canvas.setCursor(cursor);
        }
    }

    public Cursor getDefaultCanvasCursor() {
        return this.defaultCanvasCursor;
    }

    public void setDefaultCanvasCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.defaultCanvasCursor = cursor;
    }

    public void onOnline(boolean online) {
        if (!online) {
            this.context.setAccessible(!online);
            this.setFollowInstructor(false);
            if (this.isProprietary() && this.context.getDataModel().getPrivateScreens().getObjectID() != null) {
                this.gotoConferenceScreen(this.context.getDataModel().getPrivateScreens().getObjectID());
            }
        }
        if (this.importWBDAction != null) {
            this.importWBDAction.setEnabled(online);
        }
    }

    public void setChair() {
        GroupManager.GroupInfo info;
        Short groupId;
        if (this.context.isChair()) {
            this.context.setAccessible(this.whiteboardAccessible);
        }
        if ((groupId = this.context.getIDProcessor().getMyGroupId()) != null && !this.context.isChair() && this.isFollowInstructorSelected() && (info = this.context.getGroupManager().getGroupInfo(groupId)) != null && this.getScreen().getObjectID() != null && !this.getScreen().getObjectID().equals(info.getScreenUID())) {
            this.context.getController().gotoConferenceScreen(info.getScreenUID());
        }
        this.enableScreenAndGroupItems();
        SwingRunnerSupport.invokeLater((Runnable)new SetChairRunnable());
    }

    public void processNavKey(KeyEvent event) {
    }

    private void enableClearPageFeature(int nTools) {
        this.clearPageFeature.setEnabled(nTools > 0);
        this.clearPageMenuFeature.setEnabled(nTools > 0);
        this.publishActionBarScreenFeatures(this.canvas.getScreen().isPrivate() || this.context.isChair() || this.canvas.getScreen().canCreate());
    }

    private void enableScreenAndGroupItems() {
        boolean enableNew = this.canvas.getScreen().isPrivate();
        if (this.newScreenFeature != null) {
            this.newScreenFeature.setEnabled(enableNew || this.context.isChair() || this.whiteboardAccessible);
        }
        if (this.newScreenGroupFeature != null) {
            this.newScreenGroupFeature.setEnabled(this.context.isChair() || this.whiteboardAccessible);
        }
        this.publishActionBarScreenFeatures(enableNew || this.context.isChair() || this.canvas.getScreen().canCreate());
    }

    private void publishActionBarScreenFeatures(boolean setPublished) {
        if (this.newPageFeature != null) {
            this.broker.setFeaturePublished((Feature)this.newPageFeature, setPublished);
            this.broker.setFeaturePublished((Feature)this.clearPageFeature, setPublished && this.clearPageFeature.isEnabled());
            this.broker.setFeaturePublished((Feature)this.removePageFeature, setPublished);
            this.broker.setFeaturePublished((Feature)this.newPageMenuFeature, setPublished);
            this.broker.setFeaturePublished((Feature)this.clearPageMenuFeature, setPublished);
            this.broker.setFeaturePublished((Feature)this.removePageMenuFeature, setPublished);
        }
    }

    private void setWhiteboardAccessible() {
        if (this.whiteboardAccessible != this.getScreen().isAccessible()) {
            this.whiteboardAccessible = this.getScreen().isAccessible();
            SwingRunnerSupport.invokeLater((Runnable)new SetWhiteboardAccessibleRunnable());
        }
    }

    public void addAccessibleListener(AccessibleListener l) {
        if (!this.accessibleListeners.contains(l)) {
            this.accessibleListeners.add(l);
        }
    }

    public void removeAccessibleListener(AccessibleListener l) {
        this.accessibleListeners.remove(l);
    }

    private void fireAccessibleListeners(boolean accessible) {
        AccessibleListener[] listeners = new AccessibleListener[this.accessibleListeners.size()];
        listeners = this.accessibleListeners.toArray(listeners);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].onAccessible(accessible);
        }
    }

    public void setClientList(ClientList clients) {
        clients.addPropertyChangeListener("whiteboardFloor", (PropertyChangeListener)this);
        clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
    }

    public void evaluateScreenChange() {
        this.screenNavigator.evaluateScreenChange();
    }

    public void postToolPropertiesDialog() {
        if (this.toolPropertiesInterface instanceof JDialog) {
            ((JDialog)((Object)this.toolPropertiesInterface)).setLocationRelativeTo(this.canvas);
        }
        this.toolPropertiesInterface.setVisible(true);
    }

    public Long getPendingScreenUID() {
        return this.pendingScreenUID;
    }

    public void setPendingScreenUID(Long uid) {
        this.pendingScreenUID = uid;
    }

    public void postNewScreenDialog(Component component, ScreenModel[] parents) {
        if (this.newScreenDialog == null) {
            this.newScreenDialog = new NewScreenDialog(this.context);
        }
        this.newScreenDialog.setVisible(true, parents);
    }

    public void gotoConferenceScreen(Long screenUID) {
        if (!this.isExplorerSelected()) {
            this.onGotoScreen(screenUID);
        } else {
            this.screenNavigator.setReturnScreenUID(screenUID);
        }
    }

    public void gotoUIScreen(Long screenUID, boolean forceFollow) {
        ScreenModel initialScreen = this.getScreen();
        this.onGotoScreen(screenUID);
        ScreenModel newScreen = this.getScreen();
        ScreenModel targetNode = null;
        if (initialScreen == newScreen && this.getPendingScreenUID() != null) {
            try {
                targetNode = (WBNode)this.context.getObjectManager().getObjectFromMap(screenUID);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (targetNode == null) {
            targetNode = newScreen;
        }
        if (initialScreen != targetNode && targetNode.isConferenceNode() && this.isFollowInstructorSelected() && (forceFollow || this.context.getIDProcessor().isChair(this.context.getIDProcessor().getMyId()))) {
            Short groupId = this.context.getIDProcessor().getMyGroupId();
            if (groupId.shortValue() == targetNode.getRoot().getGroupID() && !this.explorerClerk.isExplorerSelected() && !targetNode.getRoot().isPrivate() && this.explorerClerk.isFollowEnabled()) {
                this.context.getGroupManager().setScreenUID(groupId, screenUID);
                GoToScreen gotoScreen = new GoToScreen(this.context, screenUID, groupId);
                this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)gotoScreen);
            }
            this.enableClearPageFeature(newScreen == null ? 0 : newScreen.getForegroundToolCount());
        }
    }

    private boolean objectsOffscreen() {
        boolean offscreen = false;
        if (this.getScreen() != null) {
            for (int i = 0; i < this.getScreen().getToolCount(); ++i) {
                AbstractToolModel tool;
                Rectangle screenBounds;
                WBNode node = (WBNode)this.getScreen().getToolAt(i);
                if (!(node instanceof AbstractToolModel) || (screenBounds = this.autoScale ? new Rectangle(this.getScreen().getScreenSize()) : this.canvas.getBounds()).intersects((tool = (AbstractToolModel)node).getBounds())) continue;
                offscreen = true;
                break;
            }
        }
        return offscreen;
    }

    @Override
    public void onGotoScreen(Long screenUID) {
        ScreenModel screen;
        if (screenUID == null) {
            return;
        }
        try {
            screen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(screenUID);
        }
        catch (Exception e) {
            screen = null;
        }
        if (screen != null && screen.getScreenDelegate() == this.getScreen()) {
            return;
        }
        Long oldPending = this.getPendingScreenUID();
        if (oldPending == null && this.getScreen() != null) {
            oldPending = this.getScreen().getObjectID();
        }
        if (screen == null) {
            this.setPendingScreenUID(screenUID);
            this.context.getDataExporter().goneToScreen(oldPending, this.getPendingScreenUID());
            return;
        }
        this.setPendingScreenUID(null);
        ScreenModel target = screen.getScreenDelegate();
        this.context.getDataExporter().goneToScreen(oldPending, target.getObjectID());
        DoGoto doGoto = new DoGoto(target);
        if (SwingUtilities.isEventDispatchThread()) {
            doGoto.run();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)doGoto);
        }
    }

    public void onACLChange(ACLTerm aclTerm) {
        try {
            if (aclTerm != null && aclTerm.getParent() != null && aclTerm.getName() != null) {
                if (aclTerm.getName().equals("accessible")) {
                    this.setWhiteboardAccessible();
                }
                if (aclTerm.getName().equals("visible")) {
                    this.screenNavigator.evaluateVisible(aclTerm.getParent());
                }
            } else {
                LogSupport.error((Object)this, (String)"onACLChange", (String)("Found ACL term bad: " + aclTerm));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void noteActivity(Short clientId, WBNode node) {
        ((WhiteboardBean)this.context.getBean()).noteActivity(clientId, node);
    }

    public void createdPeer(ScreenModel screen) {
        if (screen == this.getScreen()) {
            this.onGotoScreen(screen.getObjectID());
        }
    }

    public ScreenModel getScreen() {
        return this.canvas.getScreen();
    }

    public void screenNameChanged(ScreenModel screen) {
        if (screen == this.getScreen()) {
            // empty if block
        }
    }

    public AlignDistributeAction getAlignAction() {
        return this.alignToolsAction;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setSize() {
        this.canvas.setSize();
        this.canvasScroller.invalidate();
        this.canvas.repaintAll();
    }

    public void repaint(Object object) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (object instanceof AbstractToolModel) {
            AbstractToolModel tool = (AbstractToolModel)object;
            x = tool.getVBounds().x;
            y = tool.getVBounds().y;
            width = Math.max(tool.getVBounds().width, 3) + 4;
            height = Math.max(tool.getVBounds().height, 5) + 4;
        } else if (object instanceof Rectangle) {
            Rectangle rect = (Rectangle)object;
            x = rect.x;
            y = rect.y;
            width = rect.width;
            height = rect.height;
        }
        this.canvas.repaint(x, y, width, height);
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        this.canvas.repaint(x, y, width, height);
    }

    @Override
    public void repaint(Rectangle area) {
        this.canvas.repaint(area.x, area.y, area.width, area.height);
    }

    @Override
    public void requestFocus() {
    }

    public void requestKeyboardFocus() {
        super.requestFocus();
    }

    public void postNavigator(boolean post) {
        try {
            if (this.toolNavigator != null || post) {
                if (this.toolNavigator == null) {
                    this.toolNavigator = new ToolNavigator(this.context, this.getScreen(), this.mouseAdapter);
                    this.toolNavigatorDialog = AbstractNavigator.createDialog(this.toolNavigator, this.context.getDialogParentFrame(), this.toolNavigator.getScreenName());
                    this.toolNavigator.addTitleChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent ev) {
                            if (ControllerPane.this.toolNavigatorDialog != null) {
                                ControllerPane.this.toolNavigatorDialog.setTitle(ControllerPane.this.toolNavigator.getScreenName());
                            }
                        }
                    });
                    this.toolNavigatorDialog.setVisible(true);
                    Point loc = this.toolNavigatorDialog.getLocation();
                    this.toolNavigatorDialog.setLocation(loc.x, loc.y + 300);
                    this.context.getIDProcessor().addClientIDListener((ClientIDListener)this.toolNavigator);
                }
                this.toolNavigator.setScreen(this.getScreen());
                this.getScreen().addToolSelectionListener((ToolSelectionListener)this.toolNavigator);
            }
            if (this.toolNavigatorDialog != null && this.toolNavigatorDialog.isVisible() != post) {
                this.toolNavigatorDialog.setVisible(post);
            }
            this.postToolNavigator = post;
        }
        catch (Exception e) {
            this.toolNavigator = null;
        }
    }

    public boolean getPostToolNavigator() {
        return this.postToolNavigator;
    }

    public void postScreenNavigator(boolean post) {
        if (post && this.screenExplorerFeature == null) {
            String name = i18n.getString((PropertiesEnum)StringsProperties.NAVIGATORPANE_TITLE);
            this.treeNav = new MainTreeNavigator(this.context);
            WhiteboardModule wbdMod = ((WhiteboardBean)this.context.getBean()).getModule();
            this.screenExplorerFeature = this.broker.createComponentFeature((Object)wbdMod, "/whiteboard/ui/screenExplorer", (Component)this.treeNav, name, null);
        }
        if (post) {
            this.treeNav.setEnabled(this.whiteboardAccessible);
            this.broker.setFeaturePublished((Feature)this.screenExplorerFeature, true);
        } else if (this.screenExplorerFeature != null) {
            this.broker.setFeaturePublished((Feature)this.screenExplorerFeature, false);
        }
        this.treeNavPosted = post;
    }

    public boolean canNavigate() {
        return this.context.isOnline() && !this.isFollowInstructorSelected() && !this.context.isChair() && !this.isProprietary() || this.context.isChair() || this.context.getConferenceUID() == 0L;
    }

    public boolean getPostScreenNavigator() {
        return this.treeNavPosted;
    }

    public void showSelectionRectangle(Point press, Point release) {
        this.canvas.setSelectionRectangle(press, release);
    }

    public void clearSelectionRectangle() {
        this.canvas.clearSelectionRectangle();
    }

    public void initializeViewedScreens() {
        this.context.getDataExporter().getViewedScreens().clear();
    }

    public void setControllerTitle(String title) {
        ((WhiteboardBean)this.context.getBean()).setTitleScreenName(title);
        this.screenNavigator.publishScreenList();
    }

    public void setKeyboardTool(AbstractToolModel keyboardTool) {
        this.mouseAdapter.setKeyboardTool(keyboardTool);
    }

    public AbstractToolModel getToolCreche() {
        return this.toolCreche;
    }

    public void setToolCreche(AbstractToolModel toolCreche) {
        this.toolCreche = toolCreche;
    }

    public void sendFollowInstructor(Short groupId, boolean follow, Long screenUID) {
        SendFollowInstructor sfi = new SendFollowInstructor(this.context, groupId, follow, screenUID);
        this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)sfi);
    }

    public void setFollowInstructor(boolean selected) {
        SwingRunnerSupport.invokeLater((Runnable)new SetFollowInstructorRunnable(selected));
    }

    public boolean isFollowInstructorSelected() {
        Short groupId = this.context.getIDProcessor().getMyGroupId();
        return this.context.getGroupManager().getGroupInfo(groupId).isFollowInstructor();
    }

    public boolean isAccessible() {
        return this.whiteboardAccessible;
    }

    public void endComposition() {
        if (this.getInputContext() != null) {
            this.getInputContext().endComposition();
        }
    }

    public void enableOffscreenMove() {
        if (this.moveOnscreenFeature != null) {
            this.moveOnscreenFeature.setEnabled(this.whiteboardAccessible && this.objectsOffscreen());
        }
    }

    public void enableOneButtonOperation(boolean enabled) {
        this.createKeyboard();
        if (this.keyBoard != null) {
            this.keyBoard.setVisible(this.keyboardButton.isSelected() && enabled);
        }
        this.keyboardPanel.setVisible(enabled);
    }

    public void enableProprietaryWhiteboards(boolean enabled, boolean uiSet) {
        this.proprietaryWhiteboards = enabled;
        this.enableProtectedAction(this.navExportAction);
        this.enableProtectedAction(this.printAction);
        this.protectedLabel.setVisible(this.proprietaryWhiteboards);
        this.setFollowInstructor(true);
        if (uiSet && this.isProprietary()) {
            Short groupId = this.context.getIDProcessor().getMyGroupId();
            this.sendFollowInstructor(groupId, true, this.getScreen().getObjectID());
        }
        this.enableNavigation();
    }

    private void enableProtectedAction(Action action) {
        if (action != null) {
            action.setEnabled(!this.proprietaryWhiteboards || !this.protectedPolicy.isActive());
        }
    }

    public void enablePositionOfText(boolean showPositionOfText) {
        this.screenNavigator.enablePositionOfText(showPositionOfText);
    }

    public void enableNavigation() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean canNavigate = ControllerPane.this.canNavigate();
                if (ControllerPane.this.screenNavigator != null) {
                    ControllerPane.this.screenNavigator.enableNavigation(canNavigate);
                }
                ControllerPane.this.postScreenNavigator(canNavigate);
                ControllerPane.this.setAnnunciateState();
            }
        });
    }

    public void followInstructorMouseClicked(MouseEvent e) {
        if (this.isRightButton(false, e)) {
            this.consumeRightButton();
        }
    }

    public void setAnnunciateState() {
        boolean annunciate = false;
        if (this.context.isOnline() && (!this.isFollowInstructorSelected() || this.context.isChair() && this.isExplorerSelected())) {
            annunciate = true;
        }
        this.setControllerAnnunciation(annunciate);
    }

    public boolean setControllerAnnunciation(boolean decoupled) {
        boolean oldState = this.annunciateState;
        if (decoupled || this.isProprietary()) {
            this.canvas.setBorder(BorderFactory.createLineBorder(Color.red, 2));
        } else {
            this.canvas.setBorder(null);
        }
        this.annunciateState = decoupled;
        return oldState;
    }

    private void enableCanvasAccess(ScreenModel screen) {
        if (screen == null) {
            return;
        }
        if (this.newScreenAction != null) {
            this.newScreenAction.setEnabled(screen.canCreate());
        }
        this.publishActionBarScreenFeatures(screen.canCreate());
    }

    private void createKeyboard() {
        this.keyBoard = new KeyBoard("Keyboard");
        this.keyBoard.addPseudoKeyListener(this.mouseAdapter);
        this.canvas.addKeyListener(this.keyBoard);
        this.mouseAdapter.addMouseMotionListener(this.keyBoard);
        this.mouseAdapter.addMouseListener(this.keyBoard);
        JLayeredPane layeredPane = null;
        for (Container c = this.canvas; c != null; c = c.getParent()) {
            if (!(c instanceof JLayeredPane)) continue;
            layeredPane = (JLayeredPane)c;
        }
        if (layeredPane != null) {
            layeredPane.add((Component)this.keyBoard, JLayeredPane.POPUP_LAYER);
            Point loc = SwingUtilities.convertPoint(this.canvas, 0, 0, layeredPane);
            this.keyBoard.setLocation(loc);
        }
    }

    public boolean isRightButton(boolean eventRightState, MouseEvent me) {
        boolean result = eventRightState;
        if (me != null) {
            result |= me.isPopupTrigger();
        }
        return result |= this.rightButton.isSelected();
    }

    public void consumeRightButton() {
        this.rightButton.setSelected(false);
        ButtonBehaviour.showBehaviour((AbstractButton)this.rightButton);
    }

    public ACLTerm getACLTerm(String name) {
        if (this.aclMap == null) {
            return null;
        }
        return (ACLTerm)this.aclMap.get(name);
    }

    public void addACLTerm(ACLTerm aclTerm) {
        if (this.aclMap == null) {
            this.aclMap = new HashMap(5);
        }
        this.aclMap.put(aclTerm.getName(), aclTerm);
    }

    public void removeACLTerm(String name) {
        if (this.aclMap != null) {
            this.aclMap.remove(name);
        }
    }

    public ACLList getACLParent() {
        return this.aclParent;
    }

    public void onSwingInitialized(Frame frame, FeatureBroker broker) {
        this.screenNavigator = new ScreenNavigator(this.context, broker, this.explorerClerk);
        ScreenModel scrn = (ScreenModel)this.context.getDataModel().getPrivateScreens().getChildAt(0);
        this.onGotoScreen(scrn.getObjectID());
        WhiteboardModule wbdMod = ((WhiteboardBean)this.context.getBean()).getModule();
        if (this.broker != null) {
            return;
        }
        this.broker = broker;
        if (this.toolPropertiesInterface == null) {
            this.toolPropertiesInterface = new ToolPropertiesDialog(this.context, null);
        }
        this.toolPropertiesPanel = this.toolPropertiesInterface.getPanel();
        this.toolSlip.initializeToolProperties();
        this.toolPropertiesPanel.populateProperties(this.getScreen());
        this.quickEditorsPanel = this.toolPropertiesPanel.quickEditorsFactory(broker);
        TreePath[] paths = new TreePath[1];
        DisplayNode pathPeer = new DisplayNode();
        pathPeer.setUserObject((Object)this.getScreen());
        paths[0] = new TreePath(pathPeer);
        String whiteboardTag = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_WHITEBOARD);
        String name = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_TOOLSPALETTETITLE);
        this.toolsPaletteFeature = broker.createComponentFeature((Object)wbdMod, "/whiteboard/ui/toolslip", (Component)this.toolSlip, name, null);
        broker.setFeaturePublished((Feature)this.toolsPaletteFeature, this.context.isAccessible() || !this.context.isOnline() && !this.context.isPlayback());
        this.newScreenAction = new NewScreenAction(this.context, null, paths);
        this.newScreenFeature = this.newScreenAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/newScreen");
        broker.setFeaturePublished((Feature)this.newScreenFeature, true);
        this.newScreenGroupAction = new NewScreenGroupAction(this.context, null);
        this.newScreenGroupFeature = this.newScreenGroupAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/newScreenGroup");
        broker.setFeaturePublished((Feature)this.newScreenGroupFeature, true);
        this.importWBDAction = new ImportWBDAction(this.context, null, null, "ImportWBDAction");
        this.navImportFeature = this.importWBDAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/navImport");
        this.navImportFeature.setName(whiteboardTag);
        this.navImportFeature.setEnabled(false);
        broker.setFeaturePublished((Feature)this.navImportFeature, true);
        this.navExportAction = new NavExportAction(this.context, null, null, 1);
        this.navExportFeature = this.navExportAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/navExport");
        this.navExportFeature.setName(whiteboardTag);
        broker.setFeaturePublished((Feature)this.navExportFeature, true);
        if (PrinterJob.getPrinterJob() != null) {
            this.printAction = new NavPrintAction(this.context, null, null, Integer.MAX_VALUE);
            this.printFeature = this.printAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/print");
            broker.setFeaturePublished((Feature)this.printFeature, true);
        }
        this.alignToolsAction = new AlignDistributeAction(this.context, null, this.getScreen());
        this.alignToolsFeature = this.alignToolsAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/alignTools");
        broker.setFeaturePublished((Feature)this.alignToolsFeature, true);
        this.enableAlignMenu();
        name = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_MOVEONSCREEN);
        this.moveOnscreenFeature = broker.createActionFeature((Object)wbdMod, "/whiteboard/ui/menu/moveOnscreen", name, null);
        this.moveOnscreenFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent ev) {
                if (ControllerPane.this.getScreen() != null) {
                    for (int i = 0; i < ControllerPane.this.getScreen().getToolCount(); ++i) {
                        ControllerPane.this.moveToolOnScreen((WBNode)ControllerPane.this.getScreen().getToolAt(i), true);
                    }
                }
            }
        });
        broker.setFeaturePublished((Feature)this.moveOnscreenFeature, true);
        this.enableOffscreenMove();
        this.toolPropertiesAction = new ToolPropertiesAction(this.context, null, this.getScreen());
        this.toolPropertiesFeature = this.toolPropertiesAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/toolProperties");
        broker.setFeaturePublished((Feature)this.toolPropertiesFeature, true);
        this.screenPropertiesAction = new ScreenPropertiesAction(this.context, null, paths);
        this.screenPropertiesFeature = this.screenPropertiesAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/screenProperties");
        broker.setFeaturePublished((Feature)this.screenPropertiesFeature, true);
        this.exploreToolsAction = new ExploreToolsAction(this.context, null);
        this.exploreToolsFeature = this.exploreToolsAction.actionFeatureFactory(broker, wbdMod, "/whiteboard/ui/menu/exploreTools");
        broker.setFeaturePublished((Feature)this.exploreToolsFeature, true);
        this.newPageFeature = broker.createActionFeature((Object)this, "/whiteboard/actionBar/newPage", i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_NEWPAGE), i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_NEWPAGETIP));
        this.newPageMenuFeature = broker.createActionFeature((Object)this, "/whiteboard/optionsMenu/newPage", i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_NEWPAGE), i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_NEWPAGETIP));
        ActionFeatureListener newPageFeatureListener = new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ControllerPane.this.newPage_actionPerformed(event);
            }
        };
        this.newPageFeature.addActionFeatureListener(newPageFeatureListener);
        this.newPageMenuFeature.addActionFeatureListener(newPageFeatureListener);
        this.clearPageFeature = broker.createActionFeature((Object)this, "/whiteboard/actionBar/clearPage", i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_CLEARPAGE), i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_CLEARPAGETIP));
        this.clearPageFeature.setInteractive(true);
        this.clearPageFeature.setEnabled(false);
        this.clearPageMenuFeature = broker.createActionFeature((Object)this, "/whiteboard/optionsMenu/clearPage", i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_CLEARPAGE), i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_CLEARPAGETIP));
        this.clearPageMenuFeature.setInteractive(true);
        this.clearPageMenuFeature.setEnabled(false);
        ActionFeatureListener clearPageFeatureListener = new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ControllerPane.this.clearPage_actionPerformed(event);
            }
        };
        this.clearPageFeature.addActionFeatureListener(clearPageFeatureListener);
        this.clearPageMenuFeature.addActionFeatureListener(clearPageFeatureListener);
        this.removePageFeature = broker.createActionFeature((Object)this, "/whiteboard/actionBar/removePage", i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_REMOVEPAGE), i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_REMOVEPAGETIP));
        this.removePageMenuFeature = broker.createActionFeature((Object)this, "/whiteboard/optionsMenu/removePage", i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_REMOVEPAGE), i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_REMOVEPAGETIP));
        ActionFeatureListener removePageFeatureListener = new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ControllerPane.this.removePage_actionPerformed(event);
            }
        };
        this.removePageFeature.addActionFeatureListener(removePageFeatureListener);
        this.removePageMenuFeature.addActionFeatureListener(removePageFeatureListener);
    }

    private void setPaths() {
        TreePath[] paths = new TreePath[1];
        DisplayNode pathPeer = new DisplayNode();
        pathPeer.setUserObject((Object)this.getScreen());
        paths[0] = new TreePath(pathPeer);
        if (this.newScreenAction != null) {
            this.newScreenAction.setPaths(paths);
            this.importWBDAction.setPaths(null);
            this.navExportAction.setPaths(null);
            this.screenPropertiesAction.setPaths(paths);
            this.enableAlignMenu();
        }
    }

    private void enableAlignMenu() {
        boolean enabled;
        boolean bl = this.getScreen() != null ? this.getScreen().getSelectedToolCount() > 1 : (enabled = false);
        if (this.alignToolsAction != null) {
            this.alignToolsAction.setEnabled(enabled);
            this.alignToolsAction.setScreen(this.getScreen());
        }
    }

    public void onSelectTool(AbstractToolModel tool) {
        this.selectedTool = tool;
        this.scrollToTool(tool);
        this.enableAlignMenu();
    }

    public void onDeSelectTool(AbstractToolModel tool) {
        if (tool == this.selectedTool) {
            this.selectedTool = null;
        }
        this.enableAlignMenu();
    }

    public void moveToolOnScreen(WBNode node, boolean forUI) {
        AbstractToolModel tool;
        Point centroid;
        Rectangle screenBounds;
        if (node instanceof AbstractToolModel && !(screenBounds = this.autoScale ? new Rectangle(this.getScreen().getScreenSize()) : this.canvas.getBounds()).contains(centroid = (tool = (AbstractToolModel)node).getCentroid().getIntLocation())) {
            double dx = (double)screenBounds.width / 2.0 - tool.getCentroid().getX();
            double dy = (double)screenBounds.height / 2.0 - tool.getCentroid().getY();
            if (forUI) {
                tool.setOriginator();
            }
            tool.moveTool(dx, dy);
        }
    }

    private void canvasSizeChanged() {
        if (this.mouseAdapter.getCursorTool() != null) {
            this.scrollToTool(this.mouseAdapter.getCursorTool());
        } else if (this.selectedTool != null) {
            this.scrollToTool(this.selectedTool);
        }
    }

    protected void scrollToTool(AbstractToolModel tool) {
        if (tool != null) {
            Rectangle scrollRect = new Rectangle(tool.getVBounds());
            if (scrollRect.x < 0) {
                scrollRect.x = 0;
            }
            if (scrollRect.x >= this.canvas.getBounds().width) {
                scrollRect.x = this.canvas.getBounds().width - 1;
            }
            if (scrollRect.x + scrollRect.width > this.canvas.getBounds().width) {
                scrollRect.width = this.canvas.getBounds().width - scrollRect.x;
            }
            if (scrollRect.y < 0) {
                scrollRect.y = 0;
            }
            if (scrollRect.y >= this.canvas.getBounds().height) {
                scrollRect.y = this.canvas.getBounds().height - 1;
            }
            if (scrollRect.y + scrollRect.height > this.canvas.getBounds().height) {
                scrollRect.height = this.canvas.getBounds().height - scrollRect.y;
            }
            this.canvas.scrollRectToVisible(scrollRect);
        }
    }

    public void onScreenClipboard(Object[] obj) {
    }

    public void setToolSlipTool(AbstractToolModel tool, boolean isTemplate) {
        if (this.toolPropertiesPanel != null) {
            this.toolPropertiesPanel.setToolSlipTool(tool, isTemplate);
        }
    }

    public void unsetToolSlipTool(AbstractToolModel tool) {
        if (this.toolPropertiesPanel != null) {
            this.toolPropertiesPanel.unsetToolSlipTool(tool);
        }
    }

    public void clearToolSlipTools() {
        if (this.toolPropertiesPanel != null) {
            this.toolPropertiesPanel.clearToolSlipTools();
        }
    }

    public void setSelectMode() {
        this.toolSlip.setSelectMode();
    }

    public void setNextMode() {
        this.toolSlip.setNextMode();
    }

    public ControllerPaneMouseAdapter getMouseListener() {
        return this.mouseAdapter;
    }

    public JPanel getPropertiesPanel() {
        return this.toolPropertiesPanel;
    }

    public DataFlavorManager getDataFlavorManager() {
        if (this.dfManager == null) {
            this.dfManager = new DataFlavorManager();
        }
        return this.dfManager;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void newPage_actionPerformed(ActionFeatureEvent event) {
        ScreenModel screen = ActionUtilities.newScreen((WhiteboardContext)this.context, (int)1, (int)1, (boolean)false);
        if (screen != null) {
            this.gotoUIScreen(screen.getObjectID(), false);
        }
        this.requestFocus();
    }

    private void clearPage_actionPerformed(ActionFeatureEvent event) {
        this.setSelectMode();
        ScreenModel currentScreen = this.getScreen();
        int nTools = currentScreen.getForegroundToolCount();
        if (nTools < 1) {
            return;
        }
        String title = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_CLEARPAGECONFIRMTITLE);
        String text = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_CLEARPAGECONFIRMTEXT, new Object[]{nTools});
        int choice = ModalDialog.showConfirmDialog((Component)this.context.getDialogParentFrame(), (Object)text, (String)title, (int)0);
        if (choice != 0) {
            return;
        }
        AbstractToolModel[] fgTools = currentScreen.getForegroundTools();
        ActionUtilities.deleteToolList((AbstractToolModel[])fgTools, (WhiteboardContext)this.context);
        this.requestFocus();
    }

    private void removePage_actionPerformed(ActionFeatureEvent event) {
        ScreenModel screenToRemove = this.getScreen();
        if (!(screenToRemove instanceof ScreenRoot)) {
            String title = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_DELETEPAGECONFIRMTITLE);
            String text = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_DELETEPAGECONFIRMTEXT);
            int choice = ModalDialog.showConfirmDialog((Component)this.context.getDialogParentFrame(), (Object)text, (String)title, (int)0);
            if (choice != 0) {
                return;
            }
            ActionUtilities.deleteScreen((ScreenModel)screenToRemove, (WhiteboardContext)this.context);
        }
        this.requestFocus();
    }

    public AbstractToolModel getToolByName(String toolName, ScreenModel screen, ExternalDataBean toolData) {
        return this.toolSlip.getToolByName(toolName, screen, toolData);
    }

    public void addToolComponentToQuiesce(Window window) {
    }

    public boolean canPaste() {
        return this.context.isAccessible(this.getScreen()) && this.getScreen() != null && !(this.getScreen() instanceof ScreenRoot) && ActionUtilities2.isValidClipboardContent(this.context);
    }

    public boolean hasSelectable() {
        return this.context.isAccessible(this.getScreen()) && ActionUtilities.hasSelectableTools((WhiteboardContext)this.context, (ScreenModel)this.getScreen());
    }

    public boolean hasSelection() {
        return this.context.isAccessible(this.getScreen()) && this.getScreen().getSelectedToolCount() != 0;
    }

    public boolean supports(int action) {
        return (action & 3) > 0;
    }

    public void selectAll() {
        this.getScreen().selectAllTools(false);
    }

    public void exportToClipboard(int action) {
        if (action == 1) {
            ActionUtilities2.copySelectedTools(this.getScreen(), this.context);
        } else if (action == 2) {
            ActionUtilities2.cutSelectedTools(this.getScreen(), this.context);
        }
    }

    public void pasteFromClipboard() {
        ActionUtilities2.pasteSelectedTools(this.getScreen(), this.context, null);
    }

    public void addEditMenuSelectionListener(EditMenuSelectionListener listener) {
        this.editMenuSelectionListeners.add(listener);
    }

    public void removeEditMenuSelectionListener(EditMenuSelectionListener listener) {
        this.editMenuSelectionListeners.remove(listener);
    }

    public void fireEditMenuSelection() {
        Iterator iter = this.editMenuSelectionListeners.iterator();
        while (iter.hasNext()) {
            try {
                ((EditMenuSelectionListener)iter.next()).selectionUpdated();
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireEditMenuSelection", (Throwable)ex, (boolean)true);
            }
        }
    }

    public void onSelect(AbstractToolModel tool, boolean selected) {
        this.fireEditMenuSelection();
    }

    class DoGoto
    implements Runnable {
        ScreenModel screen;

        public DoGoto(ScreenModel screen) {
            this.screen = screen;
        }

        @Override
        public void run() {
            if (this.screen != ControllerPane.this.getScreen() && ControllerPane.this.getScreen() != null) {
                ControllerPane.this.getScreen().removeACLChangeListener((ACLChangeListener)ControllerPane.this);
                ControllerPane.this.getScreen().removeToolSelectionListener((ToolSelectionListener)ControllerPane.this);
            }
            if (this.screen != null && !this.screen.isDeleted() && this.screen.getRoot() != null) {
                ControllerPane.this.canvas.noteScreen(this.screen);
                ControllerPane.this.setWhiteboardAccessible();
                ControllerPane.this.processScaleChange();
                ControllerPane.this.screenNavigator.setCurrentScreen(this.screen);
                if (ControllerPane.this.treeNav != null) {
                    ControllerPane.this.treeNav.setScreen(this.screen);
                }
                ControllerPane.this.setControllerTitle(this.screen.getRoot().getScreenName());
                ((WhiteboardBean)ControllerPane.this.context.getBean()).setScreenTitle(this.screen.getTitle());
                if (ControllerPane.this.toolPropertiesPanel != null) {
                    ControllerPane.this.toolPropertiesPanel.populateProperties(this.screen);
                }
                ControllerPane.this.toolSlip.populateToolSlip(this.screen);
                ControllerPane.this.toolSlip.setEnabled(this.screen.canAccessTools() || ControllerPane.this.context.isChair());
                if (ControllerPane.this.broker != null) {
                    ControllerPane.this.broker.setFeaturePublished((Feature)ControllerPane.this.toolsPaletteFeature, this.screen.canAccessTools() && ControllerPane.this.context.isAccessible());
                }
                if (this.screen != null) {
                    this.screen.addACLChangeListener((ACLChangeListener)ControllerPane.this);
                    this.screen.addToolSelectionListener((ToolSelectionListener)ControllerPane.this);
                }
                ControllerPane.this.setPaths();
                ControllerPane.this.enableAlignMenu();
                ControllerPane.this.postNavigator(ControllerPane.this.postToolNavigator);
                if (ControllerPane.this.msgPublisher != null) {
                    ControllerPane.this.msgPublisher.sendWhiteboardSlideTransitionMessage(this.screen.getDisplayName(), null, false);
                    if (this.screen.getAltTextText() != null && !this.screen.getAltTextText().equals("")) {
                        ControllerPane.this.msgPublisher.sendWhiteboardSlideText(this.screen.getDisplayName(), this.screen.getAltTextText(), false);
                    }
                }
            } else if (!this.screen.isDeleted()) {
                LogSupport.error((Object)this, (String)"run", (String)("Attempt to goto screen with no root: " + this.screen));
            }
            ControllerPane.this.processScaleChange();
        }
    }

    private class FocusMouseAdapter
    extends MouseAdapter {
        private FocusMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ControllerPane.this.requestFocus();
        }
    }

    class KeyboardAction
    implements ActionListener {
        KeyboardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ControllerPane.this.keyboardButton.isSelected()) {
                if (ControllerPane.this.keyBoard == null) {
                    ControllerPane.this.createKeyboard();
                } else {
                    ControllerPane.this.keyBoard.setVisible(true);
                }
            } else if (ControllerPane.this.keyBoard != null) {
                ControllerPane.this.keyBoard.setVisible(false);
            }
        }
    }

    class SetChairRunnable
    implements Runnable {
        SetChairRunnable() {
        }

        @Override
        public void run() {
            if (ControllerPane.this.context.isChair()) {
                ControllerPane.this.screenNavigator.setEnabled(true);
                ControllerPane.this.toolSlip.setEnabled(true);
                if (ControllerPane.this.broker != null) {
                    ControllerPane.this.broker.setFeaturePublished((Feature)ControllerPane.this.toolsPaletteFeature, ControllerPane.this.context.isAccessible());
                }
            } else {
                ControllerPane.this.setExplorer(false);
            }
            ControllerPane.this.enableNavigation();
        }
    }

    class SetFollowInstructorRunnable
    implements Runnable {
        boolean selected;

        public SetFollowInstructorRunnable(boolean selected) {
            this.selected = selected;
        }

        @Override
        public void run() {
            ControllerPane.this.screenNavigator.setFollowFeatureExternally(ControllerPane.this.isFollowInstructorSelected());
            ControllerPane.this.enableNavigation();
        }
    }

    class SetWhiteboardAccessibleRunnable
    implements Runnable {
        SetWhiteboardAccessibleRunnable() {
        }

        @Override
        public void run() {
            ControllerPane.this.enableScreenAndGroupItems();
            if (!ControllerPane.this.whiteboardAccessible) {
                ControllerPane.this.getScreen().deSelectAllTools();
            }
            ControllerPane.this.screenNavigator.setWhiteboardAccessible(ControllerPane.this.whiteboardAccessible);
            ControllerPane.this.mouseAdapter.setWhiteboardAccessible(ControllerPane.this.whiteboardAccessible);
            if (ControllerPane.this.exploreToolsAction != null) {
                ControllerPane.this.exploreToolsAction.setEnabled(ControllerPane.this.whiteboardAccessible);
                if (!ControllerPane.this.whiteboardAccessible) {
                    ControllerPane.this.postNavigator(false);
                }
            }
            ControllerPane.this.fireAccessibleListeners(ControllerPane.this.whiteboardAccessible);
            ControllerPane.this.setPaths();
            if (ControllerPane.this.screenPropertiesAction != null) {
                // empty if block
            }
            ControllerPane.this.enableOffscreenMove();
        }
    }
}

