/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.StarOfficeInformation;
import com.elluminate.util.Resource;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class StarOfficeClassLoader
extends ClassLoader {
    private static String LOADER_PACKAGE = null;
    private ClassLoader parent = null;
    private static StarOfficeClassLoader loader = null;
    private String[] classPath = null;
    private static HashMap classCache = new HashMap();

    private StarOfficeClassLoader(ClassLoader parent) {
        if (parent == this) {
            return;
        }
        this.parent = parent == null ? null : this.getClass().getClassLoader();
        LOADER_PACKAGE = this.getClass().getPackage().getName() + ".loader.";
    }

    public static StarOfficeClassLoader StarOfficeClassLoaderFactory(ClassLoader parent) {
        if (loader == null) {
            loader = new StarOfficeClassLoader(parent);
        }
        return loader;
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String[] path) {
        this.classPath = path;
    }

    public byte[] readClassFile(String className, String classPath) throws IOException {
        byte[] inputBytes = null;
        int bytesRead = 0;
        File classFile = null;
        InputStream fileStream = null;
        boolean findResource = className.startsWith(LOADER_PACKAGE);
        String fileName = className.replace('.', '/') + ".class";
        if (findResource) {
            Resource rsc = new Resource(fileName);
            return rsc.load();
        }
        try {
            if (!classPath.endsWith(".jar")) {
                classFile = new File(classPath + File.separator + fileName);
                fileStream = new FileInputStream(classFile);
                bytesRead = fileStream.available();
                inputBytes = new byte[bytesRead];
            } else {
                JarFile jar = new JarFile(classPath);
                JarEntry entry = jar.getJarEntry(fileName);
                if (entry == null) {
                    throw new IOException("class: " + fileName + ", not found in jar: " + classPath);
                }
                fileStream = jar.getInputStream(entry);
                bytesRead = (int)entry.getSize();
                inputBytes = new byte[bytesRead];
            }
            int byteOffset = 0;
            int read = 1;
            while (read > 0) {
                read = fileStream.read(inputBytes, byteOffset, bytesRead - byteOffset);
                byteOffset += read;
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (Exception e) {}
            }
        }
        return inputBytes;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> newClass = this.findLoadedClass(name);
        if (newClass == null) {
            try {
                if (name.equals("StarOfficeLoader")) {
                    name = LOADER_PACKAGE + name;
                    throw new Throwable("load star office loader");
                }
                if (name.indexOf(LOADER_PACKAGE) == 0) {
                    throw new Throwable("load star office loader support");
                }
                newClass = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
            }
            catch (Throwable e) {
                newClass = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(newClass);
        }
        return newClass;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (classCache.containsKey(name)) {
            return (Class)classCache.get(name);
        }
        if (this.classPath != null) {
            byte[] bytes = null;
            for (int i = 0; i < StarOfficeInformation.JARS.length; ++i) {
                for (int j = 0; j < this.classPath.length; ++j) {
                    try {
                        bytes = this.readClassFile(name, this.classPath[j] + File.separator + StarOfficeInformation.JARS[i]);
                        Class<?> definedClass = this.defineClass(name, bytes, 0, bytes.length);
                        classCache.put(name, definedClass);
                        return definedClass;
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
            }
        }
        if (WhiteboardDebug.STAROFFICE.show()) {
            LogSupport.message((Object)this, (String)"findClass", (String)("Could not find " + name + " in " + StarOfficeInformation.concatenatePaths(this.classPath)));
        }
        throw new ClassNotFoundException("Cannot find class: " + name);
    }
}

