/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationInterface;
import com.elluminate.groupware.whiteboard.module.presentations.StarOfficeImport;
import com.elluminate.groupware.whiteboard.module.presentations.StringsProperties;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.util.Locale;
import javax.swing.JFileChooser;

public class PresentationImport {
    private static final boolean isMac = Platform.getOS() == 202;
    private static I18n i18n = I18n.create((Object)new Object(){});
    public static final int FASTER = 1;
    public static final int BETTER = 2;
    public static final int BEST = 3;
    public static final int DEFAULT_JPEG_QUALITY = 85;
    public static final int DEFAULT_PNG_COMPRESSION = 9;
    public static final int MAX_SLIDE_TYPE = 3;
    public static final String POWERPOINT = "powerpoint";
    public static final String STAROFFICE = "staroffice";
    private static PresentationInterface powerpoint;
    private static PresentationInterface starOffice;

    private PresentationImport() {
    }

    public static boolean isSupported(String processor) {
        if (processor.toLowerCase(Locale.ENGLISH).equals(STAROFFICE)) {
            if (starOffice == null) {
                starOffice = StarOfficeImport.isAvailable() ? new StarOfficeImport() : null;
            } else if (!StarOfficeImport.isAvailable()) {
                starOffice = null;
            }
            return starOffice != null && StarOfficeImport.isAvailable();
        }
        if (processor.toLowerCase(Locale.ENGLISH).equals(POWERPOINT)) {
            return powerpoint != null && PowerPointImport.isAvailable();
        }
        return false;
    }

    public static PresentationInterface presentationFactory(String processor) {
        if (processor.toLowerCase(Locale.ENGLISH).equals(STAROFFICE)) {
            return starOffice;
        }
        if (processor.toLowerCase(Locale.ENGLISH).equals(POWERPOINT)) {
            return powerpoint;
        }
        return null;
    }

    public static void addChoosableFileFilter(JFileChooser chooser, String processor) {
        try {
            if (PresentationImport.isSupported(processor)) {
                PresentationImport.presentationFactory(processor).addChoosableFileFilter(chooser);
            }
        }
        catch (Exception ex) {
            LogSupport.exception(PresentationImport.class, (String)"addChoosableFileFilter", (Throwable)ex, (boolean)false, (String)"PresentationInterface:addChoosableFileFilter:");
        }
    }

    @Deprecated
    private static PresentationInterface loadPresentationSupport(String cls, String desc) {
        try {
            return null;
        }
        catch (Exception ex) {
            LogSupport.message((String)i18n.getString((PropertiesEnum)StringsProperties.PRESENTATIONIMPORT_CANTLOAD, new Object[]{desc}));
            return null;
        }
    }

    static {
        try {
            powerpoint = PowerPointImport.isAvailable() ? new PowerPointImport() : null;
        }
        catch (Throwable t) {
            LogSupport.exception(PresentationImport.class, (String)"<clinit>", (Throwable)t, (boolean)true, (String)"Initializing PowerPoint importer");
        }
        try {
            starOffice = StarOfficeImport.isAvailable() ? new StarOfficeImport() : null;
        }
        catch (Throwable t) {
            LogSupport.exception(PresentationImport.class, (String)"<clinit>", (Throwable)t, (boolean)true, (String)"Initializing OpenOffice.org importer");
        }
    }
}

