/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.presentations.FileEntry;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointMetaData;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationImage;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationSlide;
import com.elluminate.groupware.whiteboard.module.presentations.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PowerPointPresentation {
    public static final int MIN_TITLE_CHARS = 5;
    private PresentationSlide[] slides = null;
    private I18n i18n = I18n.create((Object)this);
    int slideCount = 0;

    public void processPresentationSlides(String tempDirectoryName, int typeOfSlide, PowerPointImport.PowerPointLoadDialog progress, int wbWidth, int wbHeight) {
        long startTime = System.currentTimeMillis();
        if (progress != null) {
            progress.setString(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_LOADING));
        }
        PowerPointMetaData metaData = new PowerPointMetaData();
        metaData.extractMetaData(tempDirectoryName);
        this.slideCount = metaData.getSlideCount();
        if (this.slideCount < 1) {
            LogSupport.message((Object)this, (String)"processPresentationSlides", (String)("Status from meta data: " + this.slideCount));
            return;
        }
        this.initProgress(progress, this.slideCount);
        this.slides = new PresentationSlide[this.slideCount];
        int outputCount = 0;
        Map<Integer, List<String>> notesDataMap = metaData.getNotesDataMap();
        Map<Integer, PowerPointMetaData.MetaDataEntry> metaDataMap = metaData.getMetaDataMap();
        Map<Integer, String> altTextMap = metaData.getAltTextMap();
        for (Integer slideNum : metaDataMap.keySet()) {
            PresentationSlide slide = new PresentationSlide(slideNum, metaDataMap.get(slideNum).getFlag(), this.validateTitle(metaDataMap.get(slideNum).getTitle(), slideNum), tempDirectoryName, typeOfSlide, wbWidth, wbHeight, progress, this.getFileEntryFactory(typeOfSlide));
            progress.checkCancelled();
            progress.setString(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_PROCESSINGSLIDE, new Object[]{slideNum, this.slides.length, metaDataMap.get(slideNum).getTitle()}));
            progress.setValue(slideNum);
            slide.processSlide(progress);
            slide.setPresenterNotes(notesDataMap.get(slideNum));
            slide.setAltText(altTextMap.get(slideNum));
            outputCount += slide.getOutputImageCount();
            this.slides[slideNum.intValue() - 1] = slide;
        }
        progress.setValue(this.slides.length + 1);
        if (outputCount == 0) {
            this.slideCount = -6;
            LogSupport.message((Object)this, (String)"<init>", (String)"ERROR: All slide images are missing");
        } else if (outputCount < 0) {
            this.dispose();
        }
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((Object)this, (String)"<init>", (String)("Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
        }
    }

    private void initProgress(PowerPointImport.PowerPointLoadDialog progress, int slideCount) {
        if (progress != null) {
            progress.setMinimum(0);
            progress.setMaximum(slideCount);
        }
    }

    private String validateTitle(String title, int index) {
        return "".equals(title = this.trimTitle(title)) ? this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_DEFAULTSLIDETITLE, new Object[]{index}) : title;
    }

    private FileEntry.Factory getFileEntryFactory(int typeOfSlide) {
        return typeOfSlide == 1 ? new FileEntry.Factory() : new CommonBackgroundFactory(this.slideCount);
    }

    public PresentationImage[] getImages(int index) {
        return this.slides == null || index < 1 || index > this.slides.length ? null : this.slides[index - 1].getOutputImages();
    }

    public int getSlideCount() {
        return this.slideCount;
    }

    public String getSlideTitle(int index) {
        if (this.slides == null || index < 0 || index >= this.slides.length || this.slides[index] == null) {
            return " ****** ";
        }
        return this.slides[index].getSlideTitle();
    }

    public List<String> getSlideNotes(int index) {
        if (this.slides == null || this.slides.length < index - 1) {
            return null;
        }
        return this.slides[index - 1].getPresenterNotes();
    }

    public String getSlideAltText(int index) {
        if (this.slides == null || this.slides.length < index - 1) {
            return null;
        }
        return this.slides[index - 1].getAltText();
    }

    public void dispose() {
        if (this.slides != null) {
            for (int i = 0; i < this.slides.length; ++i) {
                if (this.slides[i] == null) continue;
                this.slides[i].dispose();
            }
        }
    }

    private String trimTitle(String title) {
        boolean inWhitespace = false;
        StringBuffer result = new StringBuffer(title.length());
        for (int i = 0; i < title.length(); ++i) {
            char titleChar = title.charAt(i);
            if (Character.isWhitespace(titleChar)) {
                if (inWhitespace) continue;
                result.append(' ');
                inWhitespace = true;
                continue;
            }
            if (Character.isIdentifierIgnorable(titleChar)) continue;
            result.append(titleChar);
            inWhitespace = false;
        }
        return result.toString();
    }

    static class CommonBackgroundFactory
    extends FileEntry.Factory {
        private ArrayList list = null;

        CommonBackgroundFactory(int nSlides) {
            this.list = new ArrayList(nSlides * 2);
        }

        @Override
        FileEntry make(int slideIndex, String containingDirectory, String prefix, String mimeType, PowerPointImport.PowerPointLoadDialog progress) {
            String suffix = mimeType.equals("image/png") ? ".png" : ".jpg";
            FileEntry fe = super.make(slideIndex, containingDirectory, prefix, mimeType, progress);
            if (!fe.isEmpty()) {
                Long crc = null;
                for (FileEntry fe2 : this.list) {
                    if (fe2.fileLength != fe.fileLength) continue;
                    if (crc == null) {
                        crc = fe.getEncodingChecksum();
                        fe.forgetData();
                    }
                    boolean wasRead2 = fe2.isDataRead();
                    Long crc2 = fe2.getEncodingChecksum();
                    if (!wasRead2) {
                        fe2.forgetData();
                    }
                    if (!crc2.equals(crc)) continue;
                    fe.dispose();
                    fe2.addRef();
                    return fe2;
                }
            }
            this.list.add(fe);
            return fe;
        }
    }
}

