/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PowerPointMetaData {
    public static final String META_DATA_FILENAME = "imageDat.tmp";
    public static final String NOTES_DATA_FILENAME = "notesdat.tmp";
    private int slideCount = 0;
    private Map<Integer, MetaDataEntry> metaDataMap = new TreeMap<Integer, MetaDataEntry>();
    private Map<Integer, List<String>> notesDataMap = new TreeMap<Integer, List<String>>();
    private Map<Integer, String> altTextMap = new TreeMap<Integer, String>();

    public int getSlideCount() {
        return this.slideCount;
    }

    public Map<Integer, MetaDataEntry> getMetaDataMap() {
        return new TreeMap<Integer, MetaDataEntry>(this.metaDataMap);
    }

    public Map<Integer, List<String>> getNotesDataMap() {
        return new TreeMap<Integer, List<String>>(this.notesDataMap);
    }

    public boolean containsNotes() {
        return !this.notesDataMap.isEmpty();
    }

    public Map<Integer, String> getAltTextMap() {
        return new TreeMap<Integer, String>(this.altTextMap);
    }

    public void extractMetaData(String tempDirectoryPath) {
        File metaDataFile = new File(tempDirectoryPath, META_DATA_FILENAME);
        File notesDataFile = new File(tempDirectoryPath, NOTES_DATA_FILENAME);
        this.notesDataMap = this.getNotesDataContents(notesDataFile);
        try {
            List<String> contents = this.getMetaDataContents(metaDataFile);
            if (contents.isEmpty()) {
                return;
            }
            this.slideCount = this.parseSlideCount(contents);
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message((Object)this, (String)"extractMetaData", (String)("slide count: " + this.slideCount));
            }
            int iterations = contents.size();
            int slideNum = 0;
            for (int i = 1; i < iterations; ++i) {
                ++slideNum;
                MetaDataEntry entry = new MetaDataEntry();
                int idx = 0;
                while ((idx = entry.extractMetaDataInfo(contents, i)) != i) {
                    i = idx;
                }
                this.metaDataMap.put(slideNum, entry);
                String altText = this.readAltText(tempDirectoryPath, slideNum);
                if (altText == null) continue;
                if (WhiteboardDebug.POWERPOINT.show()) {
                    int n = Math.min(256, altText.length());
                    LogSupport.message((Object)this, (String)"extractMetaData", (String)("alt text for " + slideNum + ": " + altText.substring(0, n).replace("\n", "<NL>")));
                }
                this.altTextMap.put(slideNum, altText);
            }
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"extractMetaData(String)", (Throwable)e, (boolean)true, (String)("Processing PowerPoint meta data file: " + metaDataFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, List<String>> getNotesDataContents(File notesFile) {
        TreeMap<Integer, List<String>> notesContents = new TreeMap<Integer, List<String>>();
        if (notesFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(notesFile));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    ArrayList<String> slideNote;
                    if (!line.startsWith("[")) continue;
                    int slideNum = Integer.parseInt(line.substring(1, line.indexOf(93)));
                    String content = line.substring(line.indexOf(93) + 1);
                    if (WhiteboardDebug.POWERPOINT.show()) {
                        LogSupport.message((Object)this, (String)"getNotesDataContents(File)", (String)("Slide " + slideNum + ": " + content));
                    }
                    if ((slideNote = (ArrayList<String>)notesContents.get(slideNum)) == null) {
                        slideNote = new ArrayList<String>();
                    }
                    slideNote.add(content);
                    notesContents.put(slideNum, slideNote);
                }
            }
            catch (FileNotFoundException fne) {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"getNotesDataContents(File)", (String)Debug.getStackTrace((Throwable)fne));
                }
            }
            catch (IndexOutOfBoundsException ioob) {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"getNotesDataContents(File)", (String)"Attempted to parse an empty note");
                }
            }
            catch (IOException ioe) {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"getNotesDataContents(File)", (String)Debug.getStackTrace((Throwable)ioe));
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable ignored) {}
            }
        }
        return notesContents;
    }

    private int parseSlideCount(List<String> contents) {
        try {
            return Integer.parseInt(contents.get(0).trim());
        }
        catch (NumberFormatException ex) {
            int count = -1;
            if (!WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message((Object)this, (String)"parseSlideCount(List)", (String)Debug.getStackTrace((Throwable)ex));
            }
            return count;
        }
    }

    private List<String> getMetaDataContents(File contentFile) throws FileNotFoundException, IOException {
        String line;
        ArrayList<String> contents = new ArrayList<String>();
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((Object)this, (String)"getMetaDataContents(File)", (String)("Processing meta data: " + contentFile));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(contentFile)));
        while ((line = reader.readLine()) != null) {
            contents.add(line);
        }
        reader.close();
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readAltText(String dir, int slideNo) {
        StringBuilder result;
        block47: {
            BufferedReader bufRdr;
            InputStreamReader rdr;
            FileInputStream fis;
            File f;
            block46: {
                String s;
                f = new File(dir, "Slide" + slideNo + ".txt");
                int expectedChars = (int)(f.length() / 2L);
                if (!f.isFile()) {
                    return null;
                }
                if (expectedChars < 1) {
                    return null;
                }
                result = null;
                fis = null;
                BufferedInputStream bis = null;
                rdr = null;
                bufRdr = null;
                fis = new FileInputStream(f);
                bis = new BufferedInputStream(fis, 4096);
                String encoding = this.determineAltTextEncoding(bis);
                rdr = "default".equalsIgnoreCase(encoding) ? new InputStreamReader(bis) : new InputStreamReader((InputStream)bis, encoding);
                bufRdr = new BufferedReader(rdr);
                while ((s = bufRdr.readLine()) != null) {
                    if ((s = s.trim()).length() <= 0) continue;
                    if (result == null) {
                        result = new StringBuilder(expectedChars + 1);
                    }
                    if (result.length() > 0) {
                        result.append('\n');
                    }
                    result.append(s);
                }
                if (bufRdr == null) break block46;
                try {
                    bufRdr.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable ignored) {}
            }
            break block47;
            catch (EOFException ignored) {
                if (bufRdr != null) {
                    try {
                        bufRdr.close();
                    }
                    catch (Throwable ignored2) {
                        // empty catch block
                    }
                }
                if (rdr != null) {
                    try {
                        rdr.close();
                    }
                    catch (Throwable ignored3) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable ignored4) {}
                }
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"readAltText", (Throwable)t, (boolean)true, (String)("Reading file " + f.getAbsolutePath()));
                String string = null;
                return string;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (bufRdr != null) {
                        try {
                            bufRdr.close();
                        }
                        catch (Throwable ignored) {}
                    }
                    if (rdr != null) {
                        try {
                            rdr.close();
                        }
                        catch (Throwable ignored) {}
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable ignored) {}
                    }
                }
            }
        }
        if (result == null) {
            return null;
        }
        if (result.length() < 1) {
            return null;
        }
        return result.toString();
    }

    private String determineAltTextEncoding(InputStream is) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("Stream does not support mark/reset");
        }
        is.mark(256);
        int c = is.read();
        if (c < 0) {
            throw new EOFException();
        }
        if (c == 10 || c == 13 || c == 32) {
            return "default";
        }
        if (c == 0 || c == 255 || c == 254) {
            is.reset();
            return "UTF-16";
        }
        if (c > 127) {
            is.reset();
            return "default";
        }
        if (c < 32) {
            String msg = "Invalid encoding char 0x" + Integer.toHexString(c);
            LogSupport.message((Object)this, (String)"determineAltTextEncoding", (String)msg);
            throw new CharConversionException("Invalid character in encoding name");
        }
        StringBuilder result = new StringBuilder();
        result.append((char)c);
        while (true) {
            if ((c = is.read()) < 0) {
                is.reset();
                return "default";
            }
            if (c == 10) break;
            if (c == 13) {
                is.mark(1);
                c = is.read();
                if (c == 10) break;
                is.reset();
                break;
            }
            if (result.length() >= 64) {
                is.reset();
                return "default";
            }
            if (c < 33 || c > 127) {
                String msg = "Invalid encoding char 0x" + Integer.toHexString(c) + " after: '" + result.toString() + "'";
                LogSupport.message((Object)this, (String)"determineAltTextEncoding", (String)msg);
                throw new CharConversionException("Invalid character in encoding name");
            }
            result.append((char)c);
        }
        return result.toString();
    }

    public class MetaDataEntry {
        private static final char TITLE_FLAG = 'T';
        private static final char UNKNOWN_FLAG = '?';
        private static final int START_POSITION = 6;
        private String title = "";
        private char flag = (char)63;

        public String getTitle() {
            return this.title;
        }

        public char getFlag() {
            return this.flag;
        }

        public int extractMetaDataInfo(List<String> contents, int startingIndex) {
            int endIndex = startingIndex;
            if (contents.isEmpty()) {
                return -1;
            }
            if (contents.size() <= startingIndex) {
                return -1;
            }
            String line = contents.get(startingIndex);
            this.flag = this.parseFlag(line);
            if ('T' == this.flag) {
                int len = this.parseLength(line);
                int startPos = 6;
                while (len > 0) {
                    if ((len = this.parseTitle(line, len, startPos)) <= 0) continue;
                    startPos = 0;
                    if (contents.size() <= endIndex + 1) {
                        return endIndex;
                    }
                    line = contents.get(++endIndex);
                }
            }
            return endIndex;
        }

        private char parseFlag(String line) {
            return line.charAt(0);
        }

        private int parseLength(String line) {
            try {
                return Integer.parseInt(line.substring(2, 5));
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }

        private int parseTitle(String line, int len, int startPos) {
            int remain = len;
            String sub = line.substring(startPos);
            this.title = this.title + sub;
            if (len > sub.length()) {
                this.title = this.title + " ";
                --len;
            }
            return len -= sub.length();
        }
    }
}

