/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.ShutdownListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointLoader;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointPresentation;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationImage;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationInterface;
import com.elluminate.groupware.whiteboard.module.presentations.StringsProperties;
import com.elluminate.groupware.whiteboard.module.presentations.macos.MacPPTLoader;
import com.elluminate.groupware.whiteboard.module.presentations.windows.WinPPTLoader;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.filechooser.FileFilter;

public class PowerPointImport
extends PresentationInterface
implements PropertyChangeListener,
ShutdownListener {
    private static PowerPointLoader loader = null;
    private static boolean loaderInitialized = false;
    static final int SOFTWARE_FAILURE = -1;
    static final int VERSION_FAILURE = -2;
    static final int IN_USE_FAILURE = -3;
    static final int NOT_INSTALLED_FAILURE = -4;
    static final int CANCELLED_FAILURE = -5;
    static final int CALL_FAILURE = -6;
    static final int OUT_OF_MEMORY = -7;
    static final int CANCELLED_FAILURE2 = -9;
    private static final String TEMP_FILE_BASE = "vcPowerPointTemp_";
    private static int tempSequence = 0;
    private static final String POWER_POINT_EXTENTION = "ppt";
    private static final String POWER_POINT_MIME_TYPE = "application/x-ms-powerpoint";
    private I18n i18n = I18n.create((Object)this);
    private static File oldPowerPointFolder;
    private int countOfScreens;
    protected File pptFile;
    private File tempPath;
    private WhiteboardContext context;
    private Preferences preferences;
    private PowerPointPresentation presentation = null;
    private int desiredWidth = 1014;
    private int desiredHeight = 835;

    public static boolean isAvailable() {
        if (!loaderInitialized) {
            loader = PowerPointImport.makeLoader();
            loaderInitialized = true;
        }
        if (loader == null) {
            return false;
        }
        return loader.isAvailable();
    }

    public void onShutdown() {
        this.dispose();
    }

    public boolean accept(File f) {
        try {
            if (FileSysUtils.isTraversableDirectory((File)f)) {
                return true;
            }
            String type = Platform.getMimeType((File)f);
            if (!type.equalsIgnoreCase(POWER_POINT_MIME_TYPE)) {
                return false;
            }
            return !f.getName().endsWith(".pptx") || loader.isXMLSupported();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public PresentationInterface importFromFile(Component parent, WhiteboardContext context, int width, int height) {
        this.context = context;
        CFileChooser chooser = new CFileChooser(oldPowerPointFolder);
        chooser.setDialogTitle(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_LOADDIALOGTITLE));
        FileFilter[] filters = chooser.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            chooser.removeChoosableFileFilter(filters[i]);
            filters[i] = null;
        }
        chooser.addChoosableFileFilter((FileFilter)((Object)this));
        if (chooser.showOpenDialog(parent) == 0) {
            this.pptFile = chooser.getSelectedFile();
            return this;
        }
        this.desiredWidth = width;
        this.desiredHeight = height;
        return this;
    }

    @Override
    public PresentationInterface importFromFile(String path, WhiteboardContext context, int width, int height) {
        return this.importFromFile(new File(path), context, width, height);
    }

    @Override
    public PresentationInterface importFromFile(File file, WhiteboardContext context, int width, int height) {
        this.context = context;
        if (!file.exists()) {
            return null;
        }
        this.pptFile = file;
        this.desiredWidth = width;
        this.desiredHeight = height;
        return this;
    }

    public PowerPointImport() {
        super(POWER_POINT_EXTENTION);
        if (!loader.isXMLSupported()) {
            this.setDescription(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_DESCRIPTIONNOXML));
        }
        this.context = null;
        this.countOfScreens = 0;
        this.presentation = null;
    }

    public void setContext(WhiteboardContext context) {
        this.context = context;
    }

    @Override
    public JComponent getAccessory() {
        return null;
    }

    @Override
    public void addChoosableFileFilter(JFileChooser chooser) {
        if (!PowerPointImport.isAvailable()) {
            return;
        }
        chooser.addChoosableFileFilter((FileFilter)((Object)this));
        chooser.addPropertyChangeListener("fileFilterChanged", this);
        chooser.setAccessory(this.getAccessory());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public int screenCount(int slideType) throws Exception {
        if (1 > slideType || slideType > 3) {
            return -1;
        }
        this.loadPresentation(slideType);
        return this.countOfScreens;
    }

    @Override
    public boolean isLoaded() {
        return this.presentation != null;
    }

    @Override
    public PresentationImage[] getScreenImages(int screenId, int slideType) throws Exception {
        this.loadPresentation(slideType);
        if (screenId < 1 && screenId > this.countOfScreens) {
            throw new Exception("getScreen: screenId (" + screenId + ") not in range 1 <= screenid <= " + this.countOfScreens);
        }
        return this.presentation.getImages(screenId);
    }

    @Override
    public void dispose() {
        if (this.tempPath != null && this.tempPath.isDirectory()) {
            if (!WhiteboardDebug.POWERPOINT.show()) {
                FileSysUtils.deleteTree((File)this.tempPath);
            }
            this.tempPath = null;
        }
        if (this.presentation != null) {
            this.presentation.dispose();
            this.presentation = null;
        }
    }

    public void loadPresentation(int slideType) throws Exception {
        if (!this.isLoaded()) {
            LoadPresentationRunnable loader = new LoadPresentationRunnable(slideType);
            PowerPointLoadDialog dialog = new PowerPointLoadDialog(this.context.getDialogParentFrame(), loader);
            dialog.setVisible(true);
            switch (this.countOfScreens) {
                case -1: {
                    throw new Exception(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_SOFTWAREERROR));
                }
                case -2: {
                    throw new Exception(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_WRONGVERSION));
                }
                case -3: {
                    throw new Exception(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_INUSENARRATIVE));
                }
                case -4: {
                    throw new Exception(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_NOTINSTALLED));
                }
                case -6: {
                    throw new Exception(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_CALLFAILURE));
                }
                case -7: {
                    throw new Exception(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_OOMEFAILURE));
                }
                case -9: 
                case -5: {
                    throw new Exception(this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_USERCANCELLEDMSG));
                }
            }
            if (this.countOfScreens < 0) {
                throw new Exception("Unknown importer error status: " + this.countOfScreens);
            }
        }
    }

    private static PowerPointLoader makeLoader() {
        PowerPointLoader result = null;
        try {
            if (Platform.getPlatform() == 1) {
                result = new WinPPTLoader();
            } else if (Platform.getPlatform() == 2) {
                result = new MacPPTLoader();
            }
        }
        catch (Throwable t) {
            LogSupport.exception(PowerPointLoader.class, (String)"makeLoader", (Throwable)t, (boolean)true);
            result = null;
        }
        return result;
    }

    private void makeTempDir() {
        File tmpRoot = Platform.getTempDir();
        do {
            this.tempPath = new File(tmpRoot, TEMP_FILE_BASE + ++tempSequence);
        } while (this.tempPath.isFile() || this.tempPath.isDirectory() || this.tempPath.exists());
        this.tempPath.mkdir();
        if (!WhiteboardDebug.POWERPOINT.show()) {
            FileSysUtils.deleteTreeOnExit((File)this.tempPath);
        }
    }

    @Override
    public String getFailReason() {
        String key;
        switch (this.countOfScreens) {
            case -1: {
                key = "Software Failure";
                break;
            }
            case -2: {
                key = "Version Failure";
                break;
            }
            case -3: {
                key = "PPT in use";
                break;
            }
            case -4: {
                key = "PPT not installed";
                break;
            }
            case -5: {
                key = "PPT cancelled";
                break;
            }
            case -6: {
                key = "PPT call failed";
                break;
            }
            case -7: {
                key = "Java memory heap exhausted";
                break;
            }
            case -9: {
                key = "PPT cancelled";
                break;
            }
            default: {
                key = "Unknown Failure";
            }
        }
        return key;
    }

    @Override
    public int getDesiredSlideType() {
        return 3;
    }

    @Override
    public boolean isNotesIncluded() {
        String name = this.getOwnerPrefix() + ".importQualityNotesImport";
        return this.getPreferences().getBooleanSetting(name, false);
    }

    @Override
    public String getSlideTitle(int index) {
        return this.presentation.getSlideTitle(index);
    }

    @Override
    public List<String> getSlideNotes(int index) {
        return this.presentation.getSlideNotes(index);
    }

    @Override
    public String getSlideAltText(int index) {
        return this.presentation.getSlideAltText(index);
    }

    private Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.context.getBean().getPreferences();
        }
        return this.preferences;
    }

    private String getOwnerPrefix() {
        return this.context.getBean().getOwnerPrefix();
    }

    public static class CancelledException
    extends RuntimeException {
        public CancelledException() {
            super("Cancelled by user.");
        }
    }

    public class LoadPresentationRunnable
    implements Runnable {
        int slideType;
        PowerPointLoadDialog progress = null;

        public LoadPresentationRunnable(int slideType) {
            this.slideType = slideType;
        }

        public void setProgress(PowerPointLoadDialog progress) {
            this.progress = progress;
        }

        boolean isCancelDisabledDuringVBLoad() {
            return loader.isCancelDisabledDuringLoad();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PowerPointImport.this.countOfScreens = 0;
            PowerPointImport.this.makeTempDir();
            try {
                File metaData = new File(PowerPointImport.this.tempPath, "imageDat.tmp");
                loader.load(PowerPointImport.this.tempPath, PowerPointImport.this.pptFile, metaData, this.slideType, PowerPointImport.this.desiredWidth, PowerPointImport.this.desiredHeight);
                this.progress.setCancelBtnEnabled(true);
                if (!metaData.exists()) {
                    LogSupport.message((Object)this, (String)"run", (String)("No title meta data file: " + metaData));
                    PowerPointImport.this.countOfScreens = -6;
                    return;
                }
                PowerPointPresentation pptPres = new PowerPointPresentation();
                pptPres.processPresentationSlides(PowerPointImport.this.tempPath.getAbsolutePath(), this.slideType, this.progress, PowerPointImport.this.desiredWidth, PowerPointImport.this.desiredHeight);
                PowerPointImport.this.presentation = pptPres;
                PowerPointImport.this.countOfScreens = PowerPointImport.this.presentation.getSlideCount();
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)("Count of screens: " + PowerPointImport.this.countOfScreens));
                }
            }
            catch (CancelledException cex) {
                PowerPointImport.this.countOfScreens = -5;
            }
            catch (OutOfMemoryError oome) {
                PowerPointImport.this.countOfScreens = -7;
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)Debug.getStackTrace((Throwable)oome));
                } else {
                    LogSupport.message((Object)this, (String)"run", (String)("Java heap exhausted: " + oome));
                }
            }
            catch (RuntimeException rx) {
                PowerPointImport.this.countOfScreens = -6;
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)Debug.getStackTrace((Throwable)rx));
                } else {
                    LogSupport.message((Object)this, (String)"run", (String)("Exception processing PPT: " + rx));
                }
                throw rx;
            }
            catch (Throwable ex) {
                PowerPointImport.this.countOfScreens = -6;
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)Debug.getStackTrace((Throwable)ex));
                } else {
                    LogSupport.message((Object)this, (String)"run", (String)("Error processing PPT: " + ex));
                }
            }
            finally {
                this.progress.setVisible(false);
            }
        }
    }

    public class PowerPointLoadDialog
    extends CDialog {
        Thread presentationLoader;
        LoadPresentationRunnable loader;
        Frame owner;
        volatile boolean cancelledFlag;
        JLabel statusMsg;
        JButton cancelBtn;
        JProgressBar progressBar;
        Cursor waitCursor;
        Cursor prevCursor;

        public PowerPointLoadDialog(Frame owner, LoadPresentationRunnable loader) {
            super(owner, PowerPointImport.this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_LOADERTITLE), true);
            this.presentationLoader = null;
            this.loader = null;
            this.cancelledFlag = false;
            this.statusMsg = new JLabel();
            this.cancelBtn = new JButton(PowerPointImport.this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_CANCELBTN));
            this.progressBar = new JProgressBar();
            this.waitCursor = Cursor.getPredefinedCursor(3);
            this.prevCursor = null;
            this.owner = owner;
            this.loader = loader;
            this.getRootPane().putClientProperty("Window.style", "small");
            Font f = this.statusMsg.getFont();
            this.statusMsg.setFont(new Font(f.getName(), 1, f.getSize()));
            this.setString(PowerPointImport.this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_CONVERTING));
            this.progressBar.setBorderPainted(true);
            Dimension barDim = new Dimension(owner.getSize());
            barDim.height = 16;
            barDim.width -= 128;
            if (barDim.width < 128) {
                barDim.width = 128;
            } else if (barDim.width > 512) {
                barDim.width = 512;
            }
            this.progressBar.setPreferredSize(barDim);
            this.progressBar.setStringPainted(true);
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    PowerPointLoadDialog.this.cancelledFlag = true;
                    PowerPointLoadDialog.this.setString(PowerPointImport.this.i18n.getString((PropertiesEnum)StringsProperties.POWERPOINTIMPORT_CANCELMSG));
                    PowerPointLoadDialog.this.cancelBtn.setEnabled(false);
                    if (PowerPointLoadDialog.this.presentationLoader != null && PowerPointLoadDialog.this.presentationLoader.isAlive()) {
                        PowerPointLoadDialog.this.presentationLoader.interrupt();
                    }
                    if (WhiteboardDebug.POWERPOINT.show()) {
                        LogSupport.message((Object)this, (String)"actionPerformed", (String)"User pressed cancel.");
                    }
                }
            });
            Container content = this.getContentPane();
            content.setLayout(new GridBagLayout());
            content.add((Component)this.statusMsg, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(16, 5, 5, 5), 0, 0));
            content.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 12, 5, 5), 0, 0));
            content.add((Component)this.cancelBtn, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 16, 5), 0, 0));
            this.setResizable(false);
            this.pack();
            loader.setProgress(this);
        }

        public void setMinimum(final int min) {
            if (this.progressBar != null) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PowerPointLoadDialog.this.progressBar.setMinimum(min);
                    }
                });
            }
        }

        public void setMaximum(final int max) {
            if (this.progressBar != null) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PowerPointLoadDialog.this.progressBar.setMaximum(max);
                    }
                });
            }
        }

        public void setValue(final int val) {
            if (this.progressBar != null) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PowerPointLoadDialog.this.progressBar.setValue(val);
                    }
                });
            }
        }

        public void setString(final String text) {
            if (this.statusMsg != null) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PowerPointLoadDialog.this.statusMsg.setText(text);
                    }
                });
            }
        }

        public boolean isCancelled() {
            if (!this.cancelledFlag && this.presentationLoader != null && this.presentationLoader.isInterrupted()) {
                this.cancelledFlag = true;
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)((Object)this), (String)"isCancelled", (String)"Detected loader interrupt.");
                }
            }
            return this.cancelledFlag;
        }

        public void checkCancelled() {
            if (this.isCancelled()) {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)((Object)this), (String)"checkCancelled", (String)"Reporting user cancel.");
                }
                throw new CancelledException();
            }
        }

        void setCancelBtnEnabled(final boolean enabled) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PowerPointLoadDialog.this.cancelBtn.setEnabled(enabled);
                }
            });
        }

        public void setVisible(boolean vis) {
            if (vis) {
                if (this.loader.isCancelDisabledDuringVBLoad()) {
                    this.cancelBtn.setEnabled(false);
                }
                this.presentationLoader = new WorkerThread((Runnable)this.loader, "PowerPoint Loader");
                this.presentationLoader.setDaemon(true);
                this.presentationLoader.start();
                Rectangle ownerBounds = this.owner.getBounds();
                Dimension dim = this.getSize();
                this.setLocation(ownerBounds.x + (ownerBounds.width - dim.width) / 2, ownerBounds.y + (ownerBounds.height - dim.height) / 2);
                if (this.prevCursor == null) {
                    this.prevCursor = this.owner.getCursor();
                }
                this.owner.setCursor(this.waitCursor);
            } else {
                if (this.presentationLoader != null && this.presentationLoader != Thread.currentThread() && this.presentationLoader.isAlive()) {
                    this.presentationLoader.interrupt();
                    this.cancelledFlag = true;
                }
                this.presentationLoader = null;
                if (this.owner.getCursor() == this.waitCursor) {
                    if (this.prevCursor != null) {
                        this.owner.setCursor(this.prevCursor);
                    } else {
                        this.owner.setCursor(Cursor.getDefaultCursor());
                    }
                }
                this.prevCursor = null;
            }
            super.setVisible(vis);
        }
    }
}

