/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.pdf;

import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.module.PDFWriterGraphics;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Png;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Watermark;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;

public class PDFWhiteboardWriter {
    private OutputStream oStream;
    private Document whiteboardDocument;
    private boolean disposed = true;
    private boolean opened = false;
    private String date;
    int depthLimit;
    private int imageWidth;
    private int imageHeight;
    private float pageWidth;
    private float pageHeight;
    private boolean continueOperation = true;
    private Rectangle imageSize;
    public static final String pdfSuffixString = "pdf";

    public PDFWhiteboardWriter(String filename) throws Exception {
        this.init(filename);
    }

    public PDFWhiteboardWriter(OutputStream oStream) throws Exception {
        this.init(oStream);
    }

    private void init(String filename) throws Exception {
        this.init(new FileOutputStream(filename));
    }

    private void init(OutputStream oStream) throws Exception {
        this.oStream = oStream;
        this.whiteboardDocument = new Document(PageSize.LETTER);
        PdfWriter.getInstance((Document)this.whiteboardDocument, (OutputStream)this.oStream);
        this.whiteboardDocument.addAuthor("Elluminate.com");
        this.whiteboardDocument.addSubject("Whiteboard Screens");
        this.whiteboardDocument.resetFooter();
        this.whiteboardDocument.resetHeader();
        HeaderFooter header = new HeaderFooter(new Phrase("Tutorsedge vClass Virtual Classroom Screens"), false);
        HeaderFooter footer = new HeaderFooter(new Phrase("Page "), new Phrase("."));
        footer.setAlignment(1);
        this.whiteboardDocument.setHeader(header);
        this.whiteboardDocument.setFooter(footer);
        this.opened = false;
        this.disposed = false;
        DateFormat fmt = DateFormat.getDateTimeInstance(2, 2);
        this.date = fmt.format((Object)new Date());
    }

    public void setWBSize(int width, int height) {
        this.pageWidth = this.whiteboardDocument.right() - this.whiteboardDocument.left();
        this.pageHeight = this.whiteboardDocument.top() - this.whiteboardDocument.bottom() - 100;
        float floatWidth = width;
        float floatHeight = height;
        this.imageWidth = (int)this.pageWidth;
        this.imageHeight = (int)(this.pageWidth * floatHeight / floatWidth);
        if ((float)this.imageHeight > this.pageHeight) {
            this.imageWidth = (int)(this.pageHeight * floatWidth / floatHeight);
            this.imageHeight = (int)this.pageHeight;
        }
    }

    public void setTitle(String title) {
        if (this.whiteboardDocument != null) {
            HeaderFooter header = new HeaderFooter(new Phrase(title + "        " + this.date), false);
            header.setAlignment(1);
            this.whiteboardDocument.setHeader(header);
        }
    }

    public void addImage(Image image, String name) {
        byte[] imageBytes = this.encodePNG(image.getScaledInstance(this.imageWidth, this.imageHeight, 4));
        if (imageBytes != null && this.continueOperation) {
            try {
                Paragraph figure = new Paragraph(name);
                figure.setAlignment(1);
                if (!this.opened) {
                    this.whiteboardDocument.open();
                    this.opened = true;
                }
                this.whiteboardDocument.add((Element)figure);
                Png png = new Png(imageBytes);
                png.setAlignment(1);
                this.whiteboardDocument.add((Element)png);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"addImage", (Throwable)ex, (boolean)true);
            }
        }
    }

    public void setWatermark(com.lowagie.text.Image image, String name) {
        if (!this.opened) {
            this.whiteboardDocument.open();
            this.opened = true;
        }
        int offsetX = 0;
        int offsetY = 0;
        try {
            Watermark waterMark = new Watermark(image, offsetX, offsetY);
            waterMark.setAlignment(5);
            this.whiteboardDocument.add(waterMark);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"setWatermark", (Throwable)ex, (boolean)true);
        }
    }

    public void newPage(String title) {
        try {
            if (this.opened) {
                this.whiteboardDocument.newPage();
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"newpage", (Throwable)ex, (boolean)true);
        }
    }

    public void closePDF() {
        if (!this.disposed && this.opened) {
            this.whiteboardDocument.close();
        }
        this.disposed = true;
    }

    private byte[] encodePNG(Image i) {
        byte[] bytes = null;
        try {
            BufferedImage bi = ImageSupport.toBufferedImage((Image)i, (int)1);
            bytes = ImageSupport.encodeAsPNG((Image)bi);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"encodePNG", (Throwable)ex, (boolean)true);
        }
        return bytes;
    }

    public void writePdf(ScreenModel[] screens, int depthLimit, ProgressUpdate progress) {
        int i;
        int toolCount = 0;
        for (i = 0; i < screens.length; ++i) {
            toolCount += ScreenModel.toolCount((ScreenModel)screens[i]);
        }
        progress.setValue(0);
        progress.setMaximum(toolCount);
        for (i = 0; i < screens.length && this.continueOperation; ++i) {
            this.depthLimit = screens[i] instanceof ScreenRoot ? Integer.MAX_VALUE : 1;
            this.pushPdfScreen(screens[i].getScreenName(), screens[i], 1, progress);
        }
    }

    private void pushPdfScreen(String title, ScreenModel screen, int depth, ProgressUpdate progress) {
        if (!screen.canSave() || depth > this.depthLimit || !this.continueOperation) {
            return;
        }
        String newTitle = "";
        this.setWBSize(screen.getScreenSize().width, screen.getScreenSize().height);
        if (!(screen instanceof ScreenRoot)) {
            progress.setFilename(title);
            PDFWriterGraphics.processToolToImage(this, title, screen.iterateTools(), screen.getScreenSize().width, screen.getScreenSize().height, progress);
            newTitle = title + " || ";
        }
        if (depth < this.depthLimit && this.continueOperation) {
            for (int i = 0; i < screen.getChildCount() && this.continueOperation; ++i) {
                ScreenModel child = (ScreenModel)screen.getChildAt(i);
                this.pushPdfScreen(newTitle + child.getScreenName(), child, depth + 1, progress);
            }
        }
    }

    public void endOperation() {
        this.continueOperation = false;
    }
}

