/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.navigation;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.module.navigation.NullParentACLList;
import com.elluminate.util.log.LogSupport;

public class NavigationEnabledClerk {
    private WhiteboardContext context;
    private boolean enableNavArrows = true;
    private boolean enabled = true;
    private boolean navEnabled = true;
    private boolean isBreakoutRoom = false;
    private ACLTerm navigableACL = null;
    private boolean whiteboardAccessible = false;

    public NavigationEnabledClerk(WhiteboardContext context) {
        this.context = context;
        this.establishACLs();
    }

    public void enableNavigation(boolean navEnabled) {
        this.navEnabled = navEnabled;
        this.validateNavigable();
    }

    private void establishACLs() {
        this.navigableACL = new ACLTerm("Navigable", new NullParentACLList(), this.context, false){

            public void notifyACLChange(Boolean state) {
                NavigationEnabledClerk.this.validateNavigable();
            }
        };
        this.navigableACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE));
        this.navigableACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.NULL_GROUP, null, ACLEntry.ALL_ROLES));
        this.navigableACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.CURRENT_GROUP, null, ACLEntry.ALL_ROLES));
        this.navigableACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.GROUP_CREATOR_ROLE));
        this.navigableACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE));
        this.navigableACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.OFFLINE_ROLE));
    }

    private void validateNavigable() {
        try {
            if (this.navigableACL != null) {
                this.enableNavArrows = this.navigableACL.allows() && this.enabled && this.navEnabled;
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    public boolean isNavArrowsEnabled() {
        return this.enableNavArrows && this.enabled;
    }

    public void setWhiteboardAcessible(boolean b) {
        this.whiteboardAccessible = b;
    }

    public boolean isWhiteboardAcessible() {
        return this.whiteboardAccessible;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isBreakoutRoom() {
        return this.isBreakoutRoom;
    }

    public void setBreakoutRoom(boolean breakoutRoom) {
        this.isBreakoutRoom = breakoutRoom;
    }
}

