/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public abstract class WBImageUtils {
    public static final boolean SUPPORT_ANIMATION = true;

    private WBImageUtils() {
    }

    public static int pixelDistance2(int pixel1, int pixel2) {
        int dRed = (pixel1 >> 16 & 0xFF) - (pixel2 >> 16 & 0xFF);
        int dGrn = (pixel1 >> 8 & 0xFF) - (pixel2 >> 8 & 0xFF);
        int dBlu = (pixel1 & 0xFF) - (pixel2 & 0xFF);
        return dRed * dRed + dGrn * dGrn + dBlu * dBlu;
    }

    public static Image clipImage(int[] foreground, int[] background, Rectangle area, boolean[] opaque) {
        boolean isOpaque = true;
        area.setLocation(0, 0);
        Dimension dim = new Dimension(area.width, area.height);
        WBImageUtils.boundArea(background, foreground, dim, area);
        if (area.width == 0 || area.height == 0) {
            return null;
        }
        BufferedImage resultImage = new BufferedImage(area.width, area.height, 2);
        int[] outputRow = new int[area.width];
        for (int y = 0; y < area.height; ++y) {
            for (int x = 0; x < area.width; ++x) {
                int alphaValue;
                int srcIndex = (y + area.y) * dim.width + (x + area.x);
                int pixel = 0;
                if (WBImageUtils.pixelDistance2(background[srcIndex], foreground[srcIndex]) > 9) {
                    alphaValue = 255;
                    pixel = foreground[srcIndex];
                } else {
                    alphaValue = 0;
                    isOpaque = false;
                }
                outputRow[x] = pixel & 0xFFFFFF | alphaValue << 24;
            }
            resultImage.setRGB(0, y, area.width, 1, outputRow, 0, area.width);
        }
        if (opaque != null && opaque.length > 0) {
            opaque[0] = isOpaque;
        }
        return resultImage;
    }

    public static Image clipImage(int[] imageData, Rectangle area) {
        Dimension dim = new Dimension(area.width, area.height);
        WBImageUtils.findOccupiedArea(imageData, dim, area);
        if (area.width == 0 || area.height == 0) {
            return null;
        }
        BufferedImage resultImage = new BufferedImage(area.width, area.height, 2);
        int[] outputRow = new int[area.width];
        for (int y = 0; y < area.height; ++y) {
            for (int x = 0; x < area.width; ++x) {
                int srcIndex = (y + area.y) * dim.width + (x + area.x);
                outputRow[x] = imageData[srcIndex];
            }
            resultImage.setRGB(0, y, area.width, 1, outputRow, 0, area.width);
        }
        return resultImage;
    }

    public static void boundArea(int[] background, int[] foreground, Dimension dim, Rectangle area) {
        int y;
        int index;
        int x;
        block0: while (area.y < area.height) {
            for (x = 0; x < dim.width; ++x) {
                index = area.y * dim.width + x;
                if (WBImageUtils.pixelDistance2(background[index], foreground[index]) > 9) break block0;
            }
            ++area.y;
        }
        block2: while (area.height > area.y) {
            for (x = 0; x < dim.width; ++x) {
                index = (area.height - 1) * dim.width + x;
                if (WBImageUtils.pixelDistance2(background[index], foreground[index]) > 9) break block2;
            }
            --area.height;
        }
        block4: while (area.x < dim.width) {
            for (y = area.y; y < area.height; ++y) {
                index = y * dim.width + area.x;
                if (WBImageUtils.pixelDistance2(background[index], foreground[index]) > 9) break block4;
            }
            ++area.x;
        }
        block6: while (area.width > area.x) {
            for (y = area.y; y < area.height; ++y) {
                index = y * dim.width + (area.width - 1);
                if (WBImageUtils.pixelDistance2(background[index], foreground[index]) > 9) break block6;
            }
            --area.width;
        }
        area.height -= area.y;
        area.width -= area.x;
    }

    public static void findOccupiedArea(int[] imageBytes, Dimension dim, Rectangle area) {
        int y;
        int index;
        int x;
        block0: while (area.y < area.height) {
            for (x = 0; x < dim.width; ++x) {
                index = area.y * dim.width + x;
                if ((imageBytes[index] & 0xFF000000) != 0) break block0;
            }
            ++area.y;
        }
        block2: while (area.height > area.y) {
            for (x = 0; x < dim.width; ++x) {
                index = (area.height - 1) * dim.width + x;
                if ((imageBytes[index] & 0xFF000000) != 0) break block2;
            }
            --area.height;
        }
        block4: while (area.x < dim.width) {
            for (y = area.y; y < area.height; ++y) {
                index = y * dim.width + area.x;
                if ((imageBytes[index] & 0xFF000000) != 0) break block4;
            }
            ++area.x;
        }
        block6: while (area.width > area.x) {
            for (y = area.y; y < area.height; ++y) {
                index = y * dim.width + (area.width - 1);
                if ((imageBytes[index] & 0xFF000000) != 0) break block6;
            }
            --area.width;
        }
        area.height -= area.y;
        area.width -= area.x;
    }
}

