/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import java.io.File;

public class PalettesFileListEntry
implements Comparable {
    private String path;
    private String url;
    private String name;

    public PalettesFileListEntry(String path, String url) {
        this.setPath(path);
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        try {
            File f = new File(path);
            this.name = f.getName();
            int pos = this.name.lastIndexOf(46);
            if (pos != -1) {
                this.name = this.name.substring(0, pos);
            }
            this.path = f.getCanonicalPath();
        }
        catch (Exception e) {
            this.path = path;
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public int compareTo(Object other) {
        if (other instanceof String) {
            String otherPath;
            try {
                otherPath = new File((String)other).getCanonicalPath();
            }
            catch (Exception e) {
                otherPath = (String)other;
            }
            return this.path.compareTo(otherPath);
        }
        return this.path.compareTo(((PalettesFileListEntry)other).getPath());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return this.path == null;
        }
        if (other instanceof PalettesFileListEntry) {
            PalettesFileListEntry entry = (PalettesFileListEntry)other;
            if (entry.path == this.path) {
                return true;
            }
            if (entry.path == null) {
                return false;
            }
            return entry.path.equals(this.path);
        }
        if (other instanceof String) {
            if (this.path == null) {
                return false;
            }
            return this.path.equals((String)other);
        }
        return false;
    }

    public int hashCode() {
        if (this.path == null) {
            return 0;
        }
        return this.path.hashCode();
    }

    public String toString() {
        return "File: " + this.path + ", URL: " + this.url;
    }
}

