/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.module.imageloading.AddResult;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.PalettesFileListEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringComparator;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.io.IOUtilities;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Palettes
implements Cloneable {
    private static I18n i18n = I18n.create(Palettes.class);
    private static boolean PROCESS_FILES_IN_FOLDER = false;
    public static final long MAX_CLIPART_FILE_SIZE = 0x100000L;
    public static final String PALETTE_PACKAGE_NAME = "com.elluminate.util.imageLoading.palette";
    private Map<String, PaletteEntry> packages = new TreeMap<String, PaletteEntry>((Comparator<String>)new StringComparator());
    private List<PalettesFileListEntry> fileList = new ArrayList<PalettesFileListEntry>();
    private String packageURL = "";
    private Component hostComponent = null;
    private Set<String> disabledTabs = new HashSet<String>();

    public Palettes(String packageURL, List<PalettesFileListEntry> paths, boolean editable, Component hostComponent, String addedPalettesKey, Preferences preferences) {
        this.packageURL = packageURL;
        this.hostComponent = hostComponent;
        paths = this.updatePaths(paths);
        this.loadPreferences(addedPalettesKey, preferences);
        for (PalettesFileListEntry entry : paths) {
            String fileUrl;
            block9: {
                fileUrl = entry.getPath();
                if (UtilDebug.PALETTE_LOAD.show()) {
                    LogSupport.message((Object)this, (String)"<init>", (String)("processing list entry: " + fileUrl));
                }
                try {
                    URL url = new URL(entry.getURL());
                    if (url.getProtocol().equalsIgnoreCase("http")) {
                        fileUrl = this.copyToLocal(fileUrl, url);
                        break block9;
                    }
                    if (url.getProtocol().equalsIgnoreCase("file")) {
                        fileUrl = url.getFile();
                        break block9;
                    }
                    LogSupport.error((String)("Unknown protocol: " + url.getProtocol() + " for palette specification: " + fileUrl));
                    break;
                }
                catch (MalformedURLException mue) {
                    if (UtilDebug.PALETTE_LOAD.show()) {
                        LogSupport.message((Object)this, (String)"<init>", (String)mue.toString());
                    }
                }
                catch (IOException ioe) {
                    LogSupport.exception((Object)this, (String)"Palettes", (Throwable)ioe, (boolean)true);
                    return;
                }
            }
            File classPathEntry = new File(fileUrl);
            if (classPathEntry.isFile()) {
                this.processFile(classPathEntry, entry.getURL(), packageURL, editable);
                continue;
            }
            if (!classPathEntry.isDirectory()) continue;
            this.processFolder(classPathEntry, entry.getURL(), packageURL, editable);
        }
    }

    protected String copyToLocal(String sUrl, URL url) throws IOException {
        File outFile = File.createTempFile("palettes", ".jar");
        outFile.deleteOnExit();
        try {
            sUrl = outFile.getCanonicalPath();
        }
        catch (Exception e) {
            sUrl = outFile.getPath();
        }
        IOUtilities.copyStream((InputStream)url.openStream(), (OutputStream)new FileOutputStream(sUrl));
        return sUrl;
    }

    private List<PalettesFileListEntry> updatePaths(List<PalettesFileListEntry> urlList) {
        ArrayList<PalettesFileListEntry> paths;
        ArrayList<PalettesFileListEntry> arrayList = paths = urlList == null ? new ArrayList<PalettesFileListEntry>() : new ArrayList<PalettesFileListEntry>(urlList);
        if (paths.isEmpty()) {
            String[] tokens;
            try {
                Enumeration<URL> e = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (e.hasMoreElements()) {
                    String jarURL;
                    int idx;
                    URL url = e.nextElement();
                    String manifestPath = url.getFile();
                    if (UtilDebug.PALETTE_LOAD.show()) {
                        LogSupport.message(Palettes.class, (String)"palettesFactory", (String)("Scanning " + url.getFile()));
                    }
                    if ((idx = manifestPath.lastIndexOf("!")) <= 0 || (jarURL = manifestPath.substring(0, idx)).indexOf("-palette") <= 0) continue;
                    jarURL = jarURL.replaceAll("https", "http");
                    jarURL = jarURL.replaceAll("jar.pack.gz", "jar");
                    String jarPath = jarURL.replaceAll(":", "");
                    if (UtilDebug.PALETTE_LOAD.show()) {
                        LogSupport.message(Palettes.class, (String)"palettesFactory", (String)("Jar URL: " + jarURL));
                        LogSupport.message(Palettes.class, (String)"palettesFactory", (String)("Jar Path: " + jarPath));
                    }
                    paths.add(new PalettesFileListEntry(jarPath, jarURL));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (String token : tokens = System.getProperty("java.class.path").split(File.pathSeparator)) {
                if (UtilDebug.PALETTE_LOAD.show()) {
                    LogSupport.message(Palettes.class, (String)"palettesFactory", (String)("creating list entry from classpath: " + token));
                }
                paths.add(new PalettesFileListEntry(token, token));
            }
        }
        return paths;
    }

    public String getPackageURL() {
        return this.packageURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFile(File file, String fileURL, String packageURL, boolean editable) {
        boolean imageAdded = false;
        ArrayList<ZipEntry> entries = null;
        HashMap<String, String> packageMap = new HashMap<String, String>();
        PalettesFileListEntry palettesFileInfo = null;
        if (UtilDebug.PALETTE_LOAD.show()) {
            LogSupport.message((Object)this, (String)"processFile", (String)("processing file: " + file));
        }
        if (file == null) {
            return false;
        }
        palettesFileInfo = new PalettesFileListEntry(file.getAbsolutePath(), fileURL);
        String extension = FileSysUtils.getExtension((File)file).toLowerCase(Locale.ENGLISH);
        if (extension != null && (extension.equals("zip") || extension.equals("jar"))) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
            }
            catch (ZipException ex) {
                return false;
            }
            catch (IOException ex) {
                Logger.getLogger(Palettes.class.getName()).log(Level.WARNING, null, ex);
            }
            try {
                entries = new ArrayList<ZipEntry>();
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    String entryName;
                    ZipEntry zipEntry = zipEntries.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    int cutIndex = zipEntry.getName().lastIndexOf(47);
                    if (cutIndex < 0) break;
                    String packageName = zipEntry.getName().replace('/', '.').substring(0, cutIndex);
                    if (!packageName.startsWith(packageURL)) continue;
                    if (this.isFileTooBig(file)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (UtilDebug.PALETTE_LOAD.show()) {
                        LogSupport.message((Object)this, (String)"processFile", (String)("processing entry: " + file + "::" + zipEntry.getName() + " as " + packageName));
                    }
                    if ((entryName = zipEntry.getName().substring(cutIndex + 1)).endsWith(".properties")) {
                        Properties props = this.loadPropertiesFromFile(zipFile.getInputStream(zipEntry));
                        if (props == null) {
                            LogSupport.message((Object)this, (String)"processFile", (String)("Failed to get palette property data: " + file + ":" + zipEntry.getName()));
                            continue;
                        }
                        PaletteEntry paletteEntry = this.loadPaletteEntry(packageName, props, packageMap, this.determineLocaleFromFilename(entryName));
                        paletteEntry.setEditable(editable);
                        if (this.disabledTabs.contains(paletteEntry.getPackageName())) {
                            paletteEntry.setVisible(false);
                        }
                        if (!editable || this.fileList.contains(palettesFileInfo)) continue;
                        this.fileList.add(palettesFileInfo);
                        continue;
                    }
                    entries.add(zipEntry);
                }
                imageAdded = this.processPaletteEntries(file, entries, packageMap, palettesFileInfo, zipFile);
                zipFile.close();
            }
            catch (IOException ioe) {
                LogSupport.exception((Object)this, (String)"processFile", (Throwable)ioe, (boolean)true, (String)("Processing file " + file));
            }
            finally {
                if (UtilDebug.PALETTE_LOAD.show()) {
                    LogSupport.message((Object)this, (String)"processFile", (String)("Finished with zip file " + file));
                }
            }
        }
        return imageAdded;
    }

    protected PaletteEntry loadPaletteEntry(String packageName, Properties props, Map<String, String> packageMap, Locale locale) {
        PaletteEntry entry = null;
        String originalTitle = null;
        if (packageMap.containsKey(packageName)) {
            originalTitle = packageMap.get(packageName);
            entry = this.packages.get(originalTitle);
        } else {
            entry = new PaletteEntry(packageName);
            originalTitle = packageName;
        }
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            entry.addBaseProperties(props);
        } else {
            entry.addProperties(locale, props);
        }
        String name = entry.getLocalizedPaletteTitle(packageName);
        String stdPriority = entry.getLocalizedPaletteSortPriority("0");
        int priority = Integer.parseInt(stdPriority);
        if (priority > 0) {
            for (int i = 0; i < priority; ++i) {
                name = "\u0000" + name;
            }
        } else {
            name = "\uffff" + name;
        }
        packageMap.put(packageName, name);
        this.packages.remove(originalTitle);
        this.packages.put(name, entry);
        return entry;
    }

    private boolean isPropertyBase(String filename) {
        return filename.equalsIgnoreCase("palette.properties");
    }

    private boolean isFileTooBig(File file) {
        if (file.length() > 0x100000L) {
            ModalDialog.showMessageDialog((Component)this.hostComponent, (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_ADDIMAGEEXCEEDS, new Object[]{file.getAbsolutePath(), new Long(file.length()), new Long(0x100000L)}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_ADDIMAGEEXCEEDSTITLE), (int)0);
            return true;
        }
        return false;
    }

    private Properties loadPropertiesFromFile(InputStream is) {
        if (is == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            properties.load(bis);
            bis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    protected Locale determineLocaleFromFilename(String filename) {
        int LANGUAGE = 1;
        int COUNTRY = 2;
        filename = filename.replace("palette", "");
        String[] details = (filename = filename.replace(".properties", "")).split("_");
        if (details.length == 2) {
            return new Locale(details[LANGUAGE]);
        }
        if (details.length > 2) {
            return new Locale(details[LANGUAGE], details[COUNTRY]);
        }
        return Locale.ENGLISH;
    }

    private boolean processPaletteEntries(File file, List<ZipEntry> entries, Map<String, String> packageMap, PalettesFileListEntry entry, ZipFile zipFile) throws IOException {
        boolean imageAdded = false;
        for (ZipEntry zipEntry : entries) {
            int cutIndex;
            if (UtilDebug.PALETTE_LOAD.show()) {
                LogSupport.message((Object)this, (String)"processPaletteEntries", (String)("Processing list entry: " + zipEntry.getName()));
            }
            if ((cutIndex = zipEntry.getName().lastIndexOf(47)) < 0) break;
            String packageName = zipEntry.getName().replace('/', '.').substring(0, cutIndex);
            String entryName = zipEntry.getName().substring(cutIndex + 1);
            PaletteEntry paletteEntry = this.packages.get(packageMap.get(packageName));
            if (paletteEntry != null) {
                ImageData data;
                if (UtilDebug.PALETTE_LOAD.show()) {
                    LogSupport.message((Object)this, (String)"processPaletteEntries", (String)("  get image data for: " + zipEntry.getName()));
                }
                if ((data = this.generateImageData(file.getPath(), entry.getURL(), zipFile.getInputStream(zipEntry), zipEntry.getSize(), entryName)) == null) {
                    LogSupport.message((Object)this, (String)"processPaletteEntries", (String)("Failed to get palette image data: " + file + ":" + zipEntry.getName()));
                } else if (data.hasImage()) {
                    AddResult addResult;
                    if (UtilDebug.PALETTE_LOAD.show()) {
                        LogSupport.message((Object)this, (String)"processPaletteEntries", (String)("adding " + zipEntry.getName() + " to palette " + packageName));
                    }
                    if ((addResult = paletteEntry.addImage(data)).isErrorOccurred()) {
                        ModalDialog.showConfirmDialog((Component)this.hostComponent, (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_ADDIMAGEEXCEEDS, new Object[]{data.getPathname(), new Long(data.getImageBytes().length), new Long(0x100000L)}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_ADDIMAGEEXCEEDSTITLE), (int)2);
                    }
                    if (addResult.isStop()) {
                        return imageAdded |= addResult.isAdded();
                    }
                    imageAdded |= addResult.isAdded();
                }
            }
            if (!UtilDebug.PALETTE_LOAD.show()) continue;
            LogSupport.message((Object)this, (String)"processPaletteEntries", (String)("  finished with entry " + zipEntry.getName()));
        }
        return imageAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData generateImageData(String path, String url, InputStream is, long size, String entryName) throws IOException {
        if (is == null) {
            return null;
        }
        ImageData data = null;
        int nread = 0;
        int total = 0;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            byte[] bytes = new byte[(int)size];
            do {
                if ((nread = bis.read(bytes, total, bytes.length - total)) > 0) {
                    total += nread;
                }
                if (!UtilDebug.PALETTE_LOAD.show()) continue;
                System.out.println("Palettes, entry: " + entryName + ", bytes: " + bytes.length + ", nread: " + nread + ", total: " + total);
            } while (nread > 0);
            if (UtilDebug.PALETTE_LOAD.show()) {
                LogSupport.message((Object)this, (String)"processFile", (String)("  read " + nread + " / " + bytes.length + " bytes"));
            }
            data = new ImageData(bytes, entryName, path, url, null);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {}
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFolder(File folder, String fileURL, String packageURL, boolean editable) {
        File packageFolder;
        File file;
        String[] entries;
        InputStream is = null;
        Properties properties = null;
        if (UtilDebug.PALETTE_LOAD.show()) {
            LogSupport.message((Object)this, (String)"processFolder", (String)("Processing " + folder));
        }
        if (PROCESS_FILES_IN_FOLDER && (entries = folder.list()) != null) {
            for (int i = 0; i < entries.length; ++i) {
                file = new File(folder, entries[i]);
                if (!file.isFile()) continue;
                this.processFile(file, fileURL, packageURL, editable);
            }
        }
        if ((packageFolder = new File(folder, packageURL.replace('.', File.separatorChar))) != null && packageFolder.isDirectory()) {
            if (UtilDebug.PALETTE_LOAD.show()) {
                LogSupport.message((Object)this, (String)"processFolder", (String)("Scanning pkg folder " + packageFolder));
            }
            String[] palettes = packageFolder.list();
            for (int i = 0; i < palettes.length; ++i) {
                File palette = new File(packageFolder, palettes[i]);
                String packageName = packageURL + "." + palettes[i];
                PaletteEntry paletteEntry = this.packages.get(packageName);
                if (paletteEntry == null) {
                    try {
                        String path = "." + packageName + ".";
                        path = folder + path.replace('.', File.separatorChar) + "Palette.properties";
                        is = new FileInputStream(path);
                        properties = new Properties();
                        properties.load(is);
                        if (UtilDebug.PALETTE_LOAD.show()) {
                            LogSupport.message((Object)this, (String)"processFolder", (String)("Read properties file " + path + ": " + properties));
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        break;
                    }
                    catch (IOException ioe) {
                        break;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                    paletteEntry = new PaletteEntry(packageName);
                    paletteEntry.addProperties(properties);
                    paletteEntry.setEditable(editable);
                    if (this.disabledTabs.contains(paletteEntry.getPackageName())) {
                        paletteEntry.setVisible(false);
                    }
                    this.packages.put(packageName, paletteEntry);
                }
                entries = palette.list();
                for (int j = 0; j < entries.length; ++j) {
                    file = new File(palette, entries[j]);
                    if (UtilDebug.PALETTE_LOAD.show()) {
                        LogSupport.message((Object)this, (String)"processFolder", (String)("Getting image data " + file));
                    }
                    try {
                        AddResult addResult;
                        is = new FileInputStream(file);
                        byte[] bytes = new byte[is.available()];
                        is.read(bytes);
                        ImageData data = new ImageData(bytes, entries[j], file.getPath(), fileURL, null);
                        if (!data.hasImage()) continue;
                        if (UtilDebug.PALETTE_LOAD.show()) {
                            LogSupport.message((Object)this, (String)"processFolder", (String)("adding image to palette " + paletteEntry.getLocalizedPaletteTitle()));
                        }
                        if ((addResult = paletteEntry.addImage(data)).isErrorOccurred()) {
                            ModalDialog.showConfirmDialog((Component)this.hostComponent, (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_ADDIMAGEEXCEEDS, new Object[]{data.getPathname(), new Long(data.getImageBytes().length), new Long(0x100000L)}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEENTRY_ADDIMAGEEXCEEDSTITLE), (int)2);
                        }
                        if (!addResult.isStop()) continue;
                        return;
                    }
                    catch (Throwable e) {
                        LogSupport.exception((Object)this, (String)"processFolder", (Throwable)e, (boolean)true, (String)("processing folder " + folder));
                    }
                }
            }
        }
    }

    public Iterator paletteEntryIterator() {
        return this.packages.values().iterator();
    }

    public Iterator fileIterator() {
        return this.fileList.iterator();
    }

    public List getFileArrayList() {
        return this.fileList;
    }

    public void mergePalette(Component component, Palettes sourcePalette) {
        Iterator iter = sourcePalette.paletteEntryIterator();
        while (iter.hasNext()) {
            PaletteEntry paletteEntry = (PaletteEntry)iter.next();
            if (this.packages.containsKey(paletteEntry.getPackageName())) continue;
            this.packages.put(paletteEntry.getPackageName(), paletteEntry);
        }
        iter = sourcePalette.fileIterator();
        while (iter.hasNext()) {
            PalettesFileListEntry fileListEntry = (PalettesFileListEntry)iter.next();
            if (this.fileList.contains(fileListEntry)) continue;
            this.fileList.add(fileListEntry);
        }
    }

    public void removePaletteEntry(PaletteEntry paletteEntry) {
        this.packages.remove(paletteEntry.getPackageName());
    }

    public void removeFile(String path) {
        Iterator<PalettesFileListEntry> iter = this.paletteEntryIterator();
        while (iter.hasNext()) {
            PaletteEntry paletteEntry = (PaletteEntry)iter.next();
            Iterator imageDataIterator = paletteEntry.imageDataIterator();
            while (imageDataIterator.hasNext()) {
                String sourcePath = ((ImageData)imageDataIterator.next()).getSourceFile();
                if (!path.equals(sourcePath)) continue;
                imageDataIterator.remove();
            }
            if (!paletteEntry.isEmpty()) continue;
            iter.remove();
        }
        iter = this.fileList.iterator();
        while (iter.hasNext()) {
            PalettesFileListEntry fileListEntry = iter.next();
            if (!fileListEntry.getPath().equals(path)) continue;
            iter.remove();
        }
    }

    public boolean loadPaletteFile(File paletteFile, boolean editable) {
        return this.processFile(paletteFile, paletteFile.getAbsolutePath(), this.getPackageURL(), editable);
    }

    public Object clone() throws CloneNotSupportedException {
        Palettes newPalettes = (Palettes)super.clone();
        newPalettes.packages = new TreeMap<String, PaletteEntry>((Comparator<String>)new StringComparator());
        newPalettes.fileList = new ArrayList<PalettesFileListEntry>();
        Iterator iter = this.paletteEntryIterator();
        while (iter.hasNext()) {
            PaletteEntry paletteEntry = (PaletteEntry)iter.next();
            newPalettes.packages.put(paletteEntry.getPackageName(), (PaletteEntry)paletteEntry.clone());
        }
        iter = this.fileIterator();
        while (iter.hasNext()) {
            newPalettes.fileList.add((PalettesFileListEntry)iter.next());
        }
        newPalettes.packageURL = this.packageURL;
        return newPalettes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreferences(String prefix, Preferences preferences) {
        Map propertyMap;
        if (preferences == null) {
            return;
        }
        String propertyNameKey = prefix + ".disableTab";
        Map map = propertyMap = preferences.getSettings(propertyNameKey);
        synchronized (map) {
            for (String property : propertyMap.keySet()) {
                this.disabledTabs.add((String)propertyMap.get(property));
            }
        }
    }

    public void savePreferences(String prefix, Preferences preferences) {
        preferences.clearSettings(prefix);
        StringBuffer arguments = new StringBuffer();
        Iterator iter = this.fileList.iterator();
        while (iter.hasNext()) {
            PalettesFileListEntry entry = iter.next();
            arguments.append(entry.getPath());
            if (!iter.hasNext()) continue;
            arguments.append(File.pathSeparator);
        }
        preferences.setSetting(prefix, arguments.toString());
        iter = this.paletteEntryIterator();
        int disableCount = 0;
        while (iter.hasNext()) {
            PaletteEntry paletteEntry = (PaletteEntry)iter.next();
            if (paletteEntry.isVisible()) continue;
            String paletteName = prefix + ".disableTab." + disableCount++;
            preferences.setSetting(paletteName, paletteEntry.getPackageName());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Palettes: packageURL" + this.packageURL);
        buf.append("\nPalettes: FileList: ");
        Iterator<Object> iter = this.fileList.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("Pakettes: packages: ");
        for (Map.Entry entry : this.packages.entrySet()) {
            buf.append("\n  package: " + (String)entry.getKey() + ", " + entry.getValue());
        }
        return buf.toString();
    }

    public boolean canShow(PaletteEntry entry, boolean isChair) {
        if (entry.getLocalizedType() == WBImage.PaletteType.BACKGROUND) {
            return entry.isVisible() && isChair;
        }
        return entry.isVisible();
    }
}

