/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteBuilderPane;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteFileFilter;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteModificationListener;
import com.elluminate.groupware.whiteboard.module.imageloading.Palettes;
import com.elluminate.groupware.whiteboard.module.imageloading.PalettesFileListEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.PropertyTableEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.PropertyTableModel;
import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CTabbedPane;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PaletteBuilderDialog
extends EasyDialog
implements ChangeListener,
PaletteModificationListener {
    private static String MANIFEST_HEADER = "Manifest-Version: 1.0\r\nCreated-By: vClass 4 (Elluminate.com)\r\n";
    private static File defaultDirectory = null;
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static String closeButtonText = i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_CLOSEBUTTONTEXT);
    private static String closeButtonToolTip = i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_CLOSEBUTTONTOOLTIP);
    private static String cancelButtonText = i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_CANCELBUTTONTEXT);
    private static String cancelButtonToolTip = i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_CANCELBUTTONTOOLTIP);
    private JPanel northPanel = new JPanel();
    private JToolBar toolBar = new JToolBar();
    private JButton newButton = new CToolBarButton();
    private JButton loadButton = new CToolBarButton();
    private JButton addButton = new CToolBarButton();
    private JButton saveButton = new CToolBarButton();
    private JButton saveAsButton = new CToolBarButton();
    private JButton deleteButton = new CToolBarButton();
    private JPanel browsePanel = new JPanel();
    private JLabel filePathLabel = new JLabel();
    private JLabel filePath = new JLabel();
    private JPanel centerPanel = new JPanel();
    private JLabel noPaletteslabel = new JLabel();
    private JTabbedPane palettesTabbedPane = new CTabbedPane();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private boolean modifiedData = false;
    private boolean dups = false;
    boolean blankTitle = true;
    private boolean listEntrySelected = false;
    private String savedFilePath = null;
    private JProgressBar progressIndicator = new JProgressBar();

    public PaletteBuilderDialog(Frame frame, String title, boolean modal) {
        super((Component)frame, title, modal);
        this.setResizable(true);
        this.setInsets(null);
        this.getRootPane().putClientProperty("Window.style", "small");
        try {
            this.jbInit();
            this.pack();
            int height = 400;
            int width = (int)((double)height * 1.61803398875);
            this.setSize(width, height);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"PaletteBuilderDialog", (Throwable)ex, (boolean)true);
        }
    }

    public PaletteBuilderDialog(Frame frame, String title, boolean modal, Palettes palettes) {
        this(frame, title, modal);
        this.buildPalettePanes(palettes);
    }

    public PaletteBuilderDialog(Frame frame, String title, boolean modal, String path, String addedPalettesKey) {
        this(frame, title, modal);
        LinkedList<PalettesFileListEntry> urls = new LinkedList<PalettesFileListEntry>();
        urls.add(new PalettesFileListEntry(path, path));
        Palettes palettes = new Palettes("com.elluminate.util.imageLoading.palette", urls, true, (Component)((Object)this), addedPalettesKey, null);
        this.buildPalettePanes(palettes);
        this.filePath.setText(path);
        defaultDirectory = new File(path);
    }

    public PaletteBuilderDialog() {
        this(null, "", true);
    }

    private void jbInit() throws Exception {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.northPanel, "North");
        contentPane.add((Component)this.centerPanel, "Center");
        this.northPanel.setLayout(new BorderLayout());
        this.northPanel.add((Component)this.toolBar, "North");
        this.northPanel.add((Component)this.browsePanel, "South");
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY), this.toolBar.getBorder()));
        this.toolBar.add(this.newButton);
        this.toolBar.add(this.loadButton);
        this.toolBar.add(this.saveButton);
        this.toolBar.add(this.saveAsButton);
        this.toolBar.add(this.deleteButton);
        JToolBar.Separator sep = new JToolBar.Separator();
        sep.setOrientation(1);
        this.toolBar.add(sep);
        this.toolBar.add(this.addButton);
        this.toolBar.add(Box.createHorizontalGlue());
        Insets ins = PaletteBuilderDialog.getStandardInsets();
        this.browsePanel.setLayout(new GridBagLayout());
        this.browsePanel.setBorder(BorderFactory.createEmptyBorder(6, ins.left, 0, ins.right));
        this.browsePanel.add((Component)this.filePathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.browsePanel.add((Component)this.filePath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.centerPanel.setLayout(new GridBagLayout());
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(6, ins.left, 0, ins.right));
        this.centerPanel.add((Component)this.noPaletteslabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.palettesTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.progressIndicator.setVisible(false);
        this.filePathLabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_FILEPATHLABEL));
        this.noPaletteslabel.setText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_NOPALETTES));
        this.noPaletteslabel.setHorizontalAlignment(0);
        this.noPaletteslabel.setVerticalAlignment(0);
        this.initButton(this.newButton, "newButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderDialog.this.createButton_actionPerformed(e);
            }
        });
        this.initButton(this.loadButton, "loadButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderDialog.this.loadButton_actionPerformed(e);
            }
        });
        this.initButton(this.addButton, "addButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderDialog.this.addButton_actionPerformed(e);
            }
        });
        this.initButton(this.saveButton, "saveButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderDialog.this.saveButton_actionPerformed(e);
            }
        });
        this.initButton(this.saveAsButton, "saveAsButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderDialog.this.saveAsButton_actionPerformed(e);
            }
        });
        this.initButton(this.deleteButton, "deleteButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderDialog.this.removePaletteButton_actionPerformed(e);
            }
        });
        this.initButton(this.okButton, "okButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderDialog.this.okButton_actionPerformed(e);
            }
        });
        this.initButton(this.cancelButton, "closeButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteBuilderDialog.this.closeDialog(false);
            }
        });
        this.palettesTabbedPane.addChangeListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PaletteBuilderDialog.this.closeDialog(false);
            }
        });
        this.filePath.setText("");
        this.setContent(contentPane);
        this.addActionButton(this.okButton, true);
        this.addCancelButton(this.cancelButton);
        this.addPassiveComponent(this.progressIndicator);
        this.enableButtons();
    }

    private void initButton(JButton button, String buttonName, ActionListener listener) {
        String buttonData = "PaletteBuilderDialog." + buttonName;
        try {
            button.setText(i18n.getStringLegacy(buttonData + "Text"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            button.setIcon(i18n.getIcon(buttonData + "Icon"));
        }
        catch (Exception ex1) {
            // empty catch block
        }
        try {
            button.setToolTipText(i18n.getStringLegacy(buttonData + "ToolTip"));
        }
        catch (Exception ex2) {
            // empty catch block
        }
        button.addActionListener(listener);
    }

    private void okButton_actionPerformed(ActionEvent e) {
        if (this.modifiedData) {
            if (!this.hasAllTitles()) {
                return;
            }
            this.enableButtons();
            if (!this.validateDups(true)) {
                return;
            }
            this.saveAsButton_actionPerformed(e);
            if (this.modifiedData) {
                return;
            }
        }
        this.closeDialog(true);
    }

    private void closeDialog(boolean save) {
        if (this.modifiedData && this.saveAsButton.isEnabled()) {
            int which = 0;
            if (!save) {
                which = ModalDialog.showConfirmDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_MODIFIEDDATA), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_MODIFIEDTITLE), (int)1);
            }
            switch (which) {
                case 2: {
                    return;
                }
                case 0: {
                    if (this.filePath.getText().equals("")) {
                        if (!this.hasAllTitles()) {
                            return;
                        }
                        this.enableButtons();
                        if (!this.validateDups(true)) {
                            return;
                        }
                        ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_NOSAVEPATH), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_NOSAVEPATHTITLE), (int)0);
                        return;
                    }
                    this.saveAs(new File(this.filePath.getText()));
                    break;
                }
            }
        }
        this.hide();
    }

    private void saveButton_actionPerformed(ActionEvent e) {
        this.saveAs(new File(this.filePath.getText()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAsButton_actionPerformed(ActionEvent e) {
        File fileToSave;
        block33: {
            block32: {
                FileOutputStream out;
                FileInputStream in;
                block31: {
                    byte[] buffer;
                    String suffix;
                    if (!this.hasAllTitles()) {
                        return;
                    }
                    this.enableButtons();
                    if (!this.validateDups(true)) {
                        return;
                    }
                    if (defaultDirectory == null) {
                        defaultDirectory = Platform.getDefaultDir();
                    }
                    CFileChooser chooser = new CFileChooser(defaultDirectory);
                    chooser.setDialogTitle(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_SAVETITLE));
                    chooser.resetChoosableFileFilters();
                    chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
                    chooser.addChoosableFileFilter(new PaletteFileFilter());
                    if (defaultDirectory != null && defaultDirectory.exists()) {
                        if (defaultDirectory.isFile()) {
                            chooser.setSelectedFile(defaultDirectory);
                            chooser.ensureFileIsVisible(defaultDirectory);
                        } else {
                            chooser.setCurrentDirectory(defaultDirectory);
                        }
                    }
                    if (chooser.showSaveDialog((Component)((Object)this)) != 0) return;
                    fileToSave = chooser.getSelectedFile();
                    String fileName = fileToSave.getAbsolutePath();
                    int cutIndex = fileName.lastIndexOf(46);
                    String string = suffix = cutIndex < 0 ? "" : fileName.substring(cutIndex + 1);
                    if (!suffix.equalsIgnoreCase("jar")) {
                        suffix = "jar";
                    } else {
                        fileName = fileName.substring(0, cutIndex);
                    }
                    fileToSave = new File(fileName + "." + suffix);
                    if (!fileToSave.exists()) break block33;
                    int which = ModalDialog.showConfirmDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_EXISTSMESSAGE), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_EXISTSTITLE), (int)1);
                    block6 : switch (which) {
                        case 2: {
                            return;
                        }
                        case 0: {
                            in = null;
                            out = null;
                            try {
                                for (int i = 0; i < 1000; ++i) {
                                    File renameFile = new File(fileName + "." + i + "." + suffix);
                                    if (renameFile.exists()) continue;
                                    out = new FileOutputStream(renameFile);
                                    in = new FileInputStream(fileToSave);
                                    buffer = new byte[Math.min(100000, in.available())];
                                    break block6;
                                }
                                break block31;
                            }
                            catch (Exception ex) {
                                try {
                                    LogSupport.exception((Object)this, (String)"saveAsButton_actionPerformed", (Throwable)ex, (boolean)true);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (in != null) {
                                            in.close();
                                        }
                                        if (out == null) throw throwable;
                                        out.close();
                                        throw throwable;
                                    }
                                    catch (Exception ex2) {
                                        LogSupport.exception((Object)this, (String)"saveAsButton_actionPerformed", (Throwable)ex2, (boolean)true);
                                    }
                                    throw throwable;
                                }
                                try {
                                    if (in != null) {
                                        in.close();
                                    }
                                    if (out != null) {
                                        out.close();
                                    }
                                    break block32;
                                }
                                catch (Exception ex3) {
                                    LogSupport.exception((Object)this, (String)"saveAsButton_actionPerformed", (Throwable)ex3, (boolean)true);
                                }
                                break block32;
                            }
                        }
                        default: {
                            break block32;
                        }
                    }
                    while (true) {
                        int bytesRead = 0;
                        try {
                            bytesRead = in.read(buffer);
                        }
                        catch (EOFException ex) {
                            break;
                        }
                        if (bytesRead < 0) break;
                        if (bytesRead <= 0) continue;
                        out.write(buffer, 0, bytesRead);
                    }
                    buffer = null;
                    out.close();
                    in.close();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"saveAsButton_actionPerformed", (Throwable)ex, (boolean)true);
                }
            }
            this.modifiedData = false;
        }
        this.saveAs(fileToSave);
    }

    private void loadButton_actionPerformed(ActionEvent e) {
        if (this.filePath.getText().equals("") || ModalDialog.showConfirmDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_WILLOVERWRITE, new Object[]{this.filePath.getText()}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_WILLOVERWRITETITLE), (int)2, (int)2) == 0) {
            this.filePath.setText("");
            this.palettesTabbedPane.removeAll();
            this.addButton_actionPerformed(e);
        }
    }

    private void addButton_actionPerformed(ActionEvent e) {
        if (defaultDirectory == null) {
            defaultDirectory = Platform.getDefaultDir();
        }
        CFileChooser chooser = new CFileChooser(defaultDirectory);
        chooser.setDialogTitle(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_LOADTITLE));
        chooser.resetChoosableFileFilters();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(new PaletteFileFilter());
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog((Component)((Object)this)) == 0) {
            File[] files = chooser.getSelectedFiles();
            if (files.length == 0) {
                files = new File[]{chooser.getSelectedFile()};
            }
            ArrayList<PalettesFileListEntry> urls = new ArrayList<PalettesFileListEntry>();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                urls.add(new PalettesFileListEntry(files[i].getAbsolutePath(), files[i].getAbsolutePath()));
                defaultDirectory = new File(files[i].getParent());
            }
            boolean noFiles = true;
            if (this.palettesTabbedPane.getTabCount() == 0 && urls.size() > 0) {
                this.modifiedData = false;
                if (files.length == 1) {
                    this.filePath.setText(urls.get(0).getPath());
                }
            }
            if (urls.size() > 0) {
                Palettes palettes = new Palettes("com.elluminate.util.imageLoading.palette", urls, true, (Component)((Object)this), "", null);
                this.buildPalettePanes(palettes);
                boolean bl = noFiles = this.palettesTabbedPane.getTabCount() == 0;
            }
            if (noFiles) {
                ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_NOFILESADDED), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_NOFILESADDEDTITLE), (int)1);
            } else {
                this.paletteChanged();
            }
        }
        this.validateDups(true);
    }

    private void buildPalettePanes(Palettes palettes) {
        Iterator iter = palettes.paletteEntryIterator();
        while (iter.hasNext()) {
            PaletteEntry palette = (PaletteEntry)iter.next();
            PaletteBuilderPane pane = new PaletteBuilderPane(palette, this);
            pane.setBorder(BorderFactory.createEmptyBorder(6, 10, 10, 10));
            this.palettesTabbedPane.add(pane.getTitle(), pane);
            this.titleChanged(pane.getTitle(), pane);
        }
        this.modifiedData = false;
        this.enableButtons();
    }

    public void titleChanged(String title, PaletteBuilderPane pane) {
        int tabIndex = this.palettesTabbedPane.indexOfComponent(pane);
        if (tabIndex >= 0 && !this.palettesTabbedPane.getTitleAt(tabIndex).equals(title)) {
            this.palettesTabbedPane.setTitleAt(tabIndex, title);
        }
    }

    private void removePaletteButton_actionPerformed(ActionEvent e) {
        int tabIndex = this.palettesTabbedPane.getSelectedIndex();
        if (tabIndex >= 0 && ModalDialog.showConfirmDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_CONFIRM, new Object[]{this.palettesTabbedPane.getTitleAt(tabIndex)}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_CONFIRMTITLE), (int)2) == 0) {
            this.palettesTabbedPane.removeTabAt(tabIndex);
            this.paletteChanged();
        }
        this.validateDups(false);
        this.enableButtons();
    }

    private void createButton_actionPerformed(ActionEvent e) {
        if (!this.validateDups(true)) {
            return;
        }
        PaletteBuilderPane pane = new PaletteBuilderPane(null, this);
        pane.setBorder(BorderFactory.createEmptyBorder(6, 10, 10, 10));
        this.palettesTabbedPane.add(pane.getTitle(), pane);
        this.palettesTabbedPane.setSelectedComponent(pane);
        this.enableButtons();
    }

    private boolean hasAllTitles() {
        boolean blankTitle = false;
        for (int i = 0; i < this.palettesTabbedPane.getTabCount(); ++i) {
            if (!this.palettesTabbedPane.getTitleAt(i).equals("")) continue;
            blankTitle = true;
            this.palettesTabbedPane.setSelectedIndex(i);
            ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_EMPTYTITLE), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_EMPTYTITLETITLE), (int)0);
            break;
        }
        return !blankTitle;
    }

    public void enableButtons() {
        boolean valid = this.palettesTabbedPane.getTabCount() > 0;
        boolean dataToSave = !this.dups && this.entriesCount() > 0;
        this.blankTitle = false;
        for (int i = 0; i < this.palettesTabbedPane.getTabCount(); ++i) {
            if (!this.palettesTabbedPane.getTitleAt(i).equals("")) continue;
            this.blankTitle = true;
            break;
        }
        this.deleteButton.setEnabled(valid);
        this.saveButton.setEnabled(this.modifiedData && dataToSave && valid && !"".equals(this.filePath.getText().trim()));
        this.saveAsButton.setEnabled(this.modifiedData && valid && dataToSave);
        this.newButton.setEnabled(this.palettesTabbedPane.getTabCount() == 0 || !this.blankTitle && !this.dups);
        this.saveButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_SAVEBUTTONTOOLTIP, new Object[]{this.filePath.getText()}));
        this.noPaletteslabel.setVisible(!valid);
        this.palettesTabbedPane.setVisible(valid);
        this.okButton.setEnabled(this.modifiedData && dataToSave);
        if (valid && this.modifiedData) {
            this.cancelButton.setText(cancelButtonText);
            this.cancelButton.setToolTipText(cancelButtonToolTip);
        } else {
            this.cancelButton.setText(closeButtonText);
            this.cancelButton.setToolTipText(closeButtonToolTip);
        }
    }

    private int entriesCount() {
        int entryCount = 0;
        for (int paletteIndex = 0; paletteIndex < this.palettesTabbedPane.getTabCount(); ++paletteIndex) {
            PaletteBuilderPane pane = (PaletteBuilderPane)this.palettesTabbedPane.getComponentAt(paletteIndex);
            PropertyTableModel model = pane.getPropertyTableModel();
            Iterator entryIterator = model.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.next();
                ++entryCount;
            }
        }
        return entryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAs(File file) {
        ZipOutputStream out = null;
        int sequence = 0;
        String packagePath = "com.elluminate.util.imageLoading.palette";
        if (!this.hasAllTitles()) {
            return;
        }
        if (!this.validateDups(true)) {
            return;
        }
        packagePath = packagePath.replace('.', '/');
        File dir = new File(file.getParent());
        if (!dir.exists()) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_NOPARENTFOLDER, new Object[]{dir.getAbsolutePath()}));
            return;
        }
        if (file.exists() && !file.canWrite()) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_CANNOTWRITE, new Object[]{file.getAbsolutePath()}));
            return;
        }
        try {
            ZipEntry zipEntry;
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            DateFormat fmt = DateFormat.getDateTimeInstance(2, 2);
            out.setComment("vClass Palette JAR: " + file.getName() + ", Created: " + fmt.format((Object)new Date()));
            for (int paletteIndex = 0; paletteIndex < this.palettesTabbedPane.getTabCount(); ++paletteIndex) {
                PaletteBuilderPane pane = (PaletteBuilderPane)this.palettesTabbedPane.getComponentAt(paletteIndex);
                PropertyTableModel model = pane.getPropertyTableModel();
                Properties properties = model.createProperties();
                String entryPath = packagePath + '/' + sequence + '/';
                zipEntry = new ZipEntry(entryPath + "Palette.properties");
                out.putNextEntry(zipEntry);
                try {
                    properties.store(out, "Palette.properties for " + model.getTitle());
                }
                catch (IOException iox) {
                    // empty catch block
                }
                out.closeEntry();
                Iterator entryIterator = model.iterator();
                while (entryIterator.hasNext()) {
                    PropertyTableEntry propertyTableEntry = (PropertyTableEntry)entryIterator.next();
                    ImageData data = propertyTableEntry.getData();
                    zipEntry = new ZipEntry(entryPath + data.getPathname());
                    out.putNextEntry(zipEntry);
                    out.write(data.getImageBytes());
                    out.closeEntry();
                }
                ++sequence;
            }
            zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            out.putNextEntry(zipEntry);
            out.write(MANIFEST_HEADER.getBytes());
            out.closeEntry();
            this.modifiedData = false;
            try {
                this.savedFilePath = file.getCanonicalPath();
            }
            catch (Exception e) {
                this.savedFilePath = file.getPath();
            }
            this.filePath.setText(this.savedFilePath);
            defaultDirectory = file;
        }
        catch (Exception e) {
            ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_SAVEASERROR, new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (out != null) {
                    out.finish();
                    out.close();
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"saveAs", (Throwable)ex, (boolean)true);
            }
        }
        this.enableButtons();
    }

    public String getSavedFilePath() {
        return this.savedFilePath;
    }

    @Override
    public void paletteChanged() {
        this.modifiedData = true;
        this.enableButtons();
    }

    public boolean validateDups(boolean announce) {
        this.dups = false;
        for (int i = 0; i < this.palettesTabbedPane.getComponentCount(); ++i) {
            String title = this.palettesTabbedPane.getTitleAt(i);
            int titleCount = 0;
            boolean firstDupIndex = true;
            for (int j = i + 1; j < this.palettesTabbedPane.getComponentCount(); ++j) {
                if (!title.equals(this.palettesTabbedPane.getTitleAt(j))) continue;
                ++titleCount;
                if (!firstDupIndex) continue;
                this.palettesTabbedPane.setSelectedIndex(j);
                firstDupIndex = false;
            }
            if (titleCount <= 0) continue;
            if (announce && this.hasAllTitles()) {
                ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_DUPLICATE, new Object[]{title}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEBUILDERDIALOG_DUPLICATETITLE), (int)0);
            }
            this.dups = true;
        }
        this.enableButtons();
        return !this.dups;
    }

    public void progressShow(int min, int max) {
        this.progressIndicator.setMinimum(min);
        this.progressIndicator.setMaximum(max);
        this.progressIndicator.setValue(min);
        this.progressIndicator.setString("");
        this.progressIndicator.setStringPainted(false);
        this.progressIndicator.setEnabled(true);
        if (!this.progressIndicator.isVisible()) {
            this.progressIndicator.setVisible(true);
            this.progressIndicator.getParent().invalidate();
        }
    }

    public void progressAdvance(int val, String msg) {
        if (val >= this.progressIndicator.getMinimum() && val <= this.progressIndicator.getMaximum()) {
            this.progressIndicator.setValue(val);
        }
        if (msg != null) {
            this.progressIndicator.setString(msg);
            this.progressIndicator.setStringPainted(true);
        }
    }

    public void progressHide() {
        if (this.progressIndicator.isVisible()) {
            this.progressIndicator.setVisible(false);
            this.progressIndicator.getParent().invalidate();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTabbedPane) {
            obj = this.palettesTabbedPane.getSelectedComponent();
        }
        if (obj instanceof PaletteBuilderPane) {
            PaletteBuilderPane pane = (PaletteBuilderPane)obj;
            ImageData imageData = pane.getSelectedImageData();
        }
    }
}

