/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.FeaturePathSupport;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.GroupwareDebug;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.imps.DocumentHandlingAPI;
import com.elluminate.groupware.imps.FileConversionAPI;
import com.elluminate.groupware.imps.ImageAcceptAPI;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.ScalableComponent;
import com.elluminate.groupware.imps.StreamingMediaAPI;
import com.elluminate.groupware.imps.StreamingMediaListener;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.imps.WhiteboardFilePreviewAPI;
import com.elluminate.groupware.imps.WhiteboardInteractionAPI;
import com.elluminate.groupware.imps.whiteboard.WhiteboardScreenNode;
import com.elluminate.groupware.whiteboard.CanvasChangeListener;
import com.elluminate.groupware.whiteboard.GroupListener;
import com.elluminate.groupware.whiteboard.InitializeWhiteboard;
import com.elluminate.groupware.whiteboard.WBScaler;
import com.elluminate.groupware.whiteboard.WhiteboardBeanInterface;
import com.elluminate.groupware.whiteboard.WhiteboardChairListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.WhiteboardProtocol;
import com.elluminate.groupware.whiteboard.attributes.PresentersNote;
import com.elluminate.groupware.whiteboard.comm.GoToScreen;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.ClientSendsScreenSynch;
import com.elluminate.groupware.whiteboard.conference.WhiteboardDataProcessor;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ActivityDisplay;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.MediaCache;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.interfaces.ControllerPaneInterface;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.groupware.whiteboard.interfaces.WBClipboardInterface;
import com.elluminate.groupware.whiteboard.listeners.SelectionListener;
import com.elluminate.groupware.whiteboard.module.ActiveProtectedPolicyImps;
import com.elluminate.groupware.whiteboard.module.BasicBean;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.ImageAcceptIMPS;
import com.elluminate.groupware.whiteboard.module.ProtectedPolicyAPI;
import com.elluminate.groupware.whiteboard.module.ScreenViewDialog;
import com.elluminate.groupware.whiteboard.module.SizeDialog;
import com.elluminate.groupware.whiteboard.module.StarOfficeInformation;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.WBClipboard;
import com.elluminate.groupware.whiteboard.module.WhiteboardFileUtilities;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.groupware.whiteboard.module.WhiteboardPermissionDelegate;
import com.elluminate.groupware.whiteboard.module.WhiteboardPublisher;
import com.elluminate.groupware.whiteboard.module.imageloading.Palettes;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationImport;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationInterface;
import com.elluminate.groupware.whiteboard.module.presentations.StarOfficeImport;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.GroupSelectionDialog;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.NoUIProgress;
import com.elluminate.groupware.whiteboard.xml.WhiteboardDataFile;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

@Singleton
public class WhiteboardBean
extends BasicBean
implements ActivityDisplay,
ChannelDataListener,
ChannelListener,
ClientListener,
MetaDataListener,
PropertyChangeListener,
ParticipantSelectionListener,
SelectionListener,
StreamingMediaAPI,
WhiteboardBeanInterface,
WhiteboardChairListener,
ClientGroupListener,
CanvasChangeListener {
    private PublishedComponent wbdComponent = null;
    private Object componentLock = new Object();
    private static final long serialVersionUID = 1L;
    private I18n i18n = I18n.create((Object)this);
    private String titleText = null;
    private boolean documentChanged = false;
    private GroupListener groupListener = null;
    private WhiteboardModule module = null;
    private WhiteboardContext context = null;
    private ControllerPane controller = null;
    private SwingRunner swinger;
    private ListenerRegistry<ShowThumbnailsListener> thumbnailsListeners;
    private FeaturePathSupport pathSupport;
    private FeatureBroker broker;
    private BooleanFeature oneButtonOperationFeature;
    private BooleanFeature showThumbnailsFeature;
    private BooleanFeature proprietaryContentFeature;
    private EnumeratedFeature<Byte> showSlidePositionFeature;
    private ActionFeature selectAllSelectedToolsFeature;
    private ActionFeature selectedToolInfoFeature;
    private ActionFeature showViewedScreensFeature;
    private ActionFeature copyMainRoomToRoomsFeature;
    private ActionFeature copyRoomsToMainRoomFeature;
    private ActionFeature copyAllRoomsToMainRoomFeature;
    private ActionFeature copySelectedRoomsToMainRoomFeature;
    private EnumeratedFeature<WBScaler> scaleSelectorFeature;
    private StringFeature scaleFactorFeature;
    private ActionFeature validateDataModelFeature;
    private ParticipantSelectorAPI selector = null;
    private CacheMonitor mediaCacheMonitor = null;
    private ContentCapture contentCapture;
    private ArrayList canvasListeners = new ArrayList();
    private ScreenViewDialog screenViewDialog = null;
    private File preloadFile = null;
    private PropertyChangeListener preferenceChangeListener;
    private FileConversionHandler fileConversionHandler = null;
    private byte defaultShowScreenCounter = 1;
    private WhiteboardPublisher msgPublisher;
    private ClientProvider clientProvider;
    private CRSession sessionModel;
    private Imps imps;
    private WhiteboardPermissionDelegate whiteboardPermissionDelegate;
    private WBScaler percent25;
    private WBScaler percent50;
    private WBScaler percent75;
    private WBScaler percent100;
    private WBScaler percent150;
    private WBScaler percent200;
    private WBScaler percent300;
    private WBScalerFitToWindow fullPage;
    private WBScalerFitToWindow fillWidth;
    private WBScalerFitToWindow fillHeight;
    private WBScalerFitToWindow fillScreen;
    private WBScalerCustom customScale;
    private WBScaler[] scalers = null;
    private WBScaler defaultScaler;
    private Preferences preferences = null;

    @Inject
    public void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        this.contentCapture = contentCaptureProvider.get();
    }

    private void initializeScalingFeature() {
        this.percent25 = new WBScaler(this.i18n.getString((PropertiesEnum)StringsProperties.PERCENT25_STRING), 0.25, 0.25);
        this.percent50 = new WBScaler(this.i18n.getString((PropertiesEnum)StringsProperties.PERCENT50_STRING), 0.5, 0.5);
        this.percent75 = new WBScaler(this.i18n.getString((PropertiesEnum)StringsProperties.PERCENT75_STRING), 0.75, 0.75);
        this.percent100 = new WBScaler(this.i18n.getString((PropertiesEnum)StringsProperties.PERCENT100_STRING), 1.0, 1.0);
        this.percent150 = new WBScaler(this.i18n.getString((PropertiesEnum)StringsProperties.PERCENT150_STRING), 1.5, 1.5);
        this.percent200 = new WBScaler(this.i18n.getString((PropertiesEnum)StringsProperties.PERCENT200_STRING), 2.0, 2.0);
        this.percent300 = new WBScaler(this.i18n.getString((PropertiesEnum)StringsProperties.PERCENT300_STRING), 3.0, 3.0);
        this.fullPage = new WBScalerFitToWindow(this.context, this.i18n.getString((PropertiesEnum)StringsProperties.FIT_PAGE_STRING), 0);
        this.fillWidth = new WBScalerFitToWindow(this.context, this.i18n.getString((PropertiesEnum)StringsProperties.FIT_WIDTH_STRING), 1);
        this.fillHeight = new WBScalerFitToWindow(this.context, this.i18n.getString((PropertiesEnum)StringsProperties.FIT_HEIGHT_STRING), 2);
        this.fillScreen = new WBScalerFitToWindow(this.context, this.i18n.getString((PropertiesEnum)StringsProperties.FILL_SCREEN_STRING), 3);
        this.customScale = new WBScalerCustom(this.context);
        this.scalers = new WBScaler[]{this.percent25, this.percent50, this.percent75, this.percent100, this.percent150, this.percent200, this.percent300, this.fullPage, this.customScale};
        this.defaultScaler = this.fullPage;
        this.scaleSelectorFeature = this.broker.createEnumeratedFeature((Object)this.module, "/whiteboard/actionBar/zoomSelector", WBScaler.class, true, (Object)this.defaultScaler, (Object[])this.scalers, this.i18n.getString((PropertiesEnum)StringsProperties.WHIBOARDBEAN_ZOOM_NAME), this.i18n.getString((PropertiesEnum)StringsProperties.WHIBOARDBEAN_ZOOM_TOOLTIP));
        this.scaleFactorFeature = this.broker.createStringFeature((Object)this.module, "/whiteboard/actionBar/zoomDisplay", true, "", this.i18n.getString((PropertiesEnum)StringsProperties.WHIBOARDBEAN_ZOOM_NAME), this.i18n.getString((PropertiesEnum)StringsProperties.WHIBOARDBEAN_SCALE_FACTOR));
        for (int i = 0; i < this.scalers.length; ++i) {
            this.scaleSelectorFeature.setValueText((Object)this.scalers[i], this.scalers[i].getName());
        }
        this.scaleSelectorFeature.addValueChangeListener((MetaDataListener)this);
        this.broker.setFeaturePublished(this.scaleSelectorFeature, true);
        this.context.setScaler(this.defaultScaler);
    }

    public void metaDataChanged(MetaDataEvent ev) {
        this.scaleSelectorFeature.removeValueChangeListener((MetaDataListener)this);
        if (ev.getSource() == this.scaleSelectorFeature) {
            WBScaler scaler = (WBScaler)ev.getNewValue();
            if (scaler == this.customScale) {
                SwingRunnerSupport.invokeLater((Runnable)new QueryScaleFactor(scaler));
                return;
            }
            this.scaleFactorFeature.setValue((Object)scaler.displayName());
            this.context.setScaler(scaler);
            this.context.getController().processScaleChange();
        }
        this.scaleSelectorFeature.addValueChangeListener((MetaDataListener)this);
    }

    @Inject
    public WhiteboardBean(ListenerRegistry<ShowThumbnailsListener> thumbnailsListeners) {
        this.thumbnailsListeners = thumbnailsListeners;
        this.context = new WhiteboardContext(true, false);
        this.context.setThrowableListener(thumbnailsListeners.getThrowableListener());
    }

    @Inject
    protected void initCRSession(CRSession sessionModel) {
        this.sessionModel = sessionModel;
    }

    @Inject
    protected void initWhiteboardPermissionDelegate(WhiteboardPermissionDelegate whiteboardPermissionDelegate) {
        this.whiteboardPermissionDelegate = whiteboardPermissionDelegate;
    }

    @Inject
    public void initWhiteboardPublisher(WhiteboardPublisher pub) {
        this.msgPublisher = pub;
    }

    @Override
    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    public void initPathSupport(FeaturePathSupport pathSupport) {
        this.pathSupport = pathSupport;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initSwingRunner(SwingRunner runner) {
        this.swinger = runner;
    }

    @Inject
    public void initDialogParentProvider(DialogParentProvider dpp) {
        this.context.setDialogParentProvider(dpp);
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClient(Client theClient) {
        ClientInfo moi;
        this.selector = (ParticipantSelectorAPI)this.imps.findBest(ParticipantSelectorAPI.class);
        if (this.selector != null) {
            this.selector.addSelectionListener((ParticipantSelectionListener)this);
        }
        try {
            ImageSupport.setMaxSize((Dimension)new Dimension(2000, 2000));
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"Constructor", (String)("ImageSupport.setMaxPixels: " + t.getMessage()));
        }
        this.envInit();
        WhiteboardProtocol proto = new WhiteboardProtocol(this.context, false);
        this.setClient(theClient, (JinxProtocol)proto, this, this, this);
        this.context.setClientList(this.clients);
        this.groupListener = new GroupListener(this.context);
        this.client.addClientGroupListener((ClientGroupListener)this.groupListener);
        this.client.addClientGroupListener((ClientGroupListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.moderator", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Moderator", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.participants", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("globalMediaBufferSize", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("globalMediaCacheSize", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("show.counter", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("defaultGroupName", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("defaultScreenName", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("whitebordProprietaryContent", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener((byte)0, (PropertyChangeListener)new WhiteboardAnnotationProvider());
        this.context.getChairManager().addChairListener((WhiteboardChairListener)this);
        this.context.addCanvasChangeListener((CanvasChangeListener)this);
        this.clients.addClientListener((ClientListener)this.context.getIDProcessor());
        Object object = this.componentLock;
        synchronized (object) {
            this.wbdComponent = new PublishedComponent();
            this.componentLock.notifyAll();
        }
        this.setupKeyBindings();
        this.wbInit();
        if (this.whiteboardPermissionDelegate != null) {
            this.whiteboardPermissionDelegate.setClientProvider(this.clientProvider);
            this.whiteboardPermissionDelegate.setSession(this.sessionModel);
            CRPermissionFactory permissionFactory = new CRPermissionFactory("WhiteBoardPermission", "WhiteBoardPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.whiteboardPermissionDelegate);
            this.sessionModel.registerPermission(permissionFactory);
            this.clients.addPropertyChangeListener(this.whiteboardPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.whiteboardPermissionDelegate));
            this.clients.addDefaultPropertyChangeListener(this.whiteboardPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.whiteboardPermissionDelegate));
        }
        if (this.selectAllSelectedToolsFeature != null) {
            String name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SELECTSELECTEDTOOLS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant")});
            this.selectAllSelectedToolsFeature.setName(name);
            this.selectAllSelectedToolsFeature.setEnabled(false);
            this.broker.setFeaturePublished((Feature)this.selectAllSelectedToolsFeature, false);
        }
        this.copyMainRoomToRoomsFeature.setEnabled(false);
        this.copyRoomsToMainRoomFeature.setEnabled(false);
        this.broker.setFeaturePublished((Feature)this.copyMainRoomToRoomsFeature, false);
        this.broker.setFeaturePublished((Feature)this.copyRoomsToMainRoomFeature, false);
        this.context.addSelectionListener((SelectionListener)this);
        if (this.contentCapture.isCapturingData()) {
            this.contentCapture = this.contentCapture.registerImageModule("Whiteboard", "Whiteboard", (Container)((ControllerPane)this.context.getController()).getCanvas(), this.i18n.getIcon("WhiteboardBean.thinClientIcon"), (byte)2, (byte)20);
        }
        if ((moi = this.clients.getMyClient()) != null) {
            ClientEvent event = new ClientEvent((Object)moi, moi.getAddress(), moi.getName(), moi.isMe());
            this.initComponents(event);
        }
    }

    private ScreenRoot[] selectGroupsQuery(StringsProperties titleKey, StringsProperties promptKey, StringsProperties buttonKey) {
        ArrayList<ScreenRoot> groups = new ArrayList<ScreenRoot>();
        ScreenGroups roots = (ScreenGroups)this.context.getDataModel().getRoot();
        for (int i = 0; i < roots.getChildCount(); ++i) {
            ScreenRoot root = (ScreenRoot)roots.getChildAt(i);
            if (root.getGroupID() == 0) continue;
            groups.add(root);
        }
        ScreenRoot[] grps = groups.toArray(new ScreenRoot[groups.size()]);
        GroupSelectionDialog d = new GroupSelectionDialog(this.getAppFrame(), this.i18n.getString((PropertiesEnum)titleKey), grps);
        d.setPrompt(this.i18n.getString((PropertiesEnum)promptKey));
        d.setButtonText(this.i18n.getString((PropertiesEnum)buttonKey));
        d.setVisible(true);
        if (!d.wasCanceled()) {
            return d.getSelectedGroups();
        }
        return null;
    }

    private void copyMainRoomToRoomsQuery() {
        ScreenModel currentScreen = this.context.getController().getScreen();
        ScreenRoot[] grps = this.selectGroupsQuery(StringsProperties.WHITEBOARDBEAN_COPYSCREENTOGROUPSDIALOGTITLE, StringsProperties.WHITEBOARDBEAN_COPYSCREENTOGROUPSDIALOGPROMPT, StringsProperties.WHITEBOARDBEAN_COPYSCREENTOGROUPSDIALOGCOPYBUTTON);
        if (grps != null) {
            ScreenModel[] src = new ScreenModel[]{currentScreen};
            ActionUtilities.duplicateScreensToGroups((WhiteboardContext)this.context, (ScreenModel[])src, (ScreenRoot[])grps);
            for (int i = 0; i < grps.length; ++i) {
                ScreenRoot grp = grps[i];
                ScreenModel scr = (ScreenModel)grp.getScreenAt(0);
                GoToScreen gotoScreen = new GoToScreen(this.context, scr.getObjectID(), Short.valueOf(grp.getGroupID()));
                this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)gotoScreen);
            }
        }
    }

    private void copyRoomsToMainRoomQuery() {
        ScreenRoot[] grps = this.selectGroupsQuery(StringsProperties.WHITEBOARDBEAN_COPYGROUPSTOMAINROOMDIALOGTITLE, StringsProperties.WHITEBOARDBEAN_COPYGROUPSTOMAINROOMDIALOGPROMPT, StringsProperties.WHITEBOARDBEAN_COPYGROUPSTOMAINROOMDIALOGCOPYBUTTON);
        if (grps != null) {
            ArrayList<String> rooms = new ArrayList<String>();
            for (int i = 0; i < grps.length; ++i) {
                rooms.add(grps[i].getDisplayName());
            }
            this.duplicateRoomsToMainRoom(rooms);
        }
    }

    private void wbInit() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"wbInit", (Throwable)ex, (boolean)true);
        }
    }

    private void envInit() {
        this.context.setBean((WhiteboardBeanInterface)this);
        this.context.setWBClipboard((WBClipboardInterface)new WBClipboard(this.context));
        this.context.setImps(this.imps);
        this.imps.provideAPI(ProtectedPolicyAPI.class, (ImpsAPI)new ActiveProtectedPolicyImps(this.module.getNameOfModule()));
        this.imps.provideAPI(StreamingMediaAPI.class, (ImpsAPI)this);
        this.imps.provideAPI(WhiteboardFilePreviewAPI.class, (ImpsAPI)new FilePreviewAPI());
        this.imps.provideAPI(ImageAcceptAPI.class, (ImpsAPI)new ImageAcceptIMPS(this.context));
        this.imps.provideAPI(WhiteboardInteractionAPI.class, (ImpsAPI)new InteractionAPI());
        this.imps.provideAPI(DocumentHandlingAPI.class, (ImpsAPI)new DocumentHandler());
        this.fileConversionHandler = new FileConversionHandler();
        this.imps.provideAPI(FileConversionAPI.class, (ImpsAPI)this.fileConversionHandler);
        WhiteboardDataProcessor dataProcessor = new WhiteboardDataProcessor(this.context);
        dataProcessor.setChannel(null);
        this.context.setDataProcessor(dataProcessor);
        this.context.setRegistryOnline(false);
        this.context.setConferenceUID(0L);
        InitializeWhiteboard.registerIntrinsicObjects((WhiteboardContext)this.context);
        this.controller = new ControllerPane(this.context);
        this.controller.initWhiteboardPublisher(this.msgPublisher);
    }

    private void jbInit() throws Exception {
        this.wbdComponent.setLayout(new BorderLayout());
        this.wbdComponent.setOpaque(false);
        this.wbdComponent.setDoubleBuffered(true);
        this.wbdComponent.setMinimumSize(new Dimension(225, 200));
        this.wbdComponent.add((Component)this.controller, "Center");
        this.documentChanged = false;
    }

    void createFeatures() {
        String path = this.pathSupport.composePath("/whiteboard", "oneButtonOperation");
        String name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_ONEBUTTONOPERATION);
        this.oneButtonOperationFeature = this.broker.createBooleanFeature((Object)this.module, path, true, false, name, null);
        this.oneButtonOperationFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                WhiteboardBean.this.enableOneButtonOperation((Boolean)WhiteboardBean.this.oneButtonOperationFeature.getValue());
            }
        });
        path = this.pathSupport.composePath("/whiteboard", "autoScale");
        path = this.pathSupport.composePath("/whiteboard", "showThumbnails");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SHOWTHUMBNAILS);
        this.showThumbnailsFeature = this.broker.createBooleanFeature((Object)this.module, path, true, true, name, null);
        this.showThumbnailsFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                WhiteboardBean.this.context.setThumbnailShow(((Boolean)WhiteboardBean.this.showThumbnailsFeature.getValue()).booleanValue());
                WhiteboardBean.this.fireShowThumbnailsListeners();
            }
        });
        this.showThumbnailsFeature.setEnabled(false);
        path = this.pathSupport.composePath("/whiteboard", "proprietaryWhiteboard");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_PROPRIETARYWHITEBOARD);
        CRParticipant moi = this.sessionModel != null ? this.sessionModel.getMe() : null;
        boolean protectDefault = moi != null ? moi.isChair() : false;
        this.proprietaryContentFeature = this.broker.createBooleanFeature((Object)this.module, path, true, protectDefault, name, null);
        this.proprietaryContentFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                ClientList cl = WhiteboardBean.this.context.getClientList();
                boolean val = (Boolean)ev.getNewValue();
                cl.setProperty("whitebordProprietaryContent", val);
                if (WhiteboardBean.this.context.getController() != null) {
                    ControllerPane ctrlr = (ControllerPane)WhiteboardBean.this.context.getController();
                    ctrlr.enableProprietaryWhiteboards(val, true);
                }
            }
        });
        this.proprietaryContentFeature.setEnabled(false);
        path = this.pathSupport.composePath("/whiteboard", "showSlidePosition");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SHOWPOSITIONOFTEXT);
        Object[] allowedValues = new Byte[]{(byte)2, (byte)1, (byte)0};
        String[] valueText = new String[]{this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SHOWPOSITIONTOALL), this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SHOWPOSITIONTOMODERATORS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderators")}), this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SHOWPOSITIONTONONE)};
        this.showSlidePositionFeature = this.broker.createEnumeratedFeature((Object)this.module, path, Byte.class, true, (Object)this.defaultShowScreenCounter, allowedValues, valueText, name, null);
        this.showSlidePositionFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                WhiteboardBean.this.changeScreenCounterProperty((Byte)WhiteboardBean.this.showSlidePositionFeature.getValue());
            }
        });
        path = this.pathSupport.composePath("/whiteboard", "selectAllSelectedTools");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SELECTSELECTEDTOOLS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant")});
        this.selectAllSelectedToolsFeature = this.broker.createActionFeature((Object)this.module, path, name, null);
        this.selectAllSelectedToolsFeature.addActionFeatureListener(new ActionFeatureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionFeatureEvent event) {
                HashSet<Short> originators = new HashSet<Short>();
                ScreenModel screen = WhiteboardBean.this.context.getController().getScreen();
                DataModel dataModel = WhiteboardBean.this.context.getDataModel();
                synchronized (dataModel) {
                    Iterator iter = screen.getSelectedToolListIterator();
                    while (iter.hasNext()) {
                        WBNode node = (WBNode)iter.next();
                        if (node.getObjectID() == null) continue;
                        Short clientId = ShortList.get((short)ObjectUID.decodeClientId((Long)node.getObjectID()));
                        originators.add(clientId);
                    }
                }
                screen.deSelectAllTools();
                for (Short clientId : originators) {
                    ActionUtilities.selectParticipantsTools((ScreenModel)screen, (WBNode)screen, (Short)clientId);
                }
            }
        });
        path = this.pathSupport.composePath("/whiteboard", "selectedToolInfo");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_GETSELECTEDINFO);
        this.selectedToolInfoFeature = this.broker.createActionFeature((Object)this.module, path, name, null);
        this.selectedToolInfoFeature.setEnabled(false);
        this.selectedToolInfoFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardBean.this.showSelectedToolInformation();
            }
        });
        path = this.pathSupport.composePath("/whiteboard", "showViewedScreens");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SHOWVIEWEDSCREENS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participants")});
        this.showViewedScreensFeature = this.broker.createActionFeature((Object)this.module, path, name, null);
        this.showViewedScreensFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardBean.this.showViewedScreens();
            }
        });
        path = this.pathSupport.composePath("/whiteboard", "copyMainRoomToRooms");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_COPYMAINROOMTOROOMSITEM);
        this.copyMainRoomToRoomsFeature = this.broker.createActionFeature((Object)this.module, path, name, null);
        this.copyMainRoomToRoomsFeature.setInteractive(true);
        this.copyMainRoomToRoomsFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardBean.this.copyMainRoomToRoomsQuery();
            }
        });
        path = this.pathSupport.composePath("/whiteboard", "copyRoomsToMainRoom");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_COPYROOMSTOMAINROOMITEM);
        this.copyRoomsToMainRoomFeature = this.broker.createActionFeature((Object)this.module, path, name, null);
        this.copyRoomsToMainRoomFeature.setInteractive(true);
        this.copyRoomsToMainRoomFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardBean.this.copyRoomsToMainRoomQuery();
            }
        });
        path = this.pathSupport.composePath("/whiteboard", "copyAllRoomsToMainRoom");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_COPYALLROOMSTOMAINROOM);
        this.copyAllRoomsToMainRoomFeature = this.broker.createActionFeature((Object)this.module, path, name, null);
        this.copyAllRoomsToMainRoomFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardBean.this.duplicateAllRoomsToMainRoom();
            }
        });
        path = this.pathSupport.composePath("/whiteboard", "copySelectedRoomsToMainRoom");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_COPYROOMTOMAINROOM);
        this.copySelectedRoomsToMainRoomFeature = this.broker.createActionFeature((Object)this.module, path, name, null);
        this.copySelectedRoomsToMainRoomFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<String> rooms = new ArrayList<String>();
                        List selected = WhiteboardBean.this.selector.getSelectedRooms();
                        for (CRRoom room : selected) {
                            rooms.add(room.getName());
                        }
                        WhiteboardBean.this.duplicateRoomsToMainRoom(rooms);
                    }
                };
                WhiteboardBean.this.swinger.invokeOnEventThread(r);
            }
        });
        this.initializeScalingFeature();
    }

    private void setupKeyBindings() {
        class NavAction
        extends AbstractAction {
            final int code;

            NavAction(int keyCode) {
                this.code = keyCode;
            }

            @Override
            public void actionPerformed(ActionEvent actionEv) {
                if (WhiteboardBean.this.context == null) {
                    return;
                }
                ControllerPaneInterface controller = WhiteboardBean.this.context.getController();
                if (controller == null) {
                    return;
                }
                Component src = null;
                Object actionSrc = actionEv.getSource();
                src = actionSrc instanceof Component ? (Component)actionSrc : WhiteboardBean.this.wbdComponent;
                KeyEvent keyEv = new KeyEvent(src, 402, actionEv.getWhen(), 0, this.code, '\uffff');
                controller.processNavKey(keyEv);
            }
        }
        NavAction pageUpAction = new NavAction(33);
        NavAction pageDownAction = new NavAction(34);
        NavAction homeAction = new NavAction(36);
        NavAction endAction = new NavAction(35);
        ActionMap aMap = this.wbdComponent.getActionMap();
        aMap.put(pageUpAction, pageUpAction);
        aMap.put(pageDownAction, pageDownAction);
        aMap.put(homeAction, homeAction);
        aMap.put(endAction, endAction);
        InputMap iMap = this.wbdComponent.getInputMap(2);
        iMap.put(KeyStroke.getKeyStroke(pageUpAction.code, 0), pageUpAction);
        iMap.put(KeyStroke.getKeyStroke(pageDownAction.code, 0), pageDownAction);
        iMap.put(KeyStroke.getKeyStroke(homeAction.code, 0), homeAction);
        iMap.put(KeyStroke.getKeyStroke(endAction.code, 0), endAction);
    }

    public void setScreenCounterDefault(byte whoShouldSee) {
        if (whoShouldSee != 2 && whoShouldSee != 1 && whoShouldSee != 0) {
            whoShouldSee = 1;
        }
        this.defaultShowScreenCounter = whoShouldSee;
    }

    void start() {
        if (this.preloadFile != null && this.context.getDataModel() != null) {
            int type = FileUtils.loadWhiteboardFile(this.preloadFile, new ScreenRoot[]{this.context.getDataModel().getPrivateScreens()}, this.context);
            switch (type) {
                case 2: {
                    if (this.proprietaryContentFeature != null) {
                        this.proprietaryContentFeature.setValue((Object)true);
                    }
                    if (this.context.getController() == null) break;
                    ((ControllerPane)this.context.getController()).enableProprietaryWhiteboards(true, false);
                    break;
                }
                case 1: {
                    if (this.proprietaryContentFeature == null) break;
                    this.proprietaryContentFeature.setValue((Object)false);
                    break;
                }
            }
        }
        this.setStreamVisible(this.wbdComponent != null && this.wbdComponent.isVisible());
    }

    void stop() {
        this.setStreamVisible(this.wbdComponent != null && this.wbdComponent.isVisible());
    }

    public void participantSelectionChanged() {
        this.enableSelectionItems();
    }

    public void sendValidate() {
        if (this.context.isOnline() && !this.context.isPlayback()) {
            this.context.getDataProcessor().sendDirective((byte)8);
        } else {
            Validator.validate((String)"WhiteboardBean.localValidate", (WhiteboardContext)this.context);
        }
    }

    void setModule(WhiteboardModule module) {
        this.module = module;
    }

    public WhiteboardModule getModule() {
        return this.module;
    }

    public String getOwnerPrefix() {
        return this.getModule() != null ? this.getModule().getPrefix() : null;
    }

    public WhiteboardContext getContext() {
        return this.context;
    }

    public void setDocumentChanged(boolean documentChanged) {
        this.documentChanged = documentChanged;
    }

    private void showViewedScreens() {
        List who = null;
        if (this.selector == null) {
            return;
        }
        who = this.selector.getSelectedClients();
        if (this.screenViewDialog == null) {
            this.screenViewDialog = new ScreenViewDialog(this.getAppFrame(), this.clients, this.context);
        }
        this.screenViewDialog.setParticipants(who);
        this.screenViewDialog.show();
    }

    void duplicateRoomToMainRoom(String breakoutRoom) {
        this.duplicateRoomsToMainRoom(Arrays.asList(breakoutRoom));
    }

    /*
     * WARNING - void declaration
     */
    void duplicateRoomsToMainRoom(List breakoutRooms) {
        void var8_12;
        DataModel model = this.context.getDataModel();
        ScreenGroups roots = (ScreenGroups)model.getRoot();
        TreeSet<WBNode> sortedRoots = new TreeSet<WBNode>(new Comparator(){

            public int compare(Object obj1, Object obj2) {
                String name1 = ((ScreenRoot)obj1).getDisplayName();
                String name2 = ((ScreenRoot)obj2).getDisplayName();
                return name1.compareTo(name2);
            }
        });
        for (int i = 0; i < roots.getChildCount(); ++i) {
            sortedRoots.add(roots.getChildAt(i));
        }
        ScreenRoot main = model.getPublicScreens();
        if (main == null) {
            return;
        }
        ArrayList<ScreenModel> list = new ArrayList<ScreenModel>();
        for (ScreenRoot screenRoot : sortedRoots) {
            if (screenRoot.getGroupID() == 0 || breakoutRooms != null && breakoutRooms.size() != 0 && !breakoutRooms.contains(screenRoot.getDisplayName())) continue;
            try {
                for (int i = 0; i < screenRoot.getScreenCount(); ++i) {
                    ScreenModel screen = (ScreenModel)screenRoot.getScreenAt(i);
                    ScreenModel clone = (ScreenModel)screen.clone();
                    ActionUtilities.makeUserNames((ScreenModel)clone, (String)screenRoot.getScreenName());
                    list.add(clone);
                }
            }
            catch (CloneNotSupportedException ex) {
            }
        }
        if (list.size() == 0) {
            return;
        }
        ScreenModel screenModel = this.context.getController().getScreen();
        if (screenModel.getRoot() != main) {
            ScreenRoot screenRoot = main;
        }
        ActionUtilities.pasteScreens((ScreenModel[])new ScreenModel[]{var8_12}, (WhiteboardContext)this.context, (int)1, (ScreenModel[])list.toArray(new ScreenModel[0]));
    }

    void duplicateAllRoomsToMainRoom() {
        this.duplicateRoomsToMainRoom(null);
    }

    public Component getMediaCacheMonitor() {
        if (this.mediaCacheMonitor == null) {
            MediaCache cache = this.context.getMediaCache();
            this.mediaCacheMonitor = new CacheMonitor(cache);
        }
        return this.mediaCacheMonitor;
    }

    public void onWhiteboardChairChange(Short clientId, Short jinxAddress, boolean add) {
        ClientInfo ci2 = null;
        if (!add && jinxAddress != null && jinxAddress.equals(this.context.getIDProcessor().getMyAddress())) {
            for (ClientInfo ci2 : this.context.getClientList()) {
                if (ci2 == null) continue;
                ci2.setProperty("whiteboardYellowStatus", false);
                ci2.setProperty("whiteboardRedStatus", false);
            }
        }
        if (clientId.equals(ClientIdentification.CLIENT_LOCAL)) {
            this.proprietaryContentFeature.setEnabled(add);
            this.showThumbnailsFeature.setEnabled(add);
            this.enableSelectionItems();
            int roomCount = this.clients != null ? this.clients.getGroupCount() : 0;
            this.broker.setFeaturePublished((Feature)this.copyAllRoomsToMainRoomFeature, add && roomCount > 1);
            this.broker.setFeaturePublished((Feature)this.copyMainRoomToRoomsFeature, add);
            this.broker.setFeaturePublished((Feature)this.copyRoomsToMainRoomFeature, add);
        }
    }

    public boolean isLoadable() {
        ScreenModel screen = this.context.getController().getScreen();
        return screen.getParent() instanceof ScreenModel ? ((ScreenModel)screen.getParent()).canLoad() : screen.canLoad();
    }

    public void save() {
        this.controller.saveDocument();
    }

    public void saveAs() {
        this.controller.saveDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreferences(String prefix, Preferences preferences) {
        Serializable parentFile;
        File file;
        File file2;
        String value;
        boolean setting = false;
        setting = preferences.getBooleanSetting(prefix + ".OneButtonOperation", false);
        this.enableOneButtonOperation(setting);
        setting = preferences.getBooleanSetting(prefix + ".Thumbnails", true);
        this.context.setThumbnailShow(setting);
        this.showThumbnailsFeature.setValue((Object)setting);
        String toLoad = "";
        if (this.context.fileToLoad != null) {
            toLoad = this.context.fileToLoad.getPath();
        }
        if ((value = preferences.getSetting(prefix + ".FileToLoad", toLoad)) != null && (file2 = new File(value)).getParent() != null && (file2.exists() || new File(file2.getParent()).exists())) {
            this.context.fileToLoad = file2;
        }
        String toSave = "";
        if (this.context.fileToSave != null) {
            toSave = this.context.fileToSave.getPath();
        }
        if ((value = preferences.getSetting(prefix + ".FileToSave", toSave)) != null && (file = new File(value)).getParent() != null) {
            parentFile = new File(file.getParent());
            if (file.exists() || parentFile != null && parentFile.exists()) {
                this.context.fileToSave = file;
            }
        }
        if ((value = preferences.getSetting(WhiteboardModule.addedPalettesKey = prefix + ".addedPalettes", "")) != null) {
            ArrayList addedURLs = new ArrayList();
            Debug.lockEnter((Object)this, (String)"whiteboardBean", (String)"paletteLock", (Object)WhiteboardModule.addedPalettes);
            try {
                parentFile = WhiteboardModule.addedPalettes;
                synchronized (parentFile) {
                    File f;
                    if (WhiteboardModule.palettes != null) {
                        WhiteboardModule.palettes.loadPreferences(prefix + ".addedPalettes", preferences);
                    }
                    ArrayList<File> files = new ArrayList<File>();
                    StringTokenizer path = new StringTokenizer(value, File.pathSeparator);
                    while (path.hasMoreTokens()) {
                        f = new File(path.nextToken());
                        if (!f.exists() || !f.isFile()) continue;
                        files.add(f);
                    }
                    if (files.size() == 0) {
                        path = new StringTokenizer(value, ",");
                        while (path.hasMoreTokens()) {
                            f = new File(path.nextToken());
                            if (!f.exists() || !f.isFile()) continue;
                            files.add(f);
                        }
                    }
                    for (File f2 : files) {
                        if (WhiteboardModule.palettes != null) {
                            WhiteboardModule.palettes.loadPaletteFile(f2, true);
                            continue;
                        }
                        String palettePath = f2.getAbsolutePath();
                        if (WhiteboardModule.addedPalettes.contains(palettePath)) continue;
                        WhiteboardModule.addedPalettes.add(palettePath);
                    }
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"whiteboardBean", (String)"paletteLock", (Object)WhiteboardModule.addedPalettes);
            }
        }
        try {
            StarOfficeInformation sinfo = StarOfficeInformation.instance();
            String path = preferences.getSetting(prefix + ".StarOfficeAppPath", "");
            if (!StarOfficeInformation.isValidApp(path)) {
                path = "";
            }
            if (path.equals("")) {
                if (WhiteboardDebug.STAROFFICE.show()) {
                    LogSupport.message((Object)this, (String)"loadPreferences", (String)"Searching for OpenOffice.org");
                }
                StarOfficeImport.findStarOffice();
                if (sinfo.isValid()) {
                    preferences.setSetting(prefix + ".StarOfficeAppPath", sinfo.getStarApplicationPath());
                }
            } else {
                StarOfficeInformation.instance().setStarOfficeApplicationPath(path);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"loadPreferences", (Throwable)t, (boolean)true, (String)"Error loading OpenOffice.org importer preference.");
            StarOfficeInformation.instance().setStarOfficeApplicationPath(null);
        }
        this.fileConversionHandler.initConvertibleExtensions();
    }

    public void setVisible(boolean visible) {
        this.setStreamVisible(visible);
        this.wbdComponent.setVisible(visible);
    }

    boolean preload(String fileToLoad) {
        this.preloadFile = new File(fileToLoad);
        return this.preloadFile.isFile();
    }

    void setFollowDefault(boolean followDefault) {
        this.context.setFollowDefault(followDefault);
    }

    public void savePreferences(String prefix, Preferences preferences) {
        String value;
        preferences.setSetting(prefix + ".OneButtonOperation", ((Boolean)this.oneButtonOperationFeature.getValue()).booleanValue());
        preferences.setSetting(prefix + ".Thumbnails", ((Boolean)this.showThumbnailsFeature.getValue()).booleanValue());
        if (this.context.fileToLoad != null && (value = !this.context.fileToLoad.isDirectory() ? this.context.fileToLoad.getParent() : (this.context.fileToLoad.exists() && this.context.fileToLoad.isFile() ? this.context.fileToLoad.getParent() : this.context.fileToLoad.getPath())) != null) {
            preferences.setSetting(prefix + ".FileToLoad", value);
        }
        if (this.context.fileToSave != null) {
            preferences.setSetting(prefix + ".FileToSave", this.context.fileToSave.getPath());
        }
        if (WhiteboardModule.palettes instanceof Palettes) {
            WhiteboardModule.palettes.savePreferences(WhiteboardModule.addedPalettesKey, preferences);
        }
    }

    void installHook(WhiteboardModule mod) {
        if (this.preferenceChangeListener == null) {
            this.preferenceChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String path = Preferences.stringValue((Object)e.getNewValue(), (String)"");
                    if (path.equals("")) {
                        StarOfficeImport.findStarOffice();
                    } else {
                        StarOfficeInformation.instance().setStarOfficeApplicationPath(path);
                    }
                }
            };
        }
        Preferences prefs = mod.getPreferences();
        String prefix = mod.getPrefix();
        prefs.addSettingChangeListener(prefix + ".StarOfficeAppPath", this.preferenceChangeListener);
    }

    void uninstallHook(WhiteboardModule mod) {
        Preferences prefs = mod.getPreferences();
        String prefix = mod.getPrefix();
        prefs.removeSettingChangeListener(prefix + ".StarOfficeAppPath", this.preferenceChangeListener);
    }

    private void changeScreenCounterProperty(byte changeTo) {
        if (!ChairProtocol.getChair((ClientList)this.clients).isMe()) {
            return;
        }
        byte current = this.clients.getProperty("show.counter", this.defaultShowScreenCounter);
        if (changeTo == current) {
            return;
        }
        this.clients.setProperty("show.counter", Bytes.get((byte)changeTo).byteValue());
    }

    private void showScreenCounter(byte counterSetting, boolean iAmChair) {
        if (counterSetting == -1) {
            counterSetting = this.defaultShowScreenCounter;
        }
        switch (counterSetting) {
            case 2: {
                this.showSlidePositionFeature.setValue((Object)2);
                ((ControllerPane)this.context.getController()).enablePositionOfText(true);
                break;
            }
            case 1: {
                this.showSlidePositionFeature.setValue((Object)1);
                ((ControllerPane)this.context.getController()).enablePositionOfText(iAmChair);
                break;
            }
            default: {
                this.showSlidePositionFeature.setValue((Object)0);
                ((ControllerPane)this.context.getController()).enablePositionOfText(false);
            }
        }
    }

    @Override
    public void onAddClient(ClientEvent e) {
        this.initComponents(e);
        if (e.isMe()) {
            byte counterSetting = this.clients.getProperty("show.counter", this.defaultShowScreenCounter);
            if (counterSetting == -1) {
                counterSetting = this.defaultShowScreenCounter;
            }
            this.showScreenCounter(counterSetting, ChairProtocol.getChair((ClientList)this.clients).isMe());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComponents(ClientEvent event) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (event != null && event.isMe()) {
                String displayName = this.clients == null || this.clients.get(event.getName()) == null ? event.getName() : this.clients.get(event.getName()).getDisplayName();
                this.context.getIDProcessor().setMyAddress(event.getAddress());
                this.context.getDataModel().getPrivateScreens().setScreenNameLocal(this.i18n.getString((PropertiesEnum)StringsProperties.DATAMODEL_DEFAULTWORKGROUPNAME) + " (" + displayName + ")", true);
                this.context.setClientOnline(true);
                if (this.selectAllSelectedToolsFeature != null) {
                    this.broker.setFeaturePublished((Feature)this.selectAllSelectedToolsFeature, true);
                }
                if (this.proprietaryContentFeature != null) {
                    this.broker.setFeaturePublished((Feature)this.proprietaryContentFeature, true);
                }
            }
        }
    }

    @Override
    public void onRemoveClient(ClientEvent e) {
        this.removeClient(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(ClientEvent e) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.context.getACLManager().removeClient(e);
            this.context.getDataExporter().offLineParticipant(ShortList.get((short)e.getAddress()));
            if (e.isMe()) {
                this.context.setClientOnline(false);
                this.proprietaryContentFeature.setEnabled(false);
                this.broker.setFeaturePublished((Feature)this.proprietaryContentFeature, false);
            }
            this.context.getChairManager().updateChair();
            if (this.selectAllSelectedToolsFeature != null && e.isMe()) {
                this.broker.setFeaturePublished((Feature)this.selectAllSelectedToolsFeature, false);
            }
        }
    }

    public void channelStateChanged(ChannelEvent e) {
        switch (e.getState()) {
            case 1: {
                if (e.getSource() instanceof Channel) {
                    this.context.getDataProcessor().setChannel((Channel)e.getSource());
                }
                if (!this.context.getDataProcessor().areChannelsUp()) break;
                this.context.setRegistryOnline(true);
                this.context.getDataProcessor().sendDirective((byte)2, null);
                String name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SHOWVIEWEDSCREENS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant")});
                this.showViewedScreensFeature.setName(name);
                if (this.selectAllSelectedToolsFeature == null) break;
                name = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SELECTSELECTEDTOOLS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant")});
                this.selectAllSelectedToolsFeature.setName(name);
                break;
            }
            case 2: {
                this.context.getChairManager().updateChair();
                this.context.setChair(false);
                this.context.setRegistryOnline(false);
                if (!(e.getSource() instanceof Channel)) break;
                this.context.getDataProcessor().setChannel((Channel)e.getSource());
                break;
            }
        }
    }

    public boolean protectWhiteboardCmd(boolean protect) {
        boolean isModerator;
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        boolean bl = isModerator = chair != null && chair.isMe();
        if (!isModerator) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        if (this.context.getController() == null) {
            return false;
        }
        this.proprietaryContentFeature.setValue((Object)protect);
        this.context.getClientList().setProperty("whitebordProprietaryContent", protect);
        ControllerPane cp = (ControllerPane)this.context.getController();
        if (cp != null) {
            cp.enableProprietaryWhiteboards(protect, false);
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        Chair chair = ChairProtocol.getChair((Connection)this.client);
        if (GroupwareDebug.EVENTS.show()) {
            LogSupport.message((Object)this, (String)"propertyChange", (String)e.toString());
        }
        if (property.equals("globalMediaCacheSize") && e.getNewValue() instanceof Long) {
            this.context.getMediaCache().setMaxImageCache(((Long)e.getNewValue()).longValue(), false);
            return;
        }
        if (property.equals("globalMediaBufferSize") && e.getNewValue() instanceof Long) {
            this.context.getMediaCache().setMaxImageInstance(((Long)e.getNewValue()).longValue(), false);
            return;
        }
        if (property.equals("chair")) {
            if (this.context.isOnline() && this.context.getChairManager() != null) {
                this.context.getChairManager().updateChair();
            }
            String modText = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SHOWPOSITIONTOMODERATORS, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderators")});
            this.showSlidePositionFeature.setValueText((Object)1, modText);
            this.broker.setFeaturePublished(this.showSlidePositionFeature, chair.isMe());
            this.showScreenCounter(this.clients.getProperty("show.counter", this.defaultShowScreenCounter), chair.isMe());
            this.enableSelectionItems();
        }
        if (property.equals("show.counter") && e.getNewValue() instanceof Byte && e.getOldValue() instanceof Byte && ((Byte)e.getNewValue()).byteValue() != ((Byte)e.getOldValue()).byteValue()) {
            this.showScreenCounter((Byte)e.getNewValue(), chair.isMe());
        }
        if (property.equals("whitebordProprietaryContent") && e.getNewValue() instanceof Boolean) {
            boolean cannotSave = (Boolean)e.getNewValue();
            this.proprietaryContentFeature.setValue((Object)cannotSave);
            if (this.context.getController() != null) {
                ((ControllerPane)this.context.getController()).enableProprietaryWhiteboards(cannotSave, false);
            }
        }
        if (property.equals("defaultGroupName") && e.getNewValue() instanceof String) {
            this.context.setDefaultPublicGroupName((String)e.getNewValue());
        } else if (property.equals("defaultScreenName") && e.getNewValue() instanceof String) {
            this.context.setDefaultPublicScreenName((String)e.getNewValue());
        }
        ((ControllerPane)this.context.getController()).propertyChange(e);
    }

    public void onChannelData(ChannelDataEvent e) {
        if (e.getChannel().equals("whiteboardCommand")) {
            try {
                ClientInfo ci = this.clients.get(e.getSourceAddress());
                if (ci != null && !ci.isMe()) {
                    switch (e.getCommand()) {
                        default: {
                            this.context.getDataProcessor().onChannelData(e);
                            break;
                        }
                        case 1: {
                            this.context.getDataProcessor().onChannelData(e);
                            break;
                        }
                        case 3: {
                            ClientSendsScreenSynch synch = new ClientSendsScreenSynch(this.context);
                            synch.setOnline(this.context.getIDProcessor().getMyId(), this.context.getConferenceUID(), this.clients.getMyDisplayName());
                            this.context.getDataProcessor().sendDirective((byte)6, (StreamableObject)synch);
                            break;
                        }
                        case 8: {
                            Validator.validate((String)"WhiteboardBean.onlineValidation", (WhiteboardContext)this.context);
                        }
                    }
                }
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"OnChannelData", (Throwable)t, (boolean)true);
            }
        } else {
            this.context.getDataProcessor().onChannelData(e);
        }
    }

    public void noteActivity(Short clientId, WBNode node) {
        try {
            Short clientAddress = this.context.getIDProcessor().getClientAddress(clientId);
            if (clientAddress != null) {
                ClientInfo ci = this.context.getClientList().get(clientAddress.shortValue());
                this.noteWhiteboardActivity(ci);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"noteActivity", (Throwable)ex, (boolean)true);
        }
    }

    private void noteWhiteboardActivity(ClientInfo ci) {
        if (!this.context.isOnline() || ci == null) {
            return;
        }
        ci.setProperty("whiteboardActive", true);
        long activityPulseTime = this.clients.getProperty("whiteboardActiveIndicatorTime", 0);
        this.context.getTimedExecution().addRunnable(System.currentTimeMillis() + activityPulseTime, (Object)ci, (Runnable)new NoteWhiteboardActivity(ci));
    }

    public void setScreenTitle(String title) {
        if (this.contentCapture != null) {
            this.contentCapture.setTitle(title);
        }
    }

    public void setTitleScreenName(String name) {
        this.titleText = name;
        this.displayTitleText();
    }

    public void displayTitleText() {
    }

    public void enableOneButtonOperation(boolean setting) {
        this.oneButtonOperationFeature.setValue((Object)setting);
        if (this.context != null) {
            ((ControllerPane)this.context.getController()).enableOneButtonOperation(setting);
        }
    }

    private void initializeSwing() {
        if (this.titleText != null) {
            this.setTitleScreenName(this.titleText);
        }
        if (this.context.getController() != null) {
            ((ControllerPane)this.context.getController()).onSwingInitialized(this.getAppFrame(), this.broker);
            Boolean proprietaryContentProperty = (Boolean)this.context.getClientList().getProperty("whitebordProprietaryContent");
            if (proprietaryContentProperty == null) {
                proprietaryContentProperty = false;
            }
            this.proprietaryContentFeature.setValue((Object)proprietaryContentProperty);
            ControllerPane cp = (ControllerPane)this.context.getController();
            if (cp != null) {
                cp.enableProprietaryWhiteboards(proprietaryContentProperty, false);
            }
        }
        this.module.enablePalettes();
        this.broker.setFeaturePublished((Feature)this.copyMainRoomToRoomsFeature, true);
        this.broker.setFeaturePublished((Feature)this.copyRoomsToMainRoomFeature, true);
        if (this.selectAllSelectedToolsFeature != null) {
            this.broker.setFeaturePublished((Feature)this.selectAllSelectedToolsFeature, true);
        }
    }

    public void setAppFrame(Frame top) {
        this.swinger.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                WhiteboardBean.this.initializeSwing();
            }
        });
        this.broker.setFeaturePublished((Feature)this.showThumbnailsFeature, true);
        this.broker.setFeaturePublished(this.showSlidePositionFeature, ChairProtocol.getChair((Connection)this.client).isMe());
        this.broker.setFeaturePublished((Feature)this.copyMainRoomToRoomsFeature, true);
        this.broker.setFeaturePublished((Feature)this.copyRoomsToMainRoomFeature, true);
        if (this.validateDataModelFeature != null) {
            this.broker.setFeaturePublished((Feature)this.validateDataModelFeature, true);
        }
    }

    public void uninstall() {
        this.setVisible(false);
        this.broker.setFeaturePublished((Feature)this.selectedToolInfoFeature, false);
        if (this.selectAllSelectedToolsFeature != null) {
            this.broker.setFeaturePublished((Feature)this.selectAllSelectedToolsFeature, false);
        }
        if (this.validateDataModelFeature != null) {
            this.broker.setFeaturePublished((Feature)this.validateDataModelFeature, false);
        }
        this.context.svcStop();
    }

    public void onSelect(AbstractToolModel tool, boolean selected) {
        this.enableSelectionItems();
    }

    public void enableSelectionItems() {
        boolean isBridge = false;
        boolean isChair = ChairProtocol.getChair((ClientList)this.clients).isMe();
        ControllerPane controller = (ControllerPane)this.context.getController();
        boolean enable = controller.getScreen().isAccessible();
        List who = null;
        if (this.selector != null) {
            who = this.selector.getSelectedParticipants();
        }
        boolean participants = who != null && who.size() > 0;
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        if (telephony != null && participants) {
            isBridge = true;
            for (CRParticipant part : who) {
                if (telephony.isBridge(part.getID())) continue;
                isBridge = false;
                break;
            }
        }
        this.broker.setFeaturePublished((Feature)this.showViewedScreensFeature, participants && !isBridge && isChair);
        if (this.selectAllSelectedToolsFeature != null) {
            this.selectAllSelectedToolsFeature.setEnabled(enable);
        }
        this.selectedToolInfoFeature.setEnabled(enable);
        int selectedGroupCount = 0;
        boolean justGroupsSelected = false;
        if (this.selector != null) {
            selectedGroupCount = this.selector.getSelectedRoomCount();
            justGroupsSelected = selectedGroupCount != 0 && this.selector.getSelectedParticipantCount() == 0;
        }
        String name = this.i18n.getString((PropertiesEnum)(selectedGroupCount > 1 ? StringsProperties.WHITEBOARDBEAN_COPYROOMSTOMAINROOM : StringsProperties.WHITEBOARDBEAN_COPYROOMTOMAINROOM));
        this.copySelectedRoomsToMainRoomFeature.setName(name);
        this.broker.setFeaturePublished((Feature)this.copySelectedRoomsToMainRoomFeature, isChair && justGroupsSelected);
    }

    private void showSelectedToolInformation() {
    }

    public void addShowThumbnailsListener(ShowThumbnailsListener l) {
        this.thumbnailsListeners.add((Object)l);
    }

    public void removeShowThumbnailsListener(ShowThumbnailsListener l) {
        this.thumbnailsListeners.remove((Object)l);
    }

    private void fireShowThumbnailsListeners() {
        FiringFunctor<ShowThumbnailsListener> ff = new FiringFunctor<ShowThumbnailsListener>(){
            private ShowThumbnailsEvent ev = null;

            public void fire(ShowThumbnailsListener l) {
                if (this.ev == null) {
                    this.ev = new ShowThumbnailsEvent();
                }
                l.showThumbnailsChanged(this.ev);
            }
        };
        Runnable r = new Runnable((FiringFunctor)ff){
            final /* synthetic */ FiringFunctor val$ff;
            {
                this.val$ff = firingFunctor;
            }

            @Override
            public void run() {
                WhiteboardBean.this.thumbnailsListeners.fire(this.val$ff);
            }
        };
        this.swinger.invokeOnEventThread(r);
    }

    public boolean areThumbnailsShowing() {
        return (Boolean)this.showThumbnailsFeature.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamingMediaListener(StreamingMediaListener l) {
        ArrayList arrayList = this.canvasListeners;
        synchronized (arrayList) {
            if (!this.canvasListeners.contains(l)) {
                this.canvasListeners.add(l);
                try {
                    l.setVisible(this.wbdComponent.isVisible(), System.currentTimeMillis());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public String getProvider() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_STREAMINGMEDIAAPI_PROVIDERWHITEBOARD);
    }

    public String getSourceName() {
        return "Whiteboard";
    }

    public String getTrackName() {
        return "";
    }

    public byte getTier() {
        return 32;
    }

    public int getMediaType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreamingMediaListener(StreamingMediaListener l) {
        ArrayList arrayList = this.canvasListeners;
        synchronized (arrayList) {
            this.canvasListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintToStream(ScalableComponent comp, Rectangle clip) {
        ArrayList arrayList = this.canvasListeners;
        synchronized (arrayList) {
            for (StreamingMediaListener l : this.canvasListeners) {
                try {
                    l.imageUpdate(comp, clip, System.currentTimeMillis());
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamVisible(boolean visible) {
        ArrayList arrayList = this.canvasListeners;
        synchronized (arrayList) {
            for (StreamingMediaListener l : this.canvasListeners) {
                try {
                    l.setVisible(visible, System.currentTimeMillis());
                }
                catch (Throwable t) {}
            }
        }
    }

    public void saveComplete() {
        this.documentChanged = false;
    }

    public void clientGroupCreated(ClientGroupEvent event) {
        boolean chair = ChairProtocol.getChair((Connection)this.context.getClientList().getConnection()).isMe();
        this.broker.setFeaturePublished((Feature)this.copyAllRoomsToMainRoomFeature, chair);
        int roomCount = this.clients != null ? this.clients.getGroupCount() : 0;
        ScreenModel scr = this.context.getController().getScreen();
        boolean mainRoomSelected = scr != null && scr.getRoot() != null && scr.getRoot().getGroupID() == 0;
        this.copyMainRoomToRoomsFeature.setEnabled(roomCount > 1 && mainRoomSelected);
        this.copyRoomsToMainRoomFeature.setEnabled(roomCount > 1);
    }

    public void clientGroupDeleted(ClientGroupEvent event) {
        boolean chair = ChairProtocol.getChair((Connection)this.context.getClientList().getConnection()).isMe();
        int roomCount = this.clients != null ? this.clients.getGroupCount() : 0;
        this.broker.setFeaturePublished((Feature)this.copyAllRoomsToMainRoomFeature, chair && roomCount > 2);
        ScreenModel scr = this.context.getController().getScreen();
        boolean mainRoomSelected = scr != null && scr.getRoot() != null && scr.getRoot().getGroupID() == 0;
        this.copyMainRoomToRoomsFeature.setEnabled(roomCount > 2 && mainRoomSelected);
        this.copyRoomsToMainRoomFeature.setEnabled(roomCount > 2);
    }

    public void clientGroupChanged(ClientGroupEvent event) {
    }

    public void clientGroupRenamed(ClientGroupEvent event) {
    }

    public void onCanvasChange() {
        int roomCount = this.clients != null ? this.clients.getGroupCount() : 0;
        ScreenModel scr = this.context.getController().getScreen();
        boolean mainRoomSelected = scr != null && scr.getRoot().getGroupID() == 0;
        this.copyMainRoomToRoomsFeature.setEnabled(roomCount > 1 && mainRoomSelected);
    }

    public boolean isPlayback() {
        return this.clientProvider != null && this.clientProvider.get() != null ? this.clientProvider.get().getConnectionType().equals((Object)Connection.Type.PLAYBACK_CLIENT) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component get(ComponentFeature feature) {
        Object object = this.componentLock;
        synchronized (object) {
            if (this.wbdComponent == null && this.swinger.isEventDispatchThread()) {
                throw new RuntimeException("Component not ready, throwing to avoid blocking EDT.");
            }
            while (this.wbdComponent == null) {
                try {
                    this.componentLock.wait();
                }
                catch (InterruptedException ix) {
                    // empty catch block
                    break;
                }
            }
            return this.wbdComponent;
        }
    }

    private static class CacheMonitor
    extends JLabel
    implements Runnable,
    PropertyChangeListener {
        private I18n i18n = I18n.create((Object)this);
        private MediaCache cache = null;

        CacheMonitor(MediaCache cache) {
            this.cache = cache;
            this.update(0L, 0L, 0L, 0L);
        }

        void update(long curMedia, long maxMedia, long curImage, long maxImage) {
            int percentMedia = maxMedia > 0L ? (int)((curMedia * 100L + maxMedia / 2L) / maxMedia) : 0;
            int percentImage = maxImage > 0L ? (int)((curImage * 100L + maxImage / 2L) / maxImage) : 0;
            String text = this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_CACHEMONITOR_MSG, new Object[]{new Long((curMedia + 512L) / 1024L), new Long((maxMedia + 512L) / 1024L), new Integer(percentMedia), new Long((curImage + 512L) / 1024L), new Long((maxImage + 512L) / 1024L), new Integer(percentImage)});
            this.setText(text);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.cache.addPropertyChangeListener("cacheSize", (PropertyChangeListener)this);
            this.cache.addPropertyChangeListener("globalMediaCacheSize", (PropertyChangeListener)this);
            this.cache.addPropertyChangeListener("mediaBufferSize", (PropertyChangeListener)this);
            this.cache.addPropertyChangeListener("globalMediaBufferSize", (PropertyChangeListener)this);
            SwingRunnerSupport.invokeLater((Runnable)this);
        }

        @Override
        public void removeNotify() {
            this.cache.removePropertyChangeListener("cacheSize", (PropertyChangeListener)this);
            this.cache.removePropertyChangeListener("globalMediaCacheSize", (PropertyChangeListener)this);
            this.cache.removePropertyChangeListener("mediaBufferSize", (PropertyChangeListener)this);
            this.cache.removePropertyChangeListener("globalMediaBufferSize", (PropertyChangeListener)this);
            super.removeNotify();
        }

        @Override
        public void run() {
            this.update(this.cache.getCacheSize(), this.cache.getMaxImageCache(), this.cache.getInstanceSize(), this.cache.getMaxImageInstance());
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SwingRunnerSupport.invokeLater((Runnable)this);
        }
    }

    private class DocumentHandler
    implements DocumentHandlingAPI {
        private DocumentHandler() {
        }

        public String getProvider() {
            return WhiteboardBean.this.module.getNameOfModule();
        }

        public byte getTier() {
            return 32;
        }

        public void newDocument() {
            WhiteboardBean.this.documentChanged = true;
        }

        public boolean openDocument(File file) {
            int currentIndex;
            ScreenModel parent;
            ((WhiteboardBean)WhiteboardBean.this).context.fileToLoad = file;
            ArrayList<ScreenModel> screensToDelete = new ArrayList<ScreenModel>();
            ControllerPaneInterface ctrl = WhiteboardBean.this.context.getController();
            ScreenModel currentScreen = ctrl.getScreen();
            if (currentScreen.isPrivate()) {
                ((WhiteboardBean)WhiteboardBean.this).context.fileToSave = file;
                ScreenRoot pri = WhiteboardBean.this.context.getDataModel().getPrivateScreens();
                for (int i = 0; i < pri.getScreenCount(); ++i) {
                    ScreenModel scr = (ScreenModel)pri.getScreenAt(i);
                    if (scr.getToolCount() != 0) {
                        screensToDelete.clear();
                        break;
                    }
                    screensToDelete.add(scr);
                }
            }
            if (currentScreen instanceof ScreenRoot) {
                parent = currentScreen;
                currentIndex = -1;
            } else {
                parent = currentScreen.getScreenParent();
                currentIndex = parent.getIndex((WBNode)currentScreen);
            }
            DisplayNode pathPeer = new DisplayNode();
            pathPeer.setUserObject((Object)parent);
            TreePath path = new TreePath(pathPeer);
            if (currentIndex != -1 && currentIndex + 1 < parent.getScreenCount()) {
                ScreenModel newScreen = (ScreenModel)parent.getScreenAt(currentIndex + 1);
                ctrl.gotoUIScreen(newScreen.getObjectID(), false);
            }
            if (screensToDelete.size() != 0) {
                ActionUtilities.deleteScreens((WBNode[])screensToDelete.toArray(new ScreenModel[0]), (WhiteboardContext)WhiteboardBean.this.context);
            }
            return true;
        }

        public boolean closeDocuments() {
            if (WhiteboardBean.this.documentChanged) {
                int save = ModalDialog.showConfirmDialog((Component)WhiteboardBean.this.wbdComponent, (Object)WhiteboardBean.this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_PROMPTCHANGED), (String)WhiteboardBean.this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_PROMPTCHANGEDTITLE), (int)1, (int)3);
                switch (save) {
                    case 0: {
                        WhiteboardBean.this.controller.saveDocument();
                        break;
                    }
                    case 1: {
                        WhiteboardBean.this.documentChanged = false;
                        break;
                    }
                }
            }
            return !WhiteboardBean.this.documentChanged;
        }
    }

    private class FileConversionHandler
    implements FileConversionAPI {
        private ArrayList convertibleExtensions = new ArrayList();

        public FileConversionHandler() {
            if (PresentationImport.isSupported("powerpoint")) {
                PresentationInterface pp = PresentationImport.presentationFactory("powerpoint");
                this.convertibleExtensions.add("ppt");
                if (pp.accept(new File("check.pptx"))) {
                    this.convertibleExtensions.add("pptx");
                }
            }
            this.convertibleExtensions.add("png");
            this.convertibleExtensions.add("jpg");
            this.convertibleExtensions.add("jpeg");
            this.convertibleExtensions.add("gif");
            this.convertibleExtensions.add("bmp");
        }

        void initConvertibleExtensions() {
            if (PresentationImport.isSupported("staroffice")) {
                PresentationInterface oo = PresentationImport.presentationFactory("staroffice");
                this.convertibleExtensions.add("sxi");
                this.convertibleExtensions.add("odp");
                if (!this.convertibleExtensions.contains("ppt")) {
                    this.convertibleExtensions.add("ppt");
                }
                if (!this.convertibleExtensions.contains("pptx") && oo.accept(new File("check.pptx"))) {
                    this.convertibleExtensions.add("pptx");
                }
            }
        }

        public String getProvider() {
            return WhiteboardBean.this.module.getNameOfModule();
        }

        public byte getTier() {
            return 32;
        }

        public boolean canConvert(String fromExtension) {
            return this.convertibleExtensions.contains(fromExtension.toLowerCase(Locale.ENGLISH));
        }

        public File convert(File file, String toExtension, Map options) throws IOException {
            String ext = WhiteboardFileUtilities.getFilenameExtension(file.getName());
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            if (!this.canConvert(ext)) {
                throw new IOException("File cannot be converted, unknown file type: " + ext);
            }
            if (!toExtension.toLowerCase(Locale.ENGLISH).equals("wbd")) {
                throw new IOException("Unknown output type: " + toExtension);
            }
            return this.convertToWBD(file);
        }

        private File convertToWBD(File file) throws IOException {
            try {
                WhiteboardContext whiteboardContext = WhiteboardBean.this.context;
                WhiteboardBean.this.context;
                WhiteboardBean.this.context;
                WhiteboardModel wbModel = FileUtils.getLoadModel(whiteboardContext, file, false, 1014, 835);
                if (wbModel == null) {
                    return null;
                }
                String base = WhiteboardFileUtilities.getFilenameBase(file.getName());
                File f = this.createNamedTempFile(base, ".wbd");
                f.deleteOnExit();
                WhiteboardDataFile jdom = new WhiteboardDataFile(WhiteboardBean.this.context);
                jdom.writeData(f, new ScreenModel[]{wbModel}, (ProgressUpdate)new NoUIProgress());
                wbModel.delete();
                return f;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
        }

        private File createNamedTempFile(String base, String extension) throws IOException {
            File fo = new File(System.getProperty("java.io.tmpdir"));
            File f = new File(fo, base + extension);
            int index = 1;
            while (f.exists()) {
                f = new File(fo, base + ++index + extension);
            }
            f.createNewFile();
            return f;
        }
    }

    private class FilePreviewAPI
    implements WhiteboardFilePreviewAPI {
        private FilePreviewAPI() {
        }

        public String getProvider() {
            return WhiteboardBean.this.module.getNameOfModule();
        }

        public byte getTier() {
            return 32;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WhiteboardScreenNode readWhiteboard(File file) throws IOException {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                WhiteboardScreenNode whiteboardScreenNode = this.readWhiteboard(in);
                return whiteboardScreenNode;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WhiteboardScreenNode readWhiteboard(URL url) throws IOException {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(url.openStream());
                WhiteboardScreenNode whiteboardScreenNode = this.readWhiteboard(in);
                return whiteboardScreenNode;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }

        public WhiteboardScreenNode readWhiteboard(BufferedInputStream inputStream) throws IOException {
            boolean docChanged = WhiteboardBean.this.documentChanged;
            try {
                ScreenNode root = null;
                WhiteboardDataFile wbdf = new WhiteboardDataFile(WhiteboardBean.this.context);
                if (wbdf.readDataStream(inputStream)) {
                    NoUIProgress progress = new NoUIProgress();
                    WhiteboardModel model = wbdf.processJDOM(wbdf, WhiteboardBean.this.context, (ProgressUpdate)progress);
                    if (model != null) {
                        root = this.makeScreenNode((ScreenModel)model);
                    }
                    model.delete();
                }
                ScreenNode screenNode = root;
                return screenNode;
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            finally {
                WhiteboardBean.this.documentChanged = docChanged;
            }
        }

        private ScreenNode makeScreenNode(ScreenModel model) {
            List list;
            StringBuffer b = new StringBuffer();
            PresentersNote notes = model.getPresentersNotes();
            if (notes != null && (list = notes.getPresentersNotes()) != null) {
                Iterator itr = list.iterator();
                while (itr.hasNext()) {
                    if (b.length() != 0) {
                        b.append("\n\n");
                    }
                    b.append(itr.next());
                }
            }
            ScreenNode node = new ScreenNode(model.getScreenName(), b.toString());
            for (int i = 0; i < model.getScreenCount(); ++i) {
                ScreenModel scr = (ScreenModel)model.getScreenAt(i);
                node.add(this.makeScreenNode(scr));
            }
            return node;
        }

        private class ScreenNode
        implements WhiteboardScreenNode {
            private String name;
            private String presenterNotes;
            private ScreenNode parent;
            private ArrayList children = new ArrayList();

            public ScreenNode(String name, String presenterNotes) {
                this.name = name;
                this.presenterNotes = presenterNotes;
            }

            public String getName() {
                return this.name;
            }

            public String getPresenterNotes() {
                return this.presenterNotes;
            }

            public WhiteboardScreenNode getParent() {
                return this.parent;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(ScreenNode node) {
                ArrayList arrayList = this.children;
                synchronized (arrayList) {
                    this.children.add(node);
                    node.parent = this;
                }
            }

            public int getChildCount() {
                return this.children.size();
            }

            public WhiteboardScreenNode getChild(int index) {
                return (WhiteboardScreenNode)this.children.get(index);
            }
        }
    }

    private class InteractionAPI
    implements WhiteboardInteractionAPI {
        private InteractionAPI() {
        }

        public String getProvider() {
            return WhiteboardBean.this.module.getNameOfModule();
        }

        public byte getTier() {
            return 32;
        }

        public Dimension showScreenSizeDialog(Frame owner) {
            int width = 0;
            int height = 0;
            ScreenModel scr = WhiteboardBean.this.context.getController().getScreen();
            if (scr != null) {
                Dimension s = scr.getScreenSize();
                width = s.width;
                height = s.height;
            }
            SizeDialog d = new SizeDialog(WhiteboardBean.this.context, WhiteboardBean.this.i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_SIZEDIALOGTITLE), true, width, height, 2000, 2000);
            d.setVisible(true);
            if (!d.wasCanceled()) {
                return new Dimension(d.getScreenWidth(), d.getScreenHeight());
            }
            return null;
        }
    }

    class NoteWhiteboardActivity
    implements Runnable {
        ClientInfo ci = null;

        public NoteWhiteboardActivity(ClientInfo ciIn) {
            this.ci = ciIn;
        }

        @Override
        public void run() {
            this.ci.setProperty("whiteboardActive", false);
        }
    }

    class PublishedComponent
    extends JPanel {
        public PublishedComponent() {
            this.enableEvents(8L);
        }
    }

    class QueryScaleFactor
    implements Runnable {
        WBScaler scaler;

        public QueryScaleFactor(WBScaler scaler) {
            this.scaler = scaler;
        }

        @Override
        public void run() {
            String scaleString = JOptionPane.showInputDialog(WhiteboardBean.this.controller, (Object)WhiteboardBean.this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_SCALE_INPUT_TITLE));
            if (scaleString != null && scaleString.length() > 0) {
                try {
                    WhiteboardBean.this.customScale.initArgument(scaleString);
                    WhiteboardBean.this.context.setScaler(this.scaler);
                    WhiteboardBean.this.context.getController().processScaleChange();
                }
                catch (Exception e) {
                    WhiteboardBean.this.customScale.initArgument(WhiteboardBean.this.percent100.displayName());
                }
            }
            WhiteboardBean.this.scaleSelectorFeature.addValueChangeListener((MetaDataListener)WhiteboardBean.this);
        }
    }

    class RemoveClient
    implements Runnable {
        ClientEvent e;

        public RemoveClient(ClientEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            WhiteboardBean.this.removeClient(this.e);
        }
    }

    public class ShowThumbnailsEvent {
        public boolean isShowingThumbnails() {
            return WhiteboardBean.this.areThumbnailsShowing();
        }
    }

    public static interface ShowThumbnailsListener {
        public void showThumbnailsChanged(ShowThumbnailsEvent var1);
    }

    class WBScalerCustom
    extends WBScaler {
        private boolean initialized;

        public WBScalerCustom(WhiteboardContext context) {
            super(WhiteboardBean.this.i18n.getString((PropertiesEnum)StringsProperties.CUSTOM_STRING), 1.0, 1.0, context);
            this.initialized = false;
        }

        protected void initArgument(String value) {
            if (value != null) {
                int percent = (value = value.replace("%", "").trim()).length() == 0 ? 0 : (int)Double.parseDouble(value);
                if (percent < 10) {
                    percent = 10;
                } else if (percent > 1000) {
                    percent = 1000;
                }
                this.scaleY = this.scaleX = (double)percent / 100.0;
                this.initialized = true;
            }
        }

        public void initialize() {
            String value = JOptionPane.showInputDialog(WhiteboardBean.this.wbdComponent, (Object)"Enter scale factor;");
            this.initArgument(value);
        }

        public String displayName() {
            if (this.initialized) {
                return "" + (int)(this.scaleX * 100.0) + "%";
            }
            return super.toString();
        }

        public String generateArgument() {
            int scaleInt = (int)(this.scaleX * 100.0);
            String str = super.toString() + scaleInt;
            return str;
        }

        public String toString() {
            return this.displayName();
        }
    }

    class WBScalerFitToWindow
    extends WBScaler {
        public WBScalerFitToWindow(WhiteboardContext context, String name, int mode) {
            super(name, context, mode);
            this.autoScaler = true;
        }
    }

    private class WhiteboardAnnotationProvider
    implements PropertyChangeListener {
        private WhiteboardAnnotationProvider() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (WhiteboardBean.this.clients == null) {
                return;
            }
            String propertyName = evt.getPropertyName();
            short ownerId = WhiteboardBean.this.clients.getPropertyOwner(evt.getSource());
            ClientInfo ci = WhiteboardBean.this.clients.get(ownerId);
            if (ci == null) {
                return;
            }
            if (propertyName.equals("whiteboardActive")) {
                boolean active = ci.getProperty("whiteboardActive", false);
                if (active) {
                    WhiteboardBean.this.sessionModel.setAnnotationValue(ownerId, "WhiteboardActivityAnnotation", (Object)1);
                } else {
                    WhiteboardBean.this.sessionModel.setAnnotationValue(ownerId, "WhiteboardActivityAnnotation", (Object)0);
                }
            } else if (propertyName.equals("whiteboardYellowStatus") || propertyName.equals("whiteboardRedStatus")) {
                boolean status_low = ci.getProperty("whiteboardYellowStatus", false);
                boolean status_high = ci.getProperty("whiteboardRedStatus", false);
                if (status_high) {
                    WhiteboardBean.this.sessionModel.setAnnotationValue(ownerId, "WhiteboardLagAnnotation", (Object)2);
                } else if (status_low) {
                    WhiteboardBean.this.sessionModel.setAnnotationValue(ownerId, "WhiteboardLagAnnotation", (Object)1);
                } else {
                    WhiteboardBean.this.sessionModel.setAnnotationValue(ownerId, "WhiteboardLagAnnotation", (Object)0);
                }
            }
        }
    }
}

