/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.InfoDotPlist;
import com.elluminate.groupware.whiteboard.module.StarOfficeLoaderInterface;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.presentations.StarOfficeClassLoader;
import com.elluminate.platform.Platform;
import com.elluminate.platform.VersionSupport;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.IOException;

public class StarOfficeInformation {
    private static I18n i18n = I18n.create((Object)new Object(){});
    public static final String STAR_OFFICE_PATH_PREF = ".StarOfficeAppPath";
    public static final String STAR_OFFICE_PATH_DEFAULT = "";
    public static String[] JARS = new String[]{"jurt.jar", "ridl.jar", "unoil.jar", "juh.jar"};
    public static final String[] STAR_OFFICE_EXTENSIONS = new String[]{"sxi", "sdd", "sdp", "odp", "sti", "otp"};
    public static final String MAC_OOo1x_BUNDLE_ID = "org.OpenOffice.Start";
    public static final String MAC_OOo2x_BUNDLE_ID = "org.openoffice.script";
    public static final String MAC_OOo_BUNDLE_NAME = "OpenOffice.org";
    public static final String MAC_SSO9b_BUNDLE_ID = "org.openoffice.script";
    public static final String MAC_SSO_BUNDLE_NAME = "StarOffice";
    private static final String[] MAC_OOo2x_BUNDLE_LAUNCH_PATH = new String[]{"Contents/MacOS/soffice", "Contents/MacOS/program/soffice"};
    private static String invalidReason = "";
    private static StarOfficeInformation instance = null;
    private static boolean isValidInstallation;
    private String starOfficeProgramPath;
    private String starOfficeApplicationPath;
    private String[] starOfficeClassPath;
    private String starOfficeExecutable = null;
    private boolean running = false;
    private boolean needX11 = false;
    private StarOfficeLoaderInterface loader = null;
    private static boolean readsPptxFormatFiles;

    private StarOfficeInformation() {
        this.resetData();
    }

    public static StarOfficeInformation instance() {
        if (instance == null) {
            instance = new StarOfficeInformation();
        }
        return instance;
    }

    private void resetData() {
        this.starOfficeProgramPath = STAR_OFFICE_PATH_DEFAULT;
        this.starOfficeApplicationPath = STAR_OFFICE_PATH_DEFAULT;
        this.starOfficeClassPath = null;
        this.starOfficeExecutable = STAR_OFFICE_PATH_DEFAULT;
        this.needX11 = false;
        this.running = false;
        invalidReason = "Installation Information Cleared";
        isValidInstallation = false;
        readsPptxFormatFiles = true;
        this.disposeLoader();
    }

    public String toString() {
        return "StarOfficeInformation programPath=" + this.starOfficeProgramPath + " applicationPath=" + this.starOfficeApplicationPath + " classPath=" + this.starOfficeClassPath + " exe=" + this.starOfficeExecutable + " valid=" + isValidInstallation + (this.needX11 ? " needsX11" : STAR_OFFICE_PATH_DEFAULT) + (this.running ? " running" : STAR_OFFICE_PATH_DEFAULT) + " readsPptxFormatFiles=" + readsPptxFormatFiles;
    }

    public String getStarOfficeProgramPath() {
        return this.starOfficeProgramPath;
    }

    public static boolean canReadPptxFormatFiles() {
        return readsPptxFormatFiles;
    }

    private static boolean containsJARs(File[] dirs) {
        if (dirs == null) {
            return false;
        }
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].isDirectory()) continue;
            return false;
        }
        for (int j = 0; j < JARS.length; ++j) {
            boolean found = false;
            for (int i = 0; i < dirs.length; ++i) {
                File f = new File(dirs[i], JARS[j]);
                if (!f.isFile()) continue;
                found = true;
                break;
            }
            if (found) continue;
            invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_MISSINGJAR, new Object[]{JARS[j]});
            return false;
        }
        return true;
    }

    private static File[] findMacClasses(File bundle) {
        readsPptxFormatFiles = true;
        File contents = new File(bundle, "Contents");
        File[] tmp = new File[]{new File(contents, "basis-link/ure-link/share/java"), new File(contents, "basis-link/program/classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            return tmp;
        }
        readsPptxFormatFiles = false;
        tmp = new File[]{new File(contents, "program/classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            return tmp;
        }
        tmp = new File[]{new File(contents, "MacOS/program/classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            return tmp;
        }
        tmp = new File[]{new File(contents, "MacOS/classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            return tmp;
        }
        File resJava = new File(contents, "Resources/Java");
        tmp = new File[]{new File(resJava, "program/classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            return tmp;
        }
        tmp = new File[]{new File(resJava, "classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            return tmp;
        }
        tmp = new File[]{resJava};
        if (StarOfficeInformation.containsJARs(tmp)) {
            return tmp;
        }
        File parent = new File(bundle.getParent());
        tmp = new File[]{new File(parent, "program/classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            return tmp;
        }
        invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_NOMACCLASSES, new Object[]{bundle.getPath()});
        return null;
    }

    private static File[] findWindowsClasses(File exe) {
        readsPptxFormatFiles = true;
        File[] tmp = new File[]{new File(exe.getParentFile(), "classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            readsPptxFormatFiles = false;
            return tmp;
        }
        File dir = exe.getParentFile();
        if (dir != null) {
            File oodir = dir.getParentFile();
            tmp = new File[]{new File(oodir, "URE\\java"), new File(oodir, "Basis\\program\\classes")};
            if (StarOfficeInformation.containsJARs(tmp)) {
                return tmp;
            }
        }
        invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_NOCLASSES, new Object[]{exe.getPath()});
        return null;
    }

    private static File[] findUnixClasses(File exe) {
        readsPptxFormatFiles = true;
        File[] tmp = new File[]{new File(exe.getParentFile(), "classes")};
        if (StarOfficeInformation.containsJARs(tmp)) {
            readsPptxFormatFiles = false;
            return tmp;
        }
        File dir = exe.getParentFile();
        if (dir != null) {
            File oodir = dir.getParentFile();
            tmp = new File[]{new File(oodir, "basis-link/ure-link/share/java"), new File(oodir, "basis-link/program/classes")};
            if (StarOfficeInformation.containsJARs(tmp)) {
                return tmp;
            }
        }
        invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_NOCLASSES, new Object[]{exe.getPath()});
        return null;
    }

    private static File[] findClassPath(File app) {
        switch (Platform.getPlatform()) {
            case 2: {
                return StarOfficeInformation.findMacClasses(app);
            }
            case 1: {
                return StarOfficeInformation.findWindowsClasses(app);
            }
            case 3: {
                return StarOfficeInformation.findUnixClasses(app);
            }
        }
        return null;
    }

    public String getStarApplicationPath() {
        return this.starOfficeApplicationPath;
    }

    public void setStarOfficeApplicationPath(String starOfficeApplicationPath) {
        block10: {
            if (this.starOfficeApplicationPath == null || starOfficeApplicationPath == null || !this.starOfficeApplicationPath.equals(starOfficeApplicationPath)) {
                this.disposeLoader();
            }
            this.starOfficeApplicationPath = starOfficeApplicationPath;
            File file = null;
            if (starOfficeApplicationPath != null) {
                file = new File(starOfficeApplicationPath);
            }
            if (file != null && file.exists()) {
                try {
                    File canonical = file.getCanonicalFile();
                    if (canonical != null) {
                        file = canonical;
                    }
                }
                catch (Throwable t) {
                    if (WhiteboardDebug.STAROFFICE.show()) {
                        LogSupport.message((Object)this, (String)"setStarOfficeApplicationPath", (String)("Exception getting canonical form of " + file + ": " + Debug.getStackTrace((Throwable)t)));
                    }
                    file = file.getAbsoluteFile();
                }
                try {
                    this.initializePaths(file);
                }
                catch (Exception ex) {
                    if (WhiteboardDebug.STAROFFICE.show()) {
                        LogSupport.message((Object)this, (String)"setStarOfficeApplicationPath", (String)("Exception initializing paths of " + file + ": " + Debug.getStackTrace((Throwable)ex)));
                    }
                    break block10;
                }
            }
            this.resetData();
        }
    }

    public static String getInvalidReason() {
        return invalidReason;
    }

    public String[] getStarOfficeClassPath() {
        return this.starOfficeClassPath;
    }

    public boolean isValid(String[] starOfficeClassPath, String starOfficeApplicationPath) {
        invalidReason = "Valid Installation";
        if (starOfficeApplicationPath == null || starOfficeApplicationPath.length() == 0) {
            invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_EMPTYAPPPATH, new Object[]{"Empty Path"});
            return false;
        }
        try {
            if (starOfficeClassPath == null || starOfficeClassPath.length == 0) {
                invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_NOCLASSES, new Object[]{"Empty Path"});
                return false;
            }
            if (!StarOfficeInformation.isValidApp(starOfficeApplicationPath)) {
                return false;
            }
            File[] dirs = new File[starOfficeClassPath.length];
            for (int i = 0; i < dirs.length; ++i) {
                dirs[i] = new File(starOfficeClassPath[i]);
            }
            return StarOfficeInformation.containsJARs(dirs);
        }
        catch (Throwable t) {
            invalidReason = t.toString();
            if (WhiteboardDebug.STAROFFICE.show()) {
                LogSupport.message((Object)this, (String)"isValid", (String)Debug.getStackTrace((Throwable)t));
            }
            return false;
        }
    }

    public boolean isValid() {
        return isValidInstallation;
    }

    public boolean validateApp() {
        isValidInstallation = StarOfficeInformation.isValidApp(this.starOfficeApplicationPath);
        return isValidInstallation;
    }

    public static boolean isValidApp(String applicationPath) {
        File[] folders;
        if (applicationPath == null || applicationPath.length() == 0) {
            invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_NOAPP);
            return false;
        }
        boolean available = true;
        File app = new File(applicationPath);
        if (Platform.getOS() == 202) {
            File app2;
            if (!app.exists()) {
                invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_BADMACOOOAPP, new Object[]{applicationPath});
                return false;
            }
            String programPath = StarOfficeInformation.findProgramPath(applicationPath);
            if (applicationPath != programPath && programPath != null && !(app2 = new File(programPath)).exists()) {
                invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_BADMACOOOAPP, new Object[]{programPath});
                return false;
            }
            if (Platform.checkOSVersion((int)202, (String)"10.5+")) {
                InfoDotPlist infoPlist = null;
                try {
                    infoPlist = new InfoDotPlist(applicationPath, false);
                    String name = infoPlist.getBundleName();
                    String id = infoPlist.getIdentifier();
                    String ver = infoPlist.getShortVersion();
                    if (id.equals("org.openoffice.script") && name.equals(MAC_OOo_BUNDLE_NAME) && !VersionSupport.matchVersion((String)ver, (String)"3.0+")) {
                        invalidReason = i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEINFORMATION_OLDMACOOOAPP, new Object[]{ver, applicationPath});
                        return false;
                    }
                }
                catch (Throwable t) {}
            }
        } else {
            available = app.isFile();
        }
        if ((folders = StarOfficeInformation.findClassPath(app)) == null || folders.length == 0) {
            return false;
        }
        if (available) {
            for (int i = 0; i < folders.length; ++i) {
                if (folders[i].isDirectory()) continue;
                available = false;
                break;
            }
        }
        if (available && !StarOfficeInformation.containsJARs(folders)) {
            available = false;
            if (WhiteboardDebug.STAROFFICE.show()) {
                LogSupport.message(StarOfficeInformation.class, (String)"isValidApp", (String)("Could not find necessary JARs in " + StarOfficeInformation.concatenatePaths(folders)));
            }
        }
        return available;
    }

    private String initializePaths(File exec) {
        File[] jarDirs = null;
        InfoDotPlist infoPlist = null;
        if (exec != null && exec.exists()) {
            switch (Platform.getOS()) {
                case 202: {
                    try {
                        infoPlist = new InfoDotPlist(exec.getPath(), false);
                        String name = infoPlist.getBundleName();
                        String id = infoPlist.getIdentifier();
                        String ver = infoPlist.getShortVersion();
                        this.needX11 = id.equals(MAC_OOo1x_BUNDLE_ID) || id.equals("org.openoffice.script") && name.equals(MAC_OOo_BUNDLE_NAME) && ver.startsWith("2");
                    }
                    catch (IOException ex) {
                        infoPlist = null;
                        this.needX11 = false;
                    }
                    File efile = new File(exec, "Contents/MacOS/soffice");
                    if (!efile.isFile()) {
                        efile = new File(exec, "Contents/MacOS/program/soffice");
                    }
                    this.starOfficeProgramPath = efile.getPath();
                    this.starOfficeApplicationPath = exec.getPath();
                    jarDirs = StarOfficeInformation.findClassPath(exec);
                    if (jarDirs != null && jarDirs.length != 0) {
                        String[] paths = new String[jarDirs.length];
                        for (int i = 0; i < jarDirs.length; ++i) {
                            paths[i] = jarDirs[i].getAbsolutePath();
                        }
                        this.starOfficeClassPath = paths;
                        this.starOfficeExecutable = this.starOfficeProgramPath;
                        break;
                    }
                    this.starOfficeClassPath = null;
                    break;
                }
                default: {
                    if (exec.isFile()) {
                        this.starOfficeApplicationPath = this.starOfficeProgramPath = exec.getPath();
                        jarDirs = StarOfficeInformation.findClassPath(exec);
                        if (jarDirs != null && jarDirs.length != 0) {
                            String[] paths = new String[jarDirs.length];
                            for (int i = 0; i < jarDirs.length; ++i) {
                                paths[i] = jarDirs[i].getAbsolutePath();
                            }
                            this.starOfficeClassPath = paths;
                            this.starOfficeExecutable = this.starOfficeProgramPath;
                            break;
                        }
                        this.starOfficeClassPath = null;
                        break;
                    }
                    this.resetData();
                    break;
                }
            }
        } else {
            this.resetData();
        }
        isValidInstallation = this.isValid(this.starOfficeClassPath, this.starOfficeApplicationPath);
        if (WhiteboardDebug.STAROFFICE.show()) {
            LogSupport.message((Object)this, (String)"initializePaths", (String)("prog path: " + this.starOfficeProgramPath + "\n    app path: " + this.starOfficeApplicationPath + "\n    class path: " + StringUtils.getStringValue((Object)this.starOfficeClassPath) + (infoPlist != null ? "\n    app bundle: " + infoPlist.getBundleName() + " " + infoPlist.getShortVersion() + " (" + infoPlist.getIdentifier() + ")" + "\n    bundle exe: " + infoPlist.getExecutable() : STAR_OFFICE_PATH_DEFAULT) + (this.needX11 ? "\n    requires X11" : STAR_OFFICE_PATH_DEFAULT) + (isValidInstallation ? "\n    Valid" : "\n    *** NOT VALID *** " + invalidReason)));
        }
        return this.starOfficeProgramPath;
    }

    private static String findProgramPath(String appPath) {
        File app = new File(appPath);
        String starOfficeProgramPath = STAR_OFFICE_PATH_DEFAULT;
        if (app != null && app.exists()) {
            switch (Platform.getOS()) {
                case 202: {
                    File efile = new File(app, "Contents/MacOS/soffice");
                    if (!efile.isFile()) {
                        efile = new File(app, "Contents/MacOS/program/soffice");
                    }
                    if (!efile.isFile()) {
                        efile = new File(app, "Contents/MacOS/soffice.bin");
                    }
                    if (!efile.isFile()) {
                        efile = new File(app, "Contents/MacOS/program/soffice.bin");
                    }
                    if (StarOfficeInformation.findClassPath(app) == null) {
                        starOfficeProgramPath = STAR_OFFICE_PATH_DEFAULT;
                        break;
                    }
                    starOfficeProgramPath = efile.getPath();
                    break;
                }
                default: {
                    if (!app.isFile()) break;
                    File[] jarDirs = StarOfficeInformation.findClassPath(app);
                    starOfficeProgramPath = jarDirs == null || jarDirs.length == 0 ? STAR_OFFICE_PATH_DEFAULT : app.getPath();
                }
            }
        }
        return starOfficeProgramPath;
    }

    public static File getAppByExtensions() {
        for (int i = 0; i < STAR_OFFICE_EXTENSIONS.length; ++i) {
            File execFile = Platform.findAppByExtension((String)STAR_OFFICE_EXTENSIONS[i]);
            if (execFile == null || !execFile.exists()) continue;
            if (WhiteboardDebug.STAROFFICE.show()) {
                LogSupport.message(StarOfficeInformation.class, (String)"getAppByExtensions", (String)(STAR_OFFICE_EXTENSIONS[i] + " => " + execFile));
            }
            return execFile;
        }
        return null;
    }

    public boolean needsX11() {
        return this.needX11;
    }

    public String getStarOfficeExecutable() {
        return this.starOfficeExecutable;
    }

    public void disposeLoader() {
        if (this.loader != null) {
            this.loader.stopStarOffice();
        }
        this.loader = null;
    }

    public StarOfficeLoaderInterface getLoader() {
        return this.loader;
    }

    public StarOfficeLoaderInterface createLoader(I18n i18n, String host, String port) {
        StarOfficeClassLoader classLoader = null;
        if (this.loader != null) {
            this.loader.stopStarOffice();
        }
        if (classLoader == null) {
            classLoader = StarOfficeClassLoader.StarOfficeClassLoaderFactory(this.getClass().getClassLoader());
            classLoader.setClassPath(this.getStarOfficeClassPath());
        }
        try {
            Class loaderClass = classLoader.loadClass("StarOfficeLoader", true);
            this.loader = (StarOfficeLoaderInterface)loaderClass.newInstance();
            this.loader.initialize(host, port, this.getStarOfficeProgramPath(), i18n);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loader = null;
        }
        return this.loader;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public static String concatenatePaths(File[] files) {
        String[] paths = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            paths[i] = files[i].getAbsolutePath();
        }
        return StarOfficeInformation.concatenatePaths(paths);
    }

    public static String concatenatePaths(String[] paths) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            if (b.length() != 0) {
                b.append(File.pathSeparator);
            }
            b.append(paths[i]);
        }
        return b.toString();
    }

    static {
        readsPptxFormatFiles = true;
    }
}

