/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanel;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanelListener;
import com.elluminate.gui.component.EasyDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class SizeDialog
extends EasyDialog
implements ScreenSizePanelListener {
    private int screenWidth;
    private int screenHeight;
    private JButton okButton;
    private ScreenSizePanel sizePanel;

    public SizeDialog(WhiteboardContext context, String title, boolean modal, int defaultWidth, int defaultHeight, int maxWidth, int maxHeight) {
        super((Component)context.getDialogParentFrame(), title, modal);
        this.screenWidth = defaultWidth;
        this.screenHeight = defaultHeight;
        this.sizePanel = new ScreenSizePanel(context, this, maxWidth, maxHeight);
        this.sizePanel.setDefaultSize(new Dimension(this.screenWidth, this.screenHeight));
        this.setContent(this.sizePanel);
        this.addCancelButton(this.makeButton(0));
        this.okButton = this.makeButton(1);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension size;
                if (SizeDialog.this.sizePanel.isSizeValid() && (size = SizeDialog.this.sizePanel.getSize(new Dimension(SizeDialog.this.screenWidth, SizeDialog.this.screenHeight))) != null) {
                    SizeDialog.this.screenHeight = size.height;
                    SizeDialog.this.screenWidth = size.width;
                }
            }
        });
        this.addActionButton(this.okButton, true);
        this.updateOKButtonEnabled();
    }

    private void updateOKButtonEnabled() {
        if (this.sizePanel != null && this.okButton != null) {
            this.okButton.setEnabled(this.sizePanel.isSizeValid());
        }
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    @Override
    public void onScreenSizePanelChange() {
        this.updateOKButtonEnabled();
    }
}

