/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.VisibleObject;
import com.elluminate.groupware.whiteboard.module.pdf.PDFWhiteboardWriter;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public class PDFWriterGraphics {
    public static void processToolToImage(PDFWhiteboardWriter pdf, String title, Iterator tools, int width, int height, ProgressUpdate progress) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2Local = image.createGraphics();
        g2Local.setClip(0, 0, width, height);
        g2Local.setColor(Color.white);
        g2Local.fill(new Rectangle(width, height));
        g2Local.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g2Local.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        while (tools.hasNext()) {
            Object obj = tools.next();
            if (!(obj instanceof VisibleObject)) continue;
            VisibleObject vObj = (VisibleObject)obj;
            try {
                vObj.render((Graphics)g2Local);
            }
            catch (Exception ex) {
                LogSupport.exception(PDFWriterGraphics.class, (String)"constructor", (Throwable)ex, (boolean)true);
            }
            progress.setValue(progress.getValue() + 1);
        }
        pdf.addImage(image, title);
        pdf.newPage(title);
        image.flush();
        image = null;
        g2Local.dispose();
        g2Local = null;
    }
}

