/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.platform.Platform;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class InfoDotPlist {
    private Element plistRoot = null;

    private static File sanitize(File pList) throws IOException {
        File tmpDir = Platform.getTempDir();
        File f = File.createTempFile("elive", null, tmpDir);
        String[] cmd = new String[]{"plutil", "-convert", "xml1", "-o", f.getAbsolutePath(), pList.getAbsolutePath()};
        f.deleteOnExit();
        StringBuffer out = new StringBuffer();
        int status = ProcessUtils.exec((String[])cmd, (StringBuffer)out, (StringBuffer)out, (long)-1L, (boolean)false);
        if (status != 0) {
            LogSupport.message(InfoDotPlist.class, (String)"sanitize", (String)("Conversion of " + pList + " to XML failed. " + "status=" + status + ":\n" + out));
            return pList;
        }
        return f;
    }

    public InfoDotPlist(String appPath, boolean pathIsPlist) throws IOException {
        File plistDotInfo;
        File app = new File(appPath);
        File file = plistDotInfo = pathIsPlist ? app : new File(app, "Contents/Info.plist");
        if (!plistDotInfo.isFile()) {
            throw new IOException("Application: " + appPath + " does not contain an Info.plist");
        }
        plistDotInfo = InfoDotPlist.sanitize(plistDotInfo);
        SAXBuilder builder = new SAXBuilder(false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            Document plistDoc = builder.build(plistDotInfo);
            Element root = plistDoc.getRootElement();
            this.plistRoot = this.buildDom(root);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private Element buildDom(Element root) {
        Element plistRoot = new Element("plist");
        this.convertPlist(plistRoot, root);
        return plistRoot.getChild("dict-0");
    }

    private void convertPlist(Element plistRoot, Element inputElement) {
        int sequence = 0;
        Element element = plistRoot;
        List children = inputElement.getChildren();
        for (Element entry : children) {
            if (entry.getName().equals("key")) {
                element = new Element(entry.getTextTrim());
                plistRoot.addContent((Content)element);
                continue;
            }
            if (entry.getName().equals("string")) {
                Element stringElement = new Element("string");
                stringElement.addContent(entry.getTextTrim());
                element.addContent((Content)stringElement);
                continue;
            }
            if (entry.getName().equals("array")) {
                this.convertPlist(element, entry);
                continue;
            }
            if (!entry.getName().equals("dict")) continue;
            Element dictElement = new Element("dict-" + sequence++);
            this.convertPlist(dictElement, entry);
            element.addContent((Content)dictElement);
        }
    }

    public String getBundleName() {
        return this.getDictEntry("CFBundleName");
    }

    public String getDictEntry(String keyName) {
        Element exe = this.plistRoot.getChild(keyName);
        if (exe != null) {
            return exe.getChildText("string");
        }
        return null;
    }

    public String[][] getDocumentTypes(String typeStarname) {
        ArrayList suffixList = new ArrayList();
        ArrayList mimeList = new ArrayList();
        Element docArray = this.plistRoot.getChild("CFBundleDocumentTypes");
        List types = docArray.getChildren();
        for (Element entry : types) {
            Element nameEntry = entry.getChild("CFBundleTypeName");
            if (nameEntry == null || !Pattern.matches(typeStarname, nameEntry.getChildTextTrim("string"))) continue;
            Element exts = entry.getChild("CFBundleTypeExtensions");
            Element mimes = entry.getChild("CFBundleTypeMIMETypes");
            if (exts == null || mimes == null) continue;
            suffixList.addAll(this.getStrings(exts));
            mimeList.addAll(this.getStrings(mimes));
        }
        String[][] result = new String[suffixList.size()][2];
        for (int i = 0; i < suffixList.size(); ++i) {
            result[i][0] = (String)suffixList.get(i);
            result[i][1] = (String)mimeList.get(i);
        }
        return result;
    }

    public String getExecutable() {
        return this.getDictEntry("CFBundleExecutable");
    }

    public String getIdentifier() {
        return this.getDictEntry("CFBundleIdentifier");
    }

    public String getInfoDictionaryVersion() {
        return this.getDictEntry("CFBundleInfoDictionaryVersion");
    }

    public String getInfoString() {
        return this.getDictEntry("CFBundleGetInfoString");
    }

    public String getPackageType() {
        return this.getDictEntry("CFBundlePackageType");
    }

    public Element getPListRoot() {
        return this.plistRoot;
    }

    public String getShortVersion() {
        return this.getDictEntry("CFBundleShortVersionString");
    }

    public String getSignature() {
        return this.getDictEntry("CFBundleSignature");
    }

    public String requiresCarbon() {
        return this.getDictEntry("LSRequiresCarbon");
    }

    private ArrayList getStrings(Element arrayRoot) {
        ArrayList<String> list = new ArrayList<String>();
        List children = arrayRoot.getChildren("string");
        for (Element element : children) {
            list.add(element.getText());
        }
        return list;
    }

    public String toString() {
        try {
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            StringWriter out = new StringWriter();
            fmt.output(this.plistRoot, (Writer)out);
            String str = out.toString();
            out.close();
            return str;
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
    }
}

