/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video;

import com.elluminate.groupware.video.VideoBlock;
import com.elluminate.groupware.video.VideoDebug;
import com.elluminate.platform.Platform;
import com.elluminate.util.log.LogSupport;

public class VideoFrame {
    private static final int BYTE_MASK = 255;
    private static final int ENCODING_REFRESH_MODULUS = 30;
    private static final int FRAME_QUALITY_SIZE = 3;
    private static final int GREEN_SHIFT = 8;
    private static final int IGNORE_NO_CHANGES = 1;
    private static final int IGNORE_SMALL_CHANGES = 25;
    public static final int INVALID_QUALITY = -1;
    private static final int MAX_AVERAGE_MILLIS = 40;
    private static final int RED_SHIFT = 16;
    private static final int UNCHANGED_PFX = 0;
    private static final int UNCHANGED_LARGE_PFX_SIZE = 6;
    private static final int UNCHANGED_LARGE_CNT_SIZE = 6;
    private static final int UNCHANGED_SMALL_PFX_SIZE = 3;
    private static final int UNCHANGED_SMALL_CNT_SIZE = 3;
    private static final int BLOCK_DIM = 8;
    public static final int COARSE_COLOR = 1;
    public static final int COARSE_GRAYS = 0;
    public static final int COARSE_RES = 0;
    private static final int FIDELITY_MASK = 1;
    public static final int FINE_COLOR = 5;
    public static final int FINE_GRAYS = 4;
    public static final int FINE_HEIGHT = 240;
    public static final int FINE_RES = 2;
    public static final int FINE_WIDTH = 320;
    private static final int COLOR = 1;
    private static final int GRAYS = 0;
    public static final int MEDIUM_COLOR = 3;
    public static final int MEDIUM_GRAYS = 2;
    public static final int MEDIUM_RES = 1;
    private static final int RES_SHIFT = 1;
    public static final int MAX_BLOCKS_PER_FRAME = 1200;
    private static final int UNCHANGED_LARGE_CODE_SIZE = 12;
    private static final int UNCHANGED_MAX_LARGE_CNT = 63;
    private static final int UNCHANGED_MAX_SMALL_CNT = 7;
    private static final int UNCHANGED_SMALL_CODE_SIZE = 6;
    private static long importedFrameCnt = 0L;
    private static long receivedBlkCnt = 0L;
    private static long receivedEncodingCnt = 0L;
    private static long receivedEncodingCumLen = 0L;
    private static long receivedPixelCnt = 0L;
    private static long receivedUnchangedBlkCnt = 0L;
    private static long receivedUnchangedBlkRunCnt = 0L;
    private static long sentAverageFilterCnt = 0L;
    private static long sentBlkCnt = 0L;
    private static long sentDeltaFilterCnt = 0L;
    private static long sentEncodingCnt = 0L;
    private static long sentEncodingCumLen = 0L;
    private static long sentPixelCnt = 0L;
    private static long sentUnchangedBlkCnt = 0L;
    private static long sentUnchangedBlkRunCnt = 0L;
    private int blockCnt = 0;
    private int blockColCnt = 0;
    private int blockRowCnt = 0;
    private VideoBlock[] blockStore;
    private int desiredQuality = 5;
    private VideoBlock[] importBlocks = new VideoBlock[16];
    private long lastFilterTime = 0L;
    private long lastQualityFavoredTime = 0L;
    private int trueQuality = -1;

    public VideoFrame() {
        this.blockStore = new VideoBlock[1200];
    }

    public synchronized void clear() {
        for (int blockIdx = 0; blockIdx < this.blockCnt; ++blockIdx) {
            this.blockStore[blockIdx].clear();
        }
        this.trueQuality = -1;
    }

    private void convertImageToHalfScale(int width, int height, int[] pixelBuf) {
        int resultIdx = 0;
        for (int row = 0; row < height; row += 2) {
            for (int col = 0; col < width; col += 2) {
                int blueSum = 0;
                int greenSum = 0;
                int redSum = 0;
                int sourceRowOff = row * width + col;
                for (int r = 0; r < 2; ++r) {
                    for (int c = 0; c < 2; ++c) {
                        int rgb = pixelBuf[sourceRowOff + c];
                        blueSum += rgb & 0xFF;
                        greenSum += rgb >> 8 & 0xFF;
                        redSum += rgb >> 16 & 0xFF;
                    }
                    sourceRowOff += width;
                }
                pixelBuf[resultIdx++] = redSum + 2 >> 2 << 16 | greenSum + 2 >> 2 << 8 | blueSum + 2 >> 2;
            }
        }
    }

    private void convertImageToQuarterScale(int width, int height, int[] pixelBuf) {
        int resultIdx = 0;
        for (int row = 0; row < height; row += 4) {
            for (int col = 0; col < width; col += 4) {
                int blueSum = 0;
                int greenSum = 0;
                int redSum = 0;
                int sourceRowOff = row * width + col;
                for (int r = 0; r < 4; ++r) {
                    for (int c = 0; c < 4; ++c) {
                        int rgb = pixelBuf[sourceRowOff + c];
                        blueSum += rgb & 0xFF;
                        greenSum += rgb >> 8 & 0xFF;
                        redSum += rgb >> 16 & 0xFF;
                    }
                    sourceRowOff += width;
                }
                pixelBuf[resultIdx++] = redSum + 8 >> 4 << 16 | greenSum + 8 >> 4 << 8 | blueSum + 8 >> 4;
            }
        }
    }

    public synchronized void discardHistory() {
        for (int blockIdx = 0; blockIdx < this.blockCnt; ++blockIdx) {
            this.blockStore[blockIdx].discardHistory();
        }
    }

    private void deblockingFilter(int[] pixels, int width, int height) {
        for (int x = 8; x < width; x += 8) {
            for (int y = 0; y < height; ++y) {
                int leftPixelIdx = y * width + x - 1;
                int leftPixel = pixels[leftPixelIdx];
                int leftBlu = leftPixel & 0xFF;
                int leftGrn = leftPixel >> 8 & 0xFF;
                int leftRed = leftPixel >> 16 & 0xFF;
                int rightPixelIdx = leftPixelIdx + 1;
                int rightPixel = pixels[rightPixelIdx];
                int rightBlu = rightPixel & 0xFF;
                int rightGrn = rightPixel >> 8 & 0xFF;
                int rightRed = rightPixel >> 16 & 0xFF;
                int newLeftBlu = (3 * leftBlu + rightBlu + 2) / 4;
                int newLeftGrn = (3 * leftGrn + rightGrn + 2) / 4;
                int newLeftRed = (3 * leftRed + rightRed + 2) / 4;
                int newRightBlu = (leftBlu + 3 * rightBlu + 2) / 4;
                int newRightGrn = (leftGrn + 3 * rightGrn + 2) / 4;
                int newRightRed = (leftRed + 3 * rightRed + 2) / 4;
                pixels[leftPixelIdx] = newLeftBlu + (newLeftGrn << 8) + (newLeftRed << 16);
                pixels[rightPixelIdx] = newRightBlu + (newRightGrn << 8) + (newRightRed << 16);
            }
        }
        for (int y = 8; y < height; y += 8) {
            for (int x = 0; x < height; ++x) {
                int lowerPixelIdx = y * width + x;
                int lowerPixel = pixels[lowerPixelIdx];
                int lowerBlu = lowerPixel & 0xFF;
                int lowerGrn = lowerPixel >> 8 & 0xFF;
                int lowerRed = lowerPixel >> 16 & 0xFF;
                int upperPixelIdx = lowerPixelIdx - width;
                int upperPixel = pixels[upperPixelIdx];
                int upperBlu = upperPixel & 0xFF;
                int upperGrn = upperPixel >> 8 & 0xFF;
                int upperRed = upperPixel >> 16 & 0xFF;
                int newLowerBlu = (3 * lowerBlu + upperBlu + 2) / 4;
                int newLowerGrn = (3 * lowerGrn + upperGrn + 2) / 4;
                int newLowerRed = (3 * lowerRed + upperRed + 2) / 4;
                int newUpperBlu = (lowerBlu + 3 * upperBlu + 2) / 4;
                int newUpperGrn = (lowerGrn + 3 * upperGrn + 2) / 4;
                int newUpperRed = (lowerRed + 3 * upperRed + 2) / 4;
                pixels[lowerPixelIdx] = newLowerBlu + (newLowerGrn << 8) + (newLowerRed << 16);
                pixels[upperPixelIdx] = newUpperBlu + (newUpperGrn << 8) + (newUpperRed << 16);
            }
        }
    }

    public synchronized void dispose() {
        for (int blockIdx = 0; blockIdx < this.blockStore.length; ++blockIdx) {
            if (this.blockStore[blockIdx] == null) continue;
            VideoBlock.freeVideoBlock(this.blockStore[blockIdx]);
            this.blockStore[blockIdx] = null;
        }
        for (int i = 0; i < this.importBlocks.length; ++i) {
            this.importBlocks[i] = null;
        }
        this.blockCnt = 0;
        this.blockColCnt = 0;
        this.blockRowCnt = 0;
        this.desiredQuality = 5;
        this.lastFilterTime = 0L;
        this.trueQuality = -1;
    }

    public synchronized int getEncoding(boolean mustBePrecise, byte[] encodingBuf) {
        if (this.trueQuality == -1) {
            this.setTrueQuality(this.desiredQuality);
        }
        int encodingSize = 0;
        if (encodingBuf != null) {
            VideoBlock.putBitField(encodingBuf, encodingSize, 3, this.trueQuality);
        }
        int encodingTrimmedSize = encodingSize += 3;
        int blockIdx = -1;
        int encodingRefreshIdx = (int)(sentEncodingCnt % 30L);
        int unchangedBlockRun = 0;
        for (int row = 0; row < this.blockRowCnt; ++row) {
            for (int col = 0; col < this.blockColCnt; ++col) {
                int blockEncodingOff;
                ++sentBlkCnt;
                int threshold = mustBePrecise || ++blockIdx % 30 == encodingRefreshIdx ? 1 : 25;
                int blockEncodingSize = this.blockStore[blockIdx].getEncoding(threshold, encodingBuf, encodingSize + (blockEncodingOff = unchangedBlockRun < 1 ? 0 : (unchangedBlockRun <= 7 ? 6 : 12)));
                if (blockEncodingSize > 0) {
                    if (unchangedBlockRun > 7) {
                        if (encodingBuf != null) {
                            VideoBlock.putBitField(encodingBuf, encodingSize, 6, 0);
                        }
                        encodingSize += 6;
                        if (encodingBuf != null) {
                            VideoBlock.putBitField(encodingBuf, encodingSize, 6, unchangedBlockRun);
                        }
                        encodingSize += 6;
                        if (encodingBuf != null) {
                            sentUnchangedBlkCnt += (long)unchangedBlockRun;
                            ++sentUnchangedBlkRunCnt;
                        }
                        unchangedBlockRun = 0;
                    } else if (unchangedBlockRun > 0) {
                        if (encodingBuf != null) {
                            VideoBlock.putBitField(encodingBuf, encodingSize, 3, 0);
                        }
                        encodingSize += 3;
                        if (encodingBuf != null) {
                            VideoBlock.putBitField(encodingBuf, encodingSize, 3, unchangedBlockRun);
                        }
                        encodingSize += 3;
                        if (encodingBuf != null) {
                            sentUnchangedBlkCnt += (long)unchangedBlockRun;
                            ++sentUnchangedBlkRunCnt;
                        }
                        unchangedBlockRun = 0;
                    }
                    encodingTrimmedSize = encodingSize += blockEncodingSize;
                    continue;
                }
                if (++unchangedBlockRun <= 63) continue;
                if (encodingBuf != null) {
                    VideoBlock.putBitField(encodingBuf, encodingSize, 6, 0);
                }
                encodingSize += 6;
                if (encodingBuf != null) {
                    VideoBlock.putBitField(encodingBuf, encodingSize, 6, 63);
                }
                encodingSize += 6;
                if (encodingBuf != null) {
                    sentUnchangedBlkCnt += 63L;
                    ++sentUnchangedBlkRunCnt;
                }
                unchangedBlockRun -= 63;
            }
        }
        encodingSize = encodingTrimmedSize;
        int fillLen = (encodingSize + 7) / 8 * 8 - encodingSize;
        if (fillLen > 0) {
            if (encodingBuf != null) {
                VideoBlock.putBitField(encodingBuf, encodingSize, fillLen, 0);
            }
            encodingSize += fillLen;
        }
        int encodingLen = encodingSize / 8;
        if (encodingBuf != null) {
            ++sentEncodingCnt;
            sentEncodingCumLen += (long)encodingLen;
            sentPixelCnt += (long)(this.blockRowCnt * this.blockColCnt * 64);
        }
        return encodingLen;
    }

    public static int getHeight(int res) {
        switch (res) {
            case 0: {
                return 60;
            }
            case 1: {
                return 120;
            }
            case 2: {
                return 240;
            }
        }
        throw new IllegalArgumentException("Invalid res: " + res);
    }

    public static int getMaxEncodingLength() {
        return VideoFrame.getMaxEncodingLength(5);
    }

    public static int getMaxEncodingLength(int quality) {
        switch (quality) {
            case 1: {
                return 15760;
            }
            case 0: {
                return 5360;
            }
            case 3: {
                return 59100;
            }
            case 2: {
                return 20100;
            }
            case 5: {
                return 236400;
            }
            case 4: {
                return 80400;
            }
        }
        throw new IllegalArgumentException("Invalid quality: " + quality);
    }

    public synchronized int getPixels(int[] pixelBuf) {
        if (this.trueQuality == -1) {
            this.setTrueQuality(this.desiredQuality);
        }
        int blockIdx = 0;
        int height = this.blockRowCnt * 8;
        int width = this.blockColCnt * 8;
        for (int yOff = 0; yOff < height; yOff += 8) {
            for (int xOff = 0; xOff < width; xOff += 8) {
                this.blockStore[blockIdx++].getPixels(pixelBuf, xOff, yOff, width);
            }
        }
        if (!VideoDebug.NO_DEBLOCKING_FILTER.isEnabled()) {
            this.deblockingFilter(pixelBuf, width, height);
        }
        return this.trueQuality >> 1;
    }

    public synchronized int getQuality() {
        return this.desiredQuality;
    }

    public static String getQualityName(int quality) {
        switch (quality) {
            case 1: {
                return "CC";
            }
            case 0: {
                return "CG";
            }
            case 5: {
                return "FC";
            }
            case 4: {
                return "FG";
            }
            case 3: {
                return "MC";
            }
            case 2: {
                return "MG";
            }
        }
        return "Invalid Quality: " + quality;
    }

    public synchronized int getTrueQuality() {
        return this.trueQuality;
    }

    public static int getWidth(int res) {
        switch (res) {
            case 0: {
                return 80;
            }
            case 1: {
                return 160;
            }
            case 2: {
                return 320;
            }
        }
        throw new IllegalArgumentException("Invalid res: " + res);
    }

    public synchronized void importPixels(VideoFrame source, boolean replace) {
        VideoBlock[] sourceBlockStore = source.blockStore;
        if (source.trueQuality <= this.desiredQuality) {
            this.setTrueQuality(source.trueQuality);
            for (int blockIdx = 0; blockIdx < this.blockCnt; ++blockIdx) {
                this.blockStore[blockIdx].importPixels(sourceBlockStore[blockIdx], replace);
            }
        } else if (source.trueQuality >> 1 == this.desiredQuality >> 1) {
            this.setTrueQuality(this.desiredQuality);
            for (int blockIdx = 0; blockIdx < this.blockCnt; ++blockIdx) {
                this.blockStore[blockIdx].importPixels(sourceBlockStore[blockIdx], replace);
            }
        } else if (source.trueQuality >> 1 == 2 && this.desiredQuality >> 1 == 0) {
            if ((source.trueQuality & 1) > (this.desiredQuality & 1)) {
                this.setTrueQuality(this.desiredQuality);
            } else {
                this.setTrueQuality(this.desiredQuality >> 1 << 1 | source.trueQuality & 1);
            }
            int blockIdx = 0;
            int sourceRowOff = 0;
            for (int rowIdx = 0; rowIdx < this.blockRowCnt; ++rowIdx) {
                int sourceColOff = sourceRowOff;
                for (int colIdx = 0; colIdx < this.blockColCnt; ++colIdx) {
                    int sourceIdx = sourceColOff;
                    this.importBlocks[0] = sourceBlockStore[sourceIdx];
                    this.importBlocks[1] = sourceBlockStore[sourceIdx + 1];
                    this.importBlocks[2] = sourceBlockStore[sourceIdx + 2];
                    this.importBlocks[3] = sourceBlockStore[sourceIdx + 3];
                    if ((sourceIdx += this.blockColCnt << 2) < sourceBlockStore.length) {
                        this.importBlocks[4] = sourceBlockStore[sourceIdx];
                        this.importBlocks[5] = sourceBlockStore[sourceIdx + 1];
                        this.importBlocks[6] = sourceBlockStore[sourceIdx + 2];
                        this.importBlocks[7] = sourceBlockStore[sourceIdx + 3];
                    } else {
                        this.importBlocks[4] = null;
                        this.importBlocks[5] = null;
                        this.importBlocks[6] = null;
                        this.importBlocks[7] = null;
                    }
                    if ((sourceIdx += this.blockColCnt << 2) < sourceBlockStore.length) {
                        this.importBlocks[8] = sourceBlockStore[sourceIdx];
                        this.importBlocks[9] = sourceBlockStore[sourceIdx + 1];
                        this.importBlocks[10] = sourceBlockStore[sourceIdx + 2];
                        this.importBlocks[11] = sourceBlockStore[sourceIdx + 3];
                    } else {
                        this.importBlocks[8] = null;
                        this.importBlocks[9] = null;
                        this.importBlocks[10] = null;
                        this.importBlocks[11] = null;
                    }
                    if ((sourceIdx += this.blockColCnt << 2) < sourceBlockStore.length) {
                        this.importBlocks[12] = sourceBlockStore[sourceIdx];
                        this.importBlocks[13] = sourceBlockStore[sourceIdx + 1];
                        this.importBlocks[14] = sourceBlockStore[sourceIdx + 2];
                        this.importBlocks[15] = sourceBlockStore[sourceIdx + 3];
                    } else {
                        this.importBlocks[12] = null;
                        this.importBlocks[13] = null;
                        this.importBlocks[14] = null;
                        this.importBlocks[15] = null;
                    }
                    this.blockStore[blockIdx++].importPixelsReducing16To1(this.importBlocks, replace);
                    sourceColOff += 4;
                }
                sourceRowOff += this.blockColCnt << 4;
            }
            for (int i = 0; i < 16; ++i) {
                this.importBlocks[i] = null;
            }
        } else {
            if ((source.trueQuality & 1) > (this.desiredQuality & 1)) {
                this.setTrueQuality(this.desiredQuality);
            } else {
                this.setTrueQuality(this.desiredQuality >> 1 << 1 | source.trueQuality & 1);
            }
            int blockIdx = 0;
            int sourceRowOff = 0;
            for (int rowIdx = 0; rowIdx < this.blockRowCnt; ++rowIdx) {
                int sourceColOff = sourceRowOff;
                for (int colIdx = 0; colIdx < this.blockColCnt; ++colIdx) {
                    int sourceIdx = sourceColOff;
                    this.importBlocks[0] = sourceBlockStore[sourceIdx];
                    this.importBlocks[1] = sourceBlockStore[sourceIdx + 1];
                    if ((sourceIdx += 2 * this.blockColCnt) < sourceBlockStore.length) {
                        this.importBlocks[2] = sourceBlockStore[sourceIdx];
                        this.importBlocks[3] = sourceBlockStore[sourceIdx + 1];
                    } else {
                        this.importBlocks[2] = null;
                        this.importBlocks[3] = null;
                    }
                    this.blockStore[blockIdx++].importPixelsReducing4To1(this.importBlocks, replace);
                    sourceColOff += 2;
                }
                sourceRowOff += this.blockColCnt << 2;
            }
            for (int i = 0; i < 4; ++i) {
                this.importBlocks[i] = null;
            }
        }
        ++importedFrameCnt;
    }

    public static void logStatistics() {
        if (importedFrameCnt == 0L && receivedEncodingCnt == 0L && sentEncodingCnt == 0L) {
            return;
        }
        LogSupport.log((String)"---------- Video Stats ----------");
        if (importedFrameCnt > 0L) {
            LogSupport.log((String)("VideoFrame.importedFrameCnt = " + importedFrameCnt));
            importedFrameCnt = 0L;
        }
        if (receivedEncodingCnt > 0L) {
            LogSupport.log((String)("VideoFrame.receivedAvgBitsPerPixel = " + (double)((int)(100.0 * (double)receivedEncodingCumLen * 8.0 / (double)receivedPixelCnt + 0.5)) / 100.0));
            LogSupport.log((String)("VideoFrame.receivedAvgEncodingLen = " + (double)((int)(10.0 * (double)receivedEncodingCumLen / (double)receivedEncodingCnt + 0.5)) / 10.0 + " bytes"));
            LogSupport.log((String)("VideoFrame.receivedEncodingCnt = " + receivedEncodingCnt));
            if (receivedUnchangedBlkCnt > 0L) {
                double unchangedBlkPct = (double)((int)(1000.0 * (double)receivedUnchangedBlkCnt / (double)receivedBlkCnt + 0.5)) / 10.0;
                LogSupport.log((String)("VideoFrame.receivedUnchangedBlkCnt = " + receivedUnchangedBlkCnt + " (" + unchangedBlkPct + "%)"));
            }
            if (receivedUnchangedBlkRunCnt > 0L) {
                LogSupport.log((String)("VideoFrame.receivedUnchangedBlkAvgRun = " + (double)((int)(10.0 * (double)receivedUnchangedBlkCnt / (double)receivedUnchangedBlkRunCnt + 0.5)) / 10.0));
            }
            receivedBlkCnt = 0L;
            receivedEncodingCnt = 0L;
            receivedEncodingCumLen = 0L;
            receivedPixelCnt = 0L;
            receivedUnchangedBlkCnt = 0L;
            receivedUnchangedBlkRunCnt = 0L;
        }
        if (sentEncodingCnt > 0L) {
            double pct;
            LogSupport.log((String)("VideoFrame.sentAvgBitsPerPixel = " + (double)((int)(100.0 * (double)sentEncodingCumLen * 8.0 / (double)sentPixelCnt + 0.5)) / 100.0));
            LogSupport.log((String)("VideoFrame.sentAvgEncodingLen = " + (double)((int)(10.0 * (double)sentEncodingCumLen / (double)sentEncodingCnt + 0.5)) / 10.0 + " bytes"));
            LogSupport.log((String)("VideoFrame.sentEncodingCnt = " + sentEncodingCnt));
            if (sentAverageFilterCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentAverageFilterCnt / (double)sentEncodingCnt + 0.5)) / 10.0;
                LogSupport.log((String)("VideoFrame.sentAverageFilterCnt = " + sentAverageFilterCnt + " (" + pct + "%)"));
            }
            if (sentDeltaFilterCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentDeltaFilterCnt / (double)sentEncodingCnt + 0.5)) / 10.0;
                LogSupport.log((String)("VideoFrame.sentDeltaFilterCnt = " + sentDeltaFilterCnt + " (" + pct + "%)"));
            }
            if (sentUnchangedBlkCnt > 0L) {
                pct = (double)((int)(1000.0 * (double)sentUnchangedBlkCnt / (double)sentBlkCnt + 0.5)) / 10.0;
                LogSupport.log((String)("VideoFrame.sentUnchangedBlkCnt = " + sentUnchangedBlkCnt + " (" + pct + "%)"));
            }
            if (sentUnchangedBlkRunCnt > 0L) {
                LogSupport.log((String)("VideoFrame.sentUnchangedBlkAvgRun = " + (double)((int)(10.0 * (double)sentUnchangedBlkCnt / (double)sentUnchangedBlkRunCnt + 0.5)) / 10.0));
            }
            sentAverageFilterCnt = 0L;
            sentBlkCnt = 0L;
            sentDeltaFilterCnt = 0L;
            sentEncodingCnt = 0L;
            sentEncodingCumLen = 0L;
            sentPixelCnt = 0L;
            sentUnchangedBlkCnt = 0L;
            sentUnchangedBlkRunCnt = 0L;
        }
        VideoBlock.logStatistics();
    }

    public synchronized int previewPixels(int sourceRes, int[] pixelBuf) {
        if (sourceRes != 0 && sourceRes != 1 && sourceRes != 2) {
            throw new IllegalArgumentException("Invalid sourceRes: " + sourceRes);
        }
        int desiredRes = this.desiredQuality >> 1;
        if (sourceRes == 2 && desiredRes == 0) {
            this.convertImageToQuarterScale(320, 240, pixelBuf);
            sourceRes = 0;
        } else if (sourceRes == 2 && desiredRes == 1) {
            this.convertImageToHalfScale(320, 240, pixelBuf);
            sourceRes = 1;
        } else if (sourceRes == 1 && desiredRes == 0) {
            this.convertImageToHalfScale(160, 120, pixelBuf);
            sourceRes = 0;
        }
        if (VideoDebug.RAW_PREVIEW.isEnabled()) {
            return sourceRes;
        }
        int height = VideoFrame.getHeight(sourceRes);
        int extendedHeight = (height + 8 - 1) / 8 * 8;
        int width = VideoFrame.getWidth(sourceRes);
        if (height < extendedHeight) {
            int imageArea;
            int extendedArea = width * extendedHeight;
            for (int i = imageArea = width * height; i < extendedArea; ++i) {
                pixelBuf[i] = 0;
            }
        }
        int filterType = 0;
        long timeDelta = Platform.currentTimeMillis() - this.lastFilterTime;
        this.lastFilterTime += timeDelta;
        if (timeDelta <= 40L && VideoDebug.USE_AVERAGE_FILTER.isEnabled()) {
            filterType = 2;
        } else if (VideoDebug.USE_DELTA_FILTER.isEnabled()) {
            filterType = 1;
        }
        int blockIdx = 0;
        for (int yOff = 0; yOff < height; yOff += 8) {
            for (int xOff = 0; xOff < width; xOff += 8) {
                if (this.blockStore[blockIdx] == null) {
                    this.blockStore[blockIdx] = VideoBlock.getVideoBlock();
                }
                this.blockStore[blockIdx++].previewPixels(pixelBuf, xOff, yOff, width, this.desiredQuality & 1, filterType);
            }
        }
        this.deblockingFilter(pixelBuf, width, height);
        return sourceRes;
    }

    public synchronized void putEncoding(byte[] encodingBuf, int encodingLen) {
        if (encodingLen < 1 || encodingLen > encodingBuf.length) {
            throw new IllegalArgumentException("Invalid encodingLength: " + encodingLen);
        }
        int encodingOff = 0;
        this.setTrueQuality(VideoBlock.getBitField(encodingBuf, encodingOff, 3));
        encodingOff += 3;
        if (encodingLen < encodingBuf.length) {
            encodingBuf[encodingLen] = 0;
        }
        int blockIdx = 0;
        int encodingLim = 8 * encodingLen - 1;
        int unchangedBlockRun = 0;
        try {
            while (encodingOff < encodingLim) {
                int unchangedBlkCnt;
                if (VideoBlock.getBitField(encodingBuf, encodingOff, 6) == 0) {
                    if (encodingOff + 12 > encodingLim) break;
                    unchangedBlkCnt = VideoBlock.getBitField(encodingBuf, encodingOff += 6, 6);
                    encodingOff += 6;
                    unchangedBlockRun += unchangedBlkCnt;
                    receivedUnchangedBlkCnt += (long)unchangedBlkCnt;
                    blockIdx += unchangedBlkCnt;
                    continue;
                }
                if (VideoBlock.getBitField(encodingBuf, encodingOff, 3) == 0) {
                    if (encodingOff + 6 > encodingLim) break;
                    unchangedBlkCnt = VideoBlock.getBitField(encodingBuf, encodingOff += 3, 3);
                    encodingOff += 3;
                    unchangedBlockRun += unchangedBlkCnt;
                    receivedUnchangedBlkCnt += (long)unchangedBlkCnt;
                    blockIdx += unchangedBlkCnt;
                    continue;
                }
                if (unchangedBlockRun > 0) {
                    receivedBlkCnt += (long)unchangedBlockRun;
                    ++receivedUnchangedBlkRunCnt;
                    unchangedBlockRun = 0;
                }
                encodingOff += this.blockStore[blockIdx].putEncoding(encodingBuf, encodingOff);
                ++blockIdx;
                ++receivedBlkCnt;
            }
            if (unchangedBlockRun > 0) {
                receivedBlkCnt += (long)unchangedBlockRun;
                ++receivedUnchangedBlkRunCnt;
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"putEncoding", (Throwable)t, (boolean)true);
        }
        ++receivedEncodingCnt;
        receivedEncodingCumLen += (long)((encodingOff + 7) / 8);
        receivedPixelCnt += (long)(this.blockRowCnt * this.blockColCnt * 64);
    }

    public synchronized void putPixels(int sourceRes, int[] pixelBuf) {
        if (sourceRes != 0 && sourceRes != 1 && sourceRes != 2) {
            throw new IllegalArgumentException("Invalid sourceRes: " + sourceRes);
        }
        int desiredRes = this.desiredQuality >> 1;
        if (sourceRes == 2 && desiredRes == 0) {
            this.convertImageToQuarterScale(320, 240, pixelBuf);
            sourceRes = 0;
        } else if (sourceRes == 2 && desiredRes == 1) {
            this.convertImageToHalfScale(320, 240, pixelBuf);
            sourceRes = 1;
        } else if (sourceRes == 1 && desiredRes == 0) {
            this.convertImageToHalfScale(160, 120, pixelBuf);
            sourceRes = 0;
        }
        int height = VideoFrame.getHeight(sourceRes);
        int width = VideoFrame.getWidth(sourceRes);
        if (height % 8 != 0) {
            int imageArea;
            int extendedHeight = (height + 8 - 1) / 8 * 8;
            int extendedArea = width * extendedHeight;
            for (int i = imageArea = width * height; i < extendedArea; ++i) {
                pixelBuf[i] = 0;
            }
        }
        if (sourceRes == desiredRes) {
            this.setTrueQuality(this.desiredQuality);
        } else {
            this.setTrueQuality(sourceRes << 1 | 1);
        }
        int filterType = 0;
        long timeDelta = Platform.currentTimeMillis() - this.lastFilterTime;
        this.lastFilterTime += timeDelta;
        if (timeDelta <= 40L && VideoDebug.USE_AVERAGE_FILTER.isEnabled()) {
            filterType = 2;
            ++sentAverageFilterCnt;
        } else if (VideoDebug.USE_DELTA_FILTER.isEnabled()) {
            filterType = 1;
            ++sentDeltaFilterCnt;
        }
        int blockIdx = 0;
        for (int yOff = 0; yOff < height; yOff += 8) {
            for (int xOff = 0; xOff < width; xOff += 8) {
                this.blockStore[blockIdx++].putPixels(pixelBuf, xOff, yOff, width, filterType);
            }
        }
    }

    public synchronized void setQuality(int newQuality) {
        switch (newQuality) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid quality: " + newQuality);
            }
        }
        this.desiredQuality = newQuality;
    }

    private void setTrueQuality(int newQuality) {
        if (newQuality != this.trueQuality) {
            int blockIdx;
            switch (newQuality) {
                case 0: 
                case 1: {
                    this.blockColCnt = 10;
                    this.blockRowCnt = 8;
                    break;
                }
                case 2: 
                case 3: {
                    this.blockColCnt = 20;
                    this.blockRowCnt = 15;
                    break;
                }
                case 4: 
                case 5: {
                    this.blockColCnt = 40;
                    this.blockRowCnt = 30;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid quality: " + newQuality);
                }
            }
            this.trueQuality = newQuality;
            for (blockIdx = this.blockCnt = this.blockColCnt * this.blockRowCnt; blockIdx < this.blockStore.length && this.blockStore[blockIdx] != null; ++blockIdx) {
                VideoBlock.freeVideoBlock(this.blockStore[blockIdx]);
                this.blockStore[blockIdx] = null;
            }
            for (blockIdx = 0; blockIdx < this.blockCnt; ++blockIdx) {
                if (this.blockStore[blockIdx] == null) {
                    this.blockStore[blockIdx] = VideoBlock.getVideoBlock();
                }
                this.blockStore[blockIdx].setQuality(newQuality);
            }
        }
    }
}

