/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.moduleloading.threadingengine;

import com.elluminate.framework.moduleloading.threadingengine.ThreadingEngine;
import com.elluminate.util.event.ThrowableListener;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadingEngineImpl
implements ThreadingEngine {
    private ExecutorService executor;
    private ThrowableListener errorListener;

    @Inject
    public void initThrowableListener(ThrowableListener errorListener) {
        this.errorListener = errorListener;
    }

    @Override
    public void execute(List<Runnable> runnables) {
        this.initExecutor();
        ArrayList results = new ArrayList();
        for (Runnable runnable : runnables) {
            results.add(this.executor.submit(runnable));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e) {
                this.errorListener.exceptionThrown(e);
            }
        }
    }

    @Override
    public void cleanUpThreads() {
        if (this.executor == null) {
            return;
        }
        this.executor.shutdown();
        this.executor = null;
    }

    private void initExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(2);
        }
    }
}

