/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware;

import com.elluminate.groupware.Chair;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.util.DebugFlag;
import java.io.DataInputStream;

public class ChairProtocol
extends JinxProtocolAdapter {
    public static final DebugFlag LOGGING = DebugFlag.get((String)"chair");
    public static final byte REMOVE_PARTICIPANT = 1;
    public static final String PROPERTY = "chair";
    public static final String LOCKED_PROPERTY = "chair.locked";
    public static final String CHAIR_ROLE = "chair.role";
    public static final String CHAIR_OF_RECORD = "chair.ofRecord";
    public static final String CHANNEL = "chair";
    public static final byte PRIORITY = 2;
    public static final String PERMISSION_CTL_NAME = "chair";
    private static final String[] CMDS = new String[]{"RemoveParticipant"};

    public ChairProtocol() {
        this.defineChannel("chair", (byte)2);
        this.defineProperty(LOCKED_PROPERTY, (byte)1, Boolean.FALSE);
        this.defineProperty(CHAIR_ROLE, (byte)0, Boolean.FALSE);
        this.defineProperty(CHAIR_OF_RECORD, (byte)0, Boolean.FALSE);
    }

    public String commandToString(byte cmd) {
        try {
            return CMDS[cmd - 1];
        }
        catch (Exception ex) {
            return "[ invalid chair protocol command - " + cmd + " ]";
        }
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String desc = this.commandToString(cmd);
        if (cmd == 1) {
            try {
                desc = desc + "(" + str.readShort() + ")";
            }
            catch (Exception ex) {
                desc = desc + "[missing address]";
            }
        }
        return desc;
    }

    @Deprecated
    public static Chair getChair(Connection connection) {
        return new Chair(connection, "chair");
    }

    @Deprecated
    public static Chair getChair(ClientList clients) {
        Connection connection = null;
        if (clients != null) {
            connection = clients.getConnection();
        }
        return new Chair(connection, "chair");
    }

    public boolean isChair(ClientList clients, short addr) {
        ClientInfo ci = clients.get(addr);
        if (ci == null) {
            return false;
        }
        return ci.getProperty(CHAIR_ROLE, false);
    }

    public boolean amChair(ClientList clients) {
        ClientInfo ci = clients.getMyClient();
        if (ci == null) {
            return false;
        }
        return ci.getProperty(CHAIR_ROLE, false);
    }

    public short[] getChairList(ClientList clients) {
        return (short[])clients.getProperty("chair");
    }

    public Chair fetchChair(ClientList clients) {
        return ChairProtocol.getChair(clients);
    }

    public Chair fetchChair(Connection client) {
        return ChairProtocol.getChair(client);
    }

    public Chair makeChair(Connection theConnection, Object obj) {
        return new Chair(theConnection, obj);
    }

    public Chair makeChair(Connection theConnection) {
        return new Chair(theConnection, "chair");
    }
}

