/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.chat.Chat;
import com.elluminate.groupware.chat.module.ErrorHandler;
import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.groupware.chat.module.ToSelection;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.util.List;

public class ToSelected
implements ToSelection {
    private Client client;
    private List<ClientInfo> toList;
    private Chair chair;
    private ErrorHandler errorHandler;
    private I18n i18n;

    public ToSelected(List<ClientInfo> toList, Chair chair, Client client) {
        this.client = client;
        this.chair = chair;
        this.toList = toList;
    }

    public void initErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void initI18n(I18n i18n) {
        this.i18n = i18n;
    }

    @Override
    public boolean address(Chat msg) {
        if (this.toList.size() == 0) {
            this.errorHandler.reportError(this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_NOSELECTION), this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSENDTITLE));
            return false;
        }
        for (ClientInfo ci : this.toList) {
            Object channelOpenForClient = ci.getProperty("directMessagingChatActive");
            if (this.isChannelClosed(channelOpenForClient) && this.toList.size() == 1) {
                this.errorHandler.reportError(this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSELECTTELECONFERENCE), this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSENDTITLE));
                return false;
            }
            if (!this.isReciepientAccessible(ci)) {
                this.errorHandler.reportError(this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_INACCESSIBLERECIPIENT), this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSENDTITLE));
                return false;
            }
            msg.addTo(ci);
        }
        return true;
    }

    private boolean isChannelClosed(Object channelOpenForClient) {
        return channelOpenForClient == null || Boolean.FALSE.equals(channelOpenForClient);
    }

    private boolean isReciepientAccessible(ClientInfo ci) {
        return this.chair.isMe() || this.chair.contains(ci.getAddress()) || ci.getGroupID() == this.client.getGroupID();
    }
}

