/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.chat.ChatDebug;
import com.elluminate.groupware.chat.module.SelectionInvalidationEvent;
import com.elluminate.groupware.chat.module.SelectionInvalidationListener;
import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SendToModel
implements ComboBoxModel,
ClientListener,
ClientGroupListener,
PropertyChangeListener {
    public static final I18n i18n = I18n.create(SendToModel.class);
    private String toAllRooms = null;
    private String toAll = null;
    private String toChairs = null;
    private String toSelected = null;
    private Client client = null;
    private ClientList clients = null;
    private String selected = null;
    private ArrayList items = null;
    private volatile boolean isChair = false;
    private boolean enabled = false;
    private boolean moderated = false;
    private boolean external = false;
    private Object listenerLock = new Object();
    private ArrayList dataListeners = new ArrayList();
    private ArrayList invListeners = new ArrayList();
    private ChairProtocol chairProtocol;
    private SwingRunner swingRunner;
    private Logger log;

    public SendToModel() {
        this.setClient(new Client());
        this.resetLabels();
    }

    public SendToModel(Client c) {
        this.setClient(c);
        this.resetLabels();
    }

    @Inject
    public void initChairProtocol(ChairProtocol cp) {
        this.chairProtocol = cp;
    }

    @Inject
    public void initSwingRunner(SwingRunner sr) {
        this.swingRunner = sr;
    }

    @Inject
    public void initLogger(Logger log) {
        this.log = log;
    }

    public void setClient(Client c) {
        if (this.client != null) {
            this.client.removeClientGroupListener((ClientGroupListener)this);
        }
        this.client = c;
        if (this.client != null) {
            this.client.addClientGroupListener((ClientGroupListener)this);
        }
        if (this.clients != null) {
            this.clients.removeClientListener((ClientListener)this);
            this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
            this.clients.removePropertyChangeListener("Label.Moderators", (PropertyChangeListener)this);
        }
        this.clients = this.client == null ? null : this.client.getClientList();
        if (this.clients != null) {
            this.clients.addClientListener((ClientListener)this);
            this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
            this.clients.addPropertyChangeListener("Label.Moderators", (PropertyChangeListener)this);
        }
        this.selected = !this.moderated || this.enabled ? this.toAll : this.toChairs;
        this.fireSelectionInvalidated();
        this.clearItems(true);
    }

    public void setEnabled(boolean enable, boolean broadcast) {
        this.enabled = enable;
        if (!this.enabled) {
            String target = this.moderated ? this.toChairs : this.toAll;
            if (this.selected != target) {
                this.selected = target;
                this.fireSelectionInvalidated();
                this.clearItems(true);
            } else {
                this.clearItems(false);
            }
        } else if (broadcast && !this.toAll.equals(this.selected)) {
            this.selected = this.toAll;
            this.fireSelectionInvalidated();
            this.clearItems(true);
        } else {
            this.clearItems(false);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setExternalAllowed(boolean enable) {
        this.external = enable;
        if (!this.external && this.toSelected.equals(this.selected)) {
            this.selected = this.enabled || !this.moderated ? this.toAll : this.toChairs;
            this.fireSelectionInvalidated();
            this.clearItems(true);
        } else {
            this.clearItems(false);
        }
    }

    public boolean isExternalAllowed() {
        return this.external;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        String check;
        if (anItem == null) {
            anItem = this.toAll;
        }
        if (!(check = (String)anItem).equals("")) {
            this.selected = check;
            this.fireContentsChanged();
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int count;
        SendToModel sendToModel = this;
        synchronized (sendToModel) {
            this.checkItems();
            count = this.items.size();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int index) {
        String item = null;
        SendToModel sendToModel = this;
        synchronized (sendToModel) {
            this.checkItems();
            try {
                item = this.items.get(index);
            }
            catch (IndexOutOfBoundsException ex) {
                item = "";
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListDataListener(ListDataListener l) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.dataListeners.contains(l)) {
                ArrayList<ListDataListener> newList = new ArrayList<ListDataListener>(this.dataListeners);
                newList.add(l);
                this.dataListeners = newList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListDataListener(ListDataListener l) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList newList = new ArrayList(this.dataListeners);
            newList.remove(l);
            this.dataListeners = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionInvalidationListener(SelectionInvalidationListener l) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.invListeners.contains(l)) {
                ArrayList<SelectionInvalidationListener> newList = new ArrayList<SelectionInvalidationListener>(this.invListeners);
                newList.add(l);
                this.invListeners = newList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionInvalidationListener(SelectionInvalidationListener l) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList newList = new ArrayList(this.invListeners);
            newList.remove(l);
            this.invListeners = newList;
        }
    }

    private void checkItems() {
        if (this.items != null) {
            return;
        }
        this.items = new ArrayList();
        if (this.isChair) {
            this.items.add(this.toAllRooms);
        }
        this.items.add(this.toAll);
        if (this.moderated) {
            this.items.add(this.toChairs);
        }
        if (this.external) {
            this.items.add(this.toSelected);
        }
        short grp = this.client.getGroupID();
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        Iterator i = this.clients.visibleIterator();
        while (i.hasNext()) {
            Object channelOpenForClient;
            ClientInfo ci = (ClientInfo)i.next();
            if (ci.isMe() || (channelOpenForClient = ci.getProperty("directMessagingChatActive")) == null || Boolean.FALSE.equals(channelOpenForClient) || !this.isChair && ci.getGroupID() != grp && !chair.contains(ci.getAddress())) continue;
            this.items.add(ci.getDisplayName());
        }
        this.fireContentsChanged();
    }

    private void resetLabels() {
        this.toAllRooms = i18n.getString((PropertiesEnum)StringsProperties.SENDTOMODEL_ALLROOMS) + " ";
        this.toAll = i18n.getString((PropertiesEnum)StringsProperties.SENDTOMODEL_ALL) + " ";
        this.toChairs = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderators") + " ";
        this.toSelected = i18n.getString((PropertiesEnum)StringsProperties.SENDTOMODEL_SELECTED) + " ";
        this.clearItems(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearItems(boolean notify) {
        SendToModel sendToModel = this;
        synchronized (sendToModel) {
            this.items = null;
        }
        if (notify) {
            this.fireContentsChanged();
        }
    }

    private boolean isStaticSelection() {
        return this.selected.endsWith(" ");
    }

    public void onAddClient(ClientEvent e) {
        ClientInfo ci = this.clients.get(e.getAddress());
        if (ChatDebug.CHAT.show()) {
            System.out.println("A new client( " + ci.getName() + ") has joined the session, it was added to the user dropdown");
        }
        if (ci == null) {
            return;
        }
        if (ci.isMe() || ci.getGroupID() == this.client.getGroupID() || this.isChair) {
            this.clearItems(false);
        }
    }

    public void onRemoveClient(ClientEvent e) {
        String name = e.getName();
        boolean me = e.isMe();
        ClientInfo ci = this.clients.get(e.getAddress());
        if (ChatDebug.CHAT.show()) {
            System.out.println("A client( " + ci.getName() + ") has left the session, it was removed from the user dropdown");
        }
        if (me || this.isChair || ci == null || ci.getGroupID() == this.client.getGroupID()) {
            this.clearItems(false);
        }
        if (name.equals(this.selected)) {
            this.selected = this.enabled || !this.moderated ? this.toAll : this.toChairs;
            this.fireSelectionInvalidated();
            this.clearItems(true);
        }
    }

    public void clientGroupCreated(ClientGroupEvent e) {
    }

    public void clientGroupDeleted(ClientGroupEvent e) {
    }

    public void clientGroupRenamed(ClientGroupEvent e) {
    }

    public void clientGroupChanged(ClientGroupEvent e) {
        if (ChatDebug.CHAT.show()) {
            System.out.println("A client was moved to a breakout room, we need to update the user list");
        }
        if (this.isChair) {
            return;
        }
        ClientGroup grp = this.clients.getClientGroup(this.client.getGroupID());
        if (e.getGroup() != grp && e.getPreviousGroup() != grp) {
            return;
        }
        ClientInfo ci = e.getClient();
        boolean invalidate = false;
        if (ci.isMe()) {
            if (!this.isStaticSelection()) {
                ClientInfo sel = this.clients.get(this.selected);
                Chair chair = ChairProtocol.getChair((ClientList)this.clients);
                if (chair != null && sel != null) {
                    invalidate = !chair.contains(sel.getAddress());
                }
            }
        } else {
            boolean bl = invalidate = e.getPreviousGroup() == grp && ci.getDisplayName().equals(this.selected);
        }
        if (invalidate) {
            this.selected = this.enabled || !this.moderated ? this.toAll : this.toChairs;
            this.fireSelectionInvalidated();
        }
        this.clearItems(invalidate);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("chair")) {
            boolean wasChair = this.isChair;
            boolean invalidate = false;
            Chair chair = this.chairProtocol.makeChair((Connection)this.client, e.getNewValue());
            this.isChair = chair.isMe();
            if (e.getOldValue() == null) {
                this.moderated = true;
            }
            if (e.getNewValue() == null) {
                this.moderated = false;
            }
            if (wasChair && !this.isChair && !this.isStaticSelection()) {
                ClientInfo sel = this.clients.get(this.selected);
                boolean bl = invalidate = sel == null || this.client == null || sel.getGroupID() != this.client.getGroupID() && !chair.contains(sel.getAddress());
            }
            if (!this.isStaticSelection() && !this.isChair) {
                ClientInfo ci = this.clients.get(this.selected);
                if (ci == null) {
                    invalidate = true;
                } else if (ci.getGroupID() != this.client.getGroupID() && !chair.contains(ci.getAddress())) {
                    invalidate = true;
                }
            }
            if (invalidate) {
                this.selected = this.enabled || !this.moderated ? this.toAll : this.toChairs;
                this.fireSelectionInvalidated();
                this.clearItems(true);
            } else {
                this.clearItems(false);
            }
        } else if (e.getPropertyName().equals("Label.Moderators")) {
            this.resetLabels();
        }
    }

    private void fireContentsChanged() {
        if (this.dataListeners.isEmpty()) {
            return;
        }
        if (this.swingRunner == null) {
            return;
        }
        this.swingRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListDataEvent e = new ListDataEvent(this, 0, 0, -1);
                for (ListDataListener l : SendToModel.this.dataListeners) {
                    try {
                        l.contentsChanged(e);
                    }
                    catch (Throwable t) {
                        SendToModel.this.log.exception((Object)this, "fireContentsChanged", t, true);
                    }
                }
            }
        });
    }

    private void fireSelectionInvalidated() {
        SelectionInvalidationEvent e = new SelectionInvalidationEvent(this, this.selected);
        for (SelectionInvalidationListener l : this.invListeners) {
            try {
                l.selectionInvalidated(e);
            }
            catch (Throwable t) {
                this.log.exception((Object)this, "fireSelectionInvalidated", t, true);
            }
        }
    }

    public String getToChairs() {
        return this.toChairs;
    }

    public String getToAllRooms() {
        return this.toAllRooms;
    }

    public String getToAll() {
        return this.toAll;
    }

    public String getToSelected() {
        return this.toSelected;
    }

    public ChairProtocol getChairProtocol() {
        return this.chairProtocol;
    }
}

