/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandNoPermissionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.SendChatMessageCommand;
import com.elluminate.engine.model.ChatRecipient;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.chat.module.ChatModule;
import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.groupware.chat.module.ToAll;
import com.elluminate.groupware.chat.module.ToAllRooms;
import com.elluminate.groupware.chat.module.ToChairs;
import com.elluminate.groupware.chat.module.ToParticipants;
import com.elluminate.groupware.chat.module.ToSelection;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SendChatMessageCmd
extends AbstractCommand
implements SendChatMessageCommand {
    private ArrayList<String> recipients = new ArrayList();
    private String messageToBeSent = "";
    private boolean announce;
    private I18n i18n = I18n.create(SendChatMessageCmd.class);
    private static ChatModule chatModule;
    private static CRSession session;

    public void setChatModule(ChatModule chatModuleIn) {
        chatModule = chatModuleIn;
    }

    public void setSession(CRSession sessionIn) {
        session = sessionIn;
    }

    public void setMessage(String message) {
        this.messageToBeSent = message;
    }

    public ChatRecipient[] getAvailableRecipients() {
        List<ChatRecipient> list = this.getAvailableRecipientsList();
        return list.toArray(new ChatRecipient[0]);
    }

    public void addRecipient(String recipient) {
        this.recipients.add(recipient);
    }

    public void setAnnouncing(boolean announcing) {
        this.announce = announcing;
    }

    private List<ChatRecipient> getAvailableRecipientsList() {
        ArrayList<ChatRecipient> list = new ArrayList<ChatRecipient>();
        ChatRecipientImpl cr = new ChatRecipientImpl();
        cr.name = "this_room";
        cr.displayName = "this_room";
        list.add(cr);
        cr = new ChatRecipientImpl();
        cr.name = "all_rooms";
        cr.displayName = "all_rooms";
        list.add(cr);
        cr = new ChatRecipientImpl();
        cr.name = "announcement";
        cr.displayName = "announcement";
        list.add(cr);
        cr = new ChatRecipientImpl();
        cr.name = "moderators";
        cr.displayName = "moderators";
        list.add(cr);
        Iterator itr = session.getParticipantIterator();
        while (itr.hasNext()) {
            CRParticipant p = (CRParticipant)itr.next();
            cr = new ChatRecipientImpl();
            cr.name = p.getName();
            cr.displayName = p.getDisplayName();
            list.add(cr);
        }
        return list;
    }

    private Map<String, ToSelection> getAvailableToSelectionList() {
        HashMap<String, ToSelection> toSelectionMap = new HashMap<String, ToSelection>();
        toSelectionMap.put("this_room", new ToAll());
        toSelectionMap.put("all_rooms", new ToAllRooms());
        toSelectionMap.put("announcement", new ToAllRooms());
        toSelectionMap.put("moderators", new ToChairs(null, null, null, null));
        toSelectionMap.put("selected_participants", new ToParticipants(new ArrayList<CRParticipant>()));
        return toSelectionMap;
    }

    public void doexecute() throws CommandExecutionException {
        String msg;
        CRParticipant me = session.getMe();
        if (me != null) {
            if (!session.getPermissionValue("ChatPermission", me.getID())) {
                throw new CommandNoPermissionException("You have no Chat permission.");
            }
        } else {
            throw new CommandNoPermissionException("No Me Participant.");
        }
        if (this.announce) {
            this.validateIsChair();
        }
        if ((msg = this.messageToBeSent) != null) {
            msg = msg.trim();
        }
        if (msg.length() == 0) {
            throw new CommandParameterException("No message to be sent.", this.i18n.getString((PropertiesEnum)StringsProperties.SENDCHATMESSAGECMD_BADPARAMMESSAGENOTSET));
        }
        boolean privateChatRestricted = chatModule.isPrivateChatRestricted();
        boolean hasPrivateChatRestricted = false;
        for (String recipient : this.recipients) {
            CRParticipant participant = session.getParticipantByName(recipient);
            if (participant != null) {
                boolean bl = hasPrivateChatRestricted = !participant.isChair() && privateChatRestricted && !session.getMe().isChair();
            }
            if (!hasPrivateChatRestricted) continue;
            break;
        }
        Map<String, ToSelection> toSelectionMap = this.getAvailableToSelectionList();
        ToParticipants toParticipants = null;
        String messageType = null;
        for (String recipient : this.recipients) {
            ToSelection to = toSelectionMap.get(recipient);
            if (to != null) {
                try {
                    chatModule.sendChat(recipient, to, this.messageToBeSent, this.announce);
                }
                catch (Exception e) {
                    this.handleSendChatException(recipient, null);
                }
                continue;
            }
            if (toParticipants == null) {
                toParticipants = (ToParticipants)toSelectionMap.get("selected_participants");
            }
            messageType = "selected_participants";
            CRParticipant p = session.getParticipantByName(recipient);
            if (p != null && !hasPrivateChatRestricted) {
                toParticipants.getToList().add(p);
                continue;
            }
            throw new CommandExecutionException("Cannot find or send a message to the specified recipient: " + recipient, this.i18n.getString((PropertiesEnum)StringsProperties.SENDCHATMESSAGECMD_BADRESULTERROROCCURRED, new Object[]{recipient}));
        }
        if (toParticipants != null && toParticipants.getToList().size() > 0) {
            try {
                chatModule.sendChat(messageType, toParticipants, this.messageToBeSent, this.announce);
            }
            catch (Exception e) {
                this.handleSendChatException("selected_participants", toParticipants);
            }
        }
    }

    private void handleSendChatException(String recipient, ToParticipants toParticipants) throws CommandExecutionException {
        StringBuilder sb = new StringBuilder();
        if (toParticipants != null) {
            for (CRParticipant p : toParticipants.getToList()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(p.getName());
            }
            if (sb.length() > 0) {
                sb.insert(0, recipient + "[").append("]");
            }
        } else {
            sb.append(recipient);
        }
        throw new CommandExecutionException("Cannot send chat message to recipients: " + sb, this.i18n.getString((PropertiesEnum)StringsProperties.SENDCHATMESSAGECMD_BADRESULTERROROCCURRED, new Object[]{sb}));
    }

    private static class ChatRecipientImpl
    implements ChatRecipient {
        public String name;
        public String displayName;

        private ChatRecipientImpl() {
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

