/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.chat.Address;
import com.elluminate.groupware.chat.Chat;
import com.elluminate.groupware.chat.ChatProtocol;
import com.elluminate.groupware.chat.module.ChannelDataEventFactory;
import com.elluminate.groupware.chat.module.ChatTerminalListener;
import com.elluminate.groupware.chat.module.ErrorHandler;
import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.groupware.chat.module.ToSelection;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;

public class ChatTerminal
extends JinxTerminal
implements ChannelListener,
ChannelDataListener {
    private ChatTerminalListener terminalListener;
    private Provider<Chat> chatProvider;
    private I18n i18n;
    private ChairProtocol chairProtocol;
    private ChannelDataEventFactory channelDataEventFactory;
    private ChatProtocol msgProtocol;
    private int maxMsgLen;
    private long localTimebase;
    private long timebase;
    private boolean connected;

    @Inject
    public ChatTerminal(I18n i18n) {
        this.i18n = i18n;
    }

    @Inject
    public void initChatProvider(Provider<Chat> cp) {
        this.chatProvider = cp;
    }

    @Inject
    public void initChairProtocol(ChairProtocol cp) {
        this.chairProtocol = cp;
    }

    @Inject
    public void initChannelDataEventFactory(ChannelDataEventFactory cdeFactory) {
        this.channelDataEventFactory = cdeFactory;
    }

    @Inject
    public void initChatProtocol(ChatProtocol msgProtocol) {
        this.msgProtocol = msgProtocol;
        super.setProtocol((JinxProtocol)msgProtocol);
    }

    @Inject
    public void initChatTerminalListener(ChatTerminalListener dmtl) {
        this.terminalListener = dmtl;
    }

    public void setMaxMsgLength(int max) {
        this.maxMsgLen = max;
    }

    public void createChannels() {
        super.createChannels((ChannelListener)this, (ChannelDataListener)this);
    }

    public boolean send(ToSelection toSelection, String text, boolean announce, ErrorHandler errorHandler) {
        ClientInfo me;
        if (toSelection == null) {
            errorHandler.reportError(this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_NOSELECTION), this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_CANTSENDTITLE));
            return false;
        }
        if (text == null) {
            return false;
        }
        if ((text = text.trim()).equals("")) {
            return false;
        }
        if (text.length() > this.maxMsgLen) {
            text = text.substring(0, this.maxMsgLen);
        }
        if ((me = this.clients.getMyClient()) == null) {
            return false;
        }
        Chat msg = (Chat)this.chatProvider.get();
        msg.setFrom(me);
        msg.setText(text);
        msg.setAnnouncement(announce);
        toSelection.address(msg);
        this.monitor(msg);
        this.fireChannelDataEvent(msg);
        return true;
    }

    private void monitor(Chat msg) {
        boolean monitored = this.clients.getProperty("directMessagingMonitored", false);
        if (!monitored) {
            return;
        }
        ClientInfo me = this.clients.getMyClient();
        Chair chair = this.getChair();
        for (ClientInfo ci : chair) {
            if (ci == me || ci == null) continue;
            msg.addBCC(ci);
        }
    }

    private Chair getChair() {
        return this.chairProtocol.fetchChair(this.clients);
    }

    private void fireChannelDataEvent(Chat msg) {
        DataOutputStream str;
        ChannelDataEvent e;
        Iterator i = msg.getRecipients().iterator();
        boolean copySelf = true;
        boolean sentToServer = false;
        while (i.hasNext()) {
            Address addr = (Address)i.next();
            ChannelDataEvent e2 = null;
            if (addr.getType() == 5) {
                e2 = this.channelDataEventFactory.getInstance(this, (short)-2, (byte)1);
                sentToServer = true;
            } else if (addr.getType() == 4) {
                e2 = this.channelDataEventFactory.getInstance(this, (short)-4, (byte)1);
                if (this.clients.getMyGroupID() == 0) {
                    sentToServer = true;
                }
            } else if (addr.getType() == 7) {
                if (msg.isFromMe() && !this.chairProtocol.fetchChair(this.clients).contains(this.clients.getMyAddress())) {
                    e2 = this.channelDataEventFactory.getInstance(this, this.clients.getMyAddress(), (byte)1);
                    copySelf = false;
                }
            } else {
                ClientInfo ci = this.clients.getVisible(addr.getName());
                if (ci != null) {
                    e2 = this.channelDataEventFactory.getInstance(this, ci.getAddress(), (byte)1);
                    if (ci == this.clients.getMyClient()) {
                        copySelf = false;
                    }
                }
            }
            if (e2 == null) {
                return;
            }
            try {
                DataOutputStream str2 = e2.write();
                this.msgProtocol.encode(str2, this.clients, msg);
                str2.close();
            }
            catch (IOException ex) {
                e2.dispose();
                LogSupport.exception((Object)((Object)this), (String)"fireChannelDataEvent", (Throwable)ex, (boolean)true);
                return;
            }
            this.fireChannelData(e2);
        }
        if (copySelf) {
            e = ChannelDataEvent.getInstance((Object)((Object)this), (short)this.clients.getMyAddress(), (byte)1);
            try {
                str = e.write();
                this.msgProtocol.encode(str, this.clients, msg);
                str.close();
                this.onChannelData(e);
                e.dispose();
            }
            catch (IOException ex) {
                LogSupport.exception((Object)((Object)this), (String)"fireChannelDataEvent", (Throwable)ex, (boolean)true);
            }
        }
        if (!sentToServer && this.clients.getProperty("directMessagingTranscript", false)) {
            e = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)1);
            try {
                str = e.write();
                this.msgProtocol.encode(str, this.clients, msg);
                str.close();
                this.fireChannelData(e);
            }
            catch (IOException ex) {
                LogSupport.exception((Object)((Object)this), (String)"fireChannelDataEvent", (Throwable)ex, (boolean)true);
            }
        }
    }

    public void onChannelData(ChannelDataEvent e) {
        DataInputStream str = e.read();
        this.localTimebase = System.currentTimeMillis() - this.client.getConnectedMillis();
        try {
            Object mi = null;
            switch (e.getCommand()) {
                case 2: {
                    long msgTime = str.readLong();
                    this.timebase = msgTime - this.client.getConnectedMillis();
                    this.terminalListener.welcome(new Date(msgTime));
                    break;
                }
                case 1: {
                    Chat msg = this.msgProtocol.decode(str, this.clients);
                    msg.setTimestamp(new Date(this.timebase + this.client.getConnectedMillis()));
                    this.terminalListener.messageRecieved(msg);
                }
            }
            str.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"onChannelData", (Throwable)ex, (boolean)true);
        }
    }

    public void channelStateChanged(ChannelEvent e) {
        switch (e.getState()) {
            case 1: {
                this.connected = true;
                ClientInfo me = this.clients.getMyClient();
                if (me == null) break;
                me.setProperty("directMessagingChatActive", true);
                break;
            }
            case 2: {
                Date date = new Date(this.timebase + (System.currentTimeMillis() - this.localTimebase));
                this.connected = false;
                try {
                    this.terminalListener.goodbye(date);
                    break;
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)((Object)this), (String)"channelStateChanged(ChannelEvent e)", (Throwable)ex, (boolean)true);
                }
            }
        }
        this.terminalListener.connectionChanged(this.connected);
    }

    public boolean isConnected() {
        return this.connected;
    }
}

