/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.classroom.client.messaging.ExtraInfo;
import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.chat.Chat;
import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.groupware.imps.SessionTimeAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class ChatPublisher {
    public static final String PRIVATE_MSG_RECEIVED = "private-msg-recd";
    public static final String PUBLIC_MSG_RECEIVED = "public-msg-recd";
    public static final String PRIVATE_MSG_SENT = "private-msg-sent";
    public static final String PUBLIC_MSG_SENT = "public-msg-sent";
    public static final String ANNOUNCEMENT_SENT = "announcement-sent";
    public static final String ANNOUNCEMENT_RECEIVED = "announcement-received";
    public static final String CHAT_ENABLED = "chat-enabled";
    public static final String CHAT_DISABLED = "chat-disabled";
    private final String UNIQUE_NAME = "ChatPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private String modName;
    private String modDisplayName;
    private final MessageRouter router;
    private SessionTimeAPI sessionTime;
    private Imps imps;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public ChatPublisher(MessagePublisher pub, MessagePublisherMetadata meta, I18n localization, MessageRouter msgRouter, ModulePublisherInfo mod) {
        this.i18n = localization;
        this.publisher = pub;
        this.metadata = meta;
        this.router = msgRouter;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_DISPLAY_NAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    @Inject
    public void initImpls(Imps i) {
        this.imps = i;
    }

    public void sendRouterMessage(Chat dmsg) {
        if (dmsg == null) {
            return;
        }
        if (this.sessionTime == null) {
            this.sessionTime = (SessionTimeAPI)this.imps.findBest(SessionTimeAPI.class);
        }
        String sender = dmsg.isFromMe() ? this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_ME) : dmsg.getOriginator().getName();
        String contents = dmsg.getText();
        long timestamp = 0L;
        MessageType type = this.determineType(dmsg);
        if (type == null) {
            throw new IllegalArgumentException("message type for this publisher could not be determined");
        }
        ExtraInfo xtra = new ExtraInfo();
        xtra.setHeader(this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_WHO_SAYS, new Object[]{sender, this.determineScope(type)}));
        this.publisher.sendMessageWithExtraInfo(contents, xtra, type, timestamp, dmsg.isFromMe());
    }

    private MessageType determineType(Chat dmsg) {
        String sType = PUBLIC_MSG_RECEIVED;
        sType = dmsg.isFromMe() ? (dmsg.isAnnouncement() ? ANNOUNCEMENT_SENT : (dmsg.isPrivate() ? PRIVATE_MSG_SENT : PUBLIC_MSG_SENT)) : (dmsg.isAnnouncement() ? ANNOUNCEMENT_RECEIVED : (dmsg.isPrivate() ? PRIVATE_MSG_RECEIVED : PUBLIC_MSG_RECEIVED));
        return this.msgTypes.get(sType);
    }

    private String determineScope(MessageType type) {
        if (type == this.msgTypes.get(ANNOUNCEMENT_RECEIVED) || type == this.msgTypes.get(ANNOUNCEMENT_SENT)) {
            return this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_ANNOUNCEMENTMESSAGE);
        }
        if (type == this.msgTypes.get(PRIVATE_MSG_RECEIVED) || type == this.msgTypes.get(PRIVATE_MSG_SENT)) {
            return this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_PRIVATEMESSAGE);
        }
        return this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_PUBLICMESSAGE);
    }

    public void sendEnabledStatusChangeMessage(boolean enabled) {
        MessageType type;
        String message = "";
        if (enabled) {
            message = this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_CHAT_ENABLED_MESSAGE);
            type = this.msgTypes.get(CHAT_ENABLED);
        } else {
            message = this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_CHAT_DISABLED_MESSAGE);
            type = this.msgTypes.get(CHAT_DISABLED);
        }
        this.publisher.sendTextMessage(message, type, false);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("ChatPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(PRIVATE_MSG_RECEIVED, new MessageType(PRIVATE_MSG_RECEIVED, this.i18n.getString((PropertiesEnum)StringsProperties.DMPUB_PRIVATE_MSG_RECEIVED), 5));
        this.msgTypes.put(PUBLIC_MSG_RECEIVED, new MessageType(PUBLIC_MSG_RECEIVED, this.i18n.getString((PropertiesEnum)StringsProperties.DMPUB_PUBLIC_MSG_RECEIVED), 5));
        this.msgTypes.put(PRIVATE_MSG_SENT, new MessageType(PRIVATE_MSG_SENT, this.i18n.getString((PropertiesEnum)StringsProperties.DMPUB_PRIVATE_MSG_SENT), 5));
        this.msgTypes.put(PUBLIC_MSG_SENT, new MessageType(PUBLIC_MSG_SENT, this.i18n.getString((PropertiesEnum)StringsProperties.DMPUB_PUBLIC_MSG_SENT), 5));
        this.msgTypes.put(ANNOUNCEMENT_RECEIVED, new MessageType(ANNOUNCEMENT_RECEIVED, this.i18n.getString((PropertiesEnum)StringsProperties.DMPUB_ANNOUNCEMENT_RECEIVED), 11));
        this.msgTypes.put(ANNOUNCEMENT_SENT, new MessageType(ANNOUNCEMENT_SENT, this.i18n.getString((PropertiesEnum)StringsProperties.DMPUB_ANNOUNCEMENT_SENT), 11));
        this.msgTypes.put(CHAT_ENABLED, new MessageType(CHAT_ENABLED, this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_TYPE_ENABLED), 6));
        this.msgTypes.put(CHAT_DISABLED, new MessageType(CHAT_DISABLED, this.i18n.getString((PropertiesEnum)StringsProperties.CHATPUBLISHER_TYPE_DISABLED), 6));
    }
}

