/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video;

import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.elluminate.groupware.imps.FollowTheSpeakerAPI;
import com.elluminate.groupware.imps.FollowTheSpeakerListener;
import com.elluminate.groupware.video.VideoDebug;
import com.elluminate.groupware.video.VideoProtocol;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ConnectionClass;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.io.DataInputStream;
import java.io.IOException;

public class VideoResponder
extends DefaultProtocolResponder
implements ChannelDataListener,
FollowTheSpeakerListener,
ImpsAvailableListener<FollowTheSpeakerAPI> {
    private static final int MAX_FILMERS_LIMIT = 9;
    private ClientList clients = new ClientList(null);
    private View[] views = new View[11];
    private boolean isRecorder = true;
    private boolean isConnected = false;
    private Following following = Following.SPEAKER;
    private FollowTheSpeakerAPI followApi;
    private Logger logger;

    public VideoResponder() {
        super((JinxProtocol)new VideoProtocol());
        this.setChannelDataListener(this);
    }

    @Inject
    public void initImps(Imps imps) {
        imps.addImpsAvailableListener((ImpsAvailableListener)this, FollowTheSpeakerAPI.class);
        this.followApi = (FollowTheSpeakerAPI)imps.findBest(FollowTheSpeakerAPI.class);
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    public void speakerChanged(short newSpeaker) {
        if (this.following != Following.SPEAKER) {
            return;
        }
        if (newSpeaker == -32767) {
            View view = this.views[0];
            if (view != null) {
                view.isTalker = false;
            }
            return;
        }
        View view = this.findView(newSpeaker);
        if (view == null) {
            view = new View(newSpeaker, false, true);
            for (int i = 0; i < this.views.length; ++i) {
                if (this.views[i] != null) continue;
                this.views[i] = view;
                view.index = i;
                break;
            }
            if (view.index == -1) {
                return;
            }
        } else if (view.index == 0) {
            return;
        }
        view.isTalker = true;
        this.setMainView(view, true);
    }

    private View findView(short addr) {
        for (int i = 0; i < this.views.length; ++i) {
            if (this.views[i] == null) {
                return null;
            }
            if (this.views[i].addr != addr) continue;
            return this.views[i];
        }
        return null;
    }

    private void setMainView(View view, boolean announce) {
        if (view.index == 0) {
            return;
        }
        if (this.views[0].isFilmer) {
            this.views[view.index] = this.views[0];
            this.views[view.index].index = view.index;
            this.views[view.index].isTalker = false;
        } else {
            for (int i = view.index + 1; i < this.views.length; ++i) {
                this.views[i - 1] = this.views[i];
                if (this.views[i - 1] == null) continue;
                this.views[i - 1].index = i - 1;
            }
            this.views[this.views.length - 1] = null;
        }
        this.views[0] = view;
        view.index = 0;
        if (announce) {
            this.announceMainView();
        }
    }

    private void addFilmer(short addr) {
        View view = this.findView(addr);
        if (view == null) {
            for (int i = 0; i < this.views.length; ++i) {
                if (this.views[i] != null) continue;
                view = new View(addr, true, false);
                view.index = i;
                if (VideoDebug.RESPONDER.show()) {
                    this.logger.message((Object)this, "addFilmer", "Adding " + view.name + " in slot " + view.index);
                }
                this.views[i] = view;
                if (i == 0) {
                    this.announceMainView();
                }
                return;
            }
            if (VideoDebug.RESPONDER.show()) {
                this.logger.message((Object)this, "addFilmer", "No slots available for " + addr);
            }
        } else {
            if (VideoDebug.RESPONDER.show()) {
                this.logger.message((Object)this, "addFilmer", view.name + " is already filming.");
            }
            view.isFilmer = true;
            if (view.index == 0) {
                this.announceMainView();
            }
        }
    }

    private void removeFilmer(short addr) {
        View view = this.findView(addr);
        if (view != null) {
            view.isFilmer = false;
            if (view.isTalker) {
                return;
            }
            if (VideoDebug.RESPONDER.show()) {
                this.logger.message((Object)this, "removeFilmer", "Removing " + view.name + " in slot " + view.index);
            }
            for (int i = view.index + 1; i < this.views.length; ++i) {
                this.views[i - 1] = this.views[i];
                if (this.views[i - 1] == null) continue;
                this.views[i - 1].index = i - 1;
            }
            this.views[this.views.length - 1] = null;
            if (view.index == 0 && this.views[0] != null) {
                this.announceMainView();
            }
        }
    }

    private void announceMainView() {
        View view = this.views[0];
        if (view == null) {
            return;
        }
        if (VideoDebug.RESPONDER.show()) {
            this.logger.message((Object)this, "announceMainView", "Switching main view to " + view.name);
        }
        byte[] mainFilmer = new byte[]{(byte)(view.addr >> 8), (byte)view.addr};
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)20, (byte[])mainFilmer);
        Channel chnl = (Channel)this.channels.get(0);
        chnl.onChannelData(cde, (byte)1);
    }

    private int getMaxXmitSpeed() {
        Connection connection = this.clients == null ? null : this.clients.getConnection();
        int xmitSpeed = 0;
        if (connection != null && (xmitSpeed = connection.getMaxXmitSpeed()) < 0) {
            xmitSpeed = 10000000;
        }
        return xmitSpeed;
    }

    public void join(Connection connection, String channel) {
        super.join(connection, channel);
        try {
            ClientInfo ci;
            this.clients = connection.getClientList();
            this.isConnected = true;
            if (this.followApi != null) {
                this.followApi.addFollowTheSpeakerListener((FollowTheSpeakerListener)this);
            }
            this.isRecorder = (ci = this.clients.get((short)1)) != null && ci.isMe();
        }
        catch (Exception ex) {
            System.out.println("VideoResponder.join: Connection: " + connection + ", channel: " + channel + ", clients: " + this.clients);
            System.err.println("VideoResponder.join, cannot instantiate test responder");
            this.isRecorder = true;
        }
    }

    public void leave(String channel) {
        super.leave(channel);
        if (this.followApi != null) {
            this.followApi.removeFollowTheSpeakerListener((FollowTheSpeakerListener)this);
        }
        this.isConnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelData(ChannelDataEvent cde) {
        Channel chnl = (Channel)this.channels.get(0);
        byte cmd = cde.getCommand();
        DataInputStream istr = null;
        try {
            istr = cde.read();
            if (cmd >= 32) {
                if ((cmd & 8) != 0) {
                    ChannelDataEvent cde2 = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)18);
                    chnl.onChannelData(cde2, (byte)1);
                }
            } else if (cmd == 3) {
                short who = istr.readShort();
                if (VideoDebug.RESPONDER.show()) {
                    this.logger.message((Object)this, "onChanelData", "Grant floor to " + who);
                }
                this.addFilmer(who);
            } else if (cmd == 4) {
                short who = istr.readShort();
                if (VideoDebug.RESPONDER.show()) {
                    this.logger.message((Object)this, "onChanelData", "Revoke floor from " + who);
                }
                this.removeFilmer(who);
            } else if (cmd == 20) {
                short mainFilmerAddr;
                View view;
                if (this.following == Following.MODERATOR && (view = this.findView(mainFilmerAddr = istr.readShort())) != null) {
                    this.setMainView(view, false);
                }
            } else if (cmd == 22) {
                Following following = this.following = istr.readBoolean() ? Following.MODERATOR : Following.SPEAKER;
                if (VideoDebug.RESPONDER.show()) {
                    this.logger.message((Object)this, "onChannelData", "switching follow mode to " + (Object)((Object)this.following));
                }
            } else if (cmd == 11) {
                int xmitSpeed;
                int quality = this.isRecorder ? 7 : ((xmitSpeed = this.getMaxXmitSpeed()) >= ConnectionClass.LAN.getXmitBandwidth() ? 7 : (xmitSpeed >= ConnectionClass.BROADBAND.getXmitBandwidth() ? 9 : 5));
                ChannelDataEvent cde2 = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)quality);
                chnl.onChannelData(cde2, (byte)1);
                byte[] frameRate = new byte[]{30};
                cde2 = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)19, (byte[])frameRate);
                chnl.onChannelData(cde2, (byte)1);
            }
        }
        catch (IOException iox) {
            this.logger.exception((Object)this, "onChannelData", (Throwable)iox, true);
        }
        finally {
            try {
                istr.close();
            }
            catch (Throwable t) {}
        }
    }

    public void available(FollowTheSpeakerAPI instance) {
        this.followApi = instance;
        if (this.isConnected) {
            this.followApi.addFollowTheSpeakerListener((FollowTheSpeakerListener)this);
        }
    }

    public void removed(FollowTheSpeakerAPI instance) {
        instance.removeFollowTheSpeakerListener((FollowTheSpeakerListener)this);
        this.followApi = null;
    }

    static enum Following {
        SPEAKER,
        MODERATOR;

    }

    class View {
        public short addr;
        public String name;
        public boolean isFilmer;
        public boolean isTalker;
        public int index = -1;

        public View(short addr, boolean isFilmer, boolean isTalker) {
            this.addr = addr;
            this.isFilmer = isFilmer;
            this.isTalker = isTalker;
            ClientInfo ci = null;
            if (VideoResponder.this.clients != null) {
                ci = VideoResponder.this.clients.get(addr);
            }
            this.name = ci == null ? "UNKNOWN" : ci.getDisplayName();
            this.name = this.name + "(" + addr + ")";
        }
    }
}

