/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module.text;

import com.elluminate.groupware.notes.module.event.FontSizeChangeEvent;
import com.elluminate.groupware.notes.module.event.FontSizeChangeListener;
import com.elluminate.groupware.notes.module.text.ResizeableText;
import java.util.ArrayList;
import java.util.List;

public class NotesResizableText
implements ResizeableText {
    private int currentFontSize = 12;
    private List fontSizeListeners = new ArrayList();

    @Override
    public int getTextSize() {
        return this.currentFontSize;
    }

    private void setCurrentFontSize(int size) {
        if (this.currentFontSize != size) {
            this.currentFontSize = size;
            this.fireFontChangeEvent();
        }
    }

    @Override
    public void setDefaultTextSize() {
        this.setTextSize(Integer.toString(12));
    }

    @Override
    public void setTextSize(String size) {
        int iSize = this.checkBounds(size);
        this.setCurrentFontSize(iSize);
    }

    private int checkBounds(String size) {
        int fontSize = 12;
        if (size != null) {
            try {
                fontSize = Integer.parseInt(size);
                if (fontSize < 8) {
                    fontSize = 8;
                } else if (fontSize > 48) {
                    fontSize = 48;
                }
            }
            catch (NumberFormatException nfe) {
                fontSize = 12;
            }
        }
        return fontSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFontSizeListener(FontSizeChangeListener l) {
        if (l != null) {
            List list = this.fontSizeListeners;
            synchronized (list) {
                this.fontSizeListeners.add(l);
            }
        }
        this.fireFontChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFontSizeListener(FontSizeChangeListener l) {
        if (l != null) {
            List list = this.fontSizeListeners;
            synchronized (list) {
                this.fontSizeListeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFontChangeEvent() {
        List list = this.fontSizeListeners;
        synchronized (list) {
            FontSizeChangeEvent e = new FontSizeChangeEvent(this);
            e.setFontSize(this.currentFontSize);
            for (FontSizeChangeListener changeListener : this.fontSizeListeners) {
                changeListener.fontSizeChanged(e);
            }
        }
    }
}

